/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.modcluster.container.catalina;

import java.util.Arrays;
import java.util.Iterator;
import org.apache.catalina.Container;
import org.apache.catalina.Globals;
import org.jboss.modcluster.container.Connector;
import org.jboss.modcluster.container.Engine;
import org.jboss.modcluster.container.Host;
import org.jboss.modcluster.container.Server;
import org.jboss.modcluster.container.catalina.CatalinaConnector;
import org.jboss.modcluster.container.catalina.CatalinaFactoryRegistry;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CatalinaEngine
implements Engine {
    protected final CatalinaFactoryRegistry registry;
    protected final org.apache.catalina.Engine engine;
    protected final Server server;

    public CatalinaEngine(CatalinaFactoryRegistry registry, org.apache.catalina.Engine engine, Server server) {
        this.registry = registry;
        this.engine = engine;
        this.server = server;
    }

    public Server getServer() {
        return this.server;
    }

    public Iterable<Host> getHosts() {
        final Iterator<Container> children = Arrays.asList(this.engine.findChildren()).iterator();
        final Iterator<Host> hosts = new Iterator<Host>(){

            @Override
            public boolean hasNext() {
                return children.hasNext();
            }

            @Override
            public Host next() {
                return CatalinaEngine.this.registry.getHostFactory().createHost(CatalinaEngine.this.registry, (org.apache.catalina.Host)children.next(), CatalinaEngine.this);
            }

            @Override
            public void remove() {
                children.remove();
            }
        };
        return new Iterable<Host>(){

            @Override
            public Iterator<Host> iterator() {
                return hosts;
            }
        };
    }

    public String getJvmRoute() {
        return this.engine.getJvmRoute();
    }

    public void setJvmRoute(String jvmRoute) {
        this.engine.setJvmRoute(jvmRoute);
    }

    public String getName() {
        return this.engine.getName();
    }

    public Iterable<Connector> getConnectors() {
        final Iterator<org.apache.catalina.connector.Connector> connectors = Arrays.asList(this.engine.getService().findConnectors()).iterator();
        final Iterator<Connector> iterator = new Iterator<Connector>(){

            @Override
            public boolean hasNext() {
                return connectors.hasNext();
            }

            @Override
            public Connector next() {
                return CatalinaEngine.this.registry.getConnectorFactory().createConnector((org.apache.catalina.connector.Connector)connectors.next());
            }

            @Override
            public void remove() {
                connectors.remove();
            }
        };
        return new Iterable<Connector>(){

            @Override
            public Iterator<Connector> iterator() {
                return iterator;
            }
        };
    }

    public Connector getProxyConnector() {
        int highestMaxThreads = 0;
        Connector bestConnector = null;
        for (org.apache.catalina.connector.Connector connector : this.engine.getService().findConnectors()) {
            Connector catalinaConnector = this.registry.getConnectorFactory().createConnector(connector);
            if (CatalinaConnector.isAJP(connector) || catalinaConnector.isReverse()) {
                return catalinaConnector;
            }
            int maxThreads = catalinaConnector.getMaxThreads();
            if (maxThreads <= highestMaxThreads) continue;
            highestMaxThreads = maxThreads;
            bestConnector = catalinaConnector;
        }
        if (bestConnector == null) {
            throw new IllegalStateException();
        }
        return bestConnector;
    }

    public Host findHost(String name) {
        org.apache.catalina.Host host = (org.apache.catalina.Host)this.engine.findChild(name);
        return host != null ? this.registry.getHostFactory().createHost(this.registry, host, this) : null;
    }

    public String getSessionCookieName() {
        return Globals.SESSION_COOKIE_NAME;
    }

    public String getSessionParameterName() {
        return Globals.SESSION_PARAMETER_NAME;
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof CatalinaEngine)) {
            return false;
        }
        CatalinaEngine engine = (CatalinaEngine)object;
        return this.engine == engine.engine;
    }

    public int hashCode() {
        return this.engine.hashCode();
    }

    public String toString() {
        return this.engine.getName();
    }
}

