/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.connector.subsystems.datasources;

import java.util.List;
import org.jboss.as.connector.ConnectorMessages;
import org.jboss.as.connector.subsystems.datasources.AbstractDataSourceService;
import org.jboss.as.connector.subsystems.datasources.Constants;
import org.jboss.as.connector.subsystems.datasources.DataSourceConfigService;
import org.jboss.as.connector.subsystems.datasources.DataSourceReferenceFactoryService;
import org.jboss.as.connector.subsystems.datasources.XADataSourceConfigService;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.naming.deployment.ContextNames;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceRegistry;

public class DataSourceDisable
implements OperationStepHandler {
    static final DataSourceDisable INSTANCE = new DataSourceDisable();

    public void execute(OperationContext context, ModelNode operation) {
        final ModelNode model = context.readResourceForUpdate(PathAddress.EMPTY_ADDRESS).getModel();
        model.get("enabled").set(false);
        if (context.getType() == OperationContext.Type.SERVER) {
            context.addStep(new OperationStepHandler(){

                /*
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
                    ServiceName binderServiceName;
                    ServiceController binderController;
                    ModelNode address = operation.require("address");
                    String dsName = PathAddress.pathAddress((ModelNode)address).getLastElement().getValue();
                    String jndiName = model.get(Constants.JNDINAME.getName()).asString();
                    ServiceRegistry registry = context.getServiceRegistry(true);
                    ServiceName dataSourceServiceName = AbstractDataSourceService.SERVICE_NAME_BASE.append(new String[]{jndiName});
                    ServiceController dataSourceController = registry.getService(dataSourceServiceName);
                    if (dataSourceController == null) throw new OperationFailedException(new ModelNode().set(ConnectorMessages.MESSAGES.serviceNotAvailable("Data-source", dsName)));
                    if (!ServiceController.State.UP.equals((Object)dataSourceController.getState())) {
                        throw new OperationFailedException(new ModelNode().set(ConnectorMessages.MESSAGES.serviceNotEnabled("Data-source", dsName)));
                    }
                    dataSourceController.setMode(ServiceController.Mode.NEVER);
                    ServiceName referenceServiceName = DataSourceReferenceFactoryService.SERVICE_NAME_BASE.append(new String[]{dsName});
                    ServiceController referenceController = registry.getService(referenceServiceName);
                    if (referenceController != null) {
                        referenceController.setMode(ServiceController.Mode.REMOVE);
                    }
                    if ((binderController = registry.getService(binderServiceName = ContextNames.bindInfoFor((String)jndiName).getBinderServiceName())) != null) {
                        binderController.setMode(ServiceController.Mode.REMOVE);
                    }
                    ServiceName dataSourceConfigServiceName = DataSourceConfigService.SERVICE_NAME_BASE.append(new String[]{dsName});
                    ServiceController dataSourceConfigController = registry.getService(dataSourceConfigServiceName);
                    List serviceNames = registry.getServiceNames();
                    ServiceName xaDataSourceConfigServiceName = XADataSourceConfigService.SERVICE_NAME_BASE.append(new String[]{dsName});
                    ServiceController xaDataSourceConfigController = registry.getService(xaDataSourceConfigServiceName);
                    for (ServiceName name : serviceNames) {
                        if (dataSourceConfigServiceName.append(new String[]{"connetion-properties"}).isParentOf(name)) {
                            ServiceController connProperyController = registry.getService(name);
                            if (connProperyController == null) throw new OperationFailedException(new ModelNode().set(ConnectorMessages.MESSAGES.serviceNotAvailable("Data-source.connectionProperty", name)));
                            if (!ServiceController.State.UP.equals((Object)connProperyController.getState())) throw new OperationFailedException(new ModelNode().set(ConnectorMessages.MESSAGES.serviceAlreadyStarted("Data-source.connectionProperty", name)));
                            connProperyController.setMode(ServiceController.Mode.NEVER);
                        }
                        if (!xaDataSourceConfigServiceName.append(new String[]{"xa-datasource-properties"}).isParentOf(name)) continue;
                        ServiceController xaConfigProperyController = registry.getService(name);
                        if (xaConfigProperyController == null) throw new OperationFailedException(new ModelNode().set(ConnectorMessages.MESSAGES.serviceNotAvailable("Data-source.xa-config-property", name)));
                        if (!ServiceController.State.UP.equals((Object)xaConfigProperyController.getState())) throw new OperationFailedException(new ModelNode().set(ConnectorMessages.MESSAGES.serviceAlreadyStarted("Data-source.xa-config-property", name)));
                        xaConfigProperyController.setMode(ServiceController.Mode.NEVER);
                    }
                    if (xaDataSourceConfigController != null) {
                        xaDataSourceConfigController.setMode(ServiceController.Mode.REMOVE);
                    }
                    if (dataSourceConfigController != null) {
                        dataSourceConfigController.setMode(ServiceController.Mode.REMOVE);
                    }
                    context.completeStep();
                }
            }, OperationContext.Stage.RUNTIME);
        }
        context.completeStep();
    }
}

