/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.connector.subsystems.jca;

import java.util.List;
import java.util.concurrent.Executor;
import org.jboss.as.connector.ConnectorServices;
import org.jboss.as.connector.workmanager.NamedWorkManager;
import org.jboss.as.connector.workmanager.WorkManagerService;
import org.jboss.as.controller.AbstractBoottimeAddStepHandler;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.ServiceVerificationHandler;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.client.helpers.MeasurementUnit;
import org.jboss.as.threads.ThreadsServices;
import org.jboss.as.txn.service.TxnServices;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.jboss.jca.core.api.workmanager.WorkManager;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceListener;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.tm.JBossXATerminator;

public class WorkManagerAdd
extends AbstractBoottimeAddStepHandler {
    public static final WorkManagerAdd INSTANCE = new WorkManagerAdd();

    protected void populateModel(ModelNode operation, ModelNode model) throws OperationFailedException {
        for (WmParameters parameter : WmParameters.values()) {
            parameter.getAttribute().validateAndSet(operation, model);
        }
    }

    protected void performBoottime(OperationContext context, ModelNode operation, ModelNode model, ServiceVerificationHandler verificationHandler, List<ServiceController<?>> newControllers) throws OperationFailedException {
        String name = WmParameters.NAME.getAttribute().validateResolvedOperation(model).asString();
        ServiceTarget serviceTarget = context.getServiceTarget();
        NamedWorkManager wm = new NamedWorkManager(name);
        WorkManagerService wmService = new WorkManagerService((WorkManager)wm);
        ServiceBuilder builder = serviceTarget.addService(ConnectorServices.WORKMANAGER_SERVICE.append(new String[]{name}), (Service)wmService);
        if (operation.get("long-running-threads").isDefined() && operation.get("long-running-threads").asBoolean()) {
            builder.addDependency(ThreadsServices.EXECUTOR.append(new String[]{name + "-" + "long-running-threads"}), Executor.class, wmService.getExecutorLongInjector());
        }
        builder.addDependency(ThreadsServices.EXECUTOR.append(new String[]{name + "-" + "short-running-threads"}), Executor.class, wmService.getExecutorShortInjector());
        builder.addDependency(TxnServices.JBOSS_TXN_XA_TERMINATOR, JBossXATerminator.class, wmService.getXaTerminatorInjector()).addListener((ServiceListener)verificationHandler).setInitialMode(ServiceController.Mode.ACTIVE).install();
    }

    public static enum WmParameters {
        NAME(SimpleAttributeDefinitionBuilder.create((String)"name", (ModelType)ModelType.STRING).setAllowExpression(true).setAllowNull(false).setMeasurementUnit(MeasurementUnit.NONE).setRestartAllServices().setXmlName("name").build());

        private SimpleAttributeDefinition attribute;

        private WmParameters(SimpleAttributeDefinition attribute) {
            this.attribute = attribute;
        }

        public SimpleAttributeDefinition getAttribute() {
            return this.attribute;
        }
    }
}

