/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller.remote;

import java.io.Closeable;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.concurrent.ExecutorService;
import org.jboss.as.controller.ControllerLogger;
import org.jboss.as.controller.ModelController;
import org.jboss.as.controller.remote.AbstractModelControllerOperationHandler;
import org.jboss.as.protocol.StreamUtils;
import org.jboss.as.protocol.mgmt.ActiveOperation;
import org.jboss.as.protocol.mgmt.FlushableDataOutput;
import org.jboss.as.protocol.mgmt.ManagementProtocolHeader;
import org.jboss.as.protocol.mgmt.ManagementRequestContext;
import org.jboss.as.protocol.mgmt.ManagementRequestHandler;
import org.jboss.as.protocol.mgmt.ManagementRequestHeader;
import org.jboss.as.protocol.mgmt.ManagementResponseHeader;
import org.jboss.as.protocol.mgmt.ProtocolUtils;
import org.jboss.dmr.ModelNode;

public class ModelControllerClientOperationHandler
extends AbstractModelControllerOperationHandler<ModelNode, Void> {
    private final ModelController controller;

    public ModelControllerClientOperationHandler(ModelController controller, ExecutorService executorService) {
        super(executorService);
        this.controller = controller;
    }

    protected ManagementRequestHeader validateRequest(ManagementProtocolHeader header) throws IOException {
        ManagementRequestHeader request = super.validateRequest(header);
        if (request.getOperationId() == 69 || request.getOperationId() == 70) {
            super.registerActiveOperation(Integer.valueOf(request.getBatchId()), null);
        }
        return request;
    }

    protected ManagementRequestHandler<ModelNode, Void> getRequestHandler(byte operationType) {
        switch (operationType) {
            case 69: 
            case 70: {
                return new ExecuteRequestHandler();
            }
            case 77: {
                return new CancelAsyncRequestHandler();
            }
        }
        return super.getRequestHandler(operationType);
    }

    private class CancelAsyncRequestHandler
    implements ManagementRequestHandler<ModelNode, Void> {
        private CancelAsyncRequestHandler() {
        }

        public void handleRequest(DataInput input, ActiveOperation.ResultHandler<ModelNode> resultHandler, ManagementRequestContext<Void> context) throws IOException {
            context.executeAsync((ManagementRequestContext.AsyncTask)new ManagementRequestContext.AsyncTask<Void>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void execute(ManagementRequestContext<Void> context) throws Exception {
                    ManagementResponseHeader response = ManagementResponseHeader.create((ManagementProtocolHeader)context.getRequestHeader());
                    FlushableDataOutput output = context.writeMessage((ManagementProtocolHeader)response);
                    try {
                        output.writeByte(36);
                        output.close();
                    }
                    finally {
                        StreamUtils.safeClose((Closeable)output);
                    }
                }
            });
            resultHandler.cancel();
        }
    }

    class ExecuteRequestHandler
    implements ManagementRequestHandler<ModelNode, Void> {
        ExecuteRequestHandler() {
        }

        public void handleRequest(DataInput input, final ActiveOperation.ResultHandler<ModelNode> resultHandler, ManagementRequestContext<Void> context) throws IOException {
            final ModelNode operation = new ModelNode();
            ProtocolUtils.expectHeader((DataInput)input, (int)97);
            operation.readExternal(input);
            ProtocolUtils.expectHeader((DataInput)input, (int)101);
            final int attachmentsLength = input.readInt();
            context.executeAsync((ManagementRequestContext.AsyncTask)new ManagementRequestContext.AsyncTask<Void>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void execute(ManagementRequestContext<Void> context) throws Exception {
                    ManagementResponseHeader response = ManagementResponseHeader.create((ManagementProtocolHeader)context.getRequestHeader());
                    ModelNode result = ExecuteRequestHandler.this.doExecute(operation, attachmentsLength, context);
                    FlushableDataOutput output = context.writeMessage((ManagementProtocolHeader)response);
                    try {
                        output.write(100);
                        result.writeExternal((DataOutput)output);
                        output.writeByte(36);
                        output.close();
                    }
                    finally {
                        StreamUtils.safeClose((Closeable)output);
                    }
                    resultHandler.done((Object)result);
                }
            });
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected ModelNode doExecute(ModelNode operation, int attachmentsLength, ManagementRequestContext<Void> context) {
            ManagementRequestHeader header = (ManagementRequestHeader)ManagementRequestHeader.class.cast(context.getRequestHeader());
            int batchId = header.getBatchId();
            ModelNode result = new ModelNode();
            AbstractModelControllerOperationHandler.OperationAttachmentsProxy attachmentsProxy = new AbstractModelControllerOperationHandler.OperationAttachmentsProxy(context.getChannel(), batchId, attachmentsLength);
            try {
                ControllerLogger.ROOT_LOGGER.tracef("Executing client request %d(%d)", batchId, header.getRequestId());
                result.set(ModelControllerClientOperationHandler.this.controller.execute(operation, new AbstractModelControllerOperationHandler.OperationMessageHandlerProxy(context.getChannel(), batchId), ModelController.OperationTransactionControl.COMMIT, attachmentsProxy));
            }
            catch (Exception e) {
                ModelNode failure = new ModelNode();
                failure.get("outcome").set("failed");
                failure.get("failure-description").set(e.getClass().getName() + ":" + e.getMessage());
                result.set(failure);
                attachmentsProxy.shutdown(e);
            }
            finally {
                ControllerLogger.ROOT_LOGGER.tracef("Executed client request %d", batchId);
            }
            return result;
        }
    }
}

