/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ee.component;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.concurrent.atomic.AtomicReference;
import org.jboss.as.ee.EeLogger;
import org.jboss.as.ee.EeMessages;
import org.jboss.as.ee.component.BasicComponent;
import org.jboss.as.ee.component.Component;
import org.jboss.as.ee.component.ComponentInstance;
import org.jboss.as.naming.ManagedReference;
import org.jboss.as.naming.ValueManagedReference;
import org.jboss.as.server.CurrentServiceContainer;
import org.jboss.invocation.Interceptor;
import org.jboss.invocation.InterceptorContext;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.value.ImmediateValue;
import org.jboss.msc.value.Value;

public class BasicComponentInstance
implements ComponentInstance {
    private static final long serialVersionUID = -8099216228976950066L;
    public static final Object INSTANCE_KEY = new Object();
    private transient BasicComponent component;
    private transient AtomicReference<ManagedReference> instanceReference;
    private transient Interceptor preDestroy;
    private volatile int done;
    private static final AtomicIntegerFieldUpdater<BasicComponentInstance> doneUpdater = AtomicIntegerFieldUpdater.newUpdater(BasicComponentInstance.class, "done");
    private transient Map<Method, Interceptor> methodMap;

    protected BasicComponentInstance(BasicComponent component, AtomicReference<ManagedReference> instanceReference, Interceptor preDestroyInterceptor, Map<Method, Interceptor> methodInterceptors) {
        this.component = component;
        this.instanceReference = instanceReference;
        this.preDestroy = preDestroyInterceptor;
        this.methodMap = Collections.unmodifiableMap(methodInterceptors);
    }

    @Override
    public Component getComponent() {
        return this.component;
    }

    @Override
    public Object getInstance() {
        ManagedReference managedReference = this.instanceReference.get();
        return managedReference.getInstance();
    }

    @Override
    public Interceptor getInterceptor(Method method) throws IllegalStateException {
        Interceptor interceptor = this.methodMap.get(method);
        if (interceptor == null) {
            throw EeMessages.MESSAGES.methodNotFound(method);
        }
        return interceptor;
    }

    @Override
    public Collection<Method> allowedMethods() {
        return this.methodMap.keySet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void destroy() {
        if (doneUpdater.compareAndSet(this, 0, 1)) {
            try {
                ManagedReference reference = this.instanceReference.get();
                if (reference != null) {
                    InterceptorContext interceptorContext = this.prepareInterceptorContext();
                    interceptorContext.setTarget(reference.getInstance());
                    this.preDestroy.processInvocation(interceptorContext);
                }
            }
            catch (Exception e) {
                EeLogger.ROOT_LOGGER.componentDestroyFailure(e, this);
            }
            finally {
                this.component.finishDestroy();
            }
        }
    }

    protected InterceptorContext prepareInterceptorContext() {
        InterceptorContext interceptorContext = new InterceptorContext();
        interceptorContext.putPrivateData(Component.class, (Object)this.component);
        interceptorContext.putPrivateData(ComponentInstance.class, (Object)this);
        interceptorContext.setContextData(new HashMap());
        return interceptorContext;
    }

    protected void finalize() {
        this.destroy();
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        out.writeUTF(this.component.getCreateServiceName().getCanonicalName());
        out.writeObject(this.instanceReference.get().getInstance());
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        ServiceName name = ServiceName.parse((String)in.readUTF());
        ServiceController service = CurrentServiceContainer.getServiceContainer().getRequiredService(name);
        this.component = (BasicComponent)service.getValue();
        BasicComponentInstance basic = this.component.constructComponentInstance((ManagedReference)new ValueManagedReference((Value)new ImmediateValue(in.readObject())), false);
        this.instanceReference = basic.instanceReference;
        this.methodMap = basic.methodMap;
        this.preDestroy = basic.preDestroy;
    }
}

