/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.logging.validators;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.operations.validation.AllowedValuesValidator;
import org.jboss.as.controller.operations.validation.ModelTypeValidator;
import org.jboss.as.logging.LoggingMessages;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;

public class ObjectTypeValidator
extends ModelTypeValidator
implements AllowedValuesValidator {
    private final Map<String, AttributeDefinition> allowedValues;
    private final List<ModelNode> nodeValues;

    public ObjectTypeValidator(boolean nullable, AttributeDefinition ... attributes) {
        super(nullable, false, false, ModelType.OBJECT, ObjectTypeValidator.findModelTypes(attributes));
        this.allowedValues = new HashMap<String, AttributeDefinition>(attributes.length);
        this.nodeValues = new ArrayList<ModelNode>(attributes.length);
        for (AttributeDefinition attribute : attributes) {
            this.allowedValues.put(attribute.getName(), attribute);
            this.nodeValues.add(new ModelNode().set(attribute.getName()));
        }
    }

    public void validateParameter(String parameterName, ModelNode value) throws OperationFailedException {
        super.validateParameter(parameterName, value);
        if (value.isDefined()) {
            for (String key : value.keys()) {
                if (this.allowedValues.containsKey(key)) {
                    this.allowedValues.get(key).getValidator().validateParameter(key, value.get(key));
                    continue;
                }
                throw new OperationFailedException(new ModelNode().set(LoggingMessages.MESSAGES.invalidValueTypeKey(key, this.allowedValues.keySet())));
            }
        }
    }

    public List<ModelNode> getAllowedValues() {
        return this.nodeValues;
    }

    private static ModelType[] findModelTypes(AttributeDefinition ... attributes) {
        HashSet<ModelType> result = new HashSet<ModelType>();
        for (AttributeDefinition attr : attributes) {
            if (attr.getType() == ModelType.OBJECT) continue;
            result.add(attr.getType());
        }
        return result.toArray(new ModelType[0]);
    }
}

