/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.osgi.testing;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import org.jboss.logging.Logger;
import org.jboss.osgi.testing.OSGiTestHelper;
import org.jboss.osgi.vfs.VirtualFile;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.junit.After;
import org.junit.Before;
import org.junit.BeforeClass;
import org.osgi.framework.Bundle;

public abstract class OSGiTest {
    private static final Logger log = Logger.getLogger(OSGiTest.class);

    @Before
    public void setUp() throws Exception {
        log.debug((Object)("### START " + this.getLongName()));
    }

    @After
    public void tearDown() throws Exception {
        log.debug((Object)("### END " + this.getLongName()));
    }

    protected String getShortName() {
        String shortName = this.getClass().getName();
        shortName = shortName.substring(shortName.lastIndexOf(".") + 1);
        return shortName;
    }

    protected String getLongName() {
        return this.getClass().getName();
    }

    protected URL getResourceURL(String resource) {
        return OSGiTestHelper.getResourceURL(resource);
    }

    protected File getResourceFile(String resource) {
        return OSGiTestHelper.getResourceFile(resource);
    }

    protected URL getTestArchiveURL(String archive) {
        return OSGiTestHelper.getTestArchiveURL(archive);
    }

    protected String getTestArchivePath(String archive) {
        return OSGiTestHelper.getTestArchivePath(archive);
    }

    protected File getTestArchiveFile(String archive) {
        return OSGiTestHelper.getTestArchiveFile(archive);
    }

    protected String getServerHost() {
        return OSGiTestHelper.getServerHost();
    }

    protected String getTargetContainer() {
        return OSGiTestHelper.getTargetContainer();
    }

    protected String getFrameworkName() {
        return OSGiTestHelper.getFrameworkName();
    }

    protected JavaArchive assembleArchive(String name, String resource, Class<?> ... packages) throws Exception {
        return OSGiTestHelper.assembleArchive(name, resource, packages);
    }

    protected JavaArchive assembleArchive(String name, String[] resources, Class<?> ... packages) throws Exception {
        return OSGiTestHelper.assembleArchive(name, resources, packages);
    }

    protected VirtualFile toVirtualFile(Archive<?> archive) throws IOException, MalformedURLException {
        return OSGiTestHelper.toVirtualFile(archive);
    }

    protected InputStream toInputStream(Archive<?> archive) throws IOException, MalformedURLException {
        return OSGiTestHelper.toInputStream(archive);
    }

    protected void assertBundleState(int expState, int wasState) {
        OSGiTestHelper.assertBundleState(expState, wasState);
    }

    protected Class<?> assertLoadClass(Bundle bundle, String className) {
        return OSGiTestHelper.assertLoadClass(bundle, className);
    }

    protected void assertLoadClassFail(Bundle bundle, String className) {
        OSGiTestHelper.assertLoadClassFail(bundle, className);
    }

    protected void assertLoadClass(Bundle bundle, String className, Bundle exporter) {
        OSGiTestHelper.assertLoadClass(bundle, className, exporter);
    }

    boolean isBeforeClassPresent() {
        boolean isPresent = false;
        for (Method method : this.getClass().getDeclaredMethods()) {
            if (!method.isAnnotationPresent(BeforeClass.class)) continue;
            isPresent = true;
            break;
        }
        return isPresent;
    }
}

