/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.validator.metadata;

import java.lang.annotation.Annotation;
import java.lang.annotation.ElementType;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.validation.GroupDefinitionException;
import javax.validation.GroupSequence;
import javax.validation.Valid;
import javax.validation.groups.Default;
import javax.validation.metadata.BeanDescriptor;
import javax.validation.metadata.PropertyDescriptor;
import org.hibernate.validator.group.DefaultGroupSequenceProvider;
import org.hibernate.validator.group.GroupSequenceProvider;
import org.hibernate.validator.metadata.AggregatedMethodMetaData;
import org.hibernate.validator.metadata.AnnotationIgnores;
import org.hibernate.validator.metadata.BeanDescriptorImpl;
import org.hibernate.validator.metadata.BeanMetaConstraint;
import org.hibernate.validator.metadata.BeanMetaData;
import org.hibernate.validator.metadata.BeanMetaDataCache;
import org.hibernate.validator.metadata.ConstraintDescriptorImpl;
import org.hibernate.validator.metadata.ConstraintHelper;
import org.hibernate.validator.metadata.ConstraintOrigin;
import org.hibernate.validator.metadata.MethodMetaConstraint;
import org.hibernate.validator.metadata.MethodMetaData;
import org.hibernate.validator.metadata.ParameterMetaData;
import org.hibernate.validator.metadata.PropertyDescriptorImpl;
import org.hibernate.validator.method.metadata.TypeDescriptor;
import org.hibernate.validator.util.CollectionHelper;
import org.hibernate.validator.util.LoggerFactory;
import org.hibernate.validator.util.ReflectionHelper;
import org.slf4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class BeanMetaDataImpl<T>
implements BeanMetaData<T> {
    private static final Logger log = LoggerFactory.make();
    public static final String DEFAULT_PARAMETER_NAME_PREFIX = "arg";
    private final Class<T> beanClass;
    private final Map<Class<?>, List<BeanMetaConstraint<?>>> metaConstraints = CollectionHelper.newHashMap();
    private final Set<BeanMetaConstraint<?>> allMetaConstraints;
    private final Set<BeanMetaConstraint<?>> directMetaConstraints;
    private BeanDescriptorImpl<T> beanDescriptor;
    private Map<Method, AggregatedMethodMetaData> methodMetaData;
    private Set<AggregatedMethodMetaData.Builder> methodMetaDataBuilders = CollectionHelper.newHashSet();
    private Set<Member> cascadedMembers = CollectionHelper.newHashSet();
    private Map<String, PropertyDescriptor> propertyDescriptors = CollectionHelper.newHashMap();
    private List<Class<?>> defaultGroupSequence = CollectionHelper.newArrayList();
    private DefaultGroupSequenceProvider<T> defaultGroupSequenceProvider;
    private List<Class<?>> classHierarchyWithoutInterfaces;
    private ConstraintHelper constraintHelper;
    private final Set<String> propertyNames = CollectionHelper.newHashSet(30);

    public BeanMetaDataImpl(Class<T> beanClass, ConstraintHelper constraintHelper, BeanMetaDataCache beanMetaDataCache) {
        this(beanClass, constraintHelper, new ArrayList(), null, new HashMap(), new HashSet<AggregatedMethodMetaData>(), new HashSet<Member>(), new AnnotationIgnores(), beanMetaDataCache);
    }

    public BeanMetaDataImpl(Class<T> beanClass, ConstraintHelper constraintHelper, List<Class<?>> defaultGroupSequence, Class<? extends DefaultGroupSequenceProvider<?>> defaultGroupSequenceProvider, Map<Class<?>, List<BeanMetaConstraint<?>>> constraints, Set<AggregatedMethodMetaData> methodMetaDatas, Set<Member> cascadedMembers, AnnotationIgnores annotationIgnores, BeanMetaDataCache beanMetaDataCache) {
        this.beanClass = beanClass;
        this.constraintHelper = constraintHelper;
        this.defaultGroupSequenceProvider = null;
        for (Member member : cascadedMembers) {
            this.addCascadedMember(member);
        }
        this.classHierarchyWithoutInterfaces = ReflectionHelper.computeClassHierarchy(beanClass, false);
        this.createMetaData(annotationIgnores, beanMetaDataCache);
        if (!defaultGroupSequence.isEmpty()) {
            this.setDefaultGroupSequence(defaultGroupSequence);
        }
        if (defaultGroupSequenceProvider != null) {
            this.defaultGroupSequenceProvider = this.newGroupSequenceProviderInstance(defaultGroupSequenceProvider);
        }
        if (this.hasDefaultGroupSequenceProvider() && this.defaultGroupSequence.size() > 1) {
            throw new GroupDefinitionException("Default group sequence and default group sequence provider cannot be defined at the same time");
        }
        for (Map.Entry entry : constraints.entrySet()) {
            Class clazz = (Class)entry.getKey();
            HashMap constraintsByMethod = CollectionHelper.newHashMap();
            for (BeanMetaConstraint beanMetaConstraint : (List)entry.getValue()) {
                if (beanMetaConstraint.getDescriptor().getElementType() == ElementType.METHOD) {
                    ArrayList constraintsForMethod = (ArrayList)constraintsByMethod.get(beanMetaConstraint.getLocation().getMember());
                    if (constraintsForMethod == null) {
                        constraintsForMethod = CollectionHelper.newArrayList();
                        constraintsByMethod.put((Method)beanMetaConstraint.getLocation().getMember(), constraintsForMethod);
                    }
                    constraintsForMethod.add(this.getAsMethodMetaConstraint(beanMetaConstraint));
                    continue;
                }
                this.addMetaConstraint(clazz, beanMetaConstraint);
            }
            for (Map.Entry entry2 : constraintsByMethod.entrySet()) {
                MethodMetaData methodMetaData = new MethodMetaData((Method)entry2.getKey(), (List)entry2.getValue(), cascadedMembers.contains(entry2.getKey()));
                this.addMethodMetaConstraint(clazz, methodMetaData);
            }
        }
        this.allMetaConstraints = this.buildAllConstraintSets();
        this.directMetaConstraints = this.buildDirectConstraintSets();
        if (!methodMetaDatas.isEmpty()) {
            for (AggregatedMethodMetaData aggregatedMethodMetaData : methodMetaDatas) {
                for (MethodMetaData methodMetaData : aggregatedMethodMetaData.getAllMethodMetaData()) {
                    Method method = methodMetaData.getMethod();
                    this.addMethodMetaConstraint(method.getDeclaringClass(), methodMetaData);
                }
            }
        }
        this.methodMetaData = Collections.unmodifiableMap(this.buildMethodMetaData());
        this.methodMetaDataBuilders = null;
        this.constraintHelper = null;
    }

    @Override
    public Class<T> getBeanClass() {
        return this.beanClass;
    }

    @Override
    public BeanDescriptor getBeanDescriptor() {
        return this.beanDescriptor;
    }

    @Override
    public TypeDescriptor getTypeDescriptor() {
        return this.beanDescriptor;
    }

    @Override
    public Set<Member> getCascadedMembers() {
        return Collections.unmodifiableSet(this.cascadedMembers);
    }

    public Map<Class<?>, List<BeanMetaConstraint<?>>> getMetaConstraintsAsMap() {
        return Collections.unmodifiableMap(this.metaConstraints);
    }

    @Override
    public Set<BeanMetaConstraint<?>> getMetaConstraints() {
        return this.allMetaConstraints;
    }

    @Override
    public Set<BeanMetaConstraint<?>> getDirectMetaConstraints() {
        return this.directMetaConstraints;
    }

    @Override
    public AggregatedMethodMetaData getMetaDataFor(Method method) {
        return this.methodMetaData.get(method);
    }

    @Override
    public Set<AggregatedMethodMetaData> getAllMethodMetaData() {
        return new HashSet<AggregatedMethodMetaData>(this.methodMetaData.values());
    }

    @Override
    public PropertyDescriptor getPropertyDescriptor(String property) {
        return this.propertyDescriptors.get(property);
    }

    @Override
    public boolean isPropertyPresent(String name) {
        return this.propertyNames.contains(name);
    }

    @Override
    public List<Class<?>> getDefaultGroupSequence(T beanState) {
        if (this.hasDefaultGroupSequenceProvider()) {
            List<Class<?>> providerDefaultGroupSequence = this.defaultGroupSequenceProvider.getValidationGroups(beanState);
            return this.getValidDefaultGroupSequence(providerDefaultGroupSequence);
        }
        return Collections.unmodifiableList(this.defaultGroupSequence);
    }

    @Override
    public boolean defaultGroupSequenceIsRedefined() {
        return this.defaultGroupSequence.size() > 1 || this.hasDefaultGroupSequenceProvider();
    }

    private boolean hasDefaultGroupSequenceProvider() {
        return this.defaultGroupSequenceProvider != null;
    }

    @Override
    public Set<PropertyDescriptor> getConstrainedProperties() {
        return Collections.unmodifiableSet(new HashSet<PropertyDescriptor>(this.propertyDescriptors.values()));
    }

    private Set<BeanMetaConstraint<?>> buildAllConstraintSets() {
        HashSet constraints = CollectionHelper.newHashSet();
        for (List<BeanMetaConstraint<?>> list : this.metaConstraints.values()) {
            constraints.addAll(list);
        }
        return Collections.unmodifiableSet(constraints);
    }

    private Set<BeanMetaConstraint<?>> buildDirectConstraintSets() {
        HashSet constraints = CollectionHelper.newHashSet();
        if (this.metaConstraints.get(this.beanClass) != null) {
            constraints.addAll((Collection)this.metaConstraints.get(this.beanClass));
        }
        Set<Class<?>> classAndInterfaces = ReflectionHelper.computeAllImplementedInterfaces(this.beanClass);
        for (Class<?> clazz : classAndInterfaces) {
            if (this.metaConstraints.get(clazz) == null) continue;
            constraints.addAll((Collection)this.metaConstraints.get(clazz));
        }
        return Collections.unmodifiableSet(constraints);
    }

    private Map<Method, AggregatedMethodMetaData> buildMethodMetaData() {
        HashMap<Method, AggregatedMethodMetaData> theValue = CollectionHelper.newHashMap();
        for (AggregatedMethodMetaData.Builder oneBuilder : this.methodMetaDataBuilders) {
            AggregatedMethodMetaData aggregatedMethodMetaData = oneBuilder.build();
            for (MethodMetaData oneMethodMetaData : aggregatedMethodMetaData.getAllMethodMetaData()) {
                theValue.put(oneMethodMetaData.getMethod(), aggregatedMethodMetaData);
            }
        }
        return theValue;
    }

    private void setDefaultGroupSequence(List<Class<?>> groupSequence) {
        this.defaultGroupSequence = this.getValidDefaultGroupSequence(groupSequence);
    }

    private List<Class<?>> getValidDefaultGroupSequence(List<Class<?>> groupSequence) {
        ArrayList validDefaultGroupSequence = new ArrayList();
        boolean groupSequenceContainsDefault = false;
        if (groupSequence != null) {
            for (Class<?> group : groupSequence) {
                if (group.getName().equals(this.beanClass.getName())) {
                    validDefaultGroupSequence.add(Default.class);
                    groupSequenceContainsDefault = true;
                    continue;
                }
                if (group.getName().equals(Default.class.getName())) {
                    throw new GroupDefinitionException("'Default.class' cannot appear in default group sequence list.");
                }
                validDefaultGroupSequence.add(group);
            }
        }
        if (!groupSequenceContainsDefault) {
            throw new GroupDefinitionException(this.beanClass.getName() + " must be part of the redefined default group sequence.");
        }
        if (log.isTraceEnabled()) {
            log.trace("Members of the default group sequence for bean {} are: {}", (Object)this.beanClass.getName(), validDefaultGroupSequence);
        }
        return validDefaultGroupSequence;
    }

    private void addMetaConstraint(Class<?> clazz, BeanMetaConstraint<?> metaConstraint) {
        List<Object> constraintList;
        if (!this.metaConstraints.containsKey(clazz)) {
            constraintList = new ArrayList();
            this.metaConstraints.put(clazz, constraintList);
        } else {
            constraintList = this.metaConstraints.get(clazz);
        }
        constraintList.add(metaConstraint);
        if (metaConstraint.getElementType() == ElementType.TYPE) {
            this.beanDescriptor.addConstraintDescriptor(metaConstraint.getDescriptor());
        } else {
            PropertyDescriptorImpl propertyDescriptor = (PropertyDescriptorImpl)this.propertyDescriptors.get(metaConstraint.getLocation().getPropertyName());
            if (propertyDescriptor == null) {
                Member member = metaConstraint.getLocation().getMember();
                propertyDescriptor = this.addPropertyDescriptorForMember(member, this.isValidAnnotationPresent(member));
            }
            propertyDescriptor.addConstraintDescriptor(metaConstraint.getDescriptor());
        }
    }

    private void addMethodMetaConstraint(Class<?> clazz, MethodMetaData methodMetaData) {
        this.addToBuilder(methodMetaData);
        if (ReflectionHelper.isGetterMethod(methodMetaData.getMethod())) {
            this.addToPropertyNameList(methodMetaData.getMethod());
            ReflectionHelper.setAccessibility(methodMetaData.getMethod());
            for (MethodMetaConstraint<?> metaConstraint : methodMetaData) {
                this.addMetaConstraint(clazz, this.getAsBeanMetaConstraint(metaConstraint, methodMetaData.getMethod()));
            }
            if (methodMetaData.isCascading()) {
                this.addCascadedMember(methodMetaData.getMethod());
            }
        }
    }

    private void addToBuilder(MethodMetaData metaData) {
        for (AggregatedMethodMetaData.Builder oneBuilder : this.methodMetaDataBuilders) {
            if (!oneBuilder.accepts(metaData)) continue;
            oneBuilder.addMetaData(metaData);
            return;
        }
        AggregatedMethodMetaData.Builder newBuilder = new AggregatedMethodMetaData.Builder(metaData);
        this.methodMetaDataBuilders.add(newBuilder);
    }

    private void addCascadedMember(Member member) {
        ReflectionHelper.setAccessibility(member);
        this.cascadedMembers.add(member);
        this.addPropertyDescriptorForMember(member, true);
    }

    @Override
    public List<Class<?>> getClassHierarchy() {
        return this.classHierarchyWithoutInterfaces;
    }

    private void createMetaData(AnnotationIgnores annotationIgnores, BeanMetaDataCache beanMetaDataCache) {
        this.beanDescriptor = new BeanDescriptorImpl(this);
        this.initDefaultGroupSequence();
        for (Class<?> current : ReflectionHelper.computeClassHierarchy(this.beanClass, true)) {
            this.initClass(current, annotationIgnores, beanMetaDataCache);
        }
    }

    private void initClass(Class<?> clazz, AnnotationIgnores annotationIgnores, BeanMetaDataCache beanMetaDataCache) {
        this.initClassConstraints(clazz, annotationIgnores, beanMetaDataCache);
        this.initMethodConstraints(clazz, annotationIgnores, beanMetaDataCache);
        this.initFieldConstraints(clazz, annotationIgnores, beanMetaDataCache);
    }

    private void initDefaultGroupSequence() {
        ArrayList groupSequence = new ArrayList();
        GroupSequenceProvider groupSequenceProviderAnnotation = this.beanClass.getAnnotation(GroupSequenceProvider.class);
        GroupSequence groupSequenceAnnotation = this.beanClass.getAnnotation(GroupSequence.class);
        if (groupSequenceAnnotation != null && groupSequenceProviderAnnotation != null) {
            throw new GroupDefinitionException("GroupSequence and GroupSequenceProvider annotations cannot be used at the same time");
        }
        if (groupSequenceProviderAnnotation != null) {
            this.defaultGroupSequenceProvider = this.newGroupSequenceProviderInstance(groupSequenceProviderAnnotation.value());
        } else if (groupSequenceAnnotation != null) {
            groupSequence.addAll(Arrays.asList(groupSequenceAnnotation.value()));
            this.setDefaultGroupSequence(groupSequence);
        } else {
            groupSequence.add(this.beanClass);
            this.setDefaultGroupSequence(groupSequence);
        }
    }

    private void initFieldConstraints(Class<?> clazz, AnnotationIgnores annotationIgnores, BeanMetaDataCache beanMetaDataCache) {
        Field[] fields;
        for (Field field : fields = ReflectionHelper.getDeclaredFields(clazz)) {
            boolean isCascadedField;
            List<ConstraintDescriptorImpl<?>> fieldMetaData;
            boolean metaDataCached;
            this.addToPropertyNameList(field);
            if (Modifier.isStatic(field.getModifiers()) || annotationIgnores.isIgnoreAnnotations(field)) continue;
            BeanMetaDataImpl<?> cachedMetaData = beanMetaDataCache.getBeanMetaData(clazz);
            boolean bl = metaDataCached = cachedMetaData != null;
            if (metaDataCached && cachedMetaData.getMetaConstraintsAsMap().get(clazz) != null) {
                fieldMetaData = new ArrayList();
                for (BeanMetaConstraint beanMetaConstraint : cachedMetaData.getMetaConstraintsAsMap().get(clazz)) {
                    ConstraintDescriptorImpl descriptor = beanMetaConstraint.getDescriptor();
                    if (descriptor.getElementType() != ElementType.FIELD || !beanMetaConstraint.getLocation().getPropertyName().equals(ReflectionHelper.getPropertyName(field))) continue;
                    fieldMetaData.add(descriptor);
                }
            } else {
                fieldMetaData = this.findConstraints(field, ElementType.FIELD);
            }
            for (ConstraintDescriptorImpl<?> constraintDescriptorImpl : fieldMetaData) {
                ReflectionHelper.setAccessibility(field);
                BeanMetaConstraint<?> metaConstraint = this.createBeanMetaConstraint(clazz, field, constraintDescriptorImpl);
                this.addMetaConstraint(clazz, metaConstraint);
            }
            boolean bl2 = isCascadedField = metaDataCached && cachedMetaData.getCascadedMembers().contains(field);
            if (!isCascadedField && !field.isAnnotationPresent(Valid.class)) continue;
            this.addCascadedMember(field);
        }
    }

    private void addToPropertyNameList(Member member) {
        String name = ReflectionHelper.getPropertyName(member);
        if (name != null) {
            this.propertyNames.add(name);
        }
    }

    private void initMethodConstraints(Class<?> clazz, AnnotationIgnores annotationIgnores, BeanMetaDataCache beanMetaDataCache) {
        Method[] declaredMethods;
        for (Method method : declaredMethods = ReflectionHelper.getDeclaredMethods(clazz)) {
            if (Modifier.isStatic(method.getModifiers()) || annotationIgnores.isIgnoreAnnotations(method) || method.isSynthetic()) continue;
            MethodMetaData methodMetaData = this.getFromCache(clazz, method, beanMetaDataCache);
            if (methodMetaData == null) {
                methodMetaData = this.findMethodMetaData(method);
            }
            this.addMethodMetaConstraint(clazz, methodMetaData);
        }
    }

    private MethodMetaData getFromCache(Class<?> clazz, Method method, BeanMetaDataCache beanMetaDataCache) {
        AggregatedMethodMetaData cachedMethodMetaData;
        BeanMetaDataImpl<?> cachedBeanMetaData = beanMetaDataCache.getBeanMetaData(clazz);
        if (cachedBeanMetaData != null && (cachedMethodMetaData = cachedBeanMetaData.getMetaDataFor(method)) != null) {
            return cachedMethodMetaData.getSingleMetaDataFor(method);
        }
        return null;
    }

    private PropertyDescriptorImpl addPropertyDescriptorForMember(Member member, boolean isCascaded) {
        String name = ReflectionHelper.getPropertyName(member);
        PropertyDescriptorImpl propertyDescriptor = (PropertyDescriptorImpl)this.propertyDescriptors.get(name);
        if (propertyDescriptor == null) {
            propertyDescriptor = new PropertyDescriptorImpl(ReflectionHelper.getType(member), isCascaded, name, this);
            this.propertyDescriptors.put(name, propertyDescriptor);
        }
        return propertyDescriptor;
    }

    private boolean isValidAnnotationPresent(Member member) {
        return ((AnnotatedElement)((Object)member)).isAnnotationPresent(Valid.class);
    }

    private void initClassConstraints(Class<?> clazz, AnnotationIgnores annotationIgnores, BeanMetaDataCache beanMetaDataCache) {
        List<ConstraintDescriptorImpl<?>> classMetaData;
        if (annotationIgnores.isIgnoreAnnotations(clazz)) {
            return;
        }
        BeanMetaDataImpl<?> cachedMetaData = beanMetaDataCache.getBeanMetaData(clazz);
        if (cachedMetaData != null && cachedMetaData.getMetaConstraintsAsMap().get(clazz) != null) {
            classMetaData = new ArrayList();
            for (BeanMetaConstraint beanMetaConstraint : cachedMetaData.getMetaConstraintsAsMap().get(clazz)) {
                ConstraintDescriptorImpl descriptor = beanMetaConstraint.getDescriptor();
                if (descriptor.getElementType() != ElementType.TYPE) continue;
                classMetaData.add(descriptor);
            }
        } else {
            classMetaData = this.findClassLevelConstraints(clazz);
        }
        for (ConstraintDescriptorImpl<?> constraintDescriptorImpl : classMetaData) {
            BeanMetaConstraint<?> metaConstraint = this.createBeanMetaConstraint(clazz, null, constraintDescriptorImpl);
            this.addMetaConstraint(clazz, metaConstraint);
        }
    }

    private <A extends Annotation> BeanMetaConstraint<?> createBeanMetaConstraint(Class<?> declaringClass, Member m, ConstraintDescriptorImpl<A> descriptor) {
        return new BeanMetaConstraint<A>(descriptor, declaringClass, m);
    }

    private <A extends Annotation> MethodMetaConstraint<A> createParameterMetaConstraint(Method method, int parameterIndex, ConstraintDescriptorImpl<A> descriptor) {
        return new MethodMetaConstraint<A>(descriptor, method, parameterIndex);
    }

    private <A extends Annotation> MethodMetaConstraint<A> createReturnValueMetaConstraint(Method method, ConstraintDescriptorImpl<A> descriptor) {
        return new MethodMetaConstraint<A>(descriptor, method);
    }

    private <A extends Annotation> List<ConstraintDescriptorImpl<?>> findConstraintAnnotations(Class<?> clazz, A annotation, ElementType type) {
        ArrayList constraintDescriptors = new ArrayList();
        ArrayList<Annotation> constraints = new ArrayList<Annotation>();
        Class<? extends Annotation> annotationType = annotation.annotationType();
        if (this.constraintHelper.isConstraintAnnotation(annotationType) || this.constraintHelper.isBuiltinConstraint(annotationType)) {
            constraints.add(annotation);
        } else if (this.constraintHelper.isMultiValueConstraint(annotationType)) {
            constraints.addAll(this.constraintHelper.getMultiValueConstraints(annotation));
        }
        for (Annotation constraint : constraints) {
            ConstraintDescriptorImpl<Annotation> constraintDescriptor = this.buildConstraintDescriptor(clazz, constraint, type);
            constraintDescriptors.add(constraintDescriptor);
        }
        return constraintDescriptors;
    }

    private <A extends Annotation> ConstraintDescriptorImpl<A> buildConstraintDescriptor(Class<?> clazz, A annotation, ElementType type) {
        ConstraintOrigin definedIn = this.determineOrigin(clazz);
        ConstraintDescriptorImpl<A> constraintDescriptor = clazz.isInterface() && !clazz.equals(this.beanClass) ? new ConstraintDescriptorImpl<A>(annotation, this.constraintHelper, clazz, type, definedIn) : new ConstraintDescriptorImpl<A>(annotation, this.constraintHelper, type, definedIn);
        return constraintDescriptor;
    }

    private List<ConstraintDescriptorImpl<?>> findClassLevelConstraints(Class<?> beanClass) {
        ArrayList metaData = new ArrayList();
        for (Annotation annotation : beanClass.getAnnotations()) {
            metaData.addAll(this.findConstraintAnnotations(beanClass, annotation, ElementType.TYPE));
        }
        return metaData;
    }

    private List<ConstraintDescriptorImpl<?>> findConstraints(Member member, ElementType type) {
        assert (member instanceof Field || member instanceof Method);
        ArrayList metaData = new ArrayList();
        for (Annotation annotation : ((AnnotatedElement)((Object)member)).getAnnotations()) {
            metaData.addAll(this.findConstraintAnnotations(member.getDeclaringClass(), annotation, type));
        }
        return metaData;
    }

    private MethodMetaData findMethodMetaData(Method method) {
        List<ParameterMetaData> parameterConstraints = this.getParameterMetaData(method);
        boolean isCascading = this.isValidAnnotationPresent(method) || this.cascadedMembers.contains(method);
        List<MethodMetaConstraint<?>> constraints = this.convertToMetaConstraints(this.findConstraints(method, ElementType.METHOD), method);
        return new MethodMetaData(method, parameterConstraints, constraints, isCascading);
    }

    private List<MethodMetaConstraint<?>> convertToMetaConstraints(List<ConstraintDescriptorImpl<?>> constraintsDescriptors, Method method) {
        ArrayList<MethodMetaConstraint<?>> constraints = CollectionHelper.newArrayList();
        for (ConstraintDescriptorImpl<?> oneDescriptor : constraintsDescriptors) {
            constraints.add(this.createReturnValueMetaConstraint(method, oneDescriptor));
        }
        return constraints;
    }

    private List<ParameterMetaData> getParameterMetaData(Method method) {
        ArrayList<ParameterMetaData> metaData = CollectionHelper.newArrayList();
        int i = 0;
        Class<?>[] parameterTypes = method.getParameterTypes();
        for (Annotation[] annotationsOfOneParameter : method.getParameterAnnotations()) {
            boolean parameterIsCascading = false;
            String parameterName = DEFAULT_PARAMETER_NAME_PREFIX + i;
            ArrayList<MethodMetaConstraint<?>> constraintsOfOneParameter = CollectionHelper.newArrayList();
            for (Annotation oneAnnotation : annotationsOfOneParameter) {
                List<ConstraintDescriptorImpl<?>> constraints = this.findConstraintAnnotations(method.getDeclaringClass(), oneAnnotation, ElementType.PARAMETER);
                for (ConstraintDescriptorImpl<?> constraintDescriptorImpl : constraints) {
                    constraintsOfOneParameter.add(this.createParameterMetaConstraint(method, i, constraintDescriptorImpl));
                }
                if (!oneAnnotation.annotationType().equals(Valid.class)) continue;
                parameterIsCascading = true;
            }
            metaData.add(new ParameterMetaData(i, parameterTypes[i], parameterName, constraintsOfOneParameter, parameterIsCascading));
            ++i;
        }
        return metaData;
    }

    private <A extends Annotation> MethodMetaConstraint<A> getAsMethodMetaConstraint(BeanMetaConstraint<A> beanMetaConstraint) {
        return new MethodMetaConstraint(beanMetaConstraint.getDescriptor(), (Method)beanMetaConstraint.getLocation().getMember());
    }

    private <A extends Annotation> BeanMetaConstraint<A> getAsBeanMetaConstraint(MethodMetaConstraint<A> methodMetaConstraint, Method method) {
        return new BeanMetaConstraint(methodMetaConstraint.getDescriptor(), methodMetaConstraint.getLocation().getBeanClass(), method);
    }

    private ConstraintOrigin determineOrigin(Class<?> clazz) {
        if (clazz.equals(this.beanClass)) {
            return ConstraintOrigin.DEFINED_LOCALLY;
        }
        return ConstraintOrigin.DEFINED_IN_HIERARCHY;
    }

    private <U extends DefaultGroupSequenceProvider<?>> DefaultGroupSequenceProvider<T> newGroupSequenceProviderInstance(Class<U> providerClass) {
        Method[] providerMethods;
        for (Method method : providerMethods = ReflectionHelper.getMethods(providerClass)) {
            Class<?>[] paramTypes = method.getParameterTypes();
            if (!"getValidationGroups".equals(method.getName()) || method.isBridge() || paramTypes.length != 1 || !paramTypes[0].isAssignableFrom(this.beanClass)) continue;
            return (DefaultGroupSequenceProvider)ReflectionHelper.newInstance(providerClass, "the default group sequence provider");
        }
        throw new GroupDefinitionException("The default group sequence provider defined for " + this.beanClass.getName() + " has the wrong type");
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("BeanMetaDataImpl");
        sb.append("{beanClass=").append(this.beanClass.getSimpleName());
        sb.append(", constraintCount=").append(this.getMetaConstraints().size());
        sb.append(", cascadedMemberCount=").append(this.cascadedMembers.size());
        sb.append(", defaultGroupSequence=").append(this.getDefaultGroupSequence(null));
        sb.append('}');
        return sb.toString();
    }
}

