/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.component.stateful;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import javax.ejb.CreateException;
import org.jboss.as.ejb3.component.interceptors.AbstractEJBInterceptor;
import org.jboss.as.ejb3.component.interceptors.EjbExceptionTransformingInterceptorFactories;
import org.jboss.as.ejb3.component.interceptors.SessionBeanHomeInterceptorFactory;
import org.jboss.invocation.Interceptor;
import org.jboss.invocation.InterceptorContext;
import org.jboss.invocation.InterceptorFactory;
import org.jboss.invocation.InterceptorFactoryContext;
import org.jboss.invocation.Interceptors;

public class StatefulInitMethodInterceptorFactory
implements InterceptorFactory {
    public static final InterceptorFactory INSTANCE = new StatefulInitMethodInterceptorFactory();

    private StatefulInitMethodInterceptorFactory() {
    }

    public Interceptor create(InterceptorFactoryContext context) {
        final Method method = SessionBeanHomeInterceptorFactory.INIT_METHOD.get();
        final Object[] params = SessionBeanHomeInterceptorFactory.INIT_PARAMETERS.get();
        SessionBeanHomeInterceptorFactory.INIT_METHOD.remove();
        SessionBeanHomeInterceptorFactory.INIT_PARAMETERS.remove();
        return new AbstractEJBInterceptor(){

            public Object processInvocation(InterceptorContext context) throws Exception {
                if (method != null) {
                    try {
                        method.invoke(context.getTarget(), params);
                    }
                    catch (InvocationTargetException e) {
                        if (CreateException.class.isAssignableFrom(e.getCause().getClass())) {
                            EjbExceptionTransformingInterceptorFactories.setCreateException((CreateException)e.getCause());
                        }
                        throw Interceptors.rethrow((Throwable)e.getCause());
                    }
                }
                return context.proceed();
            }
        };
    }
}

