/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jca.core.tx.jbossts;

import java.security.AccessController;
import java.security.Principal;
import java.security.PrivilegedAction;
import java.util.Set;
import javax.resource.ResourceException;
import javax.resource.spi.ManagedConnection;
import javax.resource.spi.ManagedConnectionFactory;
import javax.resource.spi.security.PasswordCredential;
import javax.security.auth.Subject;
import javax.transaction.xa.XAResource;
import org.jboss.jca.core.CoreLogger;
import org.jboss.jca.core.spi.recovery.RecoveryPlugin;
import org.jboss.jca.core.spi.transaction.TransactionIntegration;
import org.jboss.jca.core.spi.transaction.recovery.XAResourceRecovery;
import org.jboss.logging.Logger;
import org.jboss.security.SimplePrincipal;
import org.jboss.security.SubjectFactory;

public class XAResourceRecoveryImpl
implements XAResourceRecovery,
org.jboss.tm.XAResourceRecovery {
    private static CoreLogger log = (CoreLogger)Logger.getMessageLogger(CoreLogger.class, (String)XAResourceRecoveryImpl.class.getName());
    private final TransactionIntegration ti;
    private final ManagedConnectionFactory mcf;
    private final Boolean padXid;
    private final Boolean isSameRMOverrideValue;
    private final Boolean wrapXAResource;
    private final String recoverUserName;
    private final String recoverPassword;
    private final String recoverSecurityDomain;
    private final SubjectFactory subjectFactory;
    private final RecoveryPlugin plugin;
    private ManagedConnection recoverMC;
    private String jndiName;

    public XAResourceRecoveryImpl(TransactionIntegration ti, ManagedConnectionFactory mcf, Boolean padXid, Boolean isSameRMOverrideValue, Boolean wrapXAResource, String recoverUserName, String recoverPassword, String recoverSecurityDomain, SubjectFactory subjectFactory, RecoveryPlugin plugin) {
        if (ti == null) {
            throw new IllegalArgumentException("TransactionIntegration is null");
        }
        if (mcf == null) {
            throw new IllegalArgumentException("MCF is null");
        }
        if (plugin == null) {
            throw new IllegalArgumentException("Plugin is null");
        }
        this.ti = ti;
        this.mcf = mcf;
        this.padXid = padXid;
        this.isSameRMOverrideValue = isSameRMOverrideValue;
        this.wrapXAResource = wrapXAResource;
        this.recoverUserName = recoverUserName;
        this.recoverPassword = recoverPassword;
        this.recoverSecurityDomain = recoverSecurityDomain;
        this.subjectFactory = subjectFactory;
        this.plugin = plugin;
        this.recoverMC = null;
        this.jndiName = null;
    }

    public void setJndiName(String jndiName) {
        this.jndiName = jndiName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public XAResource[] getXAResources() {
        try {
            Subject subject = this.getSubject();
            if (subject != null) {
                ManagedConnection mc = this.open(subject);
                XAResource xaResource = null;
                Object connection = null;
                try {
                    connection = this.openConnection(mc, subject);
                    xaResource = mc.getXAResource();
                }
                catch (ResourceException reconnect) {
                    this.closeConnection(connection);
                    connection = null;
                    this.close(mc);
                    mc = this.open(subject);
                    xaResource = mc.getXAResource();
                }
                finally {
                    boolean forceDestroy = this.closeConnection(connection);
                    connection = null;
                    if (forceDestroy) {
                        this.close(mc);
                        mc = this.open(subject);
                        xaResource = mc.getXAResource();
                    }
                }
                if (this.wrapXAResource.booleanValue()) {
                    String eisProductName = null;
                    String eisProductVersion = null;
                    try {
                        if (mc.getMetaData() != null) {
                            eisProductName = mc.getMetaData().getEISProductName();
                            eisProductVersion = mc.getMetaData().getEISProductVersion();
                        }
                    }
                    catch (ResourceException re) {
                        // empty catch block
                    }
                    if (eisProductName == null) {
                        eisProductName = this.jndiName;
                    }
                    if (eisProductVersion == null) {
                        eisProductVersion = this.jndiName;
                    }
                    xaResource = this.ti.createXAResourceWrapper(xaResource, this.padXid.booleanValue(), this.isSameRMOverrideValue, eisProductName, eisProductVersion, this.jndiName);
                }
                log.debugf("Recovery XAResource=%s for %s", xaResource, this.jndiName);
                return new XAResource[]{xaResource};
            }
            log.debugf("Subject for recovery was null", new Object[0]);
        }
        catch (ResourceException re) {
            log.debugf("Error during recovery", (Object)re);
        }
        return new XAResource[0];
    }

    private Subject getSubject() {
        return AccessController.doPrivileged(new PrivilegedAction<Subject>(){

            @Override
            public Subject run() {
                if (XAResourceRecoveryImpl.this.recoverUserName != null && XAResourceRecoveryImpl.this.recoverPassword != null) {
                    log.debugf("Recovery user name=%s", XAResourceRecoveryImpl.this.recoverUserName);
                    Subject subject = new Subject();
                    SimplePrincipal p = new SimplePrincipal(XAResourceRecoveryImpl.this.recoverUserName);
                    subject.getPrincipals().add((Principal)p);
                    PasswordCredential pc = new PasswordCredential(XAResourceRecoveryImpl.this.recoverUserName, XAResourceRecoveryImpl.this.recoverPassword.toCharArray());
                    pc.setManagedConnectionFactory(XAResourceRecoveryImpl.this.mcf);
                    subject.getPrivateCredentials().add(pc);
                    log.debugf("Recovery Subject=%s", subject);
                    return subject;
                }
                try {
                    String domain = XAResourceRecoveryImpl.this.recoverSecurityDomain;
                    if (domain != null && XAResourceRecoveryImpl.this.subjectFactory != null) {
                        Subject subject = XAResourceRecoveryImpl.this.subjectFactory.createSubject(domain);
                        Set<PasswordCredential> pcs = subject.getPrivateCredentials(PasswordCredential.class);
                        if (pcs != null && pcs.size() > 0) {
                            for (PasswordCredential pc : pcs) {
                                pc.setManagedConnectionFactory(XAResourceRecoveryImpl.this.mcf);
                            }
                        }
                        log.debugf("Recovery Subject=%s", subject);
                        return subject;
                    }
                    log.debugf("RecoverySecurityDomain was empty", new Object[0]);
                }
                catch (Throwable t) {
                    log.debugf("Exception during getSubject() - %s", t.getMessage(), t);
                }
                return null;
            }
        });
    }

    private ManagedConnection open(Subject s) throws ResourceException {
        log.debugf("Open managed connection (%s)", s);
        if (this.recoverMC == null) {
            this.recoverMC = this.mcf.createManagedConnection(s, null);
        }
        return this.recoverMC;
    }

    private void close(ManagedConnection mc) {
        log.debugf("Closing managed connection for recovery (%s)", mc);
        if (mc != null) {
            try {
                mc.cleanup();
            }
            catch (ResourceException ire) {
                log.debugf("Error during recovery cleanup", (Object)ire);
            }
        }
        if (mc != null) {
            try {
                mc.destroy();
            }
            catch (ResourceException ire) {
                log.debugf("Error during recovery destroy", (Object)ire);
            }
        }
        mc = null;
        this.recoverMC = null;
    }

    private Object openConnection(ManagedConnection mc, Subject s) throws ResourceException {
        log.debugf("Open connection (%s, %s)", mc, s);
        return mc.getConnection(s, null);
    }

    private boolean closeConnection(Object c) {
        log.debugf("Closing connection for recovery check (%s)", c);
        boolean forceClose = false;
        if (c != null) {
            try {
                forceClose = !this.plugin.isValid(c);
            }
            catch (ResourceException re) {
                log.debugf("Error during recovery plugin isValid()", (Object)re);
                forceClose = true;
            }
            try {
                this.plugin.close(c);
            }
            catch (ResourceException re) {
                log.debugf("Error during recovery plugin close()", (Object)re);
                forceClose = true;
            }
        }
        log.debugf("Force close=%s", forceClose);
        return forceClose;
    }
}

