/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.jgroups.subsystem;

import java.util.HashMap;
import java.util.Map;

public enum Attribute {
    UNKNOWN(null),
    DEFAULT_EXECUTOR("default-executor"),
    DEFAULT_STACK("default-stack"),
    DIAGNOSTICS_SOCKET_BINDING("diagnostics-socket-binding"),
    MACHINE("machine"),
    NAME("name"),
    NAMESPACE("xmlns"),
    OOB_EXECUTOR("oob-executor"),
    RACK("rack"),
    SHARED("shared"),
    SITE("site"),
    SOCKET_BINDING("socket-binding"),
    THREAD_FACTORY("thread-factory"),
    TIMER_EXECUTOR("timer-executor"),
    TYPE("type");

    private final String name;
    private static final Map<String, Attribute> attributes;

    private Attribute(String name) {
        this.name = name;
    }

    public String getLocalName() {
        return this.name;
    }

    public static Attribute forName(String localName) {
        Attribute attribute = attributes.get(localName);
        return attribute == null ? UNKNOWN : attribute;
    }

    static {
        HashMap<String, Attribute> map = new HashMap<String, Attribute>();
        for (Attribute attribute : Attribute.values()) {
            String name = attribute.getLocalName();
            if (name == null) continue;
            map.put(name, attribute);
        }
        attributes = map;
    }
}

