/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.jgroups.subsystem;

import java.util.Locale;
import java.util.ResourceBundle;
import org.jboss.as.clustering.jgroups.subsystem.CommonAttributes;
import org.jboss.as.clustering.jgroups.subsystem.Namespace;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;

public class JGroupsDescriptions {
    public static final String RESOURCE_NAME = JGroupsDescriptions.class.getPackage().getName() + ".LocalDescriptions";

    private JGroupsDescriptions() {
    }

    static ModelNode getSubsystemDescription(Locale locale) {
        ResourceBundle resources = JGroupsDescriptions.getResources(locale);
        ModelNode subsystem = JGroupsDescriptions.createDescription(resources, "jgroups");
        subsystem.get("head-comment-allowed").set(true);
        subsystem.get("tail-comment-allowed").set(true);
        subsystem.get("namespace").set(Namespace.CURRENT.getUri());
        subsystem.get(new String[]{"children", "stack", "description"}).set(resources.getString("jgroups.stack"));
        subsystem.get(new String[]{"children", "stack", "min-occurs"}).set(1);
        subsystem.get(new String[]{"children", "stack", "max-occurs"}).set(Integer.MAX_VALUE);
        subsystem.get(new String[]{"children", "stack", "model-description"}).setEmptyObject();
        return subsystem;
    }

    static ModelNode getSubsystemAddDescription(Locale locale) {
        ResourceBundle resources = JGroupsDescriptions.getResources(locale);
        ModelNode op = JGroupsDescriptions.createOperationDescription("add", resources, "jgroups.add");
        CommonAttributes.DEFAULT_STACK.addOperationParameterDescription(resources, "jgroups", op);
        return op;
    }

    static ModelNode getSubsystemRemoveDescription(Locale locale) {
        ResourceBundle resources = JGroupsDescriptions.getResources(locale);
        ModelNode op = JGroupsDescriptions.createOperationDescription("remove", resources, "jgroups.remove");
        op.get("reply-properties").setEmptyObject();
        op.get("request-properties").setEmptyObject();
        return op;
    }

    static ModelNode getSubsystemDescribeDescription(Locale locale) {
        ResourceBundle resources = JGroupsDescriptions.getResources(locale);
        ModelNode op = JGroupsDescriptions.createOperationDescription("describe", resources, "jgroups.describe");
        op.get("request-properties").setEmptyObject();
        op.get(new String[]{"reply-properties", "type"}).set(ModelType.LIST);
        op.get(new String[]{"reply-properties", "value-type"}).set(ModelType.OBJECT);
        return op;
    }

    static ModelNode getProtocolStackDescription(Locale locale) {
        ResourceBundle resources = JGroupsDescriptions.getResources(locale);
        ModelNode stack = JGroupsDescriptions.createDescription(resources, "jgroups.stack");
        stack.get(new String[]{"children", "transport", "description"}).set(resources.getString("jgroups.stack.transport"));
        stack.get(new String[]{"children", "transport", "min-occurs"}).set(0);
        stack.get(new String[]{"children", "transport", "max-occurs"}).set(1);
        stack.get(new String[]{"children", "transport", "allowed"}).setEmptyList().add("TRANSPORT");
        stack.get(new String[]{"children", "transport", "model-description"});
        stack.get(new String[]{"children", "protocol", "description"}).set(resources.getString("jgroups.stack.protocol"));
        stack.get(new String[]{"children", "protocol", "min-occurs"}).set(0);
        stack.get(new String[]{"children", "protocol", "max-occurs"}).set(Integer.MAX_VALUE);
        stack.get(new String[]{"children", "protocol", "model-description"});
        return stack;
    }

    static ModelNode getProtocolStackAddDescription(Locale locale) {
        ResourceBundle resources = JGroupsDescriptions.getResources(locale);
        ModelNode op = JGroupsDescriptions.createOperationDescription("add", resources, "jgroups.stack.add");
        return op;
    }

    static ModelNode getProtocolStackRemoveDescription(Locale locale) {
        ResourceBundle resources = JGroupsDescriptions.getResources(locale);
        ModelNode op = JGroupsDescriptions.createOperationDescription("remove", resources, "jgroups.stack.remove");
        op.get("request-properties").setEmptyObject();
        return op;
    }

    static ModelNode getTransportDescription(Locale locale) {
        ResourceBundle resources = JGroupsDescriptions.getResources(locale);
        ModelNode transport = JGroupsDescriptions.createDescription(resources, "jgroups.stack.transport");
        for (AttributeDefinition attr : CommonAttributes.TRANSPORT_ATTRIBUTES) {
            if (attr.getName().equals(CommonAttributes.PROPERTIES.getName())) continue;
            attr.addResourceAttributeDescription(resources, "jgroups.stack.transport", transport);
        }
        transport.get(new String[]{"children", "property", "description"}).set(resources.getString("jgroups.stack.transport.property"));
        transport.get(new String[]{"children", "property", "min-occurs"}).set(0);
        transport.get(new String[]{"children", "property", "max-occurs"}).set(Integer.MAX_VALUE);
        transport.get(new String[]{"children", "property", "model-description"});
        return transport;
    }

    static ModelNode getTransportAddDescription(Locale locale) {
        ResourceBundle resources = JGroupsDescriptions.getResources(locale);
        ModelNode op = JGroupsDescriptions.createOperationDescription("add", resources, "jgroups.stack.transport.add");
        for (AttributeDefinition attr : CommonAttributes.TRANSPORT_ATTRIBUTES) {
            attr.addOperationParameterDescription(resources, "jgroups.stack.transport", op);
        }
        return op;
    }

    static ModelNode getTransportRemoveDescription(Locale locale) {
        ResourceBundle resources = JGroupsDescriptions.getResources(locale);
        ModelNode op = JGroupsDescriptions.createOperationDescription("remove", resources, "jgroups.stack.transport.remove");
        op.get("request-properties").setEmptyObject();
        return op;
    }

    static ModelNode getProtocolDescription(Locale locale) {
        ResourceBundle resources = JGroupsDescriptions.getResources(locale);
        ModelNode protocol = JGroupsDescriptions.createDescription(resources, "jgroups.stack.protocol");
        for (AttributeDefinition attr : CommonAttributes.PROTOCOL_ATTRIBUTES) {
            if (attr.getName().equals(CommonAttributes.PROPERTIES.getName())) continue;
            attr.addResourceAttributeDescription(resources, "jgroups.stack.protocol", protocol);
        }
        protocol.get(new String[]{"children", "property", "description"}).set(resources.getString("jgroups.stack.protocol.property"));
        protocol.get(new String[]{"children", "property", "min-occurs"}).set(0);
        protocol.get(new String[]{"children", "property", "max-occurs"}).set(Integer.MAX_VALUE);
        protocol.get(new String[]{"children", "property", "model-description"});
        return protocol;
    }

    static ModelNode getProtocolAddDescription(Locale locale) {
        ResourceBundle resources = JGroupsDescriptions.getResources(locale);
        ModelNode op = JGroupsDescriptions.createOperationDescription("add-protocol", resources, "jgroups.stack.protocol.add-protocol");
        for (AttributeDefinition attr : CommonAttributes.PROTOCOL_ATTRIBUTES) {
            attr.addOperationParameterDescription(resources, "jgroups.stack.protocol", op);
        }
        return op;
    }

    static ModelNode getProtocolRemoveDescription(Locale locale) {
        ResourceBundle resources = JGroupsDescriptions.getResources(locale);
        ModelNode op = JGroupsDescriptions.createOperationDescription("remove-protocol", resources, "jgroups.stack.protocol.remove-protocol");
        CommonAttributes.TYPE.addOperationParameterDescription(resources, "jgroups.stack.protocol", op);
        return op;
    }

    static ModelNode getProtocolPropertyDescription(Locale locale) {
        ResourceBundle resources = JGroupsDescriptions.getResources(locale);
        ModelNode protocolProperty = JGroupsDescriptions.createDescription(resources, "jgroups.stack.protocol.property");
        CommonAttributes.VALUE.addResourceAttributeDescription(resources, "jgroups.stack.protocol.property", protocolProperty);
        return protocolProperty;
    }

    static ModelNode getProtocolPropertyAddDescription(Locale locale) {
        ResourceBundle resources = JGroupsDescriptions.getResources(locale);
        ModelNode op = JGroupsDescriptions.createOperationDescription("add", resources, "jgroups.stack.protocol.property.add");
        CommonAttributes.VALUE.addOperationParameterDescription(resources, "jgroups.stack.protocol.property", op);
        return op;
    }

    static ModelNode getProtocolPropertyRemoveDescription(Locale locale) {
        ResourceBundle resources = JGroupsDescriptions.getResources(locale);
        ModelNode op = JGroupsDescriptions.createOperationDescription("remove", resources, "jgroups.stack.protocol.property.remove");
        op.get("request-properties").setEmptyObject();
        return op;
    }

    static ModelNode getExportNativeConfigurationDescription(Locale locale) {
        ResourceBundle resources = JGroupsDescriptions.getResources(locale);
        ModelNode op = JGroupsDescriptions.createOperationDescription("export-native-configuration", resources, "jgroups.stack.export-native-configuration");
        op.get("request-properties").setEmptyObject();
        op.get(new String[]{"reply-properties", "type"}).set(ModelType.STRING);
        return op;
    }

    private static ResourceBundle getResources(Locale locale) {
        return ResourceBundle.getBundle(RESOURCE_NAME, locale == null ? Locale.getDefault() : locale);
    }

    private static ModelNode createDescription(ResourceBundle resources, String key) {
        return JGroupsDescriptions.createOperationDescription(null, resources, key);
    }

    private static ModelNode createOperationDescription(String operation, ResourceBundle resources, String key) {
        ModelNode description = new ModelNode();
        if (operation != null) {
            description.get("operation-name").set(operation);
        }
        description.get("description").set(resources.getString(key));
        return description;
    }
}

