/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.infinispan.subsystem;

import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import javax.xml.stream.XMLStreamException;
import org.infinispan.eviction.EvictionStrategy;
import org.infinispan.transaction.LockingMode;
import org.infinispan.util.concurrent.IsolationLevel;
import org.jboss.as.clustering.infinispan.subsystem.Attribute;
import org.jboss.as.clustering.infinispan.subsystem.Element;
import org.jboss.as.clustering.infinispan.subsystem.Indexing;
import org.jboss.as.clustering.infinispan.subsystem.StartMode;
import org.jboss.as.clustering.infinispan.subsystem.TransactionMode;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.as.controller.parsing.ParseUtils;
import org.jboss.dmr.ModelNode;
import org.jboss.staxmapper.XMLElementReader;
import org.jboss.staxmapper.XMLExtendedStreamReader;

public class InfinispanSubsystemXMLReader_1_1
implements XMLElementReader<List<ModelNode>> {
    public void readElement(XMLExtendedStreamReader reader, List<ModelNode> operations) throws XMLStreamException {
        ModelNode subsystemAddress = new ModelNode();
        subsystemAddress.add("subsystem", "infinispan");
        subsystemAddress.protect();
        ModelNode subsystem = Util.getEmptyOperation((String)"add", (ModelNode)subsystemAddress);
        block6: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            ParseUtils.requireNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i);
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case DEFAULT_CACHE_CONTAINER: {
                    subsystem.get("default-cache-container").set(value);
                    continue block6;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        if (!subsystem.hasDefined("default-cache-container")) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, EnumSet.of(Attribute.DEFAULT_CACHE_CONTAINER));
        }
        operations.add(subsystem);
        block7: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case CACHE_CONTAINER: {
                    this.parseContainer(reader, subsystemAddress, operations);
                    continue block7;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
    }

    private void parseContainer(XMLExtendedStreamReader reader, ModelNode subsystemAddress, List<ModelNode> operations) throws XMLStreamException {
        ModelNode container = Util.getEmptyOperation((String)"add", null);
        String name = null;
        block19: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            ParseUtils.requireNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i);
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case NAME: {
                    name = value;
                    continue block19;
                }
                case ALIASES: {
                    for (String alias : reader.getListAttributeValue(i)) {
                        container.get("aliases").add(alias);
                    }
                    continue block19;
                }
                case DEFAULT_CACHE: {
                    container.get("default-cache").set(value);
                    continue block19;
                }
                case JNDI_NAME: {
                    container.get("jndi-name").set(value);
                    continue block19;
                }
                case START: {
                    try {
                        StartMode mode = StartMode.valueOf(value);
                        container.get("start").set(mode.name());
                        continue block19;
                    }
                    catch (IllegalArgumentException e) {
                        throw ParseUtils.invalidAttributeValue((XMLExtendedStreamReader)reader, (int)i);
                    }
                }
                case LISTENER_EXECUTOR: {
                    container.get("listener-executor").set(value);
                    continue block19;
                }
                case EVICTION_EXECUTOR: {
                    container.get("eviction-executor").set(value);
                    continue block19;
                }
                case REPLICATION_QUEUE_EXECUTOR: {
                    container.get("replication-queue-executor").set(value);
                    continue block19;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        ModelNode containerAddress = subsystemAddress.clone();
        containerAddress.add("cache-container", name);
        containerAddress.protect();
        container.get("address").set(containerAddress);
        operations.add(container);
        block21: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case TRANSPORT: {
                    this.parseTransport(reader, containerAddress, operations);
                    continue block21;
                }
                case LOCAL_CACHE: {
                    this.parseLocalCache(reader, containerAddress, operations);
                    continue block21;
                }
                case INVALIDATION_CACHE: {
                    this.parseInvalidationCache(reader, containerAddress, operations);
                    continue block21;
                }
                case REPLICATED_CACHE: {
                    this.parseReplicatedCache(reader, containerAddress, operations);
                    continue block21;
                }
                case DISTRIBUTED_CACHE: {
                    this.parseDistributedCache(reader, containerAddress, operations);
                    continue block21;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
    }

    private void parseTransport(XMLExtendedStreamReader reader, ModelNode containerAddress, List<ModelNode> operations) throws XMLStreamException {
        ModelNode transport = Util.getEmptyOperation((String)"add", null);
        block5: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case STACK: {
                    transport.get("stack").set(value);
                    continue block5;
                }
                case EXECUTOR: {
                    transport.get("executor").set(value);
                    continue block5;
                }
                case LOCK_TIMEOUT: {
                    transport.get("lock-timeout").set(Long.parseLong(value));
                    continue block5;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
        ModelNode transportAddress = containerAddress.clone();
        transportAddress.add("transport", "TRANSPORT");
        transportAddress.protect();
        transport.get("address").set(transportAddress);
        operations.add(transport);
    }

    private void parseCacheAttribute(XMLExtendedStreamReader reader, int index, Attribute attribute, String value, ModelNode cache) throws XMLStreamException {
        switch (attribute) {
            case NAME: {
                cache.get("name").set(value);
                break;
            }
            case START: {
                try {
                    StartMode mode = StartMode.valueOf(value);
                    cache.get("start").set(mode.name());
                    break;
                }
                catch (IllegalArgumentException e) {
                    throw ParseUtils.invalidAttributeValue((XMLExtendedStreamReader)reader, (int)index);
                }
            }
            case JNDI_NAME: {
                cache.get("jndi-name").set(value);
                break;
            }
            case BATCHING: {
                cache.get("batching").set(Boolean.parseBoolean(value));
                break;
            }
            case INDEXING: {
                try {
                    Indexing indexing = Indexing.valueOf(value);
                    cache.get("indexing").set(indexing.name());
                    break;
                }
                catch (IllegalArgumentException e) {
                    throw ParseUtils.invalidAttributeValue((XMLExtendedStreamReader)reader, (int)index);
                }
            }
            default: {
                throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)index);
            }
        }
    }

    private void parseClusteredCacheAttribute(XMLExtendedStreamReader reader, int index, Attribute attribute, String value, ModelNode cache) throws XMLStreamException {
        switch (attribute) {
            case MODE: {
                cache.get("mode").set(value);
                break;
            }
            case QUEUE_SIZE: {
                cache.get("queue-size").set(Integer.parseInt(value));
                break;
            }
            case QUEUE_FLUSH_INTERVAL: {
                cache.get("queue-flush-interval").set(Long.parseLong(value));
                break;
            }
            case REMOTE_TIMEOUT: {
                cache.get("remote-timeout").set(Long.parseLong(value));
                break;
            }
            default: {
                this.parseCacheAttribute(reader, index, attribute, value, cache);
            }
        }
    }

    private void parseLocalCache(XMLExtendedStreamReader reader, ModelNode containerAddress, List<ModelNode> operations) throws XMLStreamException {
        ModelNode cache = Util.getEmptyOperation((String)"add", null);
        ArrayList<ModelNode> additionalConfigurationOperations = new ArrayList<ModelNode>();
        for (int i = 0; i < reader.getAttributeCount(); ++i) {
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            this.parseCacheAttribute(reader, i, attribute, value, cache);
        }
        if (!cache.hasDefined("name")) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, EnumSet.of(Attribute.NAME));
        }
        this.addCacheNameToAddress(cache, containerAddress, "local-cache");
        while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            this.parseCacheElement(reader, element, cache, additionalConfigurationOperations);
        }
        operations.add(cache);
        for (ModelNode additionalOperation : additionalConfigurationOperations) {
            operations.add(additionalOperation);
        }
    }

    private void parseDistributedCache(XMLExtendedStreamReader reader, ModelNode containerAddress, List<ModelNode> operations) throws XMLStreamException {
        ModelNode cache = Util.getEmptyOperation((String)"add", null);
        ArrayList<ModelNode> additionalConfigurationOperations = new ArrayList<ModelNode>();
        block8: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case OWNERS: {
                    cache.get("owners").set(Integer.parseInt(value));
                    continue block8;
                }
                case VIRTUAL_NODES: {
                    cache.get("virtual-nodes").set(Integer.parseInt(value));
                    continue block8;
                }
                case L1_LIFESPAN: {
                    cache.get("l1-lifespan").set(Long.parseLong(value));
                    continue block8;
                }
                default: {
                    this.parseClusteredCacheAttribute(reader, i, attribute, value, cache);
                }
            }
        }
        if (!cache.hasDefined("name")) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, EnumSet.of(Attribute.NAME));
        }
        if (!cache.hasDefined("mode")) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, EnumSet.of(Attribute.MODE));
        }
        this.addCacheNameToAddress(cache, containerAddress, "distributed-cache");
        block9: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case STATE_TRANSFER: {
                    this.parseStateTransfer(reader, cache, additionalConfigurationOperations);
                    continue block9;
                }
            }
            this.parseCacheElement(reader, element, cache, additionalConfigurationOperations);
        }
        operations.add(cache);
        for (ModelNode additionalOperation : additionalConfigurationOperations) {
            operations.add(additionalOperation);
        }
    }

    private void parseReplicatedCache(XMLExtendedStreamReader reader, ModelNode containerAddress, List<ModelNode> operations) throws XMLStreamException {
        ModelNode cache = Util.getEmptyOperation((String)"add", null);
        ArrayList<ModelNode> additionalConfigurationOperations = new ArrayList<ModelNode>();
        for (int i = 0; i < reader.getAttributeCount(); ++i) {
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            this.parseClusteredCacheAttribute(reader, i, attribute, value, cache);
        }
        if (!cache.hasDefined("name")) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, EnumSet.of(Attribute.NAME));
        }
        if (!cache.hasDefined("mode")) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, EnumSet.of(Attribute.MODE));
        }
        this.addCacheNameToAddress(cache, containerAddress, "replicated-cache");
        block4: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case STATE_TRANSFER: {
                    this.parseStateTransfer(reader, cache, additionalConfigurationOperations);
                    continue block4;
                }
            }
            this.parseCacheElement(reader, element, cache, additionalConfigurationOperations);
        }
        operations.add(cache);
        for (ModelNode additionalOperation : additionalConfigurationOperations) {
            operations.add(additionalOperation);
        }
    }

    private void parseInvalidationCache(XMLExtendedStreamReader reader, ModelNode containerAddress, List<ModelNode> operations) throws XMLStreamException {
        ModelNode cache = Util.getEmptyOperation((String)"add", null);
        ArrayList<ModelNode> additionalConfigurationOperations = new ArrayList<ModelNode>();
        for (int i = 0; i < reader.getAttributeCount(); ++i) {
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            this.parseClusteredCacheAttribute(reader, i, attribute, value, cache);
        }
        if (!cache.hasDefined("name")) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, EnumSet.of(Attribute.NAME));
        }
        if (!cache.hasDefined("mode")) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, EnumSet.of(Attribute.MODE));
        }
        this.addCacheNameToAddress(cache, containerAddress, "invalidation-cache");
        while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                default: 
            }
            this.parseCacheElement(reader, element, cache, additionalConfigurationOperations);
        }
        operations.add(cache);
        for (ModelNode additionalOperation : additionalConfigurationOperations) {
            operations.add(additionalOperation);
        }
    }

    private void addCacheNameToAddress(ModelNode cache, ModelNode containerAddress, String cacheType) {
        String name = cache.get("name").asString();
        ModelNode cacheAddress = containerAddress.clone();
        cacheAddress.add(cacheType, name);
        cacheAddress.protect();
        cache.get("address").set(cacheAddress);
        cache.remove("name");
    }

    private void parseCacheElement(XMLExtendedStreamReader reader, Element element, ModelNode cache, List<ModelNode> operations) throws XMLStreamException {
        switch (element) {
            case LOCKING: {
                this.parseLocking(reader, cache, operations);
                break;
            }
            case TRANSACTION: {
                this.parseTransaction(reader, cache, operations);
                break;
            }
            case EVICTION: {
                this.parseEviction(reader, cache, operations);
                break;
            }
            case EXPIRATION: {
                this.parseExpiration(reader, cache, operations);
                break;
            }
            case STORE: {
                this.parseCustomStore(reader, cache, operations);
                break;
            }
            case FILE_STORE: {
                this.parseFileStore(reader, cache, operations);
                break;
            }
            case JDBC_STORE: {
                this.parseJDBCStore(reader, cache, operations);
                break;
            }
            case REMOTE_STORE: {
                this.parseRemoteStore(reader, cache, operations);
                break;
            }
            default: {
                throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
            }
        }
    }

    private void parseStateTransfer(XMLExtendedStreamReader reader, ModelNode cache, List<ModelNode> operations) throws XMLStreamException {
        ModelNode stateTransferAddress = cache.get("address").clone();
        stateTransferAddress.add("state-transfer", "STATE_TRANSFER");
        stateTransferAddress.protect();
        ModelNode stateTransfer = Util.getEmptyOperation((String)"add", (ModelNode)stateTransferAddress);
        block5: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case ENABLED: {
                    stateTransfer.get("enabled").set(Boolean.parseBoolean(value));
                    continue block5;
                }
                case TIMEOUT: {
                    stateTransfer.get("timeout").set(Long.parseLong(value));
                    continue block5;
                }
                case CHUNK_SIZE: {
                    stateTransfer.get("chunk-size").set(Integer.parseInt(value));
                    continue block5;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
        operations.add(stateTransfer);
    }

    private void parseLocking(XMLExtendedStreamReader reader, ModelNode cache, List<ModelNode> operations) throws XMLStreamException {
        ModelNode lockingAddress = cache.get("address").clone();
        lockingAddress.add("locking", "LOCKING");
        lockingAddress.protect();
        ModelNode locking = Util.getEmptyOperation((String)"add", (ModelNode)lockingAddress);
        block8: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case ISOLATION: {
                    try {
                        IsolationLevel level = IsolationLevel.valueOf((String)value);
                        locking.get("isolation").set(level.name());
                        continue block8;
                    }
                    catch (IllegalArgumentException e) {
                        throw ParseUtils.invalidAttributeValue((XMLExtendedStreamReader)reader, (int)i);
                    }
                }
                case STRIPING: {
                    locking.get("striping").set(Boolean.parseBoolean(value));
                    continue block8;
                }
                case ACQUIRE_TIMEOUT: {
                    locking.get("acquire-timeout").set(Long.parseLong(value));
                    continue block8;
                }
                case CONCURRENCY_LEVEL: {
                    locking.get("concurrency-level").set(Integer.parseInt(value));
                    continue block8;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
        operations.add(locking);
    }

    private void parseTransaction(XMLExtendedStreamReader reader, ModelNode cache, List<ModelNode> operations) throws XMLStreamException {
        ModelNode transactionAddress = cache.get("address").clone();
        transactionAddress.add("transaction", "TRANSACTION");
        transactionAddress.protect();
        ModelNode transaction = Util.getEmptyOperation((String)"add", (ModelNode)transactionAddress);
        block9: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case STOP_TIMEOUT: {
                    transaction.get("stop-timeout").set(Long.parseLong(value));
                    continue block9;
                }
                case MODE: {
                    try {
                        transaction.get("mode").set(TransactionMode.valueOf(value).name());
                        continue block9;
                    }
                    catch (IllegalArgumentException e) {
                        throw ParseUtils.invalidAttributeValue((XMLExtendedStreamReader)reader, (int)i);
                    }
                }
                case LOCKING: {
                    try {
                        transaction.get("locking").set(LockingMode.valueOf((String)value).name());
                        continue block9;
                    }
                    catch (IllegalArgumentException e) {
                        throw ParseUtils.invalidAttributeValue((XMLExtendedStreamReader)reader, (int)i);
                    }
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
        operations.add(transaction);
    }

    private void parseEviction(XMLExtendedStreamReader reader, ModelNode cache, List<ModelNode> operations) throws XMLStreamException {
        ModelNode evictionAddress = cache.get("address").clone();
        evictionAddress.add("eviction", "EVICTION");
        evictionAddress.protect();
        ModelNode eviction = Util.getEmptyOperation((String)"add", (ModelNode)evictionAddress);
        block6: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case STRATEGY: {
                    try {
                        EvictionStrategy strategy = EvictionStrategy.valueOf((String)value);
                        eviction.get("strategy").set(strategy.name());
                        continue block6;
                    }
                    catch (IllegalArgumentException e) {
                        throw ParseUtils.invalidAttributeValue((XMLExtendedStreamReader)reader, (int)i);
                    }
                }
                case MAX_ENTRIES: {
                    eviction.get("max-entries").set(Integer.parseInt(value));
                    continue block6;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
        operations.add(eviction);
    }

    private void parseExpiration(XMLExtendedStreamReader reader, ModelNode cache, List<ModelNode> operations) throws XMLStreamException {
        ModelNode expirationAddress = cache.get("address").clone();
        expirationAddress.add("expiration", "EXPIRATION");
        expirationAddress.protect();
        ModelNode expiration = Util.getEmptyOperation((String)"add", (ModelNode)expirationAddress);
        block5: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case MAX_IDLE: {
                    expiration.get("max-idle").set(Long.parseLong(value));
                    continue block5;
                }
                case LIFESPAN: {
                    expiration.get("lifespan").set(Long.parseLong(value));
                    continue block5;
                }
                case INTERVAL: {
                    expiration.get("interval").set(Long.parseLong(value));
                    continue block5;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
        operations.add(expiration);
    }

    private void parseCustomStore(XMLExtendedStreamReader reader, ModelNode cache, List<ModelNode> operations) throws XMLStreamException {
        ModelNode storeAddress = cache.get("address").clone();
        storeAddress.add("store", "STORE");
        storeAddress.protect();
        ModelNode store = Util.getEmptyOperation((String)"add", (ModelNode)storeAddress);
        block3: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case CLASS: {
                    store.get("class").set(value);
                    continue block3;
                }
                default: {
                    this.parseStoreAttribute(reader, i, attribute, value, store);
                }
            }
        }
        if (!store.hasDefined("class")) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, EnumSet.of(Attribute.CLASS));
        }
        this.parseStoreProperties(reader, store);
        operations.add(store);
    }

    private void parseFileStore(XMLExtendedStreamReader reader, ModelNode cache, List<ModelNode> operations) throws XMLStreamException {
        ModelNode storeAddress = cache.get("address").clone();
        storeAddress.add("file-store", "FILE_STORE");
        storeAddress.protect();
        ModelNode store = Util.getEmptyOperation((String)"add", (ModelNode)storeAddress);
        block4: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case RELATIVE_TO: {
                    store.get("relative-to").set(value);
                    continue block4;
                }
                case PATH: {
                    store.get("path").set(value);
                    continue block4;
                }
                default: {
                    this.parseStoreAttribute(reader, i, attribute, value, store);
                }
            }
        }
        this.parseStoreProperties(reader, store);
        operations.add(store);
    }

    private void parseRemoteStore(XMLExtendedStreamReader reader, ModelNode cache, List<ModelNode> operations) throws XMLStreamException {
        ModelNode storeAddress = cache.get("address").clone();
        storeAddress.add("remote-store", "REMOTE_STORE");
        storeAddress.protect();
        ModelNode store = Util.getEmptyOperation((String)"add", (ModelNode)storeAddress);
        block8: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case CACHE: {
                    store.get("cache").set(value);
                    continue block8;
                }
                case SOCKET_TIMEOUT: {
                    store.get("socket-timeout").set(Long.parseLong(value));
                    continue block8;
                }
                case TCP_NO_DELAY: {
                    store.get("tcp-no-delay").set(Boolean.valueOf(value).booleanValue());
                    continue block8;
                }
                default: {
                    this.parseStoreAttribute(reader, i, attribute, value, store);
                }
            }
        }
        block9: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case REMOTE_SERVER: {
                    this.parseRemoteServer(reader, store.get("remote-servers").add());
                    continue block9;
                }
            }
            this.parseStoreProperty(reader, store);
        }
        if (!store.hasDefined("remote-servers")) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, Collections.singleton(Element.REMOTE_SERVER));
        }
        operations.add(store);
    }

    private void parseRemoteServer(XMLExtendedStreamReader reader, ModelNode server) throws XMLStreamException {
        block3: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case OUTBOUND_SOCKET_BINDING: {
                    server.get("outbound-socket-binding").set(value);
                    continue block3;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
    }

    private void parseJDBCStore(XMLExtendedStreamReader reader, ModelNode cache, List<ModelNode> operations) throws XMLStreamException {
        ModelNode storeAddress = cache.get("address").clone();
        storeAddress.add("jdbc-store", "JDBC_STORE");
        storeAddress.protect();
        ModelNode store = Util.getEmptyOperation((String)"add", (ModelNode)storeAddress);
        block7: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case DATASOURCE: {
                    store.get("datasource").set(value);
                    continue block7;
                }
                default: {
                    this.parseStoreAttribute(reader, i, attribute, value, store);
                }
            }
        }
        if (!store.hasDefined("datasource")) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, EnumSet.of(Attribute.DATASOURCE));
        }
        block8: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case ENTRY_TABLE: {
                    this.parseJDBCStoreTable(reader, store.get("entry-table").setEmptyObject());
                    continue block8;
                }
                case BUCKET_TABLE: {
                    this.parseJDBCStoreTable(reader, store.get("bucket-table").setEmptyObject());
                    continue block8;
                }
            }
            this.parseStoreProperty(reader, store);
        }
        operations.add(store);
    }

    private void parseJDBCStoreTable(XMLExtendedStreamReader reader, ModelNode table) throws XMLStreamException {
        block10: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case PREFIX: {
                    table.get("prefix").set(value);
                    continue block10;
                }
                case FETCH_SIZE: {
                    table.get("fetch-size").set(Integer.parseInt(value));
                    continue block10;
                }
                case BATCH_SIZE: {
                    table.get("batch-size").set(Integer.parseInt(value));
                    continue block10;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        block11: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case ID_COLUMN: {
                    this.parseJDBCStoreColumn(reader, table.get("id-column").setEmptyObject());
                    continue block11;
                }
                case DATA_COLUMN: {
                    this.parseJDBCStoreColumn(reader, table.get("data-column").setEmptyObject());
                    continue block11;
                }
                case TIMESTAMP_COLUMN: {
                    this.parseJDBCStoreColumn(reader, table.get("timestamp-column").setEmptyObject());
                    continue block11;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
    }

    private void parseJDBCStoreColumn(XMLExtendedStreamReader reader, ModelNode column) throws XMLStreamException {
        block4: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case NAME: {
                    column.get("name").set(value);
                    continue block4;
                }
                case TYPE: {
                    column.get("type").set(value);
                    continue block4;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
    }

    private void parseStoreAttribute(XMLExtendedStreamReader reader, int index, Attribute attribute, String value, ModelNode store) throws XMLStreamException {
        switch (attribute) {
            case SHARED: {
                store.get("shared").set(Boolean.parseBoolean(value));
                break;
            }
            case PRELOAD: {
                store.get("preload").set(Boolean.parseBoolean(value));
                break;
            }
            case PASSIVATION: {
                store.get("passivation").set(Boolean.parseBoolean(value));
                break;
            }
            case FETCH_STATE: {
                store.get("fetch-state").set(Boolean.parseBoolean(value));
                break;
            }
            case PURGE: {
                store.get("purge").set(Boolean.parseBoolean(value));
                break;
            }
            case SINGLETON: {
                store.get("singleton").set(Boolean.parseBoolean(value));
                break;
            }
            default: {
                throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)index);
            }
        }
    }

    private void parseStoreProperties(XMLExtendedStreamReader reader, ModelNode node) throws XMLStreamException {
        while (reader.hasNext() && reader.nextTag() != 2) {
            this.parseStoreProperty(reader, node);
        }
    }

    private void parseStoreProperty(XMLExtendedStreamReader reader, ModelNode node) throws XMLStreamException {
        Element element = Element.forName(reader.getLocalName());
        switch (element) {
            case PROPERTY: {
                int attributes = reader.getAttributeCount();
                String property = null;
                block6: for (int i = 0; i < attributes; ++i) {
                    String value = reader.getAttributeValue(i);
                    Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
                    switch (attribute) {
                        case NAME: {
                            property = value;
                            continue block6;
                        }
                        default: {
                            throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                        }
                    }
                }
                if (property == null) {
                    throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, Collections.singleton(Attribute.NAME));
                }
                String value = reader.getElementText();
                node.get("properties").add(property, value);
                break;
            }
            default: {
                throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
            }
        }
    }
}

