/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb.client.remoting;

import java.io.DataInputStream;
import java.io.IOException;
import javax.ejb.EJBException;
import javax.ejb.NoSuchEJBException;
import org.jboss.ejb.client.EJBReceiverInvocationContext;
import org.jboss.ejb.client.remoting.ChannelAssociation;
import org.jboss.ejb.client.remoting.ProtocolMessageHandler;
import org.jboss.remoting3.MessageInputStream;

class GeneralInvocationFailureResponseHandler
extends ProtocolMessageHandler {
    private final ChannelAssociation channelAssociation;
    private final FailureType failureType;

    GeneralInvocationFailureResponseHandler(ChannelAssociation channelAssociation, FailureType failureType) {
        this.failureType = failureType;
        this.channelAssociation = channelAssociation;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void processMessage(MessageInputStream messageInputStream) throws IOException {
        DataInputStream dataInputStream = new DataInputStream(messageInputStream);
        try {
            short invocationId = dataInputStream.readShort();
            String failureMessage = dataInputStream.readUTF();
            EJBException exception = null;
            switch (this.failureType) {
                case NO_SUCH_EJB: {
                    exception = new NoSuchEJBException(failureMessage);
                    break;
                }
                default: {
                    exception = new EJBException(failureMessage);
                }
            }
            this.channelAssociation.resultReady(invocationId, new InvocationFailureResultProducer(exception));
        }
        finally {
            dataInputStream.close();
        }
    }

    private class InvocationFailureResultProducer
    implements EJBReceiverInvocationContext.ResultProducer {
        private final Exception invocationFailure;

        InvocationFailureResultProducer(Exception invocationFailure) {
            this.invocationFailure = invocationFailure;
        }

        @Override
        public Object getResult() throws Exception {
            throw this.invocationFailure;
        }

        @Override
        public void discardResult() {
        }
    }

    static enum FailureType {
        NO_SUCH_EJB,
        NO_SUCH_METHOD,
        SESSION_NOT_ACTIVE,
        EJB_NOT_STATEFUL;

    }
}

