/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.wsf.stack.cxf.security.authentication;

import javax.security.auth.Subject;
import org.apache.cxf.common.security.UsernameToken;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.interceptor.security.AbstractUsernameTokenInInterceptor;
import org.apache.cxf.message.Message;
import org.jboss.wsf.spi.deployment.Endpoint;
import org.jboss.wsf.spi.security.SecurityDomainContext;
import org.jboss.wsf.stack.cxf.security.authentication.SubjectCreator;
import org.jboss.wsf.stack.cxf.security.nonce.NonceStore;

public class SubjectCreatingPolicyInterceptor
extends AbstractUsernameTokenInInterceptor {
    private ThreadLocal<SecurityDomainContext> sdc = new ThreadLocal();
    private SubjectCreator helper = new SubjectCreator();

    public SubjectCreatingPolicyInterceptor() {
        this.helper.setPropagateContext(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleMessage(Message msg) throws Fault {
        Endpoint ep = (Endpoint)msg.getExchange().get(Endpoint.class);
        this.sdc.set(ep.getSecurityDomainContext());
        try {
            super.handleMessage(msg);
        }
        finally {
            if (this.sdc != null) {
                this.sdc.remove();
            }
        }
    }

    protected Subject createSubject(UsernameToken token) {
        return this.helper.createSubject(this.sdc.get(), token.getName(), token.getPassword(), token.isHashed(), token.getNonce(), token.getCreatedTime());
    }

    public void setPropagateContext(boolean propagateContext) {
        this.helper.setPropagateContext(propagateContext);
    }

    public void setTimestampThreshold(int timestampThreshold) {
        this.helper.setTimestampThreshold(timestampThreshold);
    }

    public void setNonceStore(NonceStore nonceStore) {
        this.helper.setNonceStore(nonceStore);
    }

    public void setDecodeNonce(boolean decodeNonce) {
        this.helper.setDecodeNonce(decodeNonce);
    }
}

