/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.osgi.resolver.v2.spi;

import java.util.List;
import java.util.Map;
import org.jboss.osgi.resolver.v2.XAttributeSupport;
import org.jboss.osgi.resolver.v2.XCapability;
import org.jboss.osgi.resolver.v2.XDirectiveSupport;
import org.jboss.osgi.resolver.v2.spi.AbstractElement;
import org.osgi.framework.resource.Resource;

public abstract class AbstractCapability
extends AbstractElement
implements XCapability {
    private final Resource resource;
    private final String namespace;
    private final XAttributeSupport attributes;
    private final XDirectiveSupport directives;

    protected AbstractCapability(Resource resource, String namespace, Map<String, Object> atts, Map<String, String> dirs) {
        if (resource == null) {
            throw new IllegalArgumentException("Null resource");
        }
        if (namespace == null) {
            throw new IllegalArgumentException("Null namespace");
        }
        if (atts == null) {
            throw new IllegalArgumentException("Null attributes");
        }
        if (dirs == null) {
            throw new IllegalArgumentException("Null directives");
        }
        this.resource = resource;
        this.namespace = namespace;
        this.attributes = new AbstractElement.AttributeSupporter(atts);
        this.directives = new AbstractElement.DirectiveSupporter(dirs);
        this.validateAttributes(atts);
    }

    protected void validateAttributes(Map<String, Object> atts) {
        for (String name : this.getMandatoryAttributes()) {
            if (atts.get(name) != null) continue;
            throw new IllegalArgumentException("Cannot obtain attribute: " + name);
        }
    }

    protected abstract List<String> getMandatoryAttributes();

    @Override
    public Resource getResource() {
        return this.resource;
    }

    @Override
    public String getNamespace() {
        return this.namespace;
    }

    @Override
    public Map<String, String> getDirectives() {
        return this.directives.getDirectives();
    }

    @Override
    public String getDirective(String key) {
        return this.directives.getDirective(key);
    }

    @Override
    public Map<String, Object> getAttributes() {
        return this.attributes.getAttributes();
    }

    @Override
    public Object getAttribute(String key) {
        return this.attributes.getAttribute(key);
    }

    public String toString() {
        String attstr = !this.getAttributes().isEmpty() ? ",attributes=" + this.attributes : "";
        String dirstr = !this.getDirectives().isEmpty() ? ",directives=" + this.directives : "";
        return this.getClass().getSimpleName() + "[" + this.namespace + attstr + dirstr + "]";
    }
}

