/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.modcluster;

import java.util.List;
import javax.xml.stream.XMLStreamException;
import org.jboss.as.controller.persistence.SubsystemMarshallingContext;
import org.jboss.as.modcluster.Attribute;
import org.jboss.as.modcluster.Element;
import org.jboss.as.modcluster.Namespace;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.Property;
import org.jboss.staxmapper.XMLElementWriter;
import org.jboss.staxmapper.XMLExtendedStreamWriter;

public class ModClusterSubsystemXMLWriter
implements XMLElementWriter<SubsystemMarshallingContext> {
    public void writeContent(XMLExtendedStreamWriter writer, SubsystemMarshallingContext context) throws XMLStreamException {
        context.startSubsystemElement(Namespace.CURRENT.getUri(), false);
        ModelNode node = context.getModelNode();
        if (node.get("mod-cluster-config").isDefined() && node.get("mod-cluster-config").has("configuration")) {
            ModClusterSubsystemXMLWriter.writeModClusterConfig(writer, node.get("mod-cluster-config").get("configuration"));
        } else {
            ModClusterSubsystemXMLWriter.writeModClusterConfig(writer, node);
        }
        writer.writeEndElement();
    }

    static void writeModClusterConfig(XMLExtendedStreamWriter writer, ModelNode config) throws XMLStreamException {
        writer.writeStartElement(Element.MOD_CLUSTER_CONFIG.getLocalName());
        ModClusterSubsystemXMLWriter.writePropConf(writer, config);
        if (config.hasDefined("simple-load-provider")) {
            ModClusterSubsystemXMLWriter.writeSimpleLoadProvider(writer, config.get("simple-load-provider"));
        }
        if (config.hasDefined("dynamic-load-provider")) {
            ModClusterSubsystemXMLWriter.writeDynamicLoadProvider(writer, config.get("dynamic-load-provider"));
        }
        if (config.get("ssl").isDefined() && config.get("ssl").has("configuration")) {
            ModClusterSubsystemXMLWriter.writeSSL(writer, config.get("ssl").get("configuration"));
        }
        writer.writeEndElement();
    }

    static void writePropConf(XMLExtendedStreamWriter writer, ModelNode config) throws XMLStreamException {
        ModClusterSubsystemXMLWriter.writeAttribute(writer, "advertise-socket", config);
        ModClusterSubsystemXMLWriter.writeAttribute(writer, "proxy-list", config);
        ModClusterSubsystemXMLWriter.writeAttribute(writer, "proxy-url", config);
        ModClusterSubsystemXMLWriter.writeAttribute(writer, "advertise", config);
        ModClusterSubsystemXMLWriter.writeAttribute(writer, "advertise-security-key", config);
        ModClusterSubsystemXMLWriter.writeAttribute(writer, "excluded-contexts", config);
        ModClusterSubsystemXMLWriter.writeAttribute(writer, "auto-enable-contexts", config);
        ModClusterSubsystemXMLWriter.writeAttribute(writer, "stop-context-timeout", config);
        ModClusterSubsystemXMLWriter.writeAttribute(writer, "socket-timeout", config);
        ModClusterSubsystemXMLWriter.writeAttribute(writer, "sticky-session", config);
        ModClusterSubsystemXMLWriter.writeAttribute(writer, "sticky-session-remove", config);
        ModClusterSubsystemXMLWriter.writeAttribute(writer, "sticky-session-force", config);
        ModClusterSubsystemXMLWriter.writeAttribute(writer, "worker-timeout", config);
        ModClusterSubsystemXMLWriter.writeAttribute(writer, "max-attemps", config);
        ModClusterSubsystemXMLWriter.writeAttribute(writer, "flush-packets", config);
        ModClusterSubsystemXMLWriter.writeAttribute(writer, "flush-wait", config);
        ModClusterSubsystemXMLWriter.writeAttribute(writer, "ping", config);
        ModClusterSubsystemXMLWriter.writeAttribute(writer, "smax", config);
        ModClusterSubsystemXMLWriter.writeAttribute(writer, "ttl", config);
        ModClusterSubsystemXMLWriter.writeAttribute(writer, "node-timeout", config);
        ModClusterSubsystemXMLWriter.writeAttribute(writer, "balancer", config);
        ModClusterSubsystemXMLWriter.writeAttribute(writer, "domain", config);
    }

    static void writeSSL(XMLExtendedStreamWriter writer, ModelNode sslConfig) throws XMLStreamException {
        writer.writeStartElement(Element.SSL.getLocalName());
        ModClusterSubsystemXMLWriter.writeAttribute(writer, Attribute.KEY_ALIAS.getLocalName(), sslConfig);
        ModClusterSubsystemXMLWriter.writeAttribute(writer, Attribute.PASSWORD.getLocalName(), sslConfig);
        ModClusterSubsystemXMLWriter.writeAttribute(writer, Attribute.CERTIFICATE_KEY_FILE.getLocalName(), sslConfig);
        ModClusterSubsystemXMLWriter.writeAttribute(writer, Attribute.CIPHER_SUITE.getLocalName(), sslConfig);
        ModClusterSubsystemXMLWriter.writeAttribute(writer, Attribute.PROTOCOL.getLocalName(), sslConfig);
        ModClusterSubsystemXMLWriter.writeAttribute(writer, Attribute.CA_CERTIFICATE_FILE.getLocalName(), sslConfig);
        ModClusterSubsystemXMLWriter.writeAttribute(writer, Attribute.CA_REVOCATION_URL.getLocalName(), sslConfig);
        writer.writeEndElement();
    }

    static void writeSimpleLoadProvider(XMLExtendedStreamWriter writer, ModelNode config) throws XMLStreamException {
        writer.writeStartElement(Element.SIMPLE_LOAD_PROVIDER.getLocalName());
        ModClusterSubsystemXMLWriter.writeAttribute(writer, "factor", config);
        writer.writeEndElement();
    }

    static void writeDynamicLoadProvider(XMLExtendedStreamWriter writer, ModelNode config) throws XMLStreamException {
        writer.writeStartElement(Element.DYNAMIC_LOAD_PROVIDER.getLocalName());
        ModClusterSubsystemXMLWriter.writeAttribute(writer, "history", config);
        ModClusterSubsystemXMLWriter.writeAttribute(writer, "decay", config);
        if (config.hasDefined("load-metric")) {
            ModClusterSubsystemXMLWriter.writeLoadMetric(writer, config.get("load-metric"));
        }
        if (config.hasDefined("custom-load-metric")) {
            ModClusterSubsystemXMLWriter.writeCustomLoadMetric(writer, config.get("custom-load-metric"));
        }
        writer.writeEndElement();
    }

    static void writeLoadMetric(XMLExtendedStreamWriter writer, ModelNode config) throws XMLStreamException {
        List array = config.asList();
        for (ModelNode node : array) {
            writer.writeStartElement(Element.LOAD_METRIC.getLocalName());
            ModClusterSubsystemXMLWriter.writeAttribute(writer, "type", node);
            ModClusterSubsystemXMLWriter.writeAttribute(writer, "weight", node);
            ModClusterSubsystemXMLWriter.writeAttribute(writer, "capacity", node);
            if (node.get("property").isDefined()) {
                for (Property property : node.get("property").asPropertyList()) {
                    ModClusterSubsystemXMLWriter.writeProperty(writer, property);
                }
            }
            writer.writeEndElement();
        }
    }

    static void writeCustomLoadMetric(XMLExtendedStreamWriter writer, ModelNode config) throws XMLStreamException {
        List array = config.asList();
        for (ModelNode node : array) {
            writer.writeStartElement(Element.CUSTOM_LOAD_METRIC.getLocalName());
            ModClusterSubsystemXMLWriter.writeAttribute(writer, "capacity", node);
            ModClusterSubsystemXMLWriter.writeAttribute(writer, "weight", node);
            ModClusterSubsystemXMLWriter.writeAttribute(writer, "class", node);
            if (node.get("property").isDefined()) {
                for (Property property : node.get("property").asPropertyList()) {
                    ModClusterSubsystemXMLWriter.writeProperty(writer, property);
                }
            }
            writer.writeEndElement();
        }
    }

    static void writeAttribute(XMLExtendedStreamWriter writer, String name, ModelNode node) throws XMLStreamException {
        if (node.hasDefined(name)) {
            writer.writeAttribute(name, node.get(name).asString());
        }
    }

    static void writeProperty(XMLExtendedStreamWriter writer, Property property) throws XMLStreamException {
        writer.writeStartElement(Element.PROPERTY.getLocalName());
        writer.writeAttribute("name", property.getName());
        writer.writeAttribute("value", property.getValue().asString());
        writer.writeEndElement();
    }
}

