/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.configuration.cache;

import java.util.Properties;
import java.util.concurrent.TimeUnit;
import org.infinispan.configuration.cache.AbstractLoaderConfigurationBuilder;
import org.infinispan.configuration.cache.FileCacheStoreConfiguration;
import org.infinispan.configuration.cache.LoadersConfigurationBuilder;
import org.infinispan.util.TypedProperties;

public class FileCacheStoreConfigurationBuilder
extends AbstractLoaderConfigurationBuilder<FileCacheStoreConfiguration> {
    private String location = "Infinispan-FileCacheStore";
    private long fsyncInterval = TimeUnit.SECONDS.toMillis(1L);
    private FsyncMode fsyncMode = FsyncMode.DEFAULT;
    private int streamBufferSize = 8192;
    private boolean fetchPersistentState = false;
    private boolean ignoreModifications = false;
    private boolean purgeOnStartup = false;
    private int purgerThreads = 1;
    private boolean purgeSynchronously = false;
    private int lockConcurrencyLevel;
    private long lockAcquistionTimeout;
    private Properties properties = new Properties();

    protected FileCacheStoreConfigurationBuilder(LoadersConfigurationBuilder builder) {
        super(builder);
    }

    public FileCacheStoreConfigurationBuilder location(String location) {
        this.location = location;
        return this;
    }

    public FileCacheStoreConfigurationBuilder fsyncInterval(long fsyncInterval) {
        this.fsyncInterval = fsyncInterval;
        return this;
    }

    public FileCacheStoreConfigurationBuilder fsyncMode(FsyncMode fsyncMode) {
        this.fsyncMode = fsyncMode;
        return this;
    }

    public FileCacheStoreConfigurationBuilder streamBufferSize(int streamBufferSize) {
        this.streamBufferSize = streamBufferSize;
        return this;
    }

    @Override
    void validate() {
    }

    public FileCacheStoreConfigurationBuilder purgeOnStartup(boolean purgeOnStartup) {
        this.purgeOnStartup = purgeOnStartup;
        return this;
    }

    public FileCacheStoreConfigurationBuilder purgeSynchronously(boolean purgeSynchronously) {
        this.purgeSynchronously = purgeSynchronously;
        return this;
    }

    public FileCacheStoreConfigurationBuilder purgerThreads(int i) {
        this.purgerThreads = i;
        return this;
    }

    public FileCacheStoreConfigurationBuilder fetchPersistentState(boolean fetchPersistentState) {
        this.fetchPersistentState = fetchPersistentState;
        return this;
    }

    public FileCacheStoreConfigurationBuilder ignoreModifications(boolean ignoreModifications) {
        this.ignoreModifications = ignoreModifications;
        return this;
    }

    public FileCacheStoreConfigurationBuilder lockAcquistionTimeout(long lockAcquistionTimeout) {
        this.lockAcquistionTimeout = lockAcquistionTimeout;
        return this;
    }

    public FileCacheStoreConfigurationBuilder lockConcurrencyLevel(int lockConcurrencyLevel) {
        this.lockConcurrencyLevel = lockConcurrencyLevel;
        return this;
    }

    @Override
    public AbstractLoaderConfigurationBuilder<FileCacheStoreConfiguration> withProperties(Properties p) {
        this.properties = p;
        return this;
    }

    @Override
    FileCacheStoreConfiguration create() {
        return new FileCacheStoreConfiguration(this.location, this.fsyncInterval, this.fsyncMode, this.streamBufferSize, this.lockAcquistionTimeout, this.lockConcurrencyLevel, this.purgeOnStartup, this.purgeSynchronously, this.purgerThreads, this.fetchPersistentState, this.ignoreModifications, TypedProperties.toTypedProperties(this.properties), this.async.create(), this.singletonStore.create());
    }

    public FileCacheStoreConfigurationBuilder read(FileCacheStoreConfiguration template) {
        this.fetchPersistentState = template.fetchPersistentState();
        this.fsyncInterval = template.fsyncInterval();
        this.fsyncMode = template.fsyncMode();
        this.ignoreModifications = template.ignoreModifications();
        this.location = template.location();
        this.lockAcquistionTimeout = template.lockAcquistionTimeout();
        this.lockConcurrencyLevel = template.lockConcurrencyLevel();
        this.properties = template.properties();
        this.purgeOnStartup = template.purgeOnStartup();
        this.purgeSynchronously = template.purgeSynchronously();
        this.streamBufferSize = template.streamBufferSize();
        this.async.read(template.async());
        this.singletonStore.read(template.singletonStore());
        return this;
    }

    public static enum FsyncMode {
        DEFAULT,
        PER_WRITE,
        PERIODIC;

    }
}

