/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.configuration.cache;

import org.infinispan.commons.hash.Hash;
import org.infinispan.commons.hash.MurmurHash3;
import org.infinispan.config.ConfigurationException;
import org.infinispan.configuration.cache.AbstractClusteringConfigurationChildBuilder;
import org.infinispan.configuration.cache.ClusteringConfigurationBuilder;
import org.infinispan.configuration.cache.GroupsConfigurationBuilder;
import org.infinispan.configuration.cache.HashConfiguration;
import org.infinispan.distribution.ch.ConsistentHash;

public class HashConfigurationBuilder
extends AbstractClusteringConfigurationChildBuilder<HashConfiguration> {
    private ConsistentHash consistentHash;
    private Hash hash = new MurmurHash3();
    private int numOwners = 2;
    private int numVirtualNodes = 48;
    private boolean activated = false;
    private final GroupsConfigurationBuilder groupsConfigurationBuilder;

    HashConfigurationBuilder(ClusteringConfigurationBuilder builder) {
        super(builder);
        this.groupsConfigurationBuilder = new GroupsConfigurationBuilder(builder);
    }

    public HashConfigurationBuilder consistentHash(ConsistentHash consistentHash) {
        this.consistentHash = consistentHash;
        this.activated = true;
        return this;
    }

    public HashConfigurationBuilder numOwners(int numOwners) {
        if (this.numVirtualNodes < 1) {
            throw new IllegalArgumentException("numOwners cannot be less than 1");
        }
        this.numOwners = numOwners;
        this.activated = true;
        return this;
    }

    public HashConfigurationBuilder numVirtualNodes(int numVirtualNodes) {
        if (numVirtualNodes < 1) {
            throw new IllegalArgumentException("numVirtualNodes cannot be less than 1");
        }
        this.numVirtualNodes = numVirtualNodes;
        this.activated = true;
        return this;
    }

    public HashConfigurationBuilder rehashEnabled() {
        this.stateTransfer().fetchInMemoryState(true);
        this.activated = true;
        return this;
    }

    public HashConfigurationBuilder rehashEnabled(boolean enabled) {
        this.stateTransfer().fetchInMemoryState(enabled);
        this.activated = true;
        return this;
    }

    public HashConfigurationBuilder rehashDisabled() {
        this.stateTransfer().fetchInMemoryState(false);
        this.activated = true;
        return this;
    }

    @Deprecated
    public HashConfigurationBuilder rehashRpcTimeout(long rehashRpcTimeout) {
        this.stateTransfer().timeout(rehashRpcTimeout);
        this.activated = true;
        return this;
    }

    @Deprecated
    public HashConfigurationBuilder rehashWait(long rehashWait) {
        return this;
    }

    public HashConfigurationBuilder hash(Hash hash) {
        this.hash = hash;
        this.activated = true;
        return this;
    }

    public GroupsConfigurationBuilder groups() {
        this.activated = true;
        return this.groupsConfigurationBuilder;
    }

    @Override
    void validate() {
        if (this.activated && !this.clustering().cacheMode().isDistributed()) {
            throw new ConfigurationException("Configuring the hashing behavior of entries is only supported when using DISTRIBUTED as a cache mode.  Your cache mode is set to " + this.clustering().cacheMode().friendlyCacheModeString());
        }
        this.groupsConfigurationBuilder.validate();
    }

    @Override
    HashConfiguration create() {
        return new HashConfiguration(this.consistentHash, this.hash, this.numOwners, this.numVirtualNodes, this.groupsConfigurationBuilder.create(), this.stateTransfer().create(), this.activated);
    }

    public HashConfigurationBuilder read(HashConfiguration template) {
        this.consistentHash = template.consistentHash();
        this.hash = template.hash();
        this.numOwners = template.numOwners();
        this.numVirtualNodes = template.numVirtualNodes();
        this.activated = template.activated;
        this.groupsConfigurationBuilder.read(template.groups());
        return this;
    }
}

