/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.configuration.global;

import java.util.Properties;
import java.util.concurrent.TimeUnit;
import org.infinispan.configuration.global.AbstractGlobalConfigurationBuilder;
import org.infinispan.configuration.global.GlobalConfigurationBuilder;
import org.infinispan.configuration.global.TransportConfiguration;
import org.infinispan.remoting.transport.Transport;
import org.infinispan.remoting.transport.jgroups.JGroupsTransport;
import org.infinispan.util.TypedProperties;
import org.infinispan.util.Util;

public class TransportConfigurationBuilder
extends AbstractGlobalConfigurationBuilder<TransportConfiguration> {
    public static final Class<? extends Transport> DEFAULT_TRANSPORT = JGroupsTransport.class;
    private String clusterName = "ISPN";
    private String machineId;
    private String rackId;
    private String siteId;
    private long distributedSyncTimeout = TimeUnit.MINUTES.toMillis(4L);
    private Transport transport;
    private String nodeName;
    private Properties properties = new Properties();
    private boolean strictPeerToPeer = false;

    TransportConfigurationBuilder(GlobalConfigurationBuilder globalConfig) {
        super(globalConfig);
    }

    public TransportConfigurationBuilder clusterName(String clusterName) {
        this.clusterName = clusterName;
        return this;
    }

    public TransportConfigurationBuilder machineId(String machineId) {
        this.machineId = machineId;
        return this;
    }

    public TransportConfigurationBuilder rackId(String rackId) {
        this.rackId = rackId;
        return this;
    }

    public TransportConfigurationBuilder siteId(String siteId) {
        this.siteId = siteId;
        return this;
    }

    public TransportConfigurationBuilder distributedSyncTimeout(long distributedSyncTimeout) {
        this.distributedSyncTimeout = distributedSyncTimeout;
        return this;
    }

    public TransportConfigurationBuilder transport(Transport transport) {
        this.transport = transport;
        return this;
    }

    public TransportConfigurationBuilder nodeName(String nodeName) {
        this.nodeName = nodeName;
        return this;
    }

    public TransportConfigurationBuilder withProperties(Properties properties) {
        this.properties = properties;
        return this;
    }

    public TransportConfigurationBuilder clearProperties() {
        this.properties = new Properties();
        return this;
    }

    public TransportConfigurationBuilder addProperty(String key, String value) {
        this.properties.put(key, value);
        return this;
    }

    public TransportConfigurationBuilder strictPeerToPeer(Boolean strictPeerToPeer) {
        this.strictPeerToPeer = strictPeerToPeer;
        return this;
    }

    @Override
    void validate() {
    }

    @Override
    TransportConfiguration create() {
        return new TransportConfiguration(this.clusterName, this.machineId, this.rackId, this.siteId, this.strictPeerToPeer, this.distributedSyncTimeout, this.transport, this.nodeName, TypedProperties.toTypedProperties(this.properties));
    }

    public TransportConfigurationBuilder defaultTransport() {
        this.transport(Util.getInstance(DEFAULT_TRANSPORT));
        return this;
    }

    TransportConfigurationBuilder read(TransportConfiguration template) {
        this.clusterName = template.clusterName();
        this.distributedSyncTimeout = template.distributedSyncTimeout();
        this.machineId = template.machineId();
        this.nodeName = template.nodeName();
        this.properties = template.properties();
        this.rackId = template.rackId();
        this.siteId = template.siteId();
        this.strictPeerToPeer = template.strictPeerToPeer();
        this.transport = template.transport();
        return this;
    }

    public Transport getTransport() {
        return this.transport;
    }
}

