/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.transaction;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import org.infinispan.commands.write.WriteCommand;
import org.infinispan.container.entries.CacheEntry;
import org.infinispan.transaction.AbstractCacheTransaction;
import org.infinispan.transaction.xa.GlobalTransaction;
import org.infinispan.transaction.xa.InvalidTransactionException;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class RemoteTransaction
extends AbstractCacheTransaction
implements Cloneable {
    private static final Log log = LogFactory.getLog(RemoteTransaction.class);
    private volatile boolean valid = true;

    public RemoteTransaction(WriteCommand[] modifications, GlobalTransaction tx, int viewId) {
        super(tx, viewId);
        this.modifications = modifications == null || modifications.length == 0 ? Collections.emptyList() : Arrays.asList(modifications);
        this.lookedUpEntries = new HashMap(this.modifications.size());
    }

    public RemoteTransaction(GlobalTransaction tx, int viewId) {
        super(tx, viewId);
        this.modifications = new LinkedList();
        this.lookedUpEntries = new HashMap(2);
    }

    public void invalidate() {
        this.valid = false;
    }

    @Override
    public void putLookedUpEntry(Object key, CacheEntry e) {
        if (this.valid) {
            if (log.isTraceEnabled()) {
                log.tracef("Adding key %s to tx %s", key, this.getGlobalTransaction());
            }
        } else {
            throw new InvalidTransactionException("This remote transaction " + this.getGlobalTransaction() + " is invalid");
        }
        this.lookedUpEntries.put(key, e);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof RemoteTransaction)) {
            return false;
        }
        RemoteTransaction that = (RemoteTransaction)o;
        return this.tx.equals(that.tx);
    }

    public int hashCode() {
        return this.tx.hashCode();
    }

    public Object clone() {
        try {
            RemoteTransaction dolly = (RemoteTransaction)super.clone();
            dolly.modifications = new ArrayList(this.modifications);
            dolly.lookedUpEntries = new HashMap(this.lookedUpEntries);
            return dolly;
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Impossible!!");
        }
    }

    public String toString() {
        return "RemoteTransaction{modifications=" + this.modifications + ", lookedUpEntries=" + this.lookedUpEntries + ", lockedKeys= " + this.lockedKeys + ", backupKeyLocks " + this.backupKeyLocks + ", tx=" + this.tx + '}';
    }
}

