/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.domain.controller.plan;

import org.jboss.as.domain.controller.ServerIdentity;
import org.jboss.as.domain.controller.plan.ServerUpdatePolicy;
import org.jboss.dmr.ModelNode;

abstract class AbstractServerUpdateTask
implements Runnable {
    protected final ServerUpdatePolicy updatePolicy;
    protected final ServerIdentity serverId;
    protected final ServerUpdateResultHandler resultHandler;

    AbstractServerUpdateTask(ServerIdentity serverId, ServerUpdatePolicy updatePolicy, ServerUpdateResultHandler resultHandler) {
        assert (serverId != null) : "serverId is null";
        assert (updatePolicy != null) : "updatePolicy is null";
        assert (resultHandler != null) : "resultHandler is null";
        this.serverId = serverId;
        this.updatePolicy = updatePolicy;
        this.resultHandler = resultHandler;
    }

    @Override
    public void run() {
        if (this.updatePolicy.canUpdateServer(this.serverId)) {
            this.processUpdates();
        } else {
            this.sendCancelledResponse();
        }
    }

    protected abstract void processUpdates();

    private void sendCancelledResponse() {
        ModelNode response = new ModelNode();
        response.get("outcome").set("cancelled");
        this.resultHandler.handleServerUpdateResult(this.serverId, response);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.getClass().getSimpleName());
        sb.append("{server=");
        sb.append(this.serverId.getServerName());
        sb.append("}");
        return sb.toString();
    }

    static interface ServerUpdateResultHandler {
        public void handleServerUpdateResult(ServerIdentity var1, ModelNode var2);
    }
}

