/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.host.controller;

import java.io.Closeable;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.security.AccessController;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import javax.net.SocketFactory;
import org.jboss.as.host.controller.HostControllerEnvironment;
import org.jboss.as.host.controller.HostControllerMessages;
import org.jboss.as.host.controller.ManagedServer;
import org.jboss.as.host.controller.ServerInventory;
import org.jboss.as.process.ProcessControllerClient;
import org.jboss.as.process.ProcessInfo;
import org.jboss.as.process.ProcessMessageHandler;
import org.jboss.as.process.protocol.ProtocolClient;
import org.jboss.as.protocol.StreamUtils;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.threads.JBossThreadFactory;

class ProcessControllerConnectionService
implements Service<ProcessControllerConnectionService> {
    static final ServiceName SERVICE_NAME = ServiceName.JBOSS.append(new String[]{"host", "controller", "process-controller-connection"});
    private final HostControllerEnvironment environment;
    private final byte[] authCode;
    private volatile ProcessControllerClient client;
    private volatile ServerInventory serverInventory;

    ProcessControllerConnectionService(HostControllerEnvironment environment, byte[] authCode) {
        this.environment = environment;
        this.authCode = authCode;
    }

    void setServerInventory(ServerInventory serverInventory) {
        this.serverInventory = serverInventory;
    }

    public synchronized void start(StartContext context) throws StartException {
        ProcessControllerClient client;
        try {
            ProtocolClient.Configuration configuration = new ProtocolClient.Configuration();
            configuration.setReadExecutor((Executor)Executors.newCachedThreadPool());
            configuration.setServerAddress(new InetSocketAddress(this.environment.getProcessControllerAddress(), (int)this.environment.getProcessControllerPort()));
            configuration.setBindAddress(new InetSocketAddress(this.environment.getHostControllerAddress(), (int)this.environment.getHostControllerPort()));
            JBossThreadFactory threadFactory = new JBossThreadFactory(new ThreadGroup("ProcessControllerConnection-threads"), Boolean.FALSE, null, "%G - %t", null, null, AccessController.getContext());
            configuration.setThreadFactory((ThreadFactory)threadFactory);
            configuration.setSocketFactory(SocketFactory.getDefault());
            client = ProcessControllerClient.connect((ProtocolClient.Configuration)configuration, (byte[])this.authCode, (ProcessMessageHandler)new ProcessMessageHandler(){

                public void handleProcessAdded(ProcessControllerClient client, String processName) {
                    if (ProcessControllerConnectionService.this.serverInventory == null) {
                        throw HostControllerMessages.MESSAGES.noServerInventory();
                    }
                    if (ManagedServer.isServerProcess(processName)) {
                        ProcessControllerConnectionService.this.serverInventory.serverProcessAdded(processName);
                    }
                }

                public void handleProcessStarted(ProcessControllerClient client, String processName) {
                    if (ProcessControllerConnectionService.this.serverInventory == null) {
                        throw HostControllerMessages.MESSAGES.noServerInventory();
                    }
                    if (ManagedServer.isServerProcess(processName)) {
                        ProcessControllerConnectionService.this.serverInventory.serverProcessStarted(processName);
                    }
                }

                public void handleProcessStopped(ProcessControllerClient client, String processName, long uptimeMillis) {
                    if (ProcessControllerConnectionService.this.serverInventory == null) {
                        throw HostControllerMessages.MESSAGES.noServerInventory();
                    }
                    if (ManagedServer.isServerProcess(processName)) {
                        ProcessControllerConnectionService.this.serverInventory.serverProcessStopped(processName);
                    }
                }

                public void handleProcessRemoved(ProcessControllerClient client, String processName) {
                    if (ProcessControllerConnectionService.this.serverInventory == null) {
                        throw HostControllerMessages.MESSAGES.noServerInventory();
                    }
                    if (ManagedServer.isServerProcess(processName)) {
                        ProcessControllerConnectionService.this.serverInventory.serverProcessRemoved(processName);
                    }
                }

                public void handleProcessInventory(ProcessControllerClient client, Map<String, ProcessInfo> inventory) {
                    if (ProcessControllerConnectionService.this.serverInventory == null) {
                        throw HostControllerMessages.MESSAGES.noServerInventory();
                    }
                    ProcessControllerConnectionService.this.serverInventory.processInventory(inventory);
                }

                public void handleConnectionShutdown(ProcessControllerClient client) {
                    if (ProcessControllerConnectionService.this.serverInventory == null) {
                        return;
                    }
                    ProcessControllerConnectionService.this.serverInventory.connectionFinished();
                }

                public void handleConnectionFailure(ProcessControllerClient client, IOException cause) {
                    if (ProcessControllerConnectionService.this.serverInventory == null) {
                        return;
                    }
                    ProcessControllerConnectionService.this.serverInventory.connectionFinished();
                }

                public void handleConnectionFinished(ProcessControllerClient client) {
                    if (ProcessControllerConnectionService.this.serverInventory == null) {
                        return;
                    }
                    ProcessControllerConnectionService.this.serverInventory.connectionFinished();
                }

                public void handleOperationFailed(ProcessControllerClient client, ProcessMessageHandler.OperationType operation, String processName) {
                    if (ProcessControllerConnectionService.this.serverInventory == null) {
                        throw HostControllerMessages.MESSAGES.noServerInventory();
                    }
                    if (ManagedServer.isServerProcess(processName)) {
                        ProcessControllerConnectionService.this.serverInventory.operationFailed(processName, operation);
                    }
                }
            });
        }
        catch (IOException e) {
            throw new StartException((Throwable)e);
        }
        this.client = client;
    }

    public synchronized void stop(StopContext context) {
        ProcessControllerClient client = this.client;
        this.client = null;
        StreamUtils.safeClose((Closeable)client);
    }

    public synchronized ProcessControllerConnectionService getValue() throws IllegalStateException, IllegalArgumentException {
        return this;
    }

    public synchronized ProcessControllerClient getClient() throws IllegalStateException, IllegalArgumentException {
        ProcessControllerClient client = this.client;
        if (client == null) {
            throw new IllegalStateException();
        }
        return client;
    }
}

