/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.host.controller;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.security.NoSuchAlgorithmException;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.sasl.AuthorizeCallback;
import javax.security.sasl.RealmCallback;
import org.jboss.as.controller.ProxyController;
import org.jboss.as.controller.client.helpers.domain.ServerStatus;
import org.jboss.as.domain.controller.DomainController;
import org.jboss.as.host.controller.HostControllerEnvironment;
import org.jboss.as.host.controller.HostControllerLogger;
import org.jboss.as.host.controller.HostControllerMessages;
import org.jboss.as.host.controller.ManagedServer;
import org.jboss.as.host.controller.ModelCombiner;
import org.jboss.as.host.controller.ServerInventory;
import org.jboss.as.process.ProcessControllerClient;
import org.jboss.as.process.ProcessInfo;
import org.jboss.as.process.ProcessMessageHandler;
import org.jboss.as.protocol.mgmt.ManagementChannelHandler;
import org.jboss.dmr.ModelNode;
import org.jboss.remoting3.Channel;
import org.jboss.remoting3.CloseHandler;
import org.jboss.sasl.callback.DigestHashCallback;
import org.jboss.sasl.callback.VerifyPasswordCallback;
import org.jboss.sasl.util.UsernamePasswordHashUtil;

public class ServerInventoryImpl
implements ServerInventory {
    private final ConcurrentMap<String, ManagedServer> servers = new ConcurrentHashMap<String, ManagedServer>();
    private final HostControllerEnvironment environment;
    private final ProcessControllerClient processControllerClient;
    private final InetSocketAddress managementAddress;
    private final DomainController domainController;
    private volatile boolean stopped;
    private volatile boolean connectionFinished;
    private volatile CountDownLatch processInventoryLatch;
    private volatile Map<String, ProcessInfo> processInfos;
    private final Object shutdownCondition = new Object();

    ServerInventoryImpl(DomainController domainController, HostControllerEnvironment environment, InetSocketAddress managementAddress, ProcessControllerClient processControllerClient) {
        this.domainController = domainController;
        this.environment = environment;
        this.managementAddress = managementAddress;
        this.processControllerClient = processControllerClient;
    }

    @Override
    public String getServerProcessName(String serverName) {
        return ManagedServer.getServerProcessName(serverName);
    }

    @Override
    public String getProcessServerName(String processName) {
        return ManagedServer.getServerName(processName);
    }

    @Override
    public synchronized Map<String, ProcessInfo> determineRunningProcesses() {
        this.processInventoryLatch = new CountDownLatch(1);
        try {
            this.processControllerClient.requestProcessInventory();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        try {
            if (!this.processInventoryLatch.await(30L, TimeUnit.SECONDS)) {
                throw HostControllerMessages.MESSAGES.couldNotGetServerInventory(30L, TimeUnit.SECONDS.toString().toLowerCase(Locale.US));
            }
        }
        catch (InterruptedException e) {
            throw HostControllerMessages.MESSAGES.couldNotGetServerInventory(30L, TimeUnit.SECONDS.toString().toLowerCase(Locale.US));
        }
        return this.processInfos;
    }

    @Override
    public Map<String, ProcessInfo> determineRunningProcesses(boolean serversOnly) {
        Map<String, ProcessInfo> processInfos = this.determineRunningProcesses();
        if (!serversOnly) {
            return processInfos;
        }
        HashMap<String, ProcessInfo> processes = new HashMap<String, ProcessInfo>();
        for (Map.Entry<String, ProcessInfo> procEntry : processInfos.entrySet()) {
            if (!ManagedServer.isServerProcess(procEntry.getKey())) continue;
            processes.put(procEntry.getKey(), procEntry.getValue());
        }
        return processes;
    }

    @Override
    public ServerStatus determineServerStatus(String serverName) {
        ManagedServer server = (ManagedServer)this.servers.get(serverName);
        if (server == null) {
            return ServerStatus.STOPPED;
        }
        return server.getState();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ServerStatus startServer(String serverName, ModelNode domainModel) {
        if (this.stopped || this.connectionFinished) {
            throw HostControllerMessages.MESSAGES.hostAlreadyShutdown();
        }
        ManagedServer existing = (ManagedServer)this.servers.get(serverName);
        if (existing != null) {
            HostControllerLogger.ROOT_LOGGER.existingServerWithState(serverName, existing.getState());
            return this.determineServerStatus(serverName);
        }
        ManagedServer server = this.createManagedServer(serverName, domainModel);
        if (this.servers.putIfAbsent(serverName, server) != null) {
            return this.determineServerStatus(serverName);
        }
        server.start();
        Object object = this.shutdownCondition;
        synchronized (object) {
            this.shutdownCondition.notifyAll();
        }
        return server.getState();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ServerStatus restartServer(String serverName, int gracefulTimeout, ModelNode domainModel) {
        this.stopServer(serverName, gracefulTimeout);
        Object object = this.shutdownCondition;
        synchronized (object) {
            while (true) {
                if (this.stopped || this.connectionFinished) {
                    throw HostControllerMessages.MESSAGES.hostAlreadyShutdown();
                }
                if (!this.servers.containsKey(serverName)) break;
                try {
                    this.shutdownCondition.wait();
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    break;
                }
            }
        }
        this.startServer(serverName, domainModel);
        return this.determineServerStatus(serverName);
    }

    @Override
    public ServerStatus stopServer(String serverName, int gracefulTimeout) {
        ManagedServer server = (ManagedServer)this.servers.get(serverName);
        if (server == null) {
            return ServerStatus.STOPPED;
        }
        server.stop();
        return server.getState();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void reconnectServer(String serverName, ModelNode domainModel, boolean running) {
        if (this.stopped || this.connectionFinished) {
            throw HostControllerMessages.MESSAGES.hostAlreadyShutdown();
        }
        ManagedServer existing = (ManagedServer)this.servers.get(serverName);
        if (existing != null) {
            HostControllerLogger.ROOT_LOGGER.existingServerWithState(serverName, existing.getState());
            return;
        }
        ManagedServer server = this.createManagedServer(serverName, domainModel);
        if (this.servers.putIfAbsent(serverName, server) != null) {
            HostControllerLogger.ROOT_LOGGER.existingServerWithState(serverName, existing.getState());
            return;
        }
        if (running) {
            server.reconnectServerProcess();
        }
        Object object = this.shutdownCondition;
        synchronized (object) {
            this.shutdownCondition.notifyAll();
        }
    }

    @Override
    public void stopServers(int gracefulTimeout) {
        this.stopServers(gracefulTimeout, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopServers(int gracefulTimeout, boolean blockUntilStopped) {
        boolean stopped = this.stopped;
        this.stopped = true;
        if (!stopped) {
            if (this.connectionFinished) {
                return;
            }
            for (ManagedServer server : this.servers.values()) {
                server.stop();
            }
            if (blockUntilStopped) {
                Object object = this.shutdownCondition;
                synchronized (object) {
                    while (!this.connectionFinished) {
                        int count = 0;
                        block10: for (ManagedServer server : this.servers.values()) {
                            ServerStatus state = server.getState();
                            switch (state) {
                                case DISABLED: 
                                case FAILED: 
                                case STOPPED: {
                                    continue block10;
                                }
                            }
                            ++count;
                        }
                        if (count == 0) break;
                        try {
                            this.shutdownCondition.wait();
                        }
                        catch (InterruptedException e) {
                            Thread.currentThread().interrupt();
                            break;
                        }
                    }
                }
            }
        }
    }

    @Override
    public void serverCommunicationRegistered(String serverProcessName, ManagementChannelHandler channelAssociation) {
        if (this.stopped || this.connectionFinished) {
            throw HostControllerMessages.MESSAGES.hostAlreadyShutdown();
        }
        String serverName = ManagedServer.getServerName(serverProcessName);
        final ManagedServer server = (ManagedServer)this.servers.get(serverName);
        if (server == null) {
            HostControllerLogger.ROOT_LOGGER.noServerAvailable(serverName);
            return;
        }
        try {
            Channel channel = channelAssociation.getChannel();
            channel.addCloseHandler((CloseHandler)new CloseHandler<Channel>(){

                public void handleClose(Channel closed, IOException exception) {
                    server.callbackUnregistered();
                    ServerInventoryImpl.this.domainController.unregisterRunningServer(server.getServerName());
                }
            });
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        server.channelRegistered(channelAssociation);
    }

    @Override
    public boolean serverReconnected(String serverProcessName, ManagementChannelHandler channelHandler) {
        this.serverCommunicationRegistered(serverProcessName, channelHandler);
        this.serverStarted(serverProcessName);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void serverProcessStopped(String serverProcessName) {
        String serverName = ManagedServer.getServerName(serverProcessName);
        ManagedServer server = (ManagedServer)this.servers.get(serverName);
        if (server == null) {
            HostControllerLogger.ROOT_LOGGER.noServerAvailable(serverName);
            return;
        }
        server.processFinished();
        Object object = this.shutdownCondition;
        synchronized (object) {
            this.shutdownCondition.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void connectionFinished() {
        this.connectionFinished = true;
        HostControllerLogger.ROOT_LOGGER.debug("process controller connection closed.");
        Object object = this.shutdownCondition;
        synchronized (object) {
            this.shutdownCondition.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void serverStarted(String serverProcessName) {
        String serverName = ManagedServer.getServerName(serverProcessName);
        ManagedServer server = (ManagedServer)this.servers.get(serverName);
        if (server == null) {
            HostControllerLogger.ROOT_LOGGER.noServerAvailable(serverName);
            return;
        }
        server.serverStarted(new ManagedServer.TransitionTask(){

            @Override
            public void execute(ManagedServer server) throws Exception {
                ProxyController proxy = server.getProxyController();
                if (proxy != null) {
                    ServerInventoryImpl.this.domainController.registerRunningServer(proxy);
                }
            }
        });
        Object object = this.shutdownCondition;
        synchronized (object) {
            this.shutdownCondition.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void serverStartFailed(String serverProcessName) {
        String serverName = ManagedServer.getServerName(serverProcessName);
        ManagedServer server = (ManagedServer)this.servers.get(serverName);
        if (server == null) {
            HostControllerLogger.ROOT_LOGGER.noServerAvailable(serverName);
            return;
        }
        server.serverStartFailed();
        Object object = this.shutdownCondition;
        synchronized (object) {
            this.shutdownCondition.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void serverProcessAdded(String serverProcessName) {
        String serverName = ManagedServer.getServerName(serverProcessName);
        ManagedServer server = (ManagedServer)this.servers.get(serverName);
        if (server == null) {
            HostControllerLogger.ROOT_LOGGER.noServerAvailable(serverName);
            return;
        }
        server.processAdded();
        Object object = this.shutdownCondition;
        synchronized (object) {
            this.shutdownCondition.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void serverProcessStarted(String serverProcessName) {
        String serverName = ManagedServer.getServerName(serverProcessName);
        ManagedServer server = (ManagedServer)this.servers.get(serverName);
        if (server == null) {
            HostControllerLogger.ROOT_LOGGER.noServerAvailable(serverName);
            return;
        }
        server.processStarted();
        Object object = this.shutdownCondition;
        synchronized (object) {
            this.shutdownCondition.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void serverProcessRemoved(String serverProcessName) {
        String serverName = ManagedServer.getServerName(serverProcessName);
        ManagedServer server = (ManagedServer)this.servers.remove(serverName);
        if (server == null) {
            HostControllerLogger.ROOT_LOGGER.noServerAvailable(serverName);
            return;
        }
        server.processRemoved();
        Object object = this.shutdownCondition;
        synchronized (object) {
            this.shutdownCondition.notifyAll();
        }
    }

    @Override
    public void operationFailed(String serverProcessName, ProcessMessageHandler.OperationType type) {
        String serverName = ManagedServer.getServerName(serverProcessName);
        ManagedServer server = (ManagedServer)this.servers.get(serverName);
        if (server == null) {
            HostControllerLogger.ROOT_LOGGER.noServerAvailable(serverName);
            return;
        }
        switch (type) {
            case ADD: {
                server.transitionFailed(ManagedServer.InternalState.PROCESS_ADDING);
                break;
            }
            case START: {
                server.transitionFailed(ManagedServer.InternalState.PROCESS_STARTING);
                break;
            }
            case STOP: {
                server.transitionFailed(ManagedServer.InternalState.PROCESS_STOPPING);
                break;
            }
            case SEND_STDIN: 
            case RECONNECT: {
                server.transitionFailed(ManagedServer.InternalState.SERVER_STARTING);
                break;
            }
            case REMOVE: {
                server.transitionFailed(ManagedServer.InternalState.PROCESS_REMOVING);
            }
        }
    }

    @Override
    public void processInventory(Map<String, ProcessInfo> processInfos) {
        this.processInfos = processInfos;
        if (this.processInventoryLatch != null) {
            this.processInventoryLatch.countDown();
        }
    }

    private ManagedServer createManagedServer(String serverName, ModelNode domainModel) {
        String hostControllerName = this.domainController.getLocalHostInfo().getLocalHostName();
        ModelNode hostModel = domainModel.require("host").require(hostControllerName);
        ModelCombiner combiner = new ModelCombiner(serverName, domainModel, hostModel, this.domainController, this.environment);
        ManagedServer.ManagedServerBootConfiguration configuration = combiner.createConfiguration();
        return new ManagedServer(hostControllerName, serverName, this.processControllerClient, this.managementAddress, configuration);
    }

    @Override
    public CallbackHandler getServerCallbackHandler() {
        return new CallbackHandler(){

            @Override
            public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
                LinkedList<Callback> toRespondTo = new LinkedList<Callback>();
                String userName = null;
                String realm = null;
                ManagedServer server = null;
                for (Callback current : callbacks) {
                    if (current instanceof AuthorizeCallback) {
                        toRespondTo.add(current);
                        continue;
                    }
                    if (current instanceof NameCallback) {
                        NameCallback nameCallback = (NameCallback)current;
                        userName = nameCallback.getDefaultName();
                        if (!userName.startsWith("=")) continue;
                        server = (ManagedServer)ServerInventoryImpl.this.servers.get(userName.substring(1));
                        continue;
                    }
                    if (current instanceof PasswordCallback) {
                        toRespondTo.add(current);
                        continue;
                    }
                    if (current instanceof VerifyPasswordCallback) {
                        toRespondTo.add(current);
                        continue;
                    }
                    if (current instanceof DigestHashCallback) {
                        toRespondTo.add(current);
                        continue;
                    }
                    if (current instanceof RealmCallback) {
                        realm = ((RealmCallback)current).getDefaultText();
                        continue;
                    }
                    throw new UnsupportedCallbackException(current);
                }
                if (server == null) {
                    return;
                }
                String password = new String(server.getAuthKey());
                for (Callback current : toRespondTo) {
                    if (current instanceof AuthorizeCallback) {
                        AuthorizeCallback authorizeCallback = (AuthorizeCallback)current;
                        authorizeCallback.setAuthorized(authorizeCallback.getAuthenticationID().equals(authorizeCallback.getAuthorizationID()));
                        continue;
                    }
                    if (current instanceof PasswordCallback) {
                        ((PasswordCallback)current).setPassword(password.toCharArray());
                        continue;
                    }
                    if (current instanceof VerifyPasswordCallback) {
                        VerifyPasswordCallback vpc = (VerifyPasswordCallback)current;
                        vpc.setVerified(password.equals(vpc.getPassword()));
                        continue;
                    }
                    if (!(current instanceof DigestHashCallback)) continue;
                    DigestHashCallback dhc = (DigestHashCallback)current;
                    try {
                        UsernamePasswordHashUtil uph = new UsernamePasswordHashUtil();
                        if (userName == null || realm == null) {
                            throw HostControllerMessages.MESSAGES.insufficientInformationToGenerateHash();
                        }
                        dhc.setHash(uph.generateHashedURP(userName, realm, password.toCharArray()));
                    }
                    catch (NoSuchAlgorithmException e) {
                        throw HostControllerMessages.MESSAGES.unableToGenerateHash(e);
                    }
                }
            }
        };
    }
}

