/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.host.controller.operations;

import java.util.Locale;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.descriptions.DescriptionProvider;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.host.controller.HostControllerEnvironment;
import org.jboss.as.host.controller.HostControllerMessages;
import org.jboss.as.host.controller.ignored.IgnoredDomainResourceRegistry;
import org.jboss.as.platform.mbean.PlatformMBeanConstants;
import org.jboss.as.platform.mbean.RootPlatformMBeanResource;
import org.jboss.as.version.Version;
import org.jboss.dmr.ModelNode;

public class LocalHostAddHandler
implements OperationStepHandler,
DescriptionProvider {
    public static final String OPERATION_NAME = "add-host";
    private final HostControllerEnvironment hostControllerEnvironment;
    private final IgnoredDomainResourceRegistry ignoredDomainResourceRegistry;

    public LocalHostAddHandler(HostControllerEnvironment hostControllerEnvironment, IgnoredDomainResourceRegistry ignoredDomainResourceRegistry) {
        this.hostControllerEnvironment = hostControllerEnvironment;
        this.ignoredDomainResourceRegistry = ignoredDomainResourceRegistry;
    }

    public ModelNode getModelDescription(Locale locale) {
        return new ModelNode();
    }

    public void execute(OperationContext context, ModelNode operation) {
        if (!context.isBooting()) {
            throw HostControllerMessages.MESSAGES.invocationNotAllowedAfterBoot(OPERATION_NAME);
        }
        Resource rootResource = context.createResource(PathAddress.EMPTY_ADDRESS);
        ModelNode model = rootResource.getModel();
        LocalHostAddHandler.initCoreModel(model, this.hostControllerEnvironment);
        context.createResource(PathAddress.pathAddress((PathElement[])new PathElement[]{PathElement.pathElement((String)"core-service", (String)"management")}));
        rootResource.registerChild(PlatformMBeanConstants.ROOT_PATH, (Resource)new RootPlatformMBeanResource());
        Resource.ResourceEntry ignoredRoot = this.ignoredDomainResourceRegistry.getRootResource();
        rootResource.registerChild(ignoredRoot.getPathElement(), (Resource)ignoredRoot);
        ModelNode writeNameOp = Util.getWriteAttributeOperation((ModelNode)operation.get("address"), (String)"name", (ModelNode)operation.get("name"));
        context.addStep(writeNameOp, this.hostControllerEnvironment.getProcessNameWriteHandler(), OperationContext.Stage.IMMEDIATE);
        context.completeStep(OperationContext.RollbackHandler.NOOP_ROLLBACK_HANDLER);
    }

    private static void initCoreModel(ModelNode root, HostControllerEnvironment environment) {
        root.get("release-version").set(Version.AS_VERSION);
        root.get("release-codename").set(Version.AS_RELEASE_CODENAME);
        root.get("management-major-version").set(1);
        root.get("management-minor-version").set(0);
        ModelNode nameNode = root.get("product-name");
        ModelNode versionNode = root.get("product-version");
        if (environment != null) {
            String productName = environment.getProductConfig().getProductName();
            String productVersion = environment.getProductConfig().getProductVersion();
            if (productName != null) {
                nameNode.set(productName);
            }
            if (productVersion != null) {
                versionNode.set(productVersion);
            }
        }
        root.get("name");
        root.get("namespaces").setEmptyList();
        root.get("schema-locations").setEmptyList();
        root.get("extension");
        root.get("system-property");
        root.get("path");
        root.get("core-service");
        root.get("server-config");
        root.get("domain-controller");
        root.get("interface");
        root.get("jvm");
        root.get("server");
    }
}

