/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.core.server.netty;

import java.util.HashMap;
import java.util.Map;
import java.util.ResourceBundle;
import org.jboss.ws.api.util.BundleUtils;
import org.jboss.ws.core.server.netty.NettyHttpServer;
import org.jboss.ws.core.server.netty.NettyHttpServerImpl;
import org.jboss.ws.core.server.netty.NettyRequestHandlerFactory;

public final class NettyHttpServerFactory {
    private static final ResourceBundle bundle = BundleUtils.getBundle(NettyHttpServerFactory.class);
    static final Map<Integer, NettyHttpServer> SERVERS = new HashMap<Integer, NettyHttpServer>();

    private NettyHttpServerFactory() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T extends NettyRequestHandlerFactory<?>> NettyHttpServer getNettyHttpServer(int port, T requestHandlerFactory) {
        if (port <= 0) {
            throw new IllegalArgumentException(BundleUtils.getMessage((ResourceBundle)bundle, (String)"NOT_POSITIVE_PORT_VALUE", (Object[])new Object[0]));
        }
        if (requestHandlerFactory == null) {
            throw new NullPointerException(BundleUtils.getMessage((ResourceBundle)bundle, (String)"FACTORY_CANNOT_BE_NULL", (Object[])new Object[0]));
        }
        Map<Integer, NettyHttpServer> map = SERVERS;
        synchronized (map) {
            NettyHttpServer server = SERVERS.get(port);
            if (server == null) {
                server = new NettyHttpServerImpl(port, requestHandlerFactory);
                SERVERS.put(port, server);
            }
            return server;
        }
    }
}

