/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.jpa.hibernate4;

import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import org.jboss.as.jpa.hibernate4.HibernateAnnotationScanner;
import org.jboss.as.jpa.hibernate4.JBossAppServerJtaPlatform;
import org.jboss.as.jpa.hibernate4.management.HibernateManagementAdaptor;
import org.jboss.as.jpa.spi.JtaManager;
import org.jboss.as.jpa.spi.ManagementAdaptor;
import org.jboss.as.jpa.spi.PersistenceProviderAdaptor;
import org.jboss.as.jpa.spi.PersistenceUnitMetadata;
import org.jboss.msc.service.ServiceName;

public class HibernatePersistenceProviderAdaptor
implements PersistenceProviderAdaptor {
    private static final String DEFAULT_REGION_FACTORY = "org.jboss.as.jpa.hibernate.cache.infinispan.InfinispanRegionFactory";
    private static final String DEFAULT_CACHE_CONTAINER = "hibernate";
    private static final String DEFAULT_ENTITY_CACHE = "entity";
    private static final String DEFAULT_COLLECTION_CACHE = "entity";
    private static final String DEFAULT_QUERY_CACHE = "local-query";
    private static final String DEFAULT_TIMESTAMPS_CACHE = "timestamps";
    private volatile JBossAppServerJtaPlatform appServerJtaPlatform;

    public void injectJtaManager(JtaManager jtaManager) {
        this.appServerJtaPlatform = new JBossAppServerJtaPlatform(jtaManager);
    }

    public void addProviderProperties(Map properties, PersistenceUnitMetadata pu) {
        this.putPropertyIfAbsent(pu, properties, "hibernate.id.new_generator_mappings", "true");
        this.putPropertyIfAbsent(pu, properties, "hibernate.ejb.resource_scanner", "org.jboss.as.jpa.hibernate4.HibernateAnnotationScanner");
        properties.put("hibernate.classLoader.application", pu.getClassLoader());
        this.putPropertyIfAbsent(pu, properties, "hibernate.transaction.jta.platform", (Object)this.appServerJtaPlatform);
        properties.remove("hibernate.transaction.manager_lookup_class");
        this.putPropertyIfAbsent(pu, properties, "hibernate.ejb.entitymanager_factory_name", pu.getScopedPersistenceUnitName());
        this.putPropertyIfAbsent(pu, properties, "hibernate.session_factory_name", pu.getScopedPersistenceUnitName());
        if (!pu.getProperties().containsKey("hibernate.session_factory_name")) {
            this.putPropertyIfAbsent(pu, properties, "hibernate.session_factory_name_is_jndi", Boolean.FALSE);
        }
    }

    public Iterable<ServiceName> getProviderDependencies(PersistenceUnitMetadata pu) {
        Properties properties = pu.getProperties();
        if (Boolean.parseBoolean(properties.getProperty("hibernate.cache.use_second_level_cache"))) {
            String regionFactory;
            if (properties.getProperty("hibernate.cache.region_prefix") == null) {
                properties.put("hibernate.cache.region_prefix", pu.getScopedPersistenceUnitName());
            }
            if ((regionFactory = properties.getProperty("hibernate.cache.region.factory_class")) == null) {
                regionFactory = DEFAULT_REGION_FACTORY;
                properties.setProperty("hibernate.cache.region.factory_class", regionFactory);
            }
            if (regionFactory.equals(DEFAULT_REGION_FACTORY)) {
                String container = properties.getProperty("hibernate.cache.infinispan.container");
                if (container == null) {
                    container = DEFAULT_CACHE_CONTAINER;
                    properties.setProperty("hibernate.cache.infinispan.container", container);
                }
                String entity = properties.getProperty("hibernate.cache.infinispan.entity.cfg", "entity");
                String collection = properties.getProperty("hibernate.cache.infinispan.collection.cfg", "entity");
                String query = properties.getProperty("hibernate.cache.infinispan.query.cfg", DEFAULT_QUERY_CACHE);
                String timestamps = properties.getProperty("hibernate.cache.infinispan.timestamps.cfg", DEFAULT_TIMESTAMPS_CACHE);
                HashSet<ServiceName> result = new HashSet<ServiceName>();
                result.add(this.getCacheConfigServiceName(container, entity));
                result.add(this.getCacheConfigServiceName(container, collection));
                result.add(this.getCacheConfigServiceName(container, timestamps));
                result.add(this.getCacheConfigServiceName(container, query));
                return result;
            }
        }
        return null;
    }

    private ServiceName getCacheConfigServiceName(String container, String cache) {
        return ServiceName.JBOSS.append(new String[]{"infinispan", container, cache, "config"});
    }

    private void putPropertyIfAbsent(PersistenceUnitMetadata pu, Map properties, String property, Object value) {
        if (!pu.getProperties().containsKey(property)) {
            properties.put(property, value);
        }
    }

    public void beforeCreateContainerEntityManagerFactory(PersistenceUnitMetadata pu) {
        HibernateAnnotationScanner.setThreadLocalPersistenceUnitMetadata(pu);
    }

    public void afterCreateContainerEntityManagerFactory(PersistenceUnitMetadata pu) {
        HibernateAnnotationScanner.clearThreadLocalPersistenceUnitMetadata();
    }

    public ManagementAdaptor getManagementAdaptor() {
        return HibernateManagementAdaptor.getInstance();
    }

    public void cleanup(PersistenceUnitMetadata pu) {
        HibernateAnnotationScanner.cleanup(pu);
    }
}

