/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.identity.federation.bindings.tomcat.sp;

import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.util.List;
import org.apache.catalina.Context;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.connector.Request;
import org.apache.log4j.Logger;
import org.picketlink.identity.federation.api.saml.v2.response.SAML2Response;
import org.picketlink.identity.federation.bindings.tomcat.sp.SPRedirectFormAuthenticator;
import org.picketlink.identity.federation.bindings.tomcat.sp.SecurityActions;
import org.picketlink.identity.federation.core.config.KeyProviderType;
import org.picketlink.identity.federation.core.exceptions.ConfigurationException;
import org.picketlink.identity.federation.core.exceptions.ParsingException;
import org.picketlink.identity.federation.core.exceptions.ProcessingException;
import org.picketlink.identity.federation.core.interfaces.TrustKeyConfigurationException;
import org.picketlink.identity.federation.core.interfaces.TrustKeyManager;
import org.picketlink.identity.federation.core.interfaces.TrustKeyProcessingException;
import org.picketlink.identity.federation.core.saml.v2.util.DocumentUtil;
import org.picketlink.identity.federation.core.saml.v2.util.SignatureUtil;
import org.picketlink.identity.federation.core.util.CoreConfigUtil;
import org.picketlink.identity.federation.core.util.StringUtil;
import org.picketlink.identity.federation.core.util.XMLEncryptionUtil;
import org.picketlink.identity.federation.saml.v2.assertion.EncryptedAssertionType;
import org.picketlink.identity.federation.saml.v2.assertion.EncryptedElementType;
import org.picketlink.identity.federation.saml.v2.protocol.ResponseType;
import org.picketlink.identity.federation.web.process.ServiceProviderBaseProcessor;
import org.picketlink.identity.federation.web.util.RedirectBindingSignatureUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class SPRedirectSignatureFormAuthenticator
extends SPRedirectFormAuthenticator {
    private static Logger log = Logger.getLogger(SPRedirectSignatureFormAuthenticator.class);
    private final boolean trace = log.isTraceEnabled();
    private TrustKeyManager keyManager;
    protected String idpAddress = null;

    public void setIdpAddress(String idpAddress) {
        this.idpAddress = idpAddress;
    }

    public void start() throws LifecycleException {
        super.start();
        Context context = (Context)this.getContainer();
        KeyProviderType keyProvider = this.spConfiguration.getKeyProvider();
        if (keyProvider == null) {
            throw new LifecycleException("PL00092: Null Value:KeyProvider is null for context=" + context.getName());
        }
        try {
            String keyManagerClassName = keyProvider.getClassName();
            if (keyManagerClassName == null) {
                throw new RuntimeException("PL00092: Null Value:KeyManager class name");
            }
            Class<?> clazz = SecurityActions.loadClass(((Object)((Object)this)).getClass(), keyManagerClassName);
            if (clazz == null) {
                throw new ClassNotFoundException("PL00085: Class Not Loaded:" + keyManagerClassName);
            }
            this.keyManager = (TrustKeyManager)clazz.newInstance();
            List authProperties = CoreConfigUtil.getKeyProviderProperties((KeyProviderType)keyProvider);
            this.keyManager.setAuthProperties(authProperties);
            this.keyManager.setValidatingAlias(keyProvider.getValidatingAlias());
            if (StringUtil.isNotNull((String)this.idpAddress)) {
                this.keyManager.addAdditionalOption("idp.key", (Object)this.idpAddress);
            }
        }
        catch (Exception e) {
            log.error((Object)"Exception reading configuration:", (Throwable)e);
            throw new LifecycleException(e.getLocalizedMessage());
        }
        if (this.trace) {
            log.trace((Object)("Key Provider=" + keyProvider.getClassName()));
        }
        try {
            this.populateChainConfig();
            super.initializeHandlerChain();
        }
        catch (Exception e) {
            log.error((Object)"Exception reading configuration:", (Throwable)e);
            throw new LifecycleException(e.getLocalizedMessage());
        }
    }

    protected boolean validate(Request request) throws IOException, GeneralSecurityException {
        PublicKey validatingKey;
        boolean result = super.validate(request);
        if (!result) {
            return result;
        }
        String queryString = request.getQueryString();
        byte[] sigValue = RedirectBindingSignatureUtil.getSignatureValueFromSignedURL((String)queryString);
        if (sigValue == null) {
            return false;
        }
        String reqFromURL = RedirectBindingSignatureUtil.getTokenValue((String)queryString, (String)"SAMLResponse");
        String relayStateFromURL = RedirectBindingSignatureUtil.getTokenValue((String)queryString, (String)"RelayState");
        String sigAlgFromURL = RedirectBindingSignatureUtil.getTokenValue((String)queryString, (String)"SigAlg");
        StringBuilder sb = new StringBuilder();
        sb.append("SAMLResponse=").append(reqFromURL);
        if (StringUtil.isNotNull((String)relayStateFromURL)) {
            sb.append("&RelayState=").append(relayStateFromURL);
        }
        sb.append("&SigAlg=").append(sigAlgFromURL);
        try {
            if (StringUtil.isNullOrEmpty((String)this.idpAddress)) {
                this.idpAddress = request.getRemoteAddr();
            }
            validatingKey = this.keyManager.getValidatingKey(this.idpAddress);
        }
        catch (TrustKeyConfigurationException e) {
            throw new GeneralSecurityException(e.getCause());
        }
        catch (TrustKeyProcessingException e) {
            throw new GeneralSecurityException(e.getCause());
        }
        boolean isValid = SignatureUtil.validate((byte[])sb.toString().getBytes("UTF-8"), (byte[])sigValue, (PublicKey)validatingKey);
        return isValid;
    }

    protected String getDestinationQueryString(String urlEncodedRequest, String urlEncodedRelayState, boolean sendRequest) {
        try {
            PrivateKey signingKey = this.keyManager.getSigningKey();
            String url = RedirectBindingSignatureUtil.getSAMLRequestURLWithSignature((String)urlEncodedRequest, (String)urlEncodedRelayState, (PrivateKey)signingKey);
            return url;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected void initializeSAMLProcessor(ServiceProviderBaseProcessor processor) {
        super.initializeSAMLProcessor(processor);
        processor.setTrustKeyManager(this.keyManager);
    }

    protected ResponseType decryptAssertion(ResponseType responseType) throws IOException, GeneralSecurityException, ConfigurationException, ParsingException {
        try {
            SAML2Response saml2Response = new SAML2Response();
            PrivateKey privateKey = this.keyManager.getSigningKey();
            EncryptedAssertionType myEET = ((ResponseType.RTChoiceType)responseType.getAssertions().get(0)).getEncryptedAssertion();
            Document eetDoc = saml2Response.convert((EncryptedElementType)myEET);
            Element decryptedDocumentElement = XMLEncryptionUtil.decryptElementInDocument((Document)eetDoc, (PrivateKey)privateKey);
            return saml2Response.getResponseType(DocumentUtil.getNodeAsStream((Node)decryptedDocumentElement));
        }
        catch (Exception e) {
            throw new GeneralSecurityException(e);
        }
    }

    protected void populateChainConfig() throws ConfigurationException, ProcessingException {
        super.populateChainConfig();
        if (this.keyManager != null) {
            if (this.trace) {
                log.trace((Object)"Adding Keypair to the chain config");
            }
            this.chainConfigOptions.put("KEYPAIR", this.keyManager.getSigningKeyPair());
        }
    }
}

