/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.messaging;

import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.hornetq.core.security.Role;
import org.hornetq.core.server.HornetQServer;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.client.helpers.MeasurementUnit;
import org.jboss.as.controller.descriptions.DescriptionProvider;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.messaging.MessagingDescriptions;
import org.jboss.as.messaging.MessagingServices;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;

class SecurityRoleAdd
implements OperationStepHandler,
DescriptionProvider {
    static final SecurityRoleAdd INSTANCE = new SecurityRoleAdd();
    static final AttributeDefinition SEND = new RoleAttributeDefinition("send");
    static final AttributeDefinition CONSUME = new RoleAttributeDefinition("consume");
    static final AttributeDefinition CREATE_DURABLE_QUEUE = new RoleAttributeDefinition("create-durable-queue", "createDurableQueue");
    static final AttributeDefinition DELETE_DURABLE_QUEUE = new RoleAttributeDefinition("delete-durable-queue", "deleteDurableQueue");
    static final AttributeDefinition CREATE_NON_DURABLE_QUEUE = new RoleAttributeDefinition("create-non-durable-queue", "createNonDurableQueue");
    static final AttributeDefinition DELETE_NON_DURABLE_QUEUE = new RoleAttributeDefinition("delete-non-durable-queue", "deleteNonDurableQueue");
    static final AttributeDefinition MANAGE = new RoleAttributeDefinition("manage");
    static final AttributeDefinition[] ROLE_ATTRIBUTES = new AttributeDefinition[]{SEND, CONSUME, CREATE_DURABLE_QUEUE, DELETE_DURABLE_QUEUE, CREATE_NON_DURABLE_QUEUE, DELETE_NON_DURABLE_QUEUE, MANAGE};
    static final Map<String, AttributeDefinition> ROLE_ATTRIBUTES_BY_XML_NAME;

    SecurityRoleAdd() {
    }

    public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
        Resource resource = context.createResource(PathAddress.EMPTY_ADDRESS);
        final ModelNode subModel = resource.getModel();
        for (AttributeDefinition attribute : ROLE_ATTRIBUTES) {
            attribute.validateAndSet(operation, subModel);
        }
        if (context.getType() == OperationContext.Type.SERVER) {
            context.addStep(new OperationStepHandler(){

                public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
                    PathAddress address = PathAddress.pathAddress((ModelNode)operation.require("address"));
                    HornetQServer server = SecurityRoleAdd.getServer(context, operation);
                    if (server != null) {
                        String match = address.getElement(address.size() - 2).getValue();
                        String role = address.getLastElement().getValue();
                        Set roles = (Set)server.getSecurityRepository().getMatch(match);
                        roles.add(SecurityRoleAdd.transform(context, role, subModel));
                        server.getSecurityRepository().addMatch(match, (Object)roles);
                    }
                    context.completeStep();
                }
            }, OperationContext.Stage.RUNTIME);
        }
        context.completeStep();
    }

    public ModelNode getModelDescription(Locale locale) {
        return MessagingDescriptions.getSecurityRoleAdd(locale);
    }

    static ModelNode createAddOperation(ModelNode address, ModelNode subModel) {
        ModelNode operation = new ModelNode();
        operation.get("operation").set("add");
        operation.get("address").set(address);
        for (AttributeDefinition def : ROLE_ATTRIBUTES) {
            if (!subModel.hasDefined(def.getName())) continue;
            operation.get(def.getName()).set(subModel.get(def.getName()));
        }
        return operation;
    }

    static Role transform(OperationContext context, String name, ModelNode node) throws OperationFailedException {
        boolean send = SEND.resolveModelAttribute(context, node).asBoolean();
        boolean consume = CONSUME.resolveModelAttribute(context, node).asBoolean();
        boolean createDurableQueue = CREATE_DURABLE_QUEUE.resolveModelAttribute(context, node).asBoolean();
        boolean deleteDurableQueue = DELETE_DURABLE_QUEUE.resolveModelAttribute(context, node).asBoolean();
        boolean createNonDurableQueue = CREATE_NON_DURABLE_QUEUE.resolveModelAttribute(context, node).asBoolean();
        boolean deleteNonDurableQueue = DELETE_NON_DURABLE_QUEUE.resolveModelAttribute(context, node).asBoolean();
        boolean manage = MANAGE.resolveModelAttribute(context, node).asBoolean();
        return new Role(name, send, consume, createDurableQueue, deleteDurableQueue, createNonDurableQueue, deleteNonDurableQueue, manage);
    }

    static HornetQServer getServer(OperationContext context, ModelNode operation) {
        ServiceName hqServiceName = MessagingServices.getHornetQServiceName(PathAddress.pathAddress((ModelNode)operation.get("address")));
        ServiceController controller = context.getServiceRegistry(true).getService(hqServiceName);
        if (controller != null) {
            return (HornetQServer)HornetQServer.class.cast(controller.getValue());
        }
        return null;
    }

    static {
        HashMap<String, AttributeDefinition> robxn = new HashMap<String, AttributeDefinition>();
        for (AttributeDefinition attr : ROLE_ATTRIBUTES) {
            robxn.put(attr.getXmlName(), attr);
        }
        robxn.put("createTempQueue", CREATE_NON_DURABLE_QUEUE);
        robxn.put("deleteTempQueue", DELETE_NON_DURABLE_QUEUE);
        ROLE_ATTRIBUTES_BY_XML_NAME = Collections.unmodifiableMap(robxn);
    }

    static final class RoleAttributeDefinition
    extends SimpleAttributeDefinition {
        RoleAttributeDefinition(String name) {
            this(name, name);
        }

        RoleAttributeDefinition(String name, String xmlName) {
            super(name, xmlName, new ModelNode().set(false), ModelType.BOOLEAN, false, false, MeasurementUnit.NONE);
        }
    }
}

