/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.jacorb.service;

import java.util.ArrayList;
import org.jboss.as.jacorb.JacORBLogger;
import org.jboss.as.jacorb.JacORBMessages;
import org.jboss.as.jacorb.service.CorbaServiceUtil;
import org.jboss.msc.inject.Injector;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;
import org.omg.CORBA.ORB;
import org.omg.CORBA.Object;
import org.omg.CORBA.Policy;
import org.omg.PortableServer.IdAssignmentPolicyValue;
import org.omg.PortableServer.IdUniquenessPolicyValue;
import org.omg.PortableServer.ImplicitActivationPolicyValue;
import org.omg.PortableServer.LifespanPolicyValue;
import org.omg.PortableServer.POA;
import org.omg.PortableServer.POAHelper;
import org.omg.PortableServer.RequestProcessingPolicyValue;
import org.omg.PortableServer.ServantRetentionPolicyValue;
import org.omg.PortableServer.ThreadPolicyValue;

public class CorbaPOAService
implements Service<POA> {
    public static final ServiceName SERVICE_NAME = ServiceName.JBOSS.append(new String[]{"jacorb", "poa-service"});
    public static final ServiceName ROOT_SERVICE_NAME = SERVICE_NAME.append(new String[]{"rootpoa"});
    public static final ServiceName INTERFACE_REPOSITORY_SERVICE_NAME = SERVICE_NAME.append(new String[]{"irpoa"});
    private volatile POA poa;
    private final InjectedValue<ORB> orbInjector = new InjectedValue();
    private final InjectedValue<POA> parentPOAInjector = new InjectedValue();
    private final String poaName;
    private final String bindingName;
    private final IdAssignmentPolicyValue idAssignmentPolicyValue;
    private final IdUniquenessPolicyValue idUniquenessPolicyValue;
    private final ImplicitActivationPolicyValue implicitActivationPolicyValue;
    private final LifespanPolicyValue lifespanPolicyValue;
    private final RequestProcessingPolicyValue requestProcessingPolicyValue;
    private final ServantRetentionPolicyValue servantRetentionPolicyValue;
    private final ThreadPolicyValue threadPolicyValue;

    public CorbaPOAService(String poaName, String bindingName) {
        this(poaName, bindingName, null, null, null, null, null, null, null);
    }

    public CorbaPOAService(String poaName, String bindingName, IdAssignmentPolicyValue idAssignmentPolicyValue, IdUniquenessPolicyValue idUniquenessPolicyValue, ImplicitActivationPolicyValue implicitActivationPolicyValue, LifespanPolicyValue lifespanPolicyValue, RequestProcessingPolicyValue requestProcessingPolicyValue, ServantRetentionPolicyValue servantRetentionPolicyValue, ThreadPolicyValue threadPolicyValue) {
        this.poaName = poaName;
        this.bindingName = bindingName;
        this.idAssignmentPolicyValue = idAssignmentPolicyValue;
        this.idUniquenessPolicyValue = idUniquenessPolicyValue;
        this.implicitActivationPolicyValue = implicitActivationPolicyValue;
        this.lifespanPolicyValue = lifespanPolicyValue;
        this.requestProcessingPolicyValue = requestProcessingPolicyValue;
        this.servantRetentionPolicyValue = servantRetentionPolicyValue;
        this.threadPolicyValue = threadPolicyValue;
    }

    public void start(StartContext context) throws StartException {
        JacORBLogger.ROOT_LOGGER.debugServiceStartup(context.getController().getName().getCanonicalName());
        ORB orb = (ORB)this.orbInjector.getOptionalValue();
        POA parentPOA = (POA)this.parentPOAInjector.getOptionalValue();
        if (orb != null) {
            try {
                this.poa = POAHelper.narrow((Object)orb.resolve_initial_references(this.poaName));
            }
            catch (Exception e) {
                throw JacORBMessages.MESSAGES.errorResolvingInitRef(this.poaName, e);
            }
        } else if (parentPOA != null) {
            try {
                Policy[] poaPolicies = this.createPolicies(parentPOA);
                this.poa = parentPOA.create_POA(this.poaName, null, poaPolicies);
            }
            catch (Exception e) {
                throw JacORBMessages.MESSAGES.errorCreatingPOAFromParent(e);
            }
        } else {
            throw JacORBMessages.MESSAGES.invalidPOACreationArgs();
        }
        if (this.bindingName != null) {
            CorbaServiceUtil.bindObject(context.getChildTarget(), this.bindingName, this.poa);
        }
        try {
            this.poa.the_POAManager().activate();
        }
        catch (Exception e) {
            throw JacORBMessages.MESSAGES.errorActivatingPOA(e);
        }
    }

    public void stop(StopContext context) {
        JacORBLogger.ROOT_LOGGER.debugServiceStop(context.getController().getName().getCanonicalName());
        this.poa.destroy(false, false);
    }

    public POA getValue() throws IllegalStateException, IllegalArgumentException {
        return this.poa;
    }

    public Injector<ORB> getORBInjector() {
        return this.orbInjector;
    }

    public Injector<POA> getParentPOAInjector() {
        return this.parentPOAInjector;
    }

    private Policy[] createPolicies(POA poa) {
        ArrayList<java.lang.Object> policies = new ArrayList<java.lang.Object>();
        if (this.idAssignmentPolicyValue != null) {
            policies.add(poa.create_id_assignment_policy(this.idAssignmentPolicyValue));
        }
        if (this.idUniquenessPolicyValue != null) {
            policies.add(poa.create_id_uniqueness_policy(this.idUniquenessPolicyValue));
        }
        if (this.implicitActivationPolicyValue != null) {
            policies.add(poa.create_implicit_activation_policy(this.implicitActivationPolicyValue));
        }
        if (this.lifespanPolicyValue != null) {
            policies.add(poa.create_lifespan_policy(this.lifespanPolicyValue));
        }
        if (this.requestProcessingPolicyValue != null) {
            policies.add(poa.create_request_processing_policy(this.requestProcessingPolicyValue));
        }
        if (this.servantRetentionPolicyValue != null) {
            policies.add(poa.create_servant_retention_policy(this.servantRetentionPolicyValue));
        }
        if (this.threadPolicyValue != null) {
            policies.add(poa.create_thread_policy(this.threadPolicyValue));
        }
        return policies.toArray(new Policy[policies.size()]);
    }
}

