/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.connector.pool;

import java.util.List;
import org.jboss.as.connector.ConnectorMessages;
import org.jboss.as.connector.ConnectorServices;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.dmr.ModelNode;
import org.jboss.jca.core.api.management.ManagementRepository;
import org.jboss.jca.core.spi.statistics.StatisticsPlugin;
import org.jboss.msc.service.ServiceController;

public abstract class PoolMetrics
implements OperationStepHandler {
    static final String[] NO_LOCATION = new String[0];

    public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
        if (context.getType() == OperationContext.Type.SERVER) {
            context.addStep(new OperationStepHandler(){

                public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
                    PathAddress address = PathAddress.pathAddress((ModelNode)operation.require("address"));
                    String jndiName = address.getLastElement().getValue();
                    String attributeName = operation.require("name").asString();
                    ServiceController managementRepoService = context.getServiceRegistry(false).getService(ConnectorServices.MANAGEMENT_REPOSISTORY_SERVICE);
                    if (managementRepoService != null) {
                        try {
                            ManagementRepository repository = (ManagementRepository)managementRepoService.getValue();
                            ModelNode result = context.getResult();
                            List<StatisticsPlugin> stats = PoolMetrics.this.getMatchingStats(jndiName, repository);
                            for (StatisticsPlugin stat : stats) {
                                result.set("" + stat.getValue(attributeName));
                            }
                        }
                        catch (Exception e) {
                            throw new OperationFailedException(ConnectorMessages.MESSAGES.failedToGetMetrics(e.getLocalizedMessage()));
                        }
                    }
                    context.completeStep();
                }
            }, OperationContext.Stage.RUNTIME);
        }
        context.completeStep();
    }

    protected abstract List<StatisticsPlugin> getMatchingStats(String var1, ManagementRepository var2);

    public static class ParametrizedPoolMetricsHandler
    implements OperationStepHandler {
        private final StatisticsPlugin stats;

        public ParametrizedPoolMetricsHandler(StatisticsPlugin stats) {
            this.stats = stats;
        }

        public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
            if (context.getType() == OperationContext.Type.SERVER) {
                context.addStep(new OperationStepHandler(){

                    public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
                        PathAddress address = PathAddress.pathAddress((ModelNode)operation.require("address"));
                        String attributeName = operation.require("name").asString();
                        ServiceController managementRepoService = context.getServiceRegistry(false).getService(ConnectorServices.MANAGEMENT_REPOSISTORY_SERVICE);
                        if (managementRepoService != null) {
                            try {
                                ModelNode result = context.getResult();
                                result.set("" + ParametrizedPoolMetricsHandler.this.stats.getValue(attributeName));
                            }
                            catch (Exception e) {
                                throw new OperationFailedException(ConnectorMessages.MESSAGES.failedToGetMetrics(e.getLocalizedMessage()));
                            }
                        }
                        context.completeStep();
                    }
                }, OperationContext.Stage.RUNTIME);
            }
            context.completeStep();
        }
    }
}

