/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.connector.util;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Locale;
import org.jboss.as.connector.ConnectorMessages;
import org.jboss.as.connector.util.SecurityActions;

public class Injection {
    public void inject(String propertyType, String propertyName, String propertyValue, Object object) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        Method[] methods;
        if (propertyName == null || propertyName.trim().equals("")) {
            throw ConnectorMessages.MESSAGES.undefinedVar("PropertyName");
        }
        if (object == null) {
            throw new IllegalArgumentException(ConnectorMessages.MESSAGES.nullVar("object"));
        }
        String methodName = "set" + propertyName.substring(0, 1).toUpperCase(Locale.US);
        if (propertyName.length() > 1) {
            methodName = methodName + propertyName.substring(1);
        }
        if ((propertyType == null || propertyType.trim().equals("")) && (methods = object.getClass().getMethods()) != null) {
            for (int i = 0; propertyType == null && i < methods.length; ++i) {
                Method method = methods[i];
                if (!methodName.equals(method.getName()) || method.getParameterTypes().length != 1) continue;
                propertyType = method.getParameterTypes()[0].getName();
            }
        }
        if (propertyType == null || propertyType.trim().equals("")) {
            throw ConnectorMessages.MESSAGES.undefinedVar("PropertyType");
        }
        Class parameterClass = null;
        Object parameterValue = null;
        String substituredValue = this.getSubstitutionValue(propertyValue);
        if (propertyType.equals("java.lang.String")) {
            parameterClass = String.class;
            parameterValue = substituredValue;
        } else if (propertyType.equals("byte") || propertyType.equals("java.lang.Byte")) {
            parameterClass = Byte.class;
            if (substituredValue != null && !substituredValue.trim().equals("")) {
                parameterValue = Byte.valueOf(substituredValue);
            }
        } else if (propertyType.equals("short") || propertyType.equals("java.lang.Short")) {
            parameterClass = Short.class;
            if (substituredValue != null && !substituredValue.trim().equals("")) {
                parameterValue = Short.valueOf(substituredValue);
            }
        } else if (propertyType.equals("int") || propertyType.equals("java.lang.Integer")) {
            parameterClass = Integer.class;
            if (substituredValue != null && !substituredValue.trim().equals("")) {
                parameterValue = Integer.valueOf(substituredValue);
            }
        } else if (propertyType.equals("long") || propertyType.equals("java.lang.Long")) {
            parameterClass = Long.class;
            if (substituredValue != null && !substituredValue.trim().equals("")) {
                parameterValue = Long.valueOf(substituredValue);
            }
        } else if (propertyType.equals("float") || propertyType.equals("java.lang.Float")) {
            parameterClass = Float.class;
            if (substituredValue != null && !substituredValue.trim().equals("")) {
                parameterValue = Float.valueOf(substituredValue);
            }
        } else if (propertyType.equals("double") || propertyType.equals("java.lang.Double")) {
            parameterClass = Double.class;
            if (substituredValue != null && !substituredValue.trim().equals("")) {
                parameterValue = Double.valueOf(substituredValue);
            }
        } else if (propertyType.equals("boolean") || propertyType.equals("java.lang.Boolean")) {
            parameterClass = Boolean.class;
            if (substituredValue != null && !substituredValue.trim().equals("")) {
                parameterValue = Boolean.valueOf(substituredValue);
            }
        } else if (propertyType.equals("char") || propertyType.equals("java.lang.Character")) {
            parameterClass = Character.class;
            if (substituredValue != null && !substituredValue.trim().equals("")) {
                parameterValue = Character.valueOf(substituredValue.charAt(0));
            }
        } else {
            throw ConnectorMessages.MESSAGES.unknownPropertyType(propertyType, propertyName);
        }
        Method method = null;
        boolean objectInjection = true;
        try {
            method = object.getClass().getMethod(methodName, parameterClass);
        }
        catch (NoSuchMethodException nsme) {
            objectInjection = false;
            if (parameterClass.equals(Byte.class)) {
                parameterClass = Byte.TYPE;
            } else if (parameterClass.equals(Short.class)) {
                parameterClass = Short.TYPE;
            } else if (parameterClass.equals(Integer.class)) {
                parameterClass = Integer.TYPE;
            } else if (parameterClass.equals(Long.class)) {
                parameterClass = Long.TYPE;
            } else if (parameterClass.equals(Float.class)) {
                parameterClass = Float.TYPE;
            } else if (parameterClass.equals(Double.class)) {
                parameterClass = Double.TYPE;
            } else if (parameterClass.equals(Boolean.class)) {
                parameterClass = Boolean.TYPE;
            } else if (parameterClass.equals(Character.class)) {
                parameterClass = Character.TYPE;
            }
            method = object.getClass().getMethod(methodName, parameterClass);
        }
        if (objectInjection || parameterValue != null) {
            method.invoke(object, parameterValue);
        }
    }

    private String getSubstitutionValue(String input) {
        if (input == null || input.trim().equals("")) {
            return input;
        }
        while (input.indexOf("${") != -1) {
            int from = input.indexOf("${");
            int to = input.indexOf("}");
            int dv = input.indexOf(":", from + 2);
            if (dv != -1 && dv > to) {
                dv = -1;
            }
            String systemProperty = "";
            String defaultValue = "";
            if (dv == -1) {
                String s = input.substring(from + 2, to);
                systemProperty = "/".equals(s) ? File.separator : (":".equals(s) ? File.pathSeparator : SecurityActions.getSystemProperty(s));
            } else {
                systemProperty = SecurityActions.getSystemProperty(input.substring(from + 2, dv));
                defaultValue = input.substring(dv + 1, to);
            }
            String prefix = "";
            String postfix = "";
            if (from != 0) {
                prefix = input.substring(0, from);
            }
            if (to + 1 < input.length() - 1) {
                postfix = input.substring(to + 1);
            }
            if (systemProperty != null && !systemProperty.trim().equals("")) {
                input = prefix + systemProperty + postfix;
                continue;
            }
            if (defaultValue == null || defaultValue.trim().equals("")) continue;
            input = prefix + defaultValue + postfix;
        }
        return input;
    }
}

