/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.plugins.providers.jaxb;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import javax.ws.rs.Consumes;
import javax.ws.rs.Produces;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.Provider;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.annotation.XmlRegistry;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.jboss.resteasy.annotations.providers.jaxb.DoNotUseJAXBProvider;
import org.jboss.resteasy.plugins.providers.jaxb.AbstractJAXBContextFinder;
import org.jboss.resteasy.plugins.providers.jaxb.AbstractJAXBProvider;
import org.jboss.resteasy.plugins.providers.jaxb.IgnoredMediaTypes;
import org.jboss.resteasy.plugins.providers.jaxb.JAXBMarshalException;
import org.jboss.resteasy.plugins.providers.jaxb.JAXBUnmarshalException;
import org.jboss.resteasy.util.FindAnnotation;

@Provider
@Produces(value={"application/*+xml", "text/*+xml"})
@Consumes(value={"application/*+xml", "text/*+xml"})
public class JAXBXmlTypeProvider
extends AbstractJAXBProvider<Object> {
    protected static final String OBJECT_FACTORY_NAME = ".ObjectFactory";

    @Override
    public void writeTo(Object t, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, Object> httpHeaders, OutputStream entityStream) throws IOException {
        JAXBElement<?> result = JAXBXmlTypeProvider.wrapInJAXBElement(t, type);
        super.writeTo(result, type, genericType, annotations, mediaType, httpHeaders, entityStream);
    }

    @Override
    public Object readFrom(Class<Object> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, String> httpHeaders, InputStream entityStream) throws IOException {
        try {
            JAXBContext jaxb = this.findJAXBContext(type, annotations, mediaType, true);
            Unmarshaller unmarshaller = jaxb.createUnmarshaller();
            Object obj = unmarshaller.unmarshal(entityStream);
            if (obj instanceof JAXBElement) {
                JAXBElement element = (JAXBElement)obj;
                return element.getValue();
            }
            return obj;
        }
        catch (JAXBException e) {
            throw new JAXBUnmarshalException(e);
        }
    }

    @Override
    protected boolean isReadWritable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return !type.isAnnotationPresent(XmlRootElement.class) && type.isAnnotationPresent(XmlType.class) && FindAnnotation.findAnnotation(type, (Annotation[])annotations, DoNotUseJAXBProvider.class) == null && !IgnoredMediaTypes.ignored(type, annotations, mediaType);
    }

    public static Object findObjectFactory(Class<?> type) {
        try {
            Class<?> factoryClass = AbstractJAXBContextFinder.findDefaultObjectFactoryClass(type);
            if (factoryClass != null && factoryClass.isAnnotationPresent(XmlRegistry.class)) {
                Object factory = factoryClass.newInstance();
                return factory;
            }
            throw new JAXBMarshalException("A valid XmlRegistry could not be located.");
        }
        catch (InstantiationException e) {
            throw new JAXBMarshalException(e);
        }
        catch (IllegalAccessException e) {
            throw new JAXBMarshalException(e);
        }
    }

    public static JAXBElement<?> wrapInJAXBElement(Object t, Class<?> type) {
        try {
            Object factory = JAXBXmlTypeProvider.findObjectFactory(type);
            Method[] method = factory.getClass().getDeclaredMethods();
            for (int i = 0; i < method.length; ++i) {
                Method current = method[i];
                if (current.getParameterTypes().length != 1 || !current.getParameterTypes()[0].equals(type) || !current.getName().startsWith("create")) continue;
                Object result = current.invoke(factory, t);
                return (JAXBElement)JAXBElement.class.cast(result);
            }
            throw new JAXBMarshalException(String.format("The method create%s() was not found in the object Factory!", type));
        }
        catch (IllegalArgumentException e) {
            throw new JAXBMarshalException(e);
        }
        catch (IllegalAccessException e) {
            throw new JAXBMarshalException(e);
        }
        catch (InvocationTargetException e) {
            throw new JAXBMarshalException(e.getCause());
        }
    }
}

