/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentMap;
import org.jgroups.Address;
import org.jgroups.Channel;
import org.jgroups.Event;
import org.jgroups.MergeView;
import org.jgroups.Message;
import org.jgroups.PhysicalAddress;
import org.jgroups.StateTransferException;
import org.jgroups.Version;
import org.jgroups.View;
import org.jgroups.annotations.MBean;
import org.jgroups.annotations.ManagedAttribute;
import org.jgroups.annotations.ManagedOperation;
import org.jgroups.blocks.MethodCall;
import org.jgroups.conf.ConfiguratorFactory;
import org.jgroups.conf.ProtocolConfiguration;
import org.jgroups.conf.ProtocolStackConfigurator;
import org.jgroups.logging.Log;
import org.jgroups.logging.LogFactory;
import org.jgroups.protocols.TP;
import org.jgroups.stack.AddressGenerator;
import org.jgroups.stack.DiagnosticsHandler;
import org.jgroups.stack.Protocol;
import org.jgroups.stack.ProtocolStack;
import org.jgroups.stack.StateTransferInfo;
import org.jgroups.util.Promise;
import org.jgroups.util.StateTransferResult;
import org.jgroups.util.TimeScheduler;
import org.jgroups.util.UUID;
import org.jgroups.util.Util;
import org.w3c.dom.Element;

@MBean(description="JGroups channel")
public class JChannel
extends Channel {
    public static final String DEFAULT_PROTOCOL_STACK = "udp.xml";
    protected Address local_addr = null;
    protected AddressGenerator address_generator = null;
    protected String name = null;
    private String cluster_name = null;
    private View my_view = null;
    private ProtocolStack prot_stack = null;
    private final Promise<StateTransferResult> state_promise = new Promise();
    protected volatile boolean connected = false;
    protected volatile boolean closed = false;
    private boolean state_transfer_supported = false;
    private volatile boolean flush_supported = false;
    protected final ConcurrentMap<String, Object> config = Util.createConcurrentMap(16);
    protected final Log log = LogFactory.getLog(JChannel.class);
    @ManagedAttribute(description="Collect channel statistics", writable=true)
    protected boolean stats = true;
    protected long sent_msgs = 0L;
    protected long received_msgs = 0L;
    protected long sent_bytes = 0L;
    protected long received_bytes = 0L;
    private final DiagnosticsHandler.ProbeHandler probe_handler = new MyProbeHandler();

    public JChannel(boolean create_protocol_stack) {
        if (create_protocol_stack) {
            try {
                this.init(ConfiguratorFactory.getStackConfigurator(DEFAULT_PROTOCOL_STACK));
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    public JChannel() throws Exception {
        this(DEFAULT_PROTOCOL_STACK);
    }

    public JChannel(File properties) throws Exception {
        this(ConfiguratorFactory.getStackConfigurator(properties));
    }

    public JChannel(Element properties) throws Exception {
        this(ConfiguratorFactory.getStackConfigurator(properties));
    }

    public JChannel(URL properties) throws Exception {
        this(ConfiguratorFactory.getStackConfigurator(properties));
    }

    public JChannel(String props) throws Exception {
        this(ConfiguratorFactory.getStackConfigurator(props));
    }

    public JChannel(InputStream input) throws Exception {
        this(ConfiguratorFactory.getStackConfigurator(input));
    }

    public JChannel(ProtocolStackConfigurator configurator) throws Exception {
        this.init(configurator);
    }

    public JChannel(JChannel ch) throws Exception {
        this.init(ch);
        this.discard_own_messages = ch.discard_own_messages;
    }

    @Override
    public ProtocolStack getProtocolStack() {
        return this.prot_stack;
    }

    public void setProtocolStack(ProtocolStack stack) {
        this.prot_stack = stack;
        if (this.prot_stack != null) {
            this.prot_stack.setChannel(this);
        }
    }

    @Override
    protected Log getLog() {
        return this.log;
    }

    @Override
    public String getProperties() {
        return this.prot_stack != null ? this.prot_stack.printProtocolSpec(true) : null;
    }

    public boolean statsEnabled() {
        return this.stats;
    }

    public void enableStats(boolean stats) {
        this.stats = stats;
    }

    @ManagedOperation
    public void resetStats() {
        this.received_bytes = 0L;
        this.sent_bytes = 0L;
        this.received_msgs = 0L;
        this.sent_msgs = 0L;
    }

    @ManagedAttribute
    public long getSentMessages() {
        return this.sent_msgs;
    }

    @ManagedAttribute
    public long getSentBytes() {
        return this.sent_bytes;
    }

    @ManagedAttribute
    public long getReceivedMessages() {
        return this.received_msgs;
    }

    @ManagedAttribute
    public long getReceivedBytes() {
        return this.received_bytes;
    }

    @ManagedAttribute
    public int getNumberOfTasksInTimer() {
        TimeScheduler timer = this.getTimer();
        return timer != null ? timer.size() : -1;
    }

    @ManagedAttribute
    public int getTimerThreads() {
        TimeScheduler timer = this.getTimer();
        return timer != null ? timer.getMinThreads() : -1;
    }

    @ManagedOperation
    public String dumpTimerQueue() {
        TimeScheduler timer = this.getTimer();
        return timer != null ? timer.dumpTimerTasks() : "<n/a";
    }

    @ManagedOperation
    public String printProtocolSpec(boolean include_properties) {
        ProtocolStack ps = this.getProtocolStack();
        return ps != null ? ps.printProtocolSpec(include_properties) : null;
    }

    @Override
    @ManagedOperation(description="Connects the channel to a group")
    public synchronized void connect(String cluster_name) throws Exception {
        this.connect(cluster_name, true);
    }

    @ManagedOperation(description="Connects the channel to a group")
    protected synchronized void connect(String cluster_name, boolean useFlushIfPresent) throws Exception {
        Event connect_event;
        Object res;
        if (this.connected) {
            if (this.log.isTraceEnabled()) {
                this.log.trace("already connected to " + cluster_name);
            }
            return;
        }
        this.setAddress();
        this.startStack(cluster_name);
        if (cluster_name != null && (res = this.down(connect_event = useFlushIfPresent ? new Event(92, cluster_name) : new Event(2, cluster_name))) != null && res instanceof Exception) {
            this.stopStack(true, false);
            this.init();
            throw new Exception("connect() failed", (Throwable)res);
        }
        this.connected = true;
        this.notifyChannelConnected(this);
    }

    @Override
    public synchronized void connect(String cluster_name, Address target, long timeout) throws Exception {
        this.connect(cluster_name, target, timeout, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void connect(String cluster_name, Address target, long timeout, boolean useFlushIfPresent) throws Exception {
        if (this.connected) {
            if (this.log.isTraceEnabled()) {
                this.log.trace("already connected to " + this.cluster_name);
            }
            return;
        }
        this.setAddress();
        this.startStack(cluster_name);
        boolean canFetchState = false;
        if (cluster_name == null) {
            return;
        }
        try {
            Event connect_event = useFlushIfPresent ? new Event(93, cluster_name) : new Event(80, cluster_name);
            Object res = this.down(connect_event);
            if (res instanceof Exception) {
                this.stopStack(true, false);
                this.init();
                throw new Exception("connect() failed", (Throwable)res);
            }
            this.connected = true;
            this.notifyChannelConnected(this);
            boolean bl = canFetchState = this.getView() != null && this.getView().size() > 1;
            if (canFetchState) {
                this.getState(target, timeout, false);
            }
        }
        finally {
            if (this.flushSupported() && useFlushIfPresent && (canFetchState || !this.connected)) {
                this.stopFlush();
            }
        }
    }

    @Override
    @ManagedOperation(description="Disconnects the channel if connected")
    public synchronized void disconnect() {
        if (this.closed) {
            return;
        }
        if (this.connected) {
            if (this.cluster_name != null) {
                Event disconnect_event = new Event(4, this.local_addr);
                this.down(disconnect_event);
            }
            this.connected = false;
            this.stopStack(true, false);
            this.notifyChannelDisconnected(this);
            this.init();
        }
    }

    @Override
    @ManagedOperation(description="Disconnects and destroys the channel")
    public synchronized void close() {
        this._close(true);
    }

    @Override
    @ManagedAttribute
    public boolean isOpen() {
        return !this.closed;
    }

    @Override
    @ManagedAttribute
    public boolean isConnected() {
        return this.connected;
    }

    @Override
    @ManagedOperation
    public Map<String, Object> dumpStats() {
        Map<String, Long> tmp;
        Map<String, Object> retval = this.prot_stack.dumpStats();
        if (retval != null && (tmp = this.dumpChannelStats()) != null) {
            retval.put("channel", tmp);
        }
        return retval;
    }

    public Map<String, Object> dumpStats(String protocol_name, List<String> attrs) {
        return this.prot_stack.dumpStats(protocol_name, attrs);
    }

    @ManagedOperation
    public Map<String, Object> dumpStats(String protocol_name) {
        return this.prot_stack.dumpStats(protocol_name, null);
    }

    protected Map<String, Long> dumpChannelStats() {
        HashMap<String, Long> retval = new HashMap<String, Long>();
        retval.put("sent_msgs", this.sent_msgs);
        retval.put("sent_bytes", this.sent_bytes);
        retval.put("received_msgs", this.received_msgs);
        retval.put("received_bytes", this.received_bytes);
        return retval;
    }

    @Override
    @ManagedOperation
    public void send(Message msg) throws Exception {
        this.checkClosedOrNotConnected();
        if (msg == null) {
            throw new NullPointerException("msg is null");
        }
        if (this.stats) {
            ++this.sent_msgs;
            this.sent_bytes += (long)msg.getLength();
        }
        this.down(new Event(1, msg));
    }

    @Override
    @ManagedOperation
    public void send(Address dst, Object obj) throws Exception {
        this.send(new Message(dst, null, obj));
    }

    @Override
    public void send(Address dst, byte[] buf) throws Exception {
        this.send(new Message(dst, null, buf));
    }

    @Override
    public void send(Address dst, byte[] buf, int offset, int length) throws Exception {
        this.send(new Message(dst, null, buf, offset, length));
    }

    @Override
    public View getView() {
        return this.closed || !this.connected ? null : this.my_view;
    }

    @ManagedAttribute(name="View")
    public String getViewAsString() {
        View v = this.getView();
        return v != null ? v.toString() : "n/a";
    }

    @ManagedAttribute
    public static String getVersion() {
        return Version.printDescription();
    }

    @Override
    public Address getAddress() {
        return this.closed ? null : this.local_addr;
    }

    @ManagedAttribute(name="Address")
    public String getAddressAsString() {
        return this.local_addr != null ? this.local_addr.toString() : "n/a";
    }

    @ManagedAttribute(name="Address (UUID)")
    public String getAddressAsUUID() {
        return this.local_addr instanceof UUID ? ((UUID)this.local_addr).toStringLong() : null;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getName(Address member) {
        return member != null ? UUID.get(member) : null;
    }

    @Override
    @ManagedAttribute(writable=true, description="The logical name of this channel. Stays with the channel until the channel is closed")
    public void setName(String name) {
        if (name != null) {
            if (this.isConnected()) {
                throw new IllegalStateException("name cannot be set if channel is connected (should be done before)");
            }
            this.name = name;
            if (this.local_addr != null) {
                UUID.add(this.local_addr, this.name);
            }
        }
    }

    @Override
    @ManagedAttribute(description="Returns cluster name this channel is connected to")
    public String getClusterName() {
        return this.closed ? null : (!this.connected ? null : this.cluster_name);
    }

    public AddressGenerator getAddressGenerator() {
        return this.address_generator;
    }

    public void setAddressGenerator(AddressGenerator address_generator) {
        this.address_generator = address_generator;
    }

    @Override
    public void getState(Address target, long timeout) throws Exception {
        this.getState(target, timeout, true);
    }

    public void getState(Address target, long timeout, boolean useFlushIfPresent) throws Exception {
        Callable<Boolean> flusher = new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                return Util.startFlush(JChannel.this);
            }
        };
        this.getState(target, timeout, useFlushIfPresent ? flusher : null);
    }

    protected void getState(Address target, long timeout, Callable<Boolean> flushInvoker) throws Exception {
        boolean initiateFlush;
        this.checkClosedOrNotConnected();
        if (!this.state_transfer_supported) {
            throw new IllegalStateException("fetching state will fail as state transfer is not supported. Add one of the state transfer protocols to your configuration");
        }
        if (target == null) {
            target = this.determineCoordinator();
        }
        if (target != null && this.local_addr != null && target.equals(this.local_addr)) {
            if (this.log.isTraceEnabled()) {
                this.log.trace("cannot get state from myself (" + target + "): probably the first member");
            }
            return;
        }
        boolean bl = initiateFlush = this.flushSupported() && flushInvoker != null;
        if (initiateFlush) {
            boolean successfulFlush = false;
            try {
                successfulFlush = flushInvoker.call();
            }
            catch (Throwable e) {
                successfulFlush = false;
            }
            if (!successfulFlush) {
                throw new IllegalStateException("Node " + this.local_addr + " could not flush the cluster for state retrieval");
            }
        }
        this.state_promise.reset();
        StateTransferInfo state_info = new StateTransferInfo(target, timeout);
        this.down(new Event(19, state_info));
        StateTransferResult result = this.state_promise.getResult(state_info.timeout);
        if (initiateFlush) {
            this.stopFlush();
        }
        if (result != null && result.hasException()) {
            throw new StateTransferException("state transfer failed", result.getException());
        }
    }

    public Object up(Event evt) {
        switch (evt.getType()) {
            case 1: {
                Message msg = (Message)evt.getArg();
                if (this.stats) {
                    ++this.received_msgs;
                    this.received_bytes += (long)msg.getLength();
                }
                if (!this.discard_own_messages || this.local_addr == null || msg.getSrc() == null || !this.local_addr.equals(msg.getSrc())) break;
                return null;
            }
            case 6: {
                View tmp = (View)evt.getArg();
                this.my_view = tmp instanceof MergeView ? new View(tmp.getVid(), tmp.getMembers()) : tmp;
                if (this.connected) break;
                this.connected = true;
                break;
            }
            case 56: {
                Map cfg = (Map)evt.getArg();
                if (cfg == null) break;
                if (cfg.containsKey("state_transfer")) {
                    this.state_transfer_supported = (Boolean)cfg.get("state_transfer");
                }
                if (cfg.containsKey("flush_supported")) {
                    this.flush_supported = (Boolean)cfg.get("flush_supported");
                }
                cfg.putAll(cfg);
                break;
            }
            case 20: {
                StateTransferResult result = (StateTransferResult)evt.getArg();
                if (this.up_handler != null) {
                    try {
                        Object retval = this.up_handler.up(evt);
                        this.state_promise.setResult(new StateTransferResult());
                        return retval;
                    }
                    catch (Throwable t) {
                        this.state_promise.setResult(new StateTransferResult(t));
                    }
                }
                byte[] state = result.getBuffer();
                if (this.receiver == null) break;
                try {
                    ByteArrayInputStream input = new ByteArrayInputStream(state);
                    this.receiver.setState(input);
                    this.state_promise.setResult(new StateTransferResult());
                }
                catch (Throwable t) {
                    this.state_promise.setResult(new StateTransferResult(t));
                }
                break;
            }
            case 73: {
                this.state_promise.setResult((StateTransferResult)evt.getArg());
                break;
            }
            case 71: {
                if (this.up_handler != null) {
                    return this.up_handler.up(evt);
                }
                InputStream is = (InputStream)evt.getArg();
                if (is == null || this.receiver == null) break;
                try {
                    this.receiver.setState(is);
                    break;
                }
                catch (Throwable t) {
                    throw new RuntimeException("failed calling setState() in state requester", t);
                }
            }
            case 72: {
                if (this.receiver == null || evt.getArg() == null) break;
                try {
                    this.receiver.getState((OutputStream)evt.getArg());
                    break;
                }
                catch (Exception e) {
                    throw new RuntimeException("failed calling getState() in state provider", e);
                }
            }
            case 91: {
                return this.local_addr;
            }
        }
        if (this.up_handler != null) {
            return this.up_handler.up(evt);
        }
        if (this.receiver != null) {
            return this.invokeCallback(evt.getType(), evt.getArg());
        }
        return null;
    }

    @Override
    public Object down(Event evt) {
        if (evt == null) {
            return null;
        }
        return this.prot_stack.down(evt);
    }

    @ManagedOperation
    public String toString(boolean details) {
        StringBuilder sb = new StringBuilder();
        sb.append("local_addr=").append(this.local_addr).append('\n');
        sb.append("cluster_name=").append(this.cluster_name).append('\n');
        sb.append("my_view=").append(this.my_view).append('\n');
        sb.append("connected=").append(this.connected).append('\n');
        sb.append("closed=").append(this.closed).append('\n');
        if (details) {
            sb.append("discard_own_messages=").append(this.discard_own_messages).append('\n');
            sb.append("state_transfer_supported=").append(this.state_transfer_supported).append('\n');
            sb.append("props=").append(this.getProperties()).append('\n');
        }
        return sb.toString();
    }

    protected Object invokeCallback(int type, Object arg) {
        switch (type) {
            case 1: {
                this.receiver.receive((Message)arg);
                break;
            }
            case 6: {
                this.receiver.viewAccepted((View)arg);
                break;
            }
            case 9: {
                this.receiver.suspect((Address)arg);
                break;
            }
            case 17: {
                byte[] tmp_state = null;
                if (this.receiver != null) {
                    ByteArrayOutputStream output = new ByteArrayOutputStream(1024);
                    try {
                        this.receiver.getState(output);
                        tmp_state = output.toByteArray();
                    }
                    catch (Exception e) {
                        throw new RuntimeException(this.local_addr + ": failed getting state from application", e);
                    }
                }
                return new StateTransferInfo(null, 0L, tmp_state);
            }
            case 10: {
                this.receiver.block();
                return true;
            }
            case 75: {
                this.receiver.unblock();
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void init(ProtocolStackConfigurator configurator) throws Exception {
        List<ProtocolConfiguration> configs = configurator.getProtocolStack();
        for (ProtocolConfiguration config : configs) {
            config.substituteVariables();
        }
        Class<Channel> clazz = Channel.class;
        synchronized (Channel.class) {
            this.prot_stack = new ProtocolStack(this);
            this.prot_stack.setup(configs);
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void init(JChannel ch) throws Exception {
        if (ch == null) {
            throw new IllegalArgumentException("channel is null");
        }
        Class<JChannel> clazz = JChannel.class;
        synchronized (JChannel.class) {
            this.prot_stack = new ProtocolStack(this);
            this.prot_stack.setup(ch.getProtocolStack());
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    private void init() {
        if (this.local_addr != null) {
            this.down(new Event(90, this.local_addr));
        }
        this.local_addr = null;
        this.cluster_name = null;
        this.my_view = null;
        this.connected = false;
    }

    private void startStack(String cluster_name) throws Exception {
        this.checkClosed();
        if (cluster_name == null) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("cluster_name is null, assuming unicast channel");
            }
        } else {
            this.cluster_name = cluster_name;
        }
        if (this.socket_factory != null) {
            this.prot_stack.getTopProtocol().setSocketFactory(this.socket_factory);
        }
        this.prot_stack.startStack(cluster_name, this.local_addr);
        ArrayList<Address> t = new ArrayList<Address>(1);
        t.add(this.local_addr);
        this.my_view = new View(this.local_addr, 0L, t);
        TP transport = this.prot_stack.getTransport();
        transport.registerProbeHandler(this.probe_handler);
    }

    protected void setAddress() {
        Address old_addr = this.local_addr;
        Address address = this.local_addr = this.address_generator != null ? this.address_generator.generateAddress() : UUID.randomUUID();
        if (old_addr != null) {
            this.down(new Event(90, old_addr));
        }
        if (this.name == null || this.name.length() == 0) {
            this.name = Util.generateLocalName();
        }
        if (this.name != null && this.name.length() > 0) {
            UUID.add(this.local_addr, this.name);
        }
        Event evt = new Event(8, this.local_addr);
        this.down(evt);
        if (this.up_handler != null) {
            this.up_handler.up(evt);
        }
    }

    protected void checkClosed() {
        if (this.closed) {
            throw new IllegalStateException("channel is closed");
        }
    }

    protected void checkClosedOrNotConnected() {
        if (this.closed) {
            throw new IllegalStateException("channel is closed");
        }
        if (!this.connected) {
            throw new IllegalStateException("channel is disconnected");
        }
    }

    protected void _close(boolean disconnect) {
        Address old_addr = this.local_addr;
        if (this.closed) {
            return;
        }
        if (disconnect) {
            this.disconnect();
        }
        this.stopStack(true, true);
        this.closed = true;
        this.connected = false;
        this.notifyChannelClosed(this);
        this.init();
        if (old_addr != null) {
            UUID.remove(old_addr);
        }
    }

    protected void stopStack(boolean stop, boolean destroy) {
        if (this.prot_stack != null) {
            block6: {
                try {
                    if (stop) {
                        this.prot_stack.stopStack(this.cluster_name);
                    }
                    if (destroy) {
                        this.prot_stack.destroy();
                    }
                }
                catch (Exception e) {
                    if (!this.log.isErrorEnabled()) break block6;
                    this.log.error("failed destroying the protocol stack", e);
                }
            }
            TP transport = this.prot_stack.getTransport();
            if (transport != null) {
                transport.unregisterProbeHandler(this.probe_handler);
            }
        }
    }

    @Override
    public boolean flushSupported() {
        return this.flush_supported;
    }

    @Override
    public void startFlush(boolean automatic_resume) throws Exception {
        if (!this.flushSupported()) {
            throw new IllegalStateException("Flush is not supported, add pbcast.FLUSH protocol to your configuration");
        }
        try {
            this.down(new Event(68));
        }
        catch (Exception e) {
            throw new Exception("Flush failed", e.getCause());
        }
        finally {
            if (automatic_resume) {
                this.stopFlush();
            }
        }
    }

    @Override
    public void startFlush(List<Address> flushParticipants, boolean automatic_resume) throws Exception {
        boolean validParticipants;
        if (!this.flushSupported()) {
            throw new IllegalStateException("Flush is not supported, add pbcast.FLUSH protocol to your configuration");
        }
        View v = this.getView();
        boolean bl = validParticipants = v != null && v.getMembers().containsAll(flushParticipants);
        if (!validParticipants) {
            throw new IllegalArgumentException("Current view " + v + " does not contain all flush participants " + flushParticipants);
        }
        try {
            this.down(new Event(68, flushParticipants));
        }
        catch (Exception e) {
            throw new Exception("Flush failed", e.getCause());
        }
        finally {
            if (automatic_resume) {
                this.stopFlush(flushParticipants);
            }
        }
    }

    @Override
    public void stopFlush() {
        if (!this.flushSupported()) {
            throw new IllegalStateException("Flush is not supported, add pbcast.FLUSH protocol to your configuration");
        }
        this.down(new Event(70));
    }

    @Override
    public void stopFlush(List<Address> flushParticipants) {
        if (!this.flushSupported()) {
            throw new IllegalStateException("Flush is not supported, add pbcast.FLUSH protocol to your configuration");
        }
        this.down(new Event(70, flushParticipants));
    }

    Address determineCoordinator() {
        List<Address> mbrs;
        List<Address> list = mbrs = this.my_view != null ? this.my_view.getMembers() : null;
        if (mbrs == null) {
            return null;
        }
        if (!mbrs.isEmpty()) {
            return mbrs.iterator().next();
        }
        return null;
    }

    private TimeScheduler getTimer() {
        TP transport;
        if (this.prot_stack != null && (transport = this.prot_stack.getTransport()) != null) {
            return transport.getTimer();
        }
        return null;
    }

    class MyProbeHandler
    implements DiagnosticsHandler.ProbeHandler {
        MyProbeHandler() {
        }

        @Override
        public Map<String, String> handleProbe(String ... keys) {
            HashMap<String, String> map = new HashMap<String, String>(2);
            for (String key : keys) {
                int index;
                if (key.startsWith("jmx")) {
                    Map<String, Object> tmp_stats;
                    int index2 = key.indexOf("=");
                    if (index2 > -1) {
                        List<String> list = null;
                        String protocol_name = key.substring(index2 + 1);
                        if ((index2 = protocol_name.indexOf(".")) > -1) {
                            String rest = protocol_name;
                            protocol_name = protocol_name.substring(0, index2);
                            String attrs = rest.substring(index2 + 1);
                            list = Util.parseStringList(attrs, ",");
                        }
                        tmp_stats = JChannel.this.dumpStats(protocol_name, list);
                    } else {
                        tmp_stats = JChannel.this.dumpStats();
                    }
                    map.put("jmx", tmp_stats != null ? Util.mapToString(tmp_stats) : "null");
                    continue;
                }
                if (!key.startsWith("invoke") && !key.startsWith("op") || (index = key.indexOf("=")) == -1) continue;
                try {
                    this.handleOperation(map, key.substring(index + 1));
                }
                catch (Throwable throwable) {
                    JChannel.this.log.error("failed invoking operation " + key.substring(index + 1), throwable);
                }
            }
            map.put("version", "3.0.4.Final");
            if (JChannel.this.my_view != null && !map.containsKey("view")) {
                map.put("view", JChannel.this.my_view.toString());
            }
            map.put("local_addr", JChannel.this.getAddressAsString() + " [" + JChannel.this.getAddressAsUUID() + "]");
            PhysicalAddress physical_addr = (PhysicalAddress)JChannel.this.down(new Event(87, JChannel.this.local_addr));
            if (physical_addr != null) {
                map.put("physical_addr", physical_addr.toString());
            }
            map.put("cluster", JChannel.this.getClusterName());
            return map;
        }

        @Override
        public String[] supportedKeys() {
            return new String[]{"jmx", "invoke=<operation>[<args>]", "\nop=<operation>[<args>]"};
        }

        private void handleOperation(Map<String, String> map, String operation) throws Exception {
            Object retval;
            int index = operation.indexOf(".");
            if (index == -1) {
                throw new IllegalArgumentException("operation " + operation + " is missing the protocol name");
            }
            String prot_name = operation.substring(0, index);
            Protocol prot = JChannel.this.prot_stack.findProtocol(prot_name);
            if (prot == null) {
                throw new IllegalArgumentException("protocol " + prot_name + " not found");
            }
            int args_index = operation.indexOf("[");
            String method_name = args_index != -1 ? operation.substring(index + 1, args_index).trim() : operation.substring(index + 1).trim();
            String[] args = null;
            if (args_index != -1) {
                int end_index = operation.indexOf("]");
                if (end_index == -1) {
                    throw new IllegalArgumentException("] not found");
                }
                List<String> str_args = Util.parseCommaDelimitedStrings(operation.substring(args_index + 1, end_index));
                Object[] strings = str_args.toArray();
                args = new String[strings.length];
                for (int i = 0; i < strings.length; ++i) {
                    args[i] = (String)strings[i];
                }
            }
            Method method = MethodCall.findMethod(prot.getClass(), method_name, args);
            MethodCall call = new MethodCall(method);
            Object[] converted_args = null;
            if (args != null) {
                converted_args = new Object[args.length];
                Class<?>[] types = method.getParameterTypes();
                for (int i = 0; i < args.length; ++i) {
                    converted_args[i] = MethodCall.convert(args[i], types[i]);
                }
            }
            if ((retval = call.invoke(prot, converted_args)) != null) {
                map.put(prot_name + "." + method_name, retval.toString());
            }
        }
    }
}

