/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.infinispan.subsystem;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.EnumMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.transaction.TransactionManager;
import javax.transaction.TransactionSynchronizationRegistry;
import org.infinispan.Cache;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.cache.LoaderConfigurationBuilder;
import org.infinispan.configuration.parsing.ConfigurationBuilderHolder;
import org.infinispan.configuration.parsing.Parser;
import org.infinispan.eviction.EvictionStrategy;
import org.infinispan.loaders.CacheLoader;
import org.infinispan.loaders.CacheStore;
import org.infinispan.loaders.file.FileCacheStore;
import org.infinispan.loaders.jdbc.binary.JdbcBinaryCacheStore;
import org.infinispan.loaders.jdbc.connectionfactory.ManagedConnectionFactory;
import org.infinispan.loaders.jdbc.mixed.JdbcMixedCacheStore;
import org.infinispan.loaders.jdbc.stringbased.JdbcStringBasedCacheStore;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.transaction.LockingMode;
import org.infinispan.transaction.tm.BatchModeTransactionManager;
import org.infinispan.util.TypedProperties;
import org.infinispan.util.concurrent.IsolationLevel;
import org.jboss.as.clustering.infinispan.InfinispanMessages;
import org.jboss.as.clustering.infinispan.RemoteCacheStore;
import org.jboss.as.clustering.infinispan.subsystem.CacheConfigurationService;
import org.jboss.as.clustering.infinispan.subsystem.CacheService;
import org.jboss.as.clustering.infinispan.subsystem.EmbeddedCacheManagerService;
import org.jboss.as.clustering.infinispan.subsystem.Indexing;
import org.jboss.as.clustering.infinispan.subsystem.InfinispanJndiName;
import org.jboss.as.clustering.infinispan.subsystem.StartMode;
import org.jboss.as.clustering.infinispan.subsystem.TransactionMode;
import org.jboss.as.controller.AbstractAddStepHandler;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.ServiceVerificationHandler;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.naming.ManagedReferenceInjector;
import org.jboss.as.naming.ServiceBasedNamingStore;
import org.jboss.as.naming.deployment.ContextNames;
import org.jboss.as.naming.service.BinderService;
import org.jboss.as.network.OutboundSocketBinding;
import org.jboss.as.server.services.path.AbstractPathService;
import org.jboss.as.txn.service.TxnServices;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.Property;
import org.jboss.logging.Logger;
import org.jboss.msc.inject.Injector;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceListener;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.value.InjectedValue;
import org.jboss.msc.value.Value;
import org.jboss.tm.XAResourceRecoveryRegistry;

public abstract class CacheAdd
extends AbstractAddStepHandler {
    private static final Logger log = Logger.getLogger((String)CacheAdd.class.getPackage().getName());
    private static final String DEFAULTS = "infinispan-defaults.xml";
    private static volatile Map<CacheMode, Configuration> defaults = null;
    final CacheMode mode;

    public static synchronized Configuration getDefaultConfiguration(CacheMode cacheMode) {
        if (defaults == null) {
            ConfigurationBuilderHolder holder = CacheAdd.load(DEFAULTS);
            Configuration defaultConfig = holder.getDefaultConfigurationBuilder().build();
            EnumMap<CacheMode, Configuration> map = new EnumMap<CacheMode, Configuration>(CacheMode.class);
            map.put(defaultConfig.clustering().cacheMode(), defaultConfig);
            for (ConfigurationBuilder builder : holder.getNamedConfigurationBuilders().values()) {
                Configuration config = builder.build();
                map.put(config.clustering().cacheMode(), config);
            }
            for (CacheMode mode : CacheMode.values()) {
                if (map.containsKey(mode)) continue;
                map.put(mode, new ConfigurationBuilder().read(defaultConfig).clustering().cacheMode(mode).build());
            }
            defaults = map;
        }
        return defaults.get(cacheMode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ConfigurationBuilderHolder load(String resource) {
        ConfigurationBuilderHolder configurationBuilderHolder;
        URL url = CacheAdd.find(resource, CacheAdd.class.getClassLoader());
        log.debugf("Loading Infinispan defaults from %s", (Object)url.toString());
        InputStream input = url.openStream();
        Parser parser = new Parser(Parser.class.getClassLoader());
        try {
            configurationBuilderHolder = parser.parse(input);
        }
        catch (Throwable throwable) {
            try {
                try {
                    input.close();
                }
                catch (IOException e) {
                    log.warn((Object)e.getMessage(), (Throwable)e);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new IllegalStateException(String.format("Failed to parse %s", url), e);
            }
        }
        try {
            input.close();
        }
        catch (IOException e) {
            log.warn((Object)e.getMessage(), (Throwable)e);
        }
        return configurationBuilderHolder;
    }

    private static URL find(String resource, ClassLoader ... loaders) {
        for (ClassLoader loader : loaders) {
            URL url;
            if (loader == null || (url = loader.getResource(resource)) == null) continue;
            return url;
        }
        throw new IllegalArgumentException(String.format("Failed to locate %s", resource));
    }

    CacheAdd(CacheMode mode) {
        this.mode = mode;
    }

    protected void populateModel(ModelNode operation, ModelNode model) throws OperationFailedException {
        PathAddress cacheAddress = PathAddress.pathAddress((ModelNode)operation.get("address"));
        String cacheName = cacheAddress.getLastElement().getValue();
        model.get("name").set(cacheName);
        this.populateCacheMode(operation, model);
        this.populate(operation, model);
    }

    protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model, ServiceVerificationHandler verificationHandler, List<ServiceController<?>> newControllers) throws OperationFailedException {
        model = Resource.Tools.readModel((Resource)context.readResource(PathAddress.EMPTY_ADDRESS));
        ConfigurationBuilder builder = new ConfigurationBuilder().read(CacheAdd.getDefaultConfiguration(this.mode));
        LinkedList dependencies = new LinkedList();
        PathAddress cacheAddress = PathAddress.pathAddress((ModelNode)operation.get("address"));
        PathAddress containerAddress = cacheAddress.subAddress(0, cacheAddress.size() - 1);
        String cacheName = cacheAddress.getLastElement().getValue();
        String containerName = containerAddress.getLastElement().getValue();
        this.processModelNode(containerName, model, builder, dependencies);
        ServiceName containerServiceName = EmbeddedCacheManagerService.getServiceName(containerName);
        ServiceName cacheServiceName = containerServiceName.append(new String[]{cacheName});
        ServiceName cacheConfigurationServiceName = CacheConfigurationService.getServiceName(containerName, cacheName);
        Resource rootResource = context.getRootResource();
        ModelNode container = rootResource.navigate(containerAddress).getModel();
        String defaultCache = container.get("default-cache").asString();
        ServiceController.Mode initialMode = model.hasDefined("start") ? StartMode.valueOf(model.get("start").asString()).getMode() : ServiceController.Mode.ON_DEMAND;
        ServiceTarget target = context.getServiceTarget();
        InjectedValue containerInjection = new InjectedValue();
        CacheConfigurationDependencies cacheConfigurationDependencies = new CacheConfigurationDependencies((Value<EmbeddedCacheManager>)containerInjection);
        CacheConfigurationService cacheConfigurationService = new CacheConfigurationService(cacheName, builder, cacheConfigurationDependencies);
        ServiceBuilder configBuilder = target.addService(cacheConfigurationServiceName, (Service)cacheConfigurationService).addDependency(containerServiceName, EmbeddedCacheManager.class, (Injector)containerInjection).setInitialMode(ServiceController.Mode.PASSIVE);
        Configuration config = builder.build();
        if (config.invocationBatching().enabled()) {
            cacheConfigurationDependencies.getTransactionManagerInjector().inject((Object)BatchModeTransactionManager.getInstance());
        } else if (config.transaction().transactionMode() == org.infinispan.transaction.TransactionMode.TRANSACTIONAL) {
            configBuilder.addDependency(TxnServices.JBOSS_TXN_TRANSACTION_MANAGER, TransactionManager.class, cacheConfigurationDependencies.getTransactionManagerInjector());
            if (config.transaction().useSynchronization()) {
                configBuilder.addDependency(TxnServices.JBOSS_TXN_SYNCHRONIZATION_REGISTRY, TransactionSynchronizationRegistry.class, cacheConfigurationDependencies.getTransactionSynchronizationRegistryInjector());
            }
        }
        for (Dependency dependency : dependencies) {
            this.addDependency(configBuilder, dependency);
        }
        if (cacheName.equals(defaultCache)) {
            configBuilder.addAliases(new ServiceName[]{CacheConfigurationService.getServiceName(containerName, null)});
        }
        newControllers.add(configBuilder.install());
        log.debugf("Cache configuration service for %s installed for container %s", (Object)cacheName, (Object)containerName);
        CacheDependencies cacheDependencies = new CacheDependencies((Value<EmbeddedCacheManager>)containerInjection);
        CacheService cacheService = new CacheService(cacheName, cacheDependencies);
        ServiceBuilder cacheBuilder = target.addService(cacheServiceName, cacheService).addDependency(cacheConfigurationServiceName).setInitialMode(initialMode);
        if (config.transaction().recovery().enabled()) {
            cacheBuilder.addDependency(TxnServices.JBOSS_TXN_ARJUNA_RECOVERY_MANAGER, XAResourceRecoveryRegistry.class, cacheDependencies.getRecoveryRegistryInjector());
        }
        if (cacheName.equals(defaultCache)) {
            cacheBuilder.addAliases(new ServiceName[]{CacheService.getServiceName(containerName, null)});
        }
        if (initialMode == ServiceController.Mode.ACTIVE) {
            cacheBuilder.addListener((ServiceListener)verificationHandler);
        }
        newControllers.add(cacheBuilder.install());
        String jndiName = (model.hasDefined("jndi-name") ? InfinispanJndiName.toJndiName(model.get("jndi-name").asString()) : InfinispanJndiName.defaultCacheJndiName(containerName, cacheName)).getAbsoluteName();
        ContextNames.BindInfo bindInfo = ContextNames.bindInfoFor((String)jndiName);
        BinderService binder = new BinderService(bindInfo.getBindName());
        ServiceBuilder binderBuilder = target.addService(bindInfo.getBinderServiceName(), (Service)binder).addAliases(new ServiceName[]{ContextNames.JAVA_CONTEXT_SERVICE_NAME.append(new String[]{jndiName})}).addDependency(cacheServiceName, Cache.class, (Injector)new ManagedReferenceInjector(binder.getManagedObjectInjector())).addDependency(bindInfo.getParentContextServiceName(), ServiceBasedNamingStore.class, binder.getNamingStoreInjector()).setInitialMode(ServiceController.Mode.PASSIVE);
        newControllers.add(binderBuilder.install());
        log.debugf("Cache service for cache %s installed for container %s", (Object)cacheName, (Object)containerName);
    }

    private <T> void addDependency(ServiceBuilder<?> builder, Dependency<T> dependency) {
        ServiceName name = dependency.getName();
        Injector<T> injector = dependency.getInjector();
        if (injector != null) {
            builder.addDependency(name, dependency.getType(), injector);
        } else {
            builder.addDependency(name);
        }
    }

    abstract void populateCacheMode(ModelNode var1, ModelNode var2) throws OperationFailedException;

    void populate(ModelNode fromModel, ModelNode toModel) {
        if (fromModel.hasDefined("start")) {
            toModel.get("start").set(fromModel.get("start"));
        }
        if (fromModel.hasDefined("batching")) {
            toModel.get("batching").set(fromModel.get("batching"));
        }
        if (fromModel.hasDefined("indexing")) {
            toModel.get("indexing").set(fromModel.get("indexing"));
        }
        if (fromModel.hasDefined("jndi-name")) {
            toModel.get("jndi-name").set(fromModel.get("jndi-name"));
        }
    }

    void processModelNode(String containerName, ModelNode cache, ConfigurationBuilder builder, List<Dependency<?>> dependencies) {
        String storeKey;
        builder.classLoader(((Object)((Object)this)).getClass().getClassLoader());
        builder.clustering().cacheMode(CacheMode.valueOf((String)cache.require("mode").asString()));
        if (cache.hasDefined("indexing")) {
            Indexing indexing = Indexing.valueOf(cache.get("indexing").asString());
            builder.indexing().enabled(indexing.isEnabled()).indexLocalOnly(indexing.isLocalOnly());
        }
        if (cache.hasDefined("queue-size")) {
            int size = cache.get("queue-size").asInt();
            builder.clustering().async().replQueueMaxElements(size).useReplQueue(size > 0);
        }
        if (cache.hasDefined("queue-flush-interval")) {
            builder.clustering().async().replQueueInterval(cache.get("queue-flush-interval").asLong());
        }
        if (cache.hasDefined("remote-timeout")) {
            builder.clustering().sync().replTimeout(cache.get("remote-timeout").asLong());
        }
        if (cache.hasDefined("owners")) {
            builder.clustering().hash().numOwners(cache.get("owners").asInt());
        }
        if (cache.hasDefined("virtual-nodes")) {
            builder.clustering().hash().numVirtualNodes(cache.get("virtual-nodes").asInt());
        }
        if (cache.hasDefined("l1-lifespan")) {
            long lifespan = cache.get("l1-lifespan").asLong();
            if (lifespan > 0L) {
                builder.clustering().l1().enable().lifespan(lifespan);
            } else {
                builder.clustering().l1().disable();
            }
        }
        if (cache.hasDefined("locking") && cache.get(new String[]{"locking", "LOCKING"}).isDefined()) {
            ModelNode locking = cache.get(new String[]{"locking", "LOCKING"});
            if (locking.hasDefined("isolation")) {
                builder.locking().isolationLevel(IsolationLevel.valueOf((String)locking.get("isolation").asString()));
            }
            if (locking.hasDefined("striping")) {
                builder.locking().useLockStriping(locking.get("striping").asBoolean());
            }
            if (locking.hasDefined("acquire-timeout")) {
                builder.locking().lockAcquisitionTimeout(locking.get("acquire-timeout").asLong());
            }
            if (locking.hasDefined("concurrency-level")) {
                builder.locking().concurrencyLevel(locking.get("concurrency-level").asInt());
            }
        }
        TransactionMode txMode = TransactionMode.NONE;
        LockingMode lockingMode = LockingMode.OPTIMISTIC;
        if (cache.hasDefined("transaction") && cache.get(new String[]{"transaction", "TRANSACTION"}).isDefined()) {
            ModelNode transaction = cache.get(new String[]{"transaction", "TRANSACTION"});
            if (transaction.hasDefined("stop-timeout")) {
                builder.transaction().cacheStopTimeout(transaction.get("stop-timeout").asLong());
            }
            if (transaction.hasDefined("mode")) {
                txMode = TransactionMode.valueOf(transaction.get("mode").asString());
            }
            if (transaction.hasDefined("locking")) {
                lockingMode = LockingMode.valueOf((String)transaction.get("locking").asString());
            }
        }
        builder.transaction().transactionMode(txMode.getMode()).lockingMode(lockingMode).useSynchronization(!txMode.isXAEnabled()).recovery().enabled(txMode.isRecoveryEnabled());
        if (txMode.isRecoveryEnabled()) {
            builder.transaction().syncCommitPhase(true).syncRollbackPhase(true);
        }
        if (cache.hasDefined("batching")) {
            if (cache.get("batching").asBoolean()) {
                builder.transaction().transactionMode(org.infinispan.transaction.TransactionMode.TRANSACTIONAL).invocationBatching().enable();
            } else {
                builder.transaction().invocationBatching().disable();
            }
        }
        if (cache.hasDefined("eviction") && cache.get(new String[]{"eviction", "EVICTION"}).isDefined()) {
            ModelNode eviction = cache.get(new String[]{"eviction", "EVICTION"});
            if (eviction.hasDefined("strategy")) {
                builder.eviction().strategy(EvictionStrategy.valueOf((String)eviction.get("strategy").asString()));
            }
            if (eviction.hasDefined("max-entries")) {
                builder.eviction().maxEntries(eviction.get("max-entries").asInt());
            }
        }
        if (cache.hasDefined("expiration") && cache.get(new String[]{"expiration", "EXPIRATION"}).isDefined()) {
            ModelNode expiration = cache.get(new String[]{"expiration", "EXPIRATION"});
            if (expiration.hasDefined("max-idle")) {
                builder.expiration().maxIdle(expiration.get("max-idle").asLong());
            }
            if (expiration.hasDefined("lifespan")) {
                builder.expiration().lifespan(expiration.get("lifespan").asLong());
            }
            if (expiration.hasDefined("interval")) {
                builder.expiration().wakeUpInterval(expiration.get("interval").asLong());
            }
        }
        if ((storeKey = this.findStoreKey(cache)) != null) {
            ModelNode store = this.getStoreModelNode(cache);
            builder.loaders().shared(store.hasDefined("shared") ? store.get("shared").asBoolean() : false).preload(store.hasDefined("preload") ? store.get("preload").asBoolean() : false).passivation(store.hasDefined("passivation") ? store.get("passivation").asBoolean() : true);
            LoaderConfigurationBuilder storeBuilder = builder.loaders().addCacheLoader().fetchPersistentState(store.hasDefined("fetch-state") ? store.get("fetch-state").asBoolean() : true).purgeOnStartup(store.hasDefined("purge") ? store.get("purge").asBoolean() : true).purgeSynchronously(true);
            storeBuilder.singletonStore().enabled(store.hasDefined("singleton") ? store.get("singleton").asBoolean() : false);
            this.buildCacheStore(storeBuilder, containerName, store, storeKey, dependencies);
        }
    }

    private String findStoreKey(ModelNode cache) {
        if (cache.hasDefined("store")) {
            return "store";
        }
        if (cache.hasDefined("file-store")) {
            return "file-store";
        }
        if (cache.hasDefined("jdbc-store")) {
            return "jdbc-store";
        }
        if (cache.hasDefined("remote-store")) {
            return "remote-store";
        }
        return null;
    }

    private ModelNode getStoreModelNode(ModelNode cache) {
        if (cache.hasDefined("store")) {
            return cache.get(new String[]{"store", "STORE"});
        }
        if (cache.hasDefined("file-store")) {
            return cache.get(new String[]{"file-store", "FILE_STORE"});
        }
        if (cache.hasDefined("jdbc-store")) {
            return cache.get(new String[]{"jdbc-store", "JDBC_STORE"});
        }
        if (cache.hasDefined("remote-store")) {
            return cache.get(new String[]{"remote-store", "REMOTE_STORE"});
        }
        return null;
    }

    private void buildCacheStore(LoaderConfigurationBuilder builder, String containerName, ModelNode store, String storeKey, List<Dependency<?>> dependencies) {
        TypedProperties properties = new TypedProperties();
        if (store.hasDefined("property")) {
            for (Property property : store.get("property").asPropertyList()) {
                String propertyName = property.getName();
                Property complexValue = property.getValue().asProperty();
                String propertyValue = complexValue.getValue().asString();
                properties.setProperty(propertyName, propertyValue);
            }
        }
        builder.withProperties((Properties)properties);
        if (storeKey.equals("file-store")) {
            builder.cacheLoader((CacheLoader)new FileCacheStore());
            final String path = store.hasDefined("path") ? store.get("path").asString() : containerName;
            SimpleInjector<String> injector = new SimpleInjector<String>((Properties)properties){
                final /* synthetic */ Properties val$properties;
                {
                    this.val$properties = properties;
                }

                public void inject(String value) {
                    StringBuilder location = new StringBuilder(value);
                    if (path != null) {
                        location.append(File.separatorChar).append(path);
                    }
                    this.val$properties.setProperty("location", location.toString());
                }
            };
            String relativeTo = store.hasDefined("relative-to") ? store.get("relative-to").asString() : "jboss.server.data.dir";
            dependencies.add(new Dependency<String>(AbstractPathService.pathNameOf((String)relativeTo), String.class, injector));
            properties.setProperty("fsyncMode", "perWrite");
        } else if (storeKey.equals("jdbc-store")) {
            builder.cacheLoader((CacheLoader)this.createJDBCStore((Properties)properties, store));
            String datasource = store.require("datasource").asString();
            dependencies.add(new Dependency(ServiceName.JBOSS.append(new String[]{"data-source", datasource})));
            properties.setProperty("datasourceJndiLocation", datasource);
            properties.setProperty("connectionFactoryClass", ManagedConnectionFactory.class.getName());
        } else if (storeKey.equals("remote-store")) {
            builder.cacheLoader((CacheLoader)new RemoteCacheStore());
            for (ModelNode server : store.require("remote-servers").asList()) {
                String outboundSocketBinding = server.get("outbound-socket-binding").asString();
                SimpleInjector<OutboundSocketBinding> injector = new SimpleInjector<OutboundSocketBinding>((Properties)properties){
                    final /* synthetic */ Properties val$properties;
                    {
                        this.val$properties = properties;
                    }

                    public void inject(OutboundSocketBinding value) {
                        try {
                            String address = value.getDestinationAddress().getHostAddress() + ":" + value.getDestinationPort();
                            String serverList = this.val$properties.getProperty("serverList");
                            this.val$properties.setProperty("serverList", serverList == null ? address : serverList + ";" + address);
                        }
                        catch (UnknownHostException e) {
                            throw InfinispanMessages.MESSAGES.failedToInjectSocketBinding(e, value);
                        }
                    }
                };
                dependencies.add(new Dependency<OutboundSocketBinding>(OutboundSocketBinding.OUTBOUND_SOCKET_BINDING_BASE_SERVICE_NAME.append(new String[]{outboundSocketBinding}), OutboundSocketBinding.class, injector));
            }
            if (store.hasDefined("cache")) {
                properties.setProperty("remoteCacheName", store.get("cache").asString());
                properties.setProperty("useDefaultRemoteCache", Boolean.toString(false));
            } else {
                properties.setProperty("useDefaultRemoteCache", Boolean.toString(true));
            }
            if (store.hasDefined("socket-timeout")) {
                properties.setProperty("soTimeout", store.require("socket-timeout").asString());
            }
            if (store.hasDefined("tcp-no-delay")) {
                properties.setProperty("tcpNoDelay", store.require("tcp-no-delay").asString());
            }
        } else {
            String className = store.require("class").asString();
            try {
                CacheLoader loader = CacheLoader.class.getClassLoader().loadClass(className).asSubclass(CacheLoader.class).newInstance();
                builder.cacheLoader(loader);
            }
            catch (Exception e) {
                throw new IllegalArgumentException(String.format("%s is not a valid cache store", className), e);
            }
        }
    }

    private CacheStore createJDBCStore(Properties properties, ModelNode store) {
        boolean useEntryTable = store.hasDefined("entry-table");
        boolean useBucketTable = store.hasDefined("bucket-table");
        if (useEntryTable && !useBucketTable) {
            this.setEntryTableProperties(properties, store.get("entry-table"), "", "stringsTableNamePrefix");
            return new JdbcStringBasedCacheStore();
        }
        if (useBucketTable && !useEntryTable) {
            this.setBucketTableProperties(properties, store.get("bucket-table"), "", "bucketTableNamePrefix");
            return new JdbcBinaryCacheStore();
        }
        this.setEntryTableProperties(properties, store.get("entry-table"), "ForStrings", "tableNamePrefixForStrings");
        this.setBucketTableProperties(properties, store.get("bucket-table"), "ForBinary", "tableNamePrefixForBinary");
        return new JdbcMixedCacheStore();
    }

    private void setBucketTableProperties(Properties properties, ModelNode table, String propertySuffix, String tableNamePrefixProperty) {
        this.setTableProperties(properties, table, propertySuffix, tableNamePrefixProperty, "ispn_bucket");
    }

    private void setEntryTableProperties(Properties properties, ModelNode table, String propertySuffix, String tableNamePrefixProperty) {
        this.setTableProperties(properties, table, propertySuffix, tableNamePrefixProperty, "ispn_entry");
    }

    private void setTableProperties(Properties properties, ModelNode table, String propertySuffix, String tableNamePrefixProperty, String defaultTableNamePrefix) {
        properties.setProperty("batchSize", Integer.toString(table.isDefined() && table.hasDefined("batch-size") ? table.get("batch-size").asInt() : 100));
        properties.setProperty("fetchSize", Integer.toString(table.isDefined() && table.hasDefined("fetch-size") ? table.get("fetch-size").asInt() : 100));
        properties.setProperty(tableNamePrefixProperty, table.isDefined() && table.hasDefined("prefix") ? table.get("prefix").asString() : defaultTableNamePrefix);
        properties.setProperty("idColumnName" + propertySuffix, this.getColumnProperty(table, "id-column", "name", "id"));
        properties.setProperty("idColumnType" + propertySuffix, this.getColumnProperty(table, "id-column", "type", "VARCHAR"));
        properties.setProperty("dataColumnName" + propertySuffix, this.getColumnProperty(table, "data-column", "name", "datum"));
        properties.setProperty("dataColumnType" + propertySuffix, this.getColumnProperty(table, "data-column", "type", "BINARY"));
        properties.setProperty("timestampColumnName" + propertySuffix, this.getColumnProperty(table, "timestamp-column", "name", "version"));
        properties.setProperty("timestampColumnType" + propertySuffix, this.getColumnProperty(table, "timestamp-column", "type", "BIGINT"));
    }

    private String getColumnProperty(ModelNode table, String columnKey, String key, String defaultValue) {
        if (!table.isDefined() || !table.hasDefined(columnKey)) {
            return defaultValue;
        }
        ModelNode column = table.get(columnKey);
        return column.hasDefined(key) ? column.get(key).asString() : defaultValue;
    }

    private static class CacheConfigurationDependencies
    implements CacheConfigurationService.Dependencies {
        private final Value<EmbeddedCacheManager> container;
        private final InjectedValue<TransactionManager> tm = new InjectedValue();
        private final InjectedValue<TransactionSynchronizationRegistry> tsr = new InjectedValue();

        CacheConfigurationDependencies(Value<EmbeddedCacheManager> container) {
            this.container = container;
        }

        Injector<TransactionManager> getTransactionManagerInjector() {
            return this.tm;
        }

        Injector<TransactionSynchronizationRegistry> getTransactionSynchronizationRegistryInjector() {
            return this.tsr;
        }

        @Override
        public EmbeddedCacheManager getCacheContainer() {
            return (EmbeddedCacheManager)this.container.getValue();
        }

        @Override
        public TransactionManager getTransactionManager() {
            return (TransactionManager)this.tm.getOptionalValue();
        }

        @Override
        public TransactionSynchronizationRegistry getTransactionSynchronizationRegistry() {
            return (TransactionSynchronizationRegistry)this.tsr.getOptionalValue();
        }
    }

    private static class CacheDependencies
    implements CacheService.Dependencies {
        private final Value<EmbeddedCacheManager> container;
        private final InjectedValue<XAResourceRecoveryRegistry> recoveryRegistry = new InjectedValue();

        CacheDependencies(Value<EmbeddedCacheManager> container) {
            this.container = container;
        }

        Injector<XAResourceRecoveryRegistry> getRecoveryRegistryInjector() {
            return this.recoveryRegistry;
        }

        @Override
        public EmbeddedCacheManager getCacheContainer() {
            return (EmbeddedCacheManager)this.container.getValue();
        }

        @Override
        public XAResourceRecoveryRegistry getRecoveryRegistry() {
            return (XAResourceRecoveryRegistry)this.recoveryRegistry.getOptionalValue();
        }
    }

    private abstract class SimpleInjector<I>
    implements Injector<I> {
        private SimpleInjector() {
        }

        public void uninject() {
        }
    }

    protected class Dependency<I> {
        private final ServiceName name;
        private final Class<I> type;
        private final Injector<I> target;

        Dependency(ServiceName name) {
            this(name, null, null);
        }

        Dependency(ServiceName name, Class<I> type, Injector<I> target) {
            this.name = name;
            this.type = type;
            this.target = target;
        }

        ServiceName getName() {
            return this.name;
        }

        public Class<I> getType() {
            return this.type;
        }

        public Injector<I> getInjector() {
            return this.target;
        }
    }
}

