/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.infinispan.subsystem;

import java.util.List;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.jboss.as.clustering.infinispan.subsystem.CacheAdd;
import org.jboss.as.clustering.infinispan.subsystem.ClusteredCacheAdd;
import org.jboss.dmr.ModelNode;

public abstract class SharedStateCacheAdd
extends ClusteredCacheAdd {
    SharedStateCacheAdd(CacheMode mode) {
        super(mode);
    }

    @Override
    void processModelNode(String containerName, ModelNode cache, ConfigurationBuilder builder, List<CacheAdd.Dependency<?>> dependencies) {
        super.processModelNode(containerName, cache, builder, dependencies);
        if (cache.hasDefined("state-transfer") && cache.get(new String[]{"state-transfer", "STATE_TRANSFER"}).isDefined()) {
            ModelNode stateTransfer = cache.get(new String[]{"state-transfer", "STATE_TRANSFER"});
            if (stateTransfer.hasDefined("enabled")) {
                builder.clustering().stateTransfer().fetchInMemoryState(stateTransfer.get("enabled").asBoolean());
            }
            if (stateTransfer.hasDefined("timeout")) {
                builder.clustering().stateTransfer().timeout(stateTransfer.get("timeout").asLong());
            }
            if (stateTransfer.hasDefined("chunk-size")) {
                builder.clustering().stateTransfer().chunkSize(stateTransfer.get("chunk-size").asInt());
            }
        }
    }
}

