/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.trust.jbossws.handler;

import java.security.AccessController;
import java.security.Principal;
import java.security.PrivilegedAction;
import java.security.acl.Group;
import java.util.List;
import javax.security.auth.Subject;
import org.jboss.security.SecurityContext;
import org.jboss.security.SecurityContextAssociation;
import org.jboss.security.SecurityContextFactory;
import org.jboss.security.SimplePrincipal;
import org.picketlink.identity.federation.bindings.jboss.subject.PicketLinkGroup;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class SecurityActions {
    SecurityActions() {
    }

    static SecurityContext createSecurityContext(final Principal p, final Object cred, final Subject subject) {
        return AccessController.doPrivileged(new PrivilegedAction<SecurityContext>(){

            @Override
            public SecurityContext run() {
                SecurityContext sc = null;
                try {
                    sc = SecurityContextFactory.createSecurityContext((Principal)p, (Object)cred, (Subject)subject, (String)"SAML2_HANDLER");
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
                return sc;
            }
        });
    }

    static void setSecurityContext(final SecurityContext sc) {
        AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                SecurityContextAssociation.setSecurityContext((SecurityContext)sc);
                return null;
            }
        });
    }

    static SecurityContext getSecurityContext() {
        return AccessController.doPrivileged(new PrivilegedAction<SecurityContext>(){

            @Override
            public SecurityContext run() {
                return SecurityContextAssociation.getSecurityContext();
            }
        });
    }

    static Subject getAuthenticatedSubject() {
        return AccessController.doPrivileged(new PrivilegedAction<Subject>(){

            @Override
            public Subject run() {
                SecurityContext sc = SecurityContextAssociation.getSecurityContext();
                if (sc != null) {
                    return sc.getUtil().getSubject();
                }
                return null;
            }
        });
    }

    static String getSystemProperty(final String key, final String defaultValue) {
        return AccessController.doPrivileged(new PrivilegedAction<String>(){

            @Override
            public String run() {
                return System.getProperty(key, defaultValue);
            }
        });
    }

    static ClassLoader getClassLoader(final Class<?> clazz) {
        return AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

            @Override
            public ClassLoader run() {
                return clazz.getClassLoader();
            }
        });
    }

    static ClassLoader getContextClassLoader() {
        return AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

            @Override
            public ClassLoader run() {
                return Thread.currentThread().getContextClassLoader();
            }
        });
    }

    static Group group(final List<String> roles) {
        return AccessController.doPrivileged(new PrivilegedAction<Group>(){

            @Override
            public Group run() {
                PicketLinkGroup theGroup = new PicketLinkGroup("Roles");
                for (String role : roles) {
                    theGroup.addMember((Principal)new SimplePrincipal(role));
                }
                return theGroup;
            }
        });
    }
}

