/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.web;

import java.util.Locale;
import java.util.ResourceBundle;
import org.jboss.as.web.Namespace;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;

class WebSubsystemDescriptions {
    static final String RESOURCE_NAME = WebSubsystemDescriptions.class.getPackage().getName() + ".LocalDescriptions";

    WebSubsystemDescriptions() {
    }

    static ModelNode getSubsystemDescription(Locale locale) {
        ResourceBundle bundle2 = WebSubsystemDescriptions.getResourceBundle(locale);
        ModelNode node = new ModelNode();
        node.get("description").set(bundle2.getString("web"));
        node.get("head-comment-allowed").set(true);
        node.get("tail-comment-allowed").set(true);
        node.get("namespace").set(Namespace.WEB_1_1.getUriString());
        node.get(new String[]{"attributes", "default-virtual-server", "type"}).set(ModelType.STRING);
        node.get(new String[]{"attributes", "default-virtual-server", "description"}).set(bundle2.getString("web.default-virtual-server"));
        node.get(new String[]{"attributes", "default-virtual-server", "required"}).set(false);
        node.get(new String[]{"attributes", "default-virtual-server", "default"}).set("localhost");
        node.get(new String[]{"attributes", "native", "type"}).set(ModelType.BOOLEAN);
        node.get(new String[]{"attributes", "native", "description"}).set(bundle2.getString("web.native"));
        node.get(new String[]{"attributes", "native", "required"}).set(false);
        node.get(new String[]{"attributes", "native", "default"}).set(true);
        node.get(new String[]{"attributes", "instance-id", "type"}).set(ModelType.STRING);
        node.get(new String[]{"attributes", "instance-id", "description"}).set(bundle2.getString("web.instance-id"));
        node.get(new String[]{"attributes", "instance-id", "required"}).set(false);
        node.get(new String[]{"children", "configuration", "description"}).set(bundle2.getString("web.configuration"));
        node.get(new String[]{"children", "configuration", "model-description"}).setEmptyObject();
        node.get(new String[]{"children", "connector", "description"}).set(bundle2.getString("web.connector"));
        node.get(new String[]{"children", "connector", "model-description"});
        node.get(new String[]{"children", "virtual-server", "description"}).set(bundle2.getString("web.virtual-server"));
        node.get(new String[]{"children", "virtual-server", "model-description"});
        return node;
    }

    static ModelNode getSubsystemAddDescription(Locale locale) {
        ResourceBundle bundle2 = WebSubsystemDescriptions.getResourceBundle(locale);
        ModelNode node = new ModelNode();
        node.get("operation-name").set("add");
        node.get("description").set(bundle2.getString("web.add"));
        node.get(new String[]{"request-properties", "default-virtual-server", "type"}).set(ModelType.STRING);
        node.get(new String[]{"request-properties", "default-virtual-server", "description"}).set(bundle2.getString("web.default-virtual-server"));
        node.get(new String[]{"request-properties", "default-virtual-server", "required"}).set(false);
        node.get(new String[]{"request-properties", "default-virtual-server", "default"}).set("localhost");
        node.get(new String[]{"request-properties", "native", "type"}).set(ModelType.BOOLEAN);
        node.get(new String[]{"request-properties", "native", "description"}).set(bundle2.getString("web.native"));
        node.get(new String[]{"request-properties", "native", "required"}).set(false);
        node.get(new String[]{"request-properties", "native", "default"}).set(true);
        node.get(new String[]{"request-properties", "instance-id", "type"}).set(ModelType.STRING);
        node.get(new String[]{"request-properties", "instance-id", "description"}).set(bundle2.getString("web.instance-id"));
        node.get(new String[]{"request-properties", "instance-id", "required"}).set(false);
        ModelNode configuration = node.get(new String[]{"request-properties", "configuration"});
        WebSubsystemDescriptions.getConfigurationCommonDescription(configuration, "value-type", bundle2);
        configuration.get("type").set(ModelType.OBJECT);
        configuration.get("required").set(false);
        ModelNode connector = node.get(new String[]{"request-properties", "connector"});
        WebSubsystemDescriptions.getConnectorCommonDescription(connector, "value-type", bundle2);
        connector.get("type").set(ModelType.OBJECT);
        connector.get("required").set(false);
        ModelNode virtual = node.get(new String[]{"request-properties", "virtual-server"});
        WebSubsystemDescriptions.getVirtualServerCommonDescription(virtual, "value-type", bundle2);
        virtual.get("type").set(ModelType.OBJECT);
        virtual.get("required").set(false);
        return node;
    }

    public static ModelNode getSubsystemRemoveDescription(Locale locale) {
        ResourceBundle bundle2 = WebSubsystemDescriptions.getResourceBundle(locale);
        ModelNode op = new ModelNode();
        op.get("operation-name").set("remove");
        op.get("description").set(bundle2.getString("web.remove"));
        op.get("reply-properties").setEmptyObject();
        op.get("request-properties").setEmptyObject();
        return op;
    }

    static ModelNode getConnectorDescription(Locale locale) {
        ResourceBundle bundle2 = WebSubsystemDescriptions.getResourceBundle(locale);
        ModelNode node = new ModelNode();
        node.get("head-comment-allowed").set(true);
        node.get("tail-comment-allowed").set(true);
        return WebSubsystemDescriptions.getConnectorCommonDescription(node, "attributes", bundle2);
    }

    static ModelNode getConfigurationCommonDescription(ModelNode node, String type, ResourceBundle bundle2) {
        node.get("description").set(bundle2.getString("web.configuration"));
        if ("attributes".equals(type)) {
            WebSubsystemDescriptions.getStaticResourceDescription(node.get(new String[]{"children", "static-resources"}), type, bundle2);
            WebSubsystemDescriptions.getJspConfigurationDescription(node.get(new String[]{"children", "jsp-configuration"}), type, bundle2);
            ModelNode mime = node.get(new String[]{"children", "mime-mapping"});
            mime.get("description").set(bundle2.getString("web.configuration.mime-mapping"));
            mime.get("required").set(false);
            mime.get("max-occurs").set(Integer.MAX_VALUE);
            mime.get(new String[]{type, "name", "type"}).set(ModelType.STRING);
            mime.get(new String[]{type, "name", "description"}).set(bundle2.getString("web.configuration.mime-mapping.name"));
            mime.get(new String[]{type, "name", "required"}).set(true);
            mime.get(new String[]{type, "name", "nillable"}).set(false);
            mime.get(new String[]{type, "value", "type"}).set(ModelType.STRING);
            mime.get(new String[]{type, "value", "description"}).set(bundle2.getString("web.configuration.mime-mapping.value"));
            mime.get(new String[]{type, "value", "required"}).set(true);
            mime.get(new String[]{type, "value", "nillable"}).set(false);
        }
        node.get(new String[]{type, "welcome-file", "type"}).set(ModelType.LIST);
        node.get(new String[]{type, "welcome-file", "value-type"}).set(ModelType.STRING);
        node.get(new String[]{type, "welcome-file", "description"}).set(bundle2.getString("web.configuration.welcome-file"));
        node.get(new String[]{type, "welcome-file", "required"}).set(false);
        node.get(new String[]{type, "welcome-file", "nillable"}).set(true);
        return node;
    }

    static ModelNode getStaticResourcesCommonDescription(ModelNode node, String type, ResourceBundle bundle2) {
        node.get(new String[]{type, "listings", "type"}).set(ModelType.BOOLEAN);
        node.get(new String[]{type, "listings", "description"}).set(bundle2.getString("web.configuration.static.listings"));
        node.get(new String[]{type, "listings", "required"}).set(false);
        node.get(new String[]{type, "listings", "default"}).set(false);
        node.get(new String[]{type, "sendfile", "type"}).set(ModelType.INT);
        node.get(new String[]{type, "sendfile", "description"}).set(bundle2.getString("web.configuration.static.sendfile"));
        node.get(new String[]{type, "sendfile", "required"}).set(false);
        node.get(new String[]{type, "sendfile", "default"}).set(49152);
        node.get(new String[]{type, "file-encoding", "type"}).set(ModelType.STRING);
        node.get(new String[]{type, "file-encoding", "description"}).set(bundle2.getString("web.configuration.static.file-encoding"));
        node.get(new String[]{type, "file-encoding", "required"}).set(false);
        node.get(new String[]{type, "read-only", "type"}).set(ModelType.BOOLEAN);
        node.get(new String[]{type, "read-only", "description"}).set(bundle2.getString("web.configuration.static.read-only"));
        node.get(new String[]{type, "read-only", "required"}).set(false);
        node.get(new String[]{type, "read-only", "default"}).set(true);
        node.get(new String[]{type, "webdav", "type"}).set(ModelType.BOOLEAN);
        node.get(new String[]{type, "webdav", "description"}).set(bundle2.getString("web.configuration.static.webdav"));
        node.get(new String[]{type, "webdav", "required"}).set(false);
        node.get(new String[]{type, "webdav", "default"}).set(false);
        node.get(new String[]{type, "secret", "type"}).set(ModelType.STRING);
        node.get(new String[]{type, "secret", "description"}).set(bundle2.getString("web.configuration.static.secret"));
        node.get(new String[]{type, "secret", "required"}).set(false);
        node.get(new String[]{type, "max-depth", "type"}).set(ModelType.INT);
        node.get(new String[]{type, "max-depth", "description"}).set(bundle2.getString("web.configuration.static.max-depth"));
        node.get(new String[]{type, "max-depth", "required"}).set(false);
        node.get(new String[]{type, "max-depth", "default"}).set(3);
        node.get(new String[]{type, "disabled", "type"}).set(ModelType.BOOLEAN);
        node.get(new String[]{type, "disabled", "description"}).set(bundle2.getString("web.configuration.static.disabled"));
        node.get(new String[]{type, "disabled", "required"}).set(false);
        node.get(new String[]{type, "disabled", "default"}).set(false);
        return node;
    }

    static ModelNode getJSPCommonDescription(ModelNode node, String type, ResourceBundle bundle2) {
        node.get("description").set(bundle2.getString("web.configuration.jsp"));
        node.get(new String[]{type, "development", "type"}).set(ModelType.BOOLEAN);
        node.get(new String[]{type, "development", "description"}).set(bundle2.getString("web.configuration.jsp.development"));
        node.get(new String[]{type, "development", "required"}).set(false);
        node.get(new String[]{type, "development", "default"}).set(false);
        node.get(new String[]{type, "disabled", "type"}).set(ModelType.BOOLEAN);
        node.get(new String[]{type, "disabled", "description"}).set(bundle2.getString("web.configuration.jsp.disabled"));
        node.get(new String[]{type, "disabled", "required"}).set(false);
        node.get(new String[]{type, "disabled", "default"}).set(false);
        node.get(new String[]{type, "keep-generated", "type"}).set(ModelType.BOOLEAN);
        node.get(new String[]{type, "keep-generated", "description"}).set(bundle2.getString("web.configuration.jsp.keep-generated"));
        node.get(new String[]{type, "keep-generated", "required"}).set(false);
        node.get(new String[]{type, "keep-generated", "default"}).set(true);
        node.get(new String[]{type, "trim-spaces", "type"}).set(ModelType.BOOLEAN);
        node.get(new String[]{type, "trim-spaces", "description"}).set(bundle2.getString("web.configuration.jsp.trim-spaces"));
        node.get(new String[]{type, "trim-spaces", "required"}).set(false);
        node.get(new String[]{type, "trim-spaces", "default"}).set(true);
        node.get(new String[]{type, "tag-pooling", "type"}).set(ModelType.BOOLEAN);
        node.get(new String[]{type, "tag-pooling", "description"}).set(bundle2.getString("web.configuration.jsp.tag-pooling"));
        node.get(new String[]{type, "tag-pooling", "required"}).set(false);
        node.get(new String[]{type, "tag-pooling", "default"}).set(true);
        node.get(new String[]{type, "mapped-file", "type"}).set(ModelType.BOOLEAN);
        node.get(new String[]{type, "mapped-file", "description"}).set(bundle2.getString("web.configuration.jsp.mapped-file"));
        node.get(new String[]{type, "mapped-file", "required"}).set(false);
        node.get(new String[]{type, "mapped-file", "default"}).set(true);
        node.get(new String[]{type, "check-interval", "type"}).set(ModelType.INT);
        node.get(new String[]{type, "check-interval", "description"}).set(bundle2.getString("web.configuration.jsp.check-interval"));
        node.get(new String[]{type, "check-interval", "required"}).set(false);
        node.get(new String[]{type, "check-interval", "default"}).set(0);
        node.get(new String[]{type, "modification-test-interval", "type"}).set(ModelType.INT);
        node.get(new String[]{type, "modification-test-interval", "description"}).set(bundle2.getString("web.configuration.jsp.modification-test-interval"));
        node.get(new String[]{type, "modification-test-interval", "required"}).set(false);
        node.get(new String[]{type, "modification-test-interval", "default"}).set(4);
        node.get(new String[]{type, "recompile-on-fail", "type"}).set(ModelType.BOOLEAN);
        node.get(new String[]{type, "recompile-on-fail", "description"}).set(bundle2.getString("web.configuration.jsp.recompile-on-fail"));
        node.get(new String[]{type, "recompile-on-fail", "required"}).set(false);
        node.get(new String[]{type, "recompile-on-fail", "default"}).set(false);
        node.get(new String[]{type, "smap", "type"}).set(ModelType.BOOLEAN);
        node.get(new String[]{type, "smap", "description"}).set(bundle2.getString("web.configuration.jsp.smap"));
        node.get(new String[]{type, "smap", "required"}).set(false);
        node.get(new String[]{type, "smap", "default"}).set(false);
        node.get(new String[]{type, "dump-smap", "type"}).set(ModelType.BOOLEAN);
        node.get(new String[]{type, "dump-smap", "description"}).set(bundle2.getString("web.configuration.jsp.dump-smap"));
        node.get(new String[]{type, "dump-smap", "required"}).set(false);
        node.get(new String[]{type, "dump-smap", "default"}).set(false);
        node.get(new String[]{type, "generate-strings-as-char-arrays", "type"}).set(ModelType.BOOLEAN);
        node.get(new String[]{type, "generate-strings-as-char-arrays", "description"}).set(bundle2.getString("web.configuration.jsp.generate-strings-as-char-arrays"));
        node.get(new String[]{type, "generate-strings-as-char-arrays", "required"}).set(false);
        node.get(new String[]{type, "generate-strings-as-char-arrays", "default"}).set(false);
        node.get(new String[]{type, "error-on-use-bean-invalid-class-attribute", "type"}).set(ModelType.BOOLEAN);
        node.get(new String[]{type, "error-on-use-bean-invalid-class-attribute", "description"}).set(bundle2.getString("web.configuration.jsp.error-on-use-bean-invalid-class-attribute"));
        node.get(new String[]{type, "error-on-use-bean-invalid-class-attribute", "required"}).set(false);
        node.get(new String[]{type, "error-on-use-bean-invalid-class-attribute", "default"}).set(false);
        node.get(new String[]{type, "scratch-dir", "type"}).set(ModelType.STRING);
        node.get(new String[]{type, "scratch-dir", "description"}).set(bundle2.getString("web.configuration.jsp.scratch-dir"));
        node.get(new String[]{type, "scratch-dir", "required"}).set(false);
        node.get(new String[]{type, "source-vm", "type"}).set(ModelType.STRING);
        node.get(new String[]{type, "source-vm", "description"}).set(bundle2.getString("web.configuration.jsp.source-vm"));
        node.get(new String[]{type, "source-vm", "required"}).set(false);
        node.get(new String[]{type, "source-vm", "default"}).set("1.5");
        node.get(new String[]{type, "target-vm", "type"}).set(ModelType.STRING);
        node.get(new String[]{type, "target-vm", "description"}).set(bundle2.getString("web.configuration.jsp.target-vm"));
        node.get(new String[]{type, "target-vm", "required"}).set(false);
        node.get(new String[]{type, "target-vm", "default"}).set("1.5");
        node.get(new String[]{type, "java-encoding", "type"}).set(ModelType.STRING);
        node.get(new String[]{type, "java-encoding", "description"}).set(bundle2.getString("web.configuration.jsp.java-encoding"));
        node.get(new String[]{type, "java-encoding", "required"}).set(false);
        node.get(new String[]{type, "java-encoding", "default"}).set("UTF-8");
        node.get(new String[]{type, "x-powered-by", "type"}).set(ModelType.BOOLEAN);
        node.get(new String[]{type, "x-powered-by", "description"}).set(bundle2.getString("web.configuration.jsp.x-powered-by"));
        node.get(new String[]{type, "x-powered-by", "required"}).set(false);
        node.get(new String[]{type, "x-powered-by", "default"}).set(true);
        node.get(new String[]{type, "display-source-fragment", "type"}).set(ModelType.BOOLEAN);
        node.get(new String[]{type, "display-source-fragment", "description"}).set(bundle2.getString("web.configuration.jsp.display-source-fragment"));
        node.get(new String[]{type, "display-source-fragment", "required"}).set(false);
        node.get(new String[]{type, "display-source-fragment", "default"}).set(true);
        return node;
    }

    static ModelNode getConnectorCommonDescription(ModelNode node, String type, ResourceBundle bundle2) {
        node.get("description").set(bundle2.getString("web.connector"));
        node.get(new String[]{type, "name", "type"}).set(ModelType.STRING);
        node.get(new String[]{type, "name", "description"}).set(bundle2.getString("web.connector.name"));
        node.get(new String[]{type, "name", "required"}).set(false);
        node.get(new String[]{type, "name", "nillable"}).set(false);
        node.get(new String[]{type, "protocol", "type"}).set(ModelType.STRING);
        node.get(new String[]{type, "protocol", "description"}).set(bundle2.getString("web.connector.protocol"));
        node.get(new String[]{type, "protocol", "required"}).set(true);
        node.get(new String[]{type, "socket-binding", "type"}).set(ModelType.STRING);
        node.get(new String[]{type, "socket-binding", "description"}).set(bundle2.getString("web.connector.socket-binding"));
        node.get(new String[]{type, "socket-binding", "required"}).set(true);
        node.get(new String[]{type, "socket-binding", "nillable"}).set(false);
        node.get(new String[]{type, "scheme", "type"}).set(ModelType.STRING);
        node.get(new String[]{type, "scheme", "description"}).set(bundle2.getString("web.connector.scheme"));
        node.get(new String[]{type, "scheme", "required"}).set(false);
        node.get(new String[]{type, "scheme", "default"}).set("http");
        node.get(new String[]{type, "executor", "type"}).set(ModelType.STRING);
        node.get(new String[]{type, "executor", "description"}).set(bundle2.getString("web.connector.executor"));
        node.get(new String[]{type, "executor", "required"}).set(false);
        node.get(new String[]{type, "enabled", "type"}).set(ModelType.BOOLEAN);
        node.get(new String[]{type, "enabled", "description"}).set(bundle2.getString("web.connector.enabled"));
        node.get(new String[]{type, "enabled", "required"}).set(false);
        node.get(new String[]{type, "enabled", "default"}).set(true);
        node.get(new String[]{type, "enable-lookups", "type"}).set(ModelType.BOOLEAN);
        node.get(new String[]{type, "enable-lookups", "description"}).set(bundle2.getString("web.connector.enable-lookups"));
        node.get(new String[]{type, "enable-lookups", "required"}).set(false);
        node.get(new String[]{type, "enable-lookups", "default"}).set(false);
        node.get(new String[]{type, "proxy-name", "type"}).set(ModelType.STRING);
        node.get(new String[]{type, "proxy-name", "description"}).set(bundle2.getString("web.connector.proxy-name"));
        node.get(new String[]{type, "proxy-name", "required"}).set(false);
        node.get(new String[]{type, "proxy-port", "type"}).set(ModelType.INT);
        node.get(new String[]{type, "proxy-port", "description"}).set(bundle2.getString("web.connector.proxy-port"));
        node.get(new String[]{type, "proxy-port", "required"}).set(false);
        node.get(new String[]{type, "max-post-size", "type"}).set(ModelType.INT);
        node.get(new String[]{type, "max-post-size", "description"}).set(bundle2.getString("web.connector.max-post-size"));
        node.get(new String[]{type, "max-post-size", "required"}).set(false);
        node.get(new String[]{type, "max-post-size", "default"}).set(0x200000);
        node.get(new String[]{type, "max-save-post-size", "type"}).set(ModelType.INT);
        node.get(new String[]{type, "max-save-post-size", "description"}).set(bundle2.getString("web.connector.max-save-post-size"));
        node.get(new String[]{type, "max-save-post-size", "required"}).set(false);
        node.get(new String[]{type, "max-save-post-size", "default"}).set(4096);
        node.get(new String[]{type, "secure", "type"}).set(ModelType.BOOLEAN);
        node.get(new String[]{type, "secure", "description"}).set(bundle2.getString("web.connector.secure"));
        node.get(new String[]{type, "secure", "required"}).set(false);
        node.get(new String[]{type, "secure", "default"}).set(false);
        node.get(new String[]{type, "redirect-port", "type"}).set(ModelType.INT);
        node.get(new String[]{type, "redirect-port", "description"}).set(bundle2.getString("web.connector.redirect-port"));
        node.get(new String[]{type, "redirect-port", "required"}).set(false);
        node.get(new String[]{type, "redirect-port", "default"}).set(8443);
        node.get(new String[]{type, "max-connections", "type"}).set(ModelType.INT);
        node.get(new String[]{type, "max-connections", "description"}).set(bundle2.getString("web.connector.max-connections"));
        node.get(new String[]{type, "max-connections", "required"}).set(false);
        node.get(new String[]{type, "virtual-server", "type"}).set(ModelType.LIST);
        node.get(new String[]{type, "virtual-server", "value-type"}).set(ModelType.STRING);
        node.get(new String[]{type, "virtual-server", "description"}).set(bundle2.getString("web.connector.virtual-server"));
        node.get(new String[]{type, "virtual-server", "required"}).set(false);
        if ("attributes".equals(type)) {
            node.get(new String[]{type, "bytesSent", "type"}).set(ModelType.INT);
            node.get(new String[]{type, "bytesSent", "description"}).set(bundle2.getString("web.connector.stats.bytes-sent"));
            node.get(new String[]{type, "bytesReceived", "type"}).set(ModelType.INT);
            node.get(new String[]{type, "bytesReceived", "description"}).set(bundle2.getString("web.connector.stats.bytes-received"));
            node.get(new String[]{type, "processingTime", "type"}).set(ModelType.INT);
            node.get(new String[]{type, "processingTime", "description"}).set(bundle2.getString("web.connector.stats.processing-time"));
            node.get(new String[]{type, "errorCount", "type"}).set(ModelType.INT);
            node.get(new String[]{type, "errorCount", "description"}).set(bundle2.getString("web.connector.stats.error-count"));
            node.get(new String[]{type, "maxTime", "type"}).set(ModelType.INT);
            node.get(new String[]{type, "maxTime", "description"}).set(bundle2.getString("web.connector.stats.max-time"));
            node.get(new String[]{type, "requestCount", "type"}).set(ModelType.INT);
            node.get(new String[]{type, "requestCount", "description"}).set(bundle2.getString("web.connector.request-count"));
            node.get(new String[]{"children", "ssl", "description"}).set(bundle2.getString("web.connector.ssl"));
            node.get(new String[]{"children", "ssl", "model-description"}).setEmptyObject();
        }
        return node;
    }

    static ModelNode addSSLCommonDescription(ModelNode node, String type, ResourceBundle bundle2) {
        node.get(new String[]{type, "name", "type"}).set(ModelType.STRING);
        node.get(new String[]{type, "name", "description"}).set(bundle2.getString("web.connector.ssl.name"));
        node.get(new String[]{type, "name", "required"}).set(false);
        node.get(new String[]{type, "key-alias", "type"}).set(ModelType.STRING);
        node.get(new String[]{type, "key-alias", "description"}).set(bundle2.getString("web.connector.ssl.key-alias"));
        node.get(new String[]{type, "key-alias", "required"}).set(false);
        node.get(new String[]{type, "password", "type"}).set(ModelType.STRING);
        node.get(new String[]{type, "password", "description"}).set(bundle2.getString("web.connector.ssl.password"));
        node.get(new String[]{type, "password", "required"}).set(false);
        node.get(new String[]{type, "password", "expressions-allowed"}).set(true);
        node.get(new String[]{type, "certificate-key-file", "type"}).set(ModelType.STRING);
        node.get(new String[]{type, "certificate-key-file", "description"}).set(bundle2.getString("web.connector.ssl.certificate-key-file"));
        node.get(new String[]{type, "certificate-key-file", "required"}).set(false);
        node.get(new String[]{type, "certificate-key-file", "expressions-allowed"}).set(true);
        node.get(new String[]{type, "cipher-suite", "type"}).set(ModelType.STRING);
        node.get(new String[]{type, "cipher-suite", "description"}).set(bundle2.getString("web.connector.ssl.cipher-suite"));
        node.get(new String[]{type, "cipher-suite", "required"}).set(false);
        node.get(new String[]{type, "protocol", "type"}).set(ModelType.STRING);
        node.get(new String[]{type, "protocol", "description"}).set(bundle2.getString("web.connector.ssl.protocol"));
        node.get(new String[]{type, "protocol", "required"}).set(false);
        node.get(new String[]{type, "verify-client", "type"}).set(ModelType.STRING);
        node.get(new String[]{type, "verify-client", "description"}).set(bundle2.getString("web.connector.ssl.verify-client"));
        node.get(new String[]{type, "verify-client", "required"}).set(false);
        node.get(new String[]{type, "verify-depth", "type"}).set(ModelType.INT);
        node.get(new String[]{type, "verify-depth", "description"}).set(bundle2.getString("web.connector.ssl.verify-depth"));
        node.get(new String[]{type, "verify-depth", "required"}).set(false);
        node.get(new String[]{type, "certificate-file", "type"}).set(ModelType.STRING);
        node.get(new String[]{type, "certificate-file", "description"}).set(bundle2.getString("web.connector.ssl.certificate-file"));
        node.get(new String[]{type, "certificate-file", "required"}).set(false);
        node.get(new String[]{type, "certificate-file", "expressions-allowed"}).set(true);
        node.get(new String[]{type, "ca-certificate-file", "type"}).set(ModelType.STRING);
        node.get(new String[]{type, "ca-certificate-file", "description"}).set(bundle2.getString("web.connector.ssl.ca-certificate-file"));
        node.get(new String[]{type, "ca-certificate-file", "required"}).set(false);
        node.get(new String[]{type, "ca-certificate-file", "expressions-allowed"}).set(true);
        node.get(new String[]{type, "ca-certificate-password", "type"}).set(ModelType.STRING);
        node.get(new String[]{type, "ca-certificate-password", "description"}).set(bundle2.getString("web.connector.ssl.ca-certificate-file"));
        node.get(new String[]{type, "ca-certificate-password", "required"}).set(false);
        node.get(new String[]{type, "ca-certificate-password", "expressions-allowed"}).set(true);
        node.get(new String[]{type, "ca-revocation-url", "type"}).set(ModelType.STRING);
        node.get(new String[]{type, "ca-revocation-url", "description"}).set(bundle2.getString("web.connector.ssl.ca-revocation-url"));
        node.get(new String[]{type, "ca-revocation-url", "required"}).set(false);
        node.get(new String[]{type, "session-cache-size", "type"}).set(ModelType.STRING);
        node.get(new String[]{type, "session-cache-size", "description"}).set(bundle2.getString("web.connector.ssl.session-cache-size"));
        node.get(new String[]{type, "session-cache-size", "required"}).set(false);
        node.get(new String[]{type, "session-timeout", "type"}).set(ModelType.STRING);
        node.get(new String[]{type, "session-timeout", "description"}).set(bundle2.getString("web.connector.ssl.session-timeout"));
        node.get(new String[]{type, "session-timeout", "required"}).set(false);
        return node;
    }

    static ModelNode getSSLCommonDescription(ModelNode node, String type, ResourceBundle bundle2) {
        node.get("description").set(bundle2.getString("web.connector.ssl"));
        return WebSubsystemDescriptions.addSSLCommonDescription(node, type, bundle2);
    }

    static ModelNode getConnectorAdd(Locale locale) {
        ResourceBundle bundle2 = WebSubsystemDescriptions.getResourceBundle(locale);
        ModelNode node = new ModelNode();
        node.get("operation-name").set("add");
        node.get("description").set(bundle2.getString("web.connector.add"));
        WebSubsystemDescriptions.getConnectorCommonDescription(node, "request-properties", bundle2);
        ModelNode ssl = node.get(new String[]{"request-properties", "ssl"});
        WebSubsystemDescriptions.getSSLCommonDescription(ssl, "value-type", bundle2);
        ssl.get("type").set(ModelType.OBJECT);
        ssl.get("required").set(false);
        return node;
    }

    static ModelNode getConnectorRemove(Locale locale) {
        ResourceBundle bundle2 = WebSubsystemDescriptions.getResourceBundle(locale);
        ModelNode node = new ModelNode();
        node.get("operation-name").set("remove");
        node.get("description").set(bundle2.getString("web.connector.remove"));
        return node;
    }

    static ModelNode getVirtualServerDescription(Locale locale) {
        ResourceBundle bundle2 = WebSubsystemDescriptions.getResourceBundle(locale);
        ModelNode node = new ModelNode();
        node.get("head-comment-allowed").set(true);
        node.get("tail-comment-allowed").set(true);
        return WebSubsystemDescriptions.getVirtualServerCommonDescription(node, "attributes", bundle2);
    }

    static ModelNode getVirtualServerCommonDescription(ModelNode node, String type, ResourceBundle bundle2) {
        node.get("description").set(bundle2.getString("web.virtual-server"));
        node.get(new String[]{type, "name", "type"}).set(ModelType.STRING);
        node.get(new String[]{type, "name", "description"}).set(bundle2.getString("web.virtual-server.name"));
        node.get(new String[]{type, "name", "required"}).set(false);
        node.get(new String[]{type, "name", "nillable"}).set(false);
        node.get(new String[]{type, "alias", "type"}).set(ModelType.LIST);
        node.get(new String[]{type, "alias", "value-type"}).set(ModelType.STRING);
        node.get(new String[]{type, "alias", "description"}).set(bundle2.getString("web.virtual-server.alias"));
        node.get(new String[]{type, "alias", "required"}).set(false);
        node.get(new String[]{type, "alias", "nillable"}).set(true);
        node.get(new String[]{type, "default-web-module", "type"}).set(ModelType.STRING);
        node.get(new String[]{type, "default-web-module", "description"}).set(bundle2.getString("web.virtual-server.default-web-module"));
        node.get(new String[]{type, "default-web-module", "required"}).set(false);
        node.get(new String[]{type, "default-web-module", "default"}).set("ROOT.war");
        node.get(new String[]{type, "enable-welcome-root", "type"}).set(ModelType.BOOLEAN);
        node.get(new String[]{type, "enable-welcome-root", "description"}).set(bundle2.getString("web.virtual-server.enable-welcome-root"));
        node.get(new String[]{type, "enable-welcome-root", "required"}).set(false);
        if ("attributes".equals(type)) {
            node.get(new String[]{"children", "access-log", "description"}).set(bundle2.getString("web.virtual-server.access-log"));
            node.get(new String[]{"children", "access-log", "model-description"}).setEmptyObject();
            node.get(new String[]{"children", "rewrite", "description"}).set(bundle2.getString("web.virtual-server.rewrite"));
            node.get(new String[]{"children", "rewrite", "model-description"}).setEmptyObject();
            node.get(new String[]{"children", "sso", "description"}).set(bundle2.getString("web.virtual-server.sso"));
            node.get(new String[]{"children", "sso", "model-description"}).setEmptyObject();
        }
        return node;
    }

    static ModelNode getSsoCommonDescription(ModelNode node, String type, ResourceBundle bundle2) {
        node.get("description").set(bundle2.getString("web.virtual-server.sso"));
        WebSubsystemDescriptions.addSsoCommonDescription(node, type, bundle2);
        return node;
    }

    static void addSsoCommonDescription(ModelNode node, String type, ResourceBundle bundle2) {
        node.get(new String[]{type, "cache-container", "type"}).set(ModelType.STRING);
        node.get(new String[]{type, "cache-container", "description"}).set(bundle2.getString("web.virtual-server.sso.cache-container"));
        node.get(new String[]{type, "cache-container", "required"}).set(false);
        node.get(new String[]{type, "cache-name", "type"}).set(ModelType.STRING);
        node.get(new String[]{type, "cache-name", "description"}).set(bundle2.getString("web.virtual-server.sso.cache-name"));
        node.get(new String[]{type, "cache-name", "required"}).set(false);
        node.get(new String[]{type, "domain", "type"}).set(ModelType.STRING);
        node.get(new String[]{type, "domain", "description"}).set(bundle2.getString("web.virtual-server.sso.domain"));
        node.get(new String[]{type, "domain", "required"}).set(false);
        node.get(new String[]{type, "reauthenticate", "type"}).set(ModelType.BOOLEAN);
        node.get(new String[]{type, "reauthenticate", "description"}).set(bundle2.getString("web.virtual-server.sso.reauthenticate"));
        node.get(new String[]{type, "reauthenticate", "required"}).set(false);
        node.get(new String[]{type, "reauthenticate", "default"}).set(false);
    }

    static ModelNode getAccessLogCommonDescription(ModelNode node, String type, ResourceBundle bundle2) {
        node.get("description").set(bundle2.getString("web.virtual-server.access-log"));
        WebSubsystemDescriptions.addAccessLogCommonDescription(node, type, bundle2);
        return node;
    }

    static void addAccessLogCommonDescription(ModelNode node, String type, ResourceBundle bundle2) {
        node.get(new String[]{type, "pattern", "type"}).set(ModelType.STRING);
        node.get(new String[]{type, "pattern", "description"}).set(bundle2.getString("web.virtual-server.access-log.pattern"));
        node.get(new String[]{type, "pattern", "required"}).set(false);
        node.get(new String[]{type, "pattern", "default"}).set("common");
        node.get(new String[]{type, "resolve-hosts", "type"}).set(ModelType.BOOLEAN);
        node.get(new String[]{type, "resolve-hosts", "description"}).set(bundle2.getString("web.virtual-server.access-log.resolve-hosts"));
        node.get(new String[]{type, "resolve-hosts", "required"}).set(false);
        node.get(new String[]{type, "resolve-hosts", "default"}).set(false);
        node.get(new String[]{type, "extended", "type"}).set(ModelType.BOOLEAN);
        node.get(new String[]{type, "extended", "description"}).set(bundle2.getString("web.virtual-server.access-log.extended"));
        node.get(new String[]{type, "extended", "required"}).set(false);
        node.get(new String[]{type, "extended", "default"}).set(false);
        node.get(new String[]{type, "prefix", "type"}).set(ModelType.STRING);
        node.get(new String[]{type, "prefix", "description"}).set(bundle2.getString("web.virtual-server.access-log.prefix"));
        node.get(new String[]{type, "prefix", "required"}).set(false);
        node.get(new String[]{type, "rotate", "type"}).set(ModelType.BOOLEAN);
        node.get(new String[]{type, "rotate", "description"}).set(bundle2.getString("web.virtual-server.access-log.rotate"));
        node.get(new String[]{type, "rotate", "required"}).set(false);
        node.get(new String[]{type, "rotate", "default"}).set(true);
        if ("attributes".equals(type)) {
            node.get(new String[]{"children", "directory", "description"}).set(bundle2.getString("web.virtual-server.access-log.directory"));
            node.get(new String[]{"children", "directory", "model-description"});
        }
    }

    static ModelNode getRewriteCommonDescription(ModelNode node, String type, ResourceBundle bundle2) {
        node.get("description").set(bundle2.getString("web.virtual-server.rewrite"));
        WebSubsystemDescriptions.addRewriteCommonDescription(node, type, bundle2);
        if ("attributes".equals(type)) {
            node.get(new String[]{"children", "condition", "description"}).set(bundle2.getString("web.virtual-server.rewrite.condition"));
            node.get(new String[]{"children", "condition", "model-description"});
        }
        return node;
    }

    static void addRewriteCommonDescription(ModelNode node, String type, ResourceBundle bundle2) {
        node.get(new String[]{type, "pattern", "type"}).set(ModelType.STRING);
        node.get(new String[]{type, "pattern", "description"}).set(bundle2.getString("web.virtual-server.rewrite.pattern"));
        node.get(new String[]{type, "pattern", "required"}).set(false);
        node.get(new String[]{type, "substitution", "type"}).set(ModelType.STRING);
        node.get(new String[]{type, "substitution", "description"}).set(bundle2.getString("web.virtual-server.rewrite.substitution"));
        node.get(new String[]{type, "substitution", "required"}).set(false);
        node.get(new String[]{type, "flags", "type"}).set(ModelType.STRING);
        node.get(new String[]{type, "flags", "description"}).set(bundle2.getString("web.virtual-server.rewrite.flags"));
        node.get(new String[]{type, "flags", "required"}).set(false);
    }

    static void addRewriteConditionnCommonDescription(ModelNode node, String type, ResourceBundle bundle2) {
        node.get(new String[]{type, "test", "type"}).set(ModelType.STRING);
        node.get(new String[]{type, "test", "description"}).set(bundle2.getString("web.virtual-server.rewrite.condition.test"));
        node.get(new String[]{type, "test", "required"}).set(false);
        node.get(new String[]{type, "pattern", "type"}).set(ModelType.STRING);
        node.get(new String[]{type, "pattern", "description"}).set(bundle2.getString("web.virtual-server.rewrite.condition.pattern"));
        node.get(new String[]{type, "pattern", "required"}).set(false);
        node.get(new String[]{type, "flags", "type"}).set(ModelType.STRING);
        node.get(new String[]{type, "flags", "description"}).set(bundle2.getString("web.virtual-server.rewrite.condition.flags"));
        node.get(new String[]{type, "flags", "required"}).set(false);
    }

    static ModelNode getVirtualServerAdd(Locale locale) {
        ResourceBundle bundle2 = WebSubsystemDescriptions.getResourceBundle(locale);
        ModelNode node = new ModelNode();
        node.get("operation-name").set("add");
        node.get("description").set(bundle2.getString("web.virtual-server.add"));
        WebSubsystemDescriptions.getVirtualServerCommonDescription(node, "request-properties", bundle2);
        ModelNode accesslog = node.get(new String[]{"request-properties", "access-log"});
        WebSubsystemDescriptions.getAccessLogCommonDescription(accesslog, "value-type", bundle2);
        accesslog.get("required").set(false);
        accesslog.get("type").set(ModelType.OBJECT);
        ModelNode rewrite = node.get(new String[]{"request-properties", "rewrite"});
        WebSubsystemDescriptions.getRewriteCommonDescription(rewrite, "value-type", bundle2);
        rewrite.get("required").set(false);
        rewrite.get("type").set(ModelType.OBJECT);
        ModelNode sso = node.get(new String[]{"request-properties", "sso"});
        WebSubsystemDescriptions.getSsoCommonDescription(sso, "value-type", bundle2);
        sso.get("required").set(false);
        sso.get("type").set(ModelType.OBJECT);
        return node;
    }

    static ModelNode getVirtualServerRemove(Locale locale) {
        ResourceBundle bundle2 = WebSubsystemDescriptions.getResourceBundle(locale);
        ModelNode node = new ModelNode();
        node.get("operation-name").set("remove");
        node.get("description").set(bundle2.getString("web.virtual-server.remove"));
        return node;
    }

    static ModelNode getDeploymentRuntimeDescription(Locale locale) {
        ResourceBundle bundle2 = WebSubsystemDescriptions.getResourceBundle(locale);
        ModelNode node = new ModelNode();
        node.get("description").set(bundle2.getString("web.deployment"));
        node.get("attributes").setEmptyObject();
        node.get("operations");
        node.get(new String[]{"children", "servlet", "description"}).set(bundle2.getString("web.deployment.servlet"));
        node.get(new String[]{"children", "servlet", "min-occurs"}).set(0);
        node.get(new String[]{"children", "servlet", "model-description"});
        return node;
    }

    static ModelNode getDeploymentServletDescription(Locale locale) {
        ResourceBundle bundle2 = WebSubsystemDescriptions.getResourceBundle(locale);
        ModelNode node = new ModelNode();
        node.get("description").set(bundle2.getString("web.deployment.servlet"));
        node.get(new String[]{"attributes", "load-time", "description"}).set(bundle2.getString("web.deployment.servlet.load-time"));
        node.get(new String[]{"attributes", "load-time", "type"}).set(ModelType.LONG);
        node.get(new String[]{"attributes", "max-time", "description"}).set(bundle2.getString("web.deployment.servlet.max-time"));
        node.get(new String[]{"attributes", "max-time", "type"}).set(ModelType.LONG);
        node.get(new String[]{"attributes", "min-time", "description"}).set(bundle2.getString("web.deployment.servlet.min-time"));
        node.get(new String[]{"attributes", "min-time", "type"}).set(ModelType.LONG);
        node.get(new String[]{"attributes", "processing-time", "description"}).set(bundle2.getString("web.deployment.servlet.processing-time"));
        node.get(new String[]{"attributes", "processing-time", "type"}).set(ModelType.LONG);
        node.get(new String[]{"attributes", "request-count", "description"}).set(bundle2.getString("web.deployment.servlet.request-count"));
        node.get(new String[]{"attributes", "request-count", "type"}).set(ModelType.INT);
        node.get("operations");
        node.get("children").setEmptyObject();
        return node;
    }

    public static ModelNode getJspConfigurationDescription(Locale locale) {
        ResourceBundle bundle2 = WebSubsystemDescriptions.getResourceBundle(locale);
        ModelNode node = new ModelNode();
        node.get("description").set(bundle2.getString("web.configuration.jsp"));
        return WebSubsystemDescriptions.getJSPCommonDescription(node, "attributes", bundle2);
    }

    public static ModelNode getJspConfigurationDescription(ModelNode node, String type, ResourceBundle bundle2) {
        node.get("description").set(bundle2.getString("web.configuration.jsp"));
        return WebSubsystemDescriptions.getJSPCommonDescription(node, type, bundle2);
    }

    public static ModelNode getStaticResourceDescription(Locale locale) {
        ResourceBundle bundle2 = WebSubsystemDescriptions.getResourceBundle(locale);
        ModelNode node = new ModelNode();
        node.get("description").set(bundle2.getString("web.configuration.static"));
        return WebSubsystemDescriptions.getStaticResourcesCommonDescription(node, "attributes", bundle2);
    }

    public static ModelNode getStaticResourceDescription(ModelNode node, String type, ResourceBundle bundle2) {
        node.get("description").set(bundle2.getString("web.configuration.static"));
        return WebSubsystemDescriptions.getStaticResourcesCommonDescription(node, type, bundle2);
    }

    private static ResourceBundle getResourceBundle(Locale locale) {
        if (locale == null) {
            locale = Locale.getDefault();
        }
        return ResourceBundle.getBundle(RESOURCE_NAME, locale);
    }

    public static ModelNode getConfigurationDescription(Locale locale) {
        ResourceBundle bundle2 = WebSubsystemDescriptions.getResourceBundle(locale);
        ModelNode node = new ModelNode();
        node.get("description").set(bundle2.getString("web.configuration"));
        node.get(new String[]{"children", "static-resources", "description"}).set(bundle2.getString("web.configuration.static"));
        node.get(new String[]{"children", "static-resources", "model-description"}).setEmptyObject();
        node.get(new String[]{"children", "jsp-configuration", "description"}).set(bundle2.getString("web.configuration.jsp"));
        node.get(new String[]{"children", "jsp-configuration", "model-description"}).setEmptyObject();
        node.get(new String[]{"children", "container", "description"}).set(bundle2.getString("web.configuration.container"));
        node.get(new String[]{"children", "container", "model-description"}).setEmptyObject();
        return node;
    }

    public static ModelNode getContainerDescription(Locale locale) {
        ResourceBundle bundle2 = WebSubsystemDescriptions.getResourceBundle(locale);
        ModelNode node = new ModelNode();
        node.get("description").set(bundle2.getString("web.configuration.container"));
        return node;
    }

    public static ModelNode getMimeMappingAddDescription(Locale locale) {
        ResourceBundle bundle2 = WebSubsystemDescriptions.getResourceBundle(locale);
        ModelNode node = new ModelNode();
        node.get("operation-name").set("add-mime");
        node.get("description").set(bundle2.getString("web.configuration.add-mime"));
        node.get(new String[]{"request-properties", "name", "type"}).set(ModelType.STRING);
        node.get(new String[]{"request-properties", "name", "description"}).set(bundle2.getString("web.configuration.mime-mapping.name"));
        node.get(new String[]{"request-properties", "name", "required"}).set(true);
        node.get(new String[]{"request-properties", "value", "type"}).set(ModelType.STRING);
        node.get(new String[]{"request-properties", "value", "description"}).set(bundle2.getString("web.configuration.mime-mapping.value"));
        node.get(new String[]{"request-properties", "value", "required"}).set(true);
        return node;
    }

    public static ModelNode getMimeMappingRemoveDescription(Locale locale) {
        ResourceBundle bundle2 = WebSubsystemDescriptions.getResourceBundle(locale);
        ModelNode node = new ModelNode();
        node.get("operation-name").set("remove-mime");
        node.get("description").set(bundle2.getString("web.configuration.remove-mime"));
        node.get(new String[]{"request-properties", "name", "type"}).set(ModelType.STRING);
        node.get(new String[]{"request-properties", "name", "description"}).set(bundle2.getString("web.configuration.mime-mapping.name"));
        node.get(new String[]{"request-properties", "name", "required"}).set(true);
        return node;
    }

    public static ModelNode getReWriteDescription(Locale locale) {
        ResourceBundle bundle2 = WebSubsystemDescriptions.getResourceBundle(locale);
        ModelNode node = new ModelNode();
        node.get("description").set(bundle2.getString("web.virtual-server.rewrite"));
        return WebSubsystemDescriptions.getRewriteCommonDescription(node, "attributes", bundle2);
    }

    public static ModelNode getAccessLogDescription(Locale locale) {
        ResourceBundle bundle2 = WebSubsystemDescriptions.getResourceBundle(locale);
        ModelNode node = new ModelNode();
        node.get("description").set(bundle2.getString("web.virtual-server.access-log"));
        return WebSubsystemDescriptions.getAccessLogCommonDescription(node, "attributes", bundle2);
    }

    public static ModelNode getDirectoryDescription(Locale locale) {
        ResourceBundle bundle2 = WebSubsystemDescriptions.getResourceBundle(locale);
        ModelNode node = new ModelNode();
        node.get("description").set(bundle2.getString("web.virtual-server.access-log.directory"));
        return node;
    }

    public static ModelNode getReWriteCondDescription(Locale locale) {
        ResourceBundle bundle2 = WebSubsystemDescriptions.getResourceBundle(locale);
        ModelNode node = new ModelNode();
        node.get("description").set(bundle2.getString("web.virtual-server.rewrite.condition"));
        return node;
    }

    public static ModelNode getAccessLogAdd(Locale locale) {
        ResourceBundle bundle2 = WebSubsystemDescriptions.getResourceBundle(locale);
        ModelNode node = new ModelNode();
        node.get("operation-name").set("add");
        node.get("description").set(bundle2.getString("web.virtual-server.access-log-add"));
        WebSubsystemDescriptions.addAccessLogCommonDescription(node, "request-properties", bundle2);
        return node;
    }

    public static ModelNode getAccessLogRemove(Locale locale) {
        ResourceBundle bundle2 = WebSubsystemDescriptions.getResourceBundle(locale);
        ModelNode node = new ModelNode();
        node.get("operation-name").set("remove");
        node.get("description").set(bundle2.getString("web.virtual-server.access-log-remove"));
        return node;
    }

    public static ModelNode getReWriteRemove(Locale locale) {
        ResourceBundle bundle2 = WebSubsystemDescriptions.getResourceBundle(locale);
        ModelNode node = new ModelNode();
        node.get("operation-name").set("remove");
        node.get("description").set(bundle2.getString("web.virtual-server.rewrite-remove"));
        return node;
    }

    public static ModelNode getReWriteAdd(Locale locale) {
        ResourceBundle bundle2 = WebSubsystemDescriptions.getResourceBundle(locale);
        ModelNode node = new ModelNode();
        node.get("operation-name").set("add");
        node.get("description").set(bundle2.getString("web.virtual-server.rewrite-add"));
        WebSubsystemDescriptions.addRewriteCommonDescription(node, "request-properties", bundle2);
        return node;
    }

    public static ModelNode getReWriteConditionAdd(Locale locale) {
        ResourceBundle bundle2 = WebSubsystemDescriptions.getResourceBundle(locale);
        ModelNode node = new ModelNode();
        node.get("operation-name").set("add");
        node.get("description").set(bundle2.getString("web.virtual-server.rewrite.condition-add"));
        WebSubsystemDescriptions.addRewriteConditionnCommonDescription(node, "request-properties", bundle2);
        return node;
    }

    public static ModelNode getReWriteConditionRemove(Locale locale) {
        ResourceBundle bundle2 = WebSubsystemDescriptions.getResourceBundle(locale);
        ModelNode node = new ModelNode();
        node.get("operation-name").set("remove");
        node.get("description").set(bundle2.getString("web.virtual-server.rewrite.condition-remove"));
        return node;
    }

    public static ModelNode getSSLDescription(Locale locale) {
        ResourceBundle bundle2 = WebSubsystemDescriptions.getResourceBundle(locale);
        ModelNode node = new ModelNode();
        return WebSubsystemDescriptions.getSSLCommonDescription(node, "attributes", bundle2);
    }

    public static ModelNode getSSODescription(Locale locale) {
        ResourceBundle bundle2 = WebSubsystemDescriptions.getResourceBundle(locale);
        ModelNode node = new ModelNode();
        node.get("description").set(bundle2.getString("web.virtual-server.sso"));
        return node;
    }

    public static ModelNode getSSOAdd(Locale locale) {
        ResourceBundle bundle2 = WebSubsystemDescriptions.getResourceBundle(locale);
        ModelNode node = new ModelNode();
        node.get("operation-name").set("add");
        node.get("description").set(bundle2.getString("web.virtual-server.sso-add"));
        WebSubsystemDescriptions.addSsoCommonDescription(node, "request-properties", bundle2);
        return node;
    }

    public static ModelNode getSSORemove(Locale locale) {
        ResourceBundle bundle2 = WebSubsystemDescriptions.getResourceBundle(locale);
        ModelNode node = new ModelNode();
        node.get("operation-name").set("remove");
        node.get("description").set(bundle2.getString("web.virtual-server.sso-remove"));
        return node;
    }

    public static ModelNode getSSLAdd(Locale locale) {
        ResourceBundle bundle2 = WebSubsystemDescriptions.getResourceBundle(locale);
        ModelNode node = new ModelNode();
        node.get("operation-name").set("add");
        node.get("description").set(bundle2.getString("web.connector.ssl-add"));
        WebSubsystemDescriptions.addSSLCommonDescription(node, "request-properties", bundle2);
        return node;
    }

    public static ModelNode getSSLRemove(Locale locale) {
        ResourceBundle bundle2 = WebSubsystemDescriptions.getResourceBundle(locale);
        ModelNode node = new ModelNode();
        node.get("operation-name").set("remove");
        node.get("description").set(bundle2.getString("web.connector.ssl-remove"));
        return node;
    }
}

