/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.osgi.repository.core;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.jboss.logging.Logger;
import org.jboss.osgi.repository.RepositoryResolutionException;
import org.jboss.osgi.repository.RepositoryStorageException;
import org.jboss.osgi.repository.spi.AbstractRepositoryCachePlugin;
import org.jboss.osgi.resolver.v2.MavenCoordinates;
import org.jboss.osgi.resolver.v2.XIdentityCapability;
import org.jboss.osgi.resolver.v2.XResource;
import org.jboss.osgi.resolver.v2.XResourceBuilder;
import org.osgi.framework.resource.Capability;
import org.osgi.framework.resource.Requirement;
import org.osgi.framework.resource.Resource;

public class FileBasedRepositoryCachePlugin
extends AbstractRepositoryCachePlugin {
    private static Logger log = Logger.getLogger(FileBasedRepositoryCachePlugin.class);
    private final File repository;

    public FileBasedRepositoryCachePlugin(File repository) {
        this.repository = repository;
    }

    public Collection<Capability> findProviders(Requirement req) {
        String namespace = req.getNamespace();
        if (!"maven.identity".equals(namespace)) {
            return Collections.emptySet();
        }
        String mavenId = (String)req.getAttributes().get("maven.identity");
        MavenCoordinates coordinates = MavenCoordinates.parse((String)mavenId);
        try {
            ArrayList<XIdentityCapability> result = new ArrayList<XIdentityCapability>();
            URL baseURL = this.repository.toURI().toURL();
            URL url = coordinates.toArtifactURL(baseURL);
            if (new File(url.getPath()).exists()) {
                String contentPath = url.toExternalForm();
                contentPath = contentPath.substring(baseURL.toExternalForm().length());
                XResource resource = XResourceBuilder.create((URL)baseURL, (String)contentPath).getResource();
                result.add(resource.getIdentityCapability());
            }
            return Collections.unmodifiableList(result);
        }
        catch (Exception ex) {
            throw new RepositoryResolutionException((Throwable)ex);
        }
    }

    public Collection<Capability> storeCapabilities(Collection<Capability> caps) throws RepositoryStorageException {
        ArrayList<XIdentityCapability> result = new ArrayList<XIdentityCapability>(caps.size());
        for (Capability cap : caps) {
            XIdentityCapability icap = (XIdentityCapability)cap;
            String contentPath = (String)icap.getAttribute("content.path");
            if (contentPath == null) continue;
            File contentFile = new File(this.repository.getAbsolutePath() + File.separator + contentPath);
            try {
                this.copyResourceContent(cap.getResource(), contentFile);
                XIdentityCapability newid = this.recreateIdentity(contentFile);
                result.add(newid);
            }
            catch (IOException ex) {
                new RepositoryStorageException((Throwable)ex);
            }
        }
        return Collections.unmodifiableList(result);
    }

    private XIdentityCapability recreateIdentity(File contentFile) throws IOException {
        URL baseURL = this.repository.toURI().toURL();
        String contentPath = contentFile.getPath().substring(this.repository.getAbsolutePath().length() + 1);
        XResourceBuilder builder = XResourceBuilder.create((URL)baseURL, (String)contentPath);
        return builder.getResource().getIdentityCapability();
    }

    private void copyResourceContent(Resource resource, File contentFile) throws IOException {
        int len = 0;
        byte[] buf = new byte[4096];
        contentFile.getParentFile().mkdirs();
        InputStream in = resource.getContent();
        FileOutputStream out = new FileOutputStream(contentFile);
        while ((len = in.read(buf)) >= 0) {
            ((OutputStream)out).write(buf, 0, len);
        }
        in.close();
        ((OutputStream)out).close();
    }
}

