/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb.client;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.jboss.ejb.client.ClusterNodeManager;
import org.jboss.ejb.client.ClusterNodeSelector;
import org.jboss.ejb.client.DaemonThreadFactory;
import org.jboss.ejb.client.EJBClientConfiguration;
import org.jboss.ejb.client.EJBClientContext;
import org.jboss.ejb.client.EJBReceiver;
import org.jboss.ejb.client.EJBReceiverContext;
import org.jboss.ejb.client.RandomClusterNodeSelector;
import org.jboss.logging.Logger;

public final class ClusterContext
implements EJBClientContext.EJBReceiverContextCloseHandler {
    private static final Logger logger = Logger.getLogger(ClusterContext.class);
    private static final ExecutorService executorService = Executors.newCachedThreadPool(new DaemonThreadFactory("ejb-client-cluster-node-connection-creation"));
    private final String clusterName;
    private final EJBClientContext clientContext;
    private final Map<String, ClusterNodeManager> nodeManagers = Collections.synchronizedMap(new HashMap());
    private long maxClusterNodeOpenConnections = 10L;
    private ClusterNodeSelector clusterNodeSelector = new RandomClusterNodeSelector();
    private final Set<String> connectedNodes = Collections.synchronizedSet(new HashSet());

    ClusterContext(String clusterName, EJBClientContext clientContext, EJBClientConfiguration ejbClientConfiguration) {
        this.clusterName = clusterName;
        this.clientContext = clientContext;
        if (ejbClientConfiguration != null && ejbClientConfiguration.getClusterConfiguration(this.clusterName) != null) {
            EJBClientConfiguration.ClusterConfiguration clusterConfiguration = ejbClientConfiguration.getClusterConfiguration(this.clusterName);
            this.setupClusterSpecificConfigurations(clusterConfiguration);
        } else {
            this.maxClusterNodeOpenConnections = 10L;
        }
    }

    public String getClusterName() {
        return this.clusterName;
    }

    public EJBClientContext getEJBClientContext() {
        return this.clientContext;
    }

    EJBReceiverContext requireEJBReceiverContext() throws IllegalArgumentException {
        EJBReceiverContext ejbReceiverContext = this.getEJBReceiverContext();
        if (ejbReceiverContext == null) {
            throw new IllegalStateException("No EJB receiver contexts available in cluster " + this.clusterName);
        }
        return ejbReceiverContext;
    }

    EJBReceiverContext getEJBReceiverContext() {
        if (this.nodeManagers.isEmpty()) {
            return null;
        }
        Set<String> availableNodes = this.nodeManagers.keySet();
        String selectedNodeName = this.clusterNodeSelector.selectNode(this.clusterName, this.connectedNodes.toArray(new String[this.connectedNodes.size()]), availableNodes.toArray(new String[availableNodes.size()]));
        if (selectedNodeName == null || !this.nodeManagers.containsKey(selectedNodeName)) {
            logger.warn((Object)(this.clusterNodeSelector + " selected an invalid node name: " + selectedNodeName + " for cluster: " + this.clusterName + ". No EJB receiver context can be selected"));
            return null;
        }
        logger.debug((Object)(this.clusterNodeSelector + " has selected node " + selectedNodeName + ", in cluster " + this.clusterName));
        EJBReceiverContext selectedNodeReceiverContext = this.clientContext.getNodeEJBReceiverContext(selectedNodeName);
        if (selectedNodeReceiverContext != null) {
            return selectedNodeReceiverContext;
        }
        ClusterNodeManager clusterNodeManager = this.nodeManagers.get(selectedNodeName);
        if (clusterNodeManager == null) {
            logger.error((Object)("Cannot create EJBReceiver since no cluster node manager found for node " + selectedNodeName + " in cluster context for cluster " + this.clusterName));
            return null;
        }
        EJBReceiver ejbReceiver = clusterNodeManager.getEJBReceiver();
        if (ejbReceiver == null) {
            return null;
        }
        this.registerEJBReceiver(ejbReceiver);
        return this.clientContext.getNodeEJBReceiverContext(selectedNodeName);
    }

    boolean isNodeAvailable(String nodeName) {
        if (nodeName == null) {
            return false;
        }
        return this.nodeManagers.containsKey(nodeName);
    }

    public void addClusterNode(String nodeName, ClusterNodeManager clusterNodeManager) {
        this.nodeManagers.put(nodeName, clusterNodeManager);
        if (!this.connectedNodes.contains(nodeName) && (long)this.connectedNodes.size() < this.maxClusterNodeOpenConnections) {
            executorService.submit(new EJBReceiverAssociationTask(this, nodeName));
        }
    }

    public void removeClusterNode(String nodeName) {
        this.nodeManagers.remove(nodeName);
        this.connectedNodes.remove(nodeName);
    }

    public void removeAllClusterNodes() {
        this.nodeManagers.clear();
        this.connectedNodes.clear();
    }

    void close() {
        this.removeAllClusterNodes();
    }

    public void registerEJBReceiver(EJBReceiver receiver) {
        if (receiver == null) {
            throw new IllegalArgumentException("receiver is null");
        }
        String nodeName = receiver.getNodeName();
        if (this.connectedNodes.contains(nodeName)) {
            return;
        }
        this.clientContext.registerEJBReceiver(receiver, this);
        EJBReceiverContext ejbReceiverContext = this.clientContext.getNodeEJBReceiverContext(nodeName);
        if (ejbReceiverContext != null) {
            this.connectedNodes.add(nodeName);
            logger.info((Object)("Added a new EJB receiver in cluster context " + this.clusterName + " for node " + nodeName + ". Total nodes in cluster context = " + this.connectedNodes.size()));
        }
    }

    private void setupClusterSpecificConfigurations(EJBClientConfiguration.ClusterConfiguration clusterConfiguration) {
        ClusterNodeSelector nodeSelector;
        long maxLimit = clusterConfiguration.getMaximumAllowedConnectedNodes();
        if (maxLimit > 0L) {
            this.maxClusterNodeOpenConnections = maxLimit;
        }
        if ((nodeSelector = clusterConfiguration.getClusterNodeSelector()) != null) {
            this.clusterNodeSelector = nodeSelector;
        }
    }

    @Override
    public void receiverContextClosed(EJBReceiverContext receiverContext) {
        String nodeName = receiverContext.getReceiver().getNodeName();
        this.connectedNodes.remove(nodeName);
    }

    private class EJBReceiverAssociationTask
    implements Runnable {
        private final ClusterContext clusterContext;
        private final String nodeName;

        EJBReceiverAssociationTask(ClusterContext clusterContext2, String nodeName) {
            this.nodeName = nodeName;
            this.clusterContext = clusterContext2;
        }

        @Override
        public void run() {
            ClusterNodeManager clusterNodeManager = (ClusterNodeManager)this.clusterContext.nodeManagers.get(this.nodeName);
            if (clusterNodeManager == null) {
                logger.error((Object)("Cannot create EJBReceiver since no cluster node manager found for node " + this.nodeName + " in cluster context for cluster " + ClusterContext.this.clusterName));
                return;
            }
            EJBReceiver ejbReceiver = clusterNodeManager.getEJBReceiver();
            if (ejbReceiver == null) {
                return;
            }
            this.clusterContext.registerEJBReceiver(ejbReceiver);
        }
    }
}

