/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.identity.federation.api.soap;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.net.URL;
import javax.xml.soap.SOAPConnection;
import javax.xml.soap.SOAPConnectionFactory;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPMessage;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLStreamWriter;
import org.apache.log4j.Logger;
import org.jboss.security.xacml.core.model.context.DecisionType;
import org.jboss.security.xacml.core.model.context.RequestType;
import org.jboss.security.xacml.core.model.context.ResultType;
import org.picketlink.identity.federation.core.exceptions.ConfigurationException;
import org.picketlink.identity.federation.core.exceptions.ParsingException;
import org.picketlink.identity.federation.core.exceptions.ProcessingException;
import org.picketlink.identity.federation.core.parsers.saml.SAMLResponseParser;
import org.picketlink.identity.federation.core.parsers.util.StaxParserUtil;
import org.picketlink.identity.federation.core.saml.v2.common.IDGenerator;
import org.picketlink.identity.federation.core.saml.v2.constants.JBossSAMLConstants;
import org.picketlink.identity.federation.core.saml.v2.util.DocumentUtil;
import org.picketlink.identity.federation.core.saml.v2.util.XMLTimeUtil;
import org.picketlink.identity.federation.core.saml.v2.writers.SAMLRequestWriter;
import org.picketlink.identity.federation.core.util.SOAPUtil;
import org.picketlink.identity.federation.core.util.StaxUtil;
import org.picketlink.identity.federation.saml.v2.assertion.AssertionType;
import org.picketlink.identity.federation.saml.v2.assertion.NameIDType;
import org.picketlink.identity.federation.saml.v2.profiles.xacml.assertion.XACMLAuthzDecisionStatementType;
import org.picketlink.identity.federation.saml.v2.protocol.ResponseType;
import org.picketlink.identity.federation.saml.v2.protocol.XACMLAuthzDecisionQueryType;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class SOAPSAMLXACML {
    protected Logger log = Logger.getLogger(SOAPSAMLXACML.class);

    public Result send(String endpoint, String issuer, RequestType xacmlRequest) throws ProcessingException, SOAPException, ParsingException {
        try {
            String id = IDGenerator.create("ID_");
            XACMLAuthzDecisionQueryType queryType = new XACMLAuthzDecisionQueryType(id, XMLTimeUtil.getIssueInstant());
            queryType.setRequest(xacmlRequest);
            NameIDType nameIDType = new NameIDType();
            nameIDType.setValue(issuer);
            queryType.setIssuer(nameIDType);
            SOAPMessage soapMessage = SOAPUtil.create();
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            XMLStreamWriter xmlStreamWriter = StaxUtil.getXMLStreamWriter(baos);
            SAMLRequestWriter samlRequestWriter = new SAMLRequestWriter(xmlStreamWriter);
            samlRequestWriter.write(queryType);
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Sending::" + new String(baos.toByteArray())));
            }
            Document reqDocument = DocumentUtil.getDocument(new ByteArrayInputStream(baos.toByteArray()));
            soapMessage.getSOAPBody().addDocument(reqDocument);
            SOAPConnectionFactory connectFactory = SOAPConnectionFactory.newInstance();
            SOAPConnection connection = connectFactory.createConnection();
            URL url = new URL(endpoint);
            SOAPMessage response = connection.call(soapMessage, (Object)url);
            NodeList nl = response.getSOAPBody().getChildNodes();
            Node node = null;
            int length = nl != null ? nl.getLength() : 0;
            for (int i = 0; i < length; ++i) {
                Node n = nl.item(i);
                String localName = n.getLocalName();
                if (!localName.contains(JBossSAMLConstants.RESPONSE.get())) continue;
                node = n;
                break;
            }
            if (node == null) {
                throw new RuntimeException("PL00092: Null Value:Did not find Response node");
            }
            XMLEventReader xmlEventReader = StaxParserUtil.getXMLEventReader(DocumentUtil.getNodeAsStream(node));
            SAMLResponseParser samlResponseParser = new SAMLResponseParser();
            ResponseType responseType = (ResponseType)samlResponseParser.parse(xmlEventReader);
            AssertionType at = responseType.getAssertions().get(0).getAssertion();
            XACMLAuthzDecisionStatementType xst = (XACMLAuthzDecisionStatementType)at.getStatements().iterator().next();
            ResultType rt = (ResultType)xst.getResponse().getResult().get(0);
            DecisionType dt = rt.getDecision();
            return new Result(dt, null);
        }
        catch (IOException e) {
            throw new ProcessingException(e);
        }
        catch (ConfigurationException e) {
            throw new ProcessingException(e);
        }
    }

    public static class Result {
        private Element fault = null;
        private final DecisionType decisionType;

        Result(DecisionType decision, Element fault) {
            this.decisionType = decision;
            this.fault = fault;
        }

        public boolean isResponseAvailable() {
            return this.decisionType != null;
        }

        public boolean isFault() {
            return this.fault != null;
        }

        public DecisionType getDecision() {
            return this.decisionType;
        }

        public Element getFault() {
            return this.fault;
        }

        public boolean isPermit() {
            return this.decisionType == DecisionType.PERMIT;
        }

        public boolean isDeny() {
            return this.decisionType == DecisionType.DENY;
        }
    }
}

