/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.common;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.util.ResourceBundle;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.jboss.logging.Logger;
import org.jboss.ws.api.util.BundleUtils;
import org.jboss.ws.common.DOMWriter;
import org.jboss.ws.common.SecurityActions;
import org.jboss.ws.common.utils.JBossWSEntityResolver;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public final class DOMUtils
extends org.jboss.ws.api.util.DOMUtils {
    private static final ResourceBundle bundle = BundleUtils.getBundle(DOMUtils.class);
    private static Logger log = Logger.getLogger(DOMUtils.class);
    private static final String DISABLE_DEFERRED_NODE_EXPANSION = "org.jboss.ws.disable_deferred_node_expansion";
    private static final String DEFER_NODE_EXPANSION_FEATURE = "http://apache.org/xml/features/dom/defer-node-expansion";
    private static final String ENABLE_DOCTYPE_DECL = "org.jboss.ws.enable_doctype_decl";
    private static final String DISALLOW_DOCTYPE_DECL_FEATURE = "http://apache.org/xml/features/disallow-doctype-decl";
    private static String documentBuilderFactoryName;
    private static DocumentBuilderFactory documentBuilderFactory;
    private static final boolean alwaysResolveFactoryName;
    private static final boolean disableDeferedNodeExpansion;
    private static final boolean enableDoctypeDeclaration;
    private static ThreadLocal<Document> documentThreadLocal;
    private static ThreadLocal<DocumentBuilder> builderThreadLocal;

    private static void setEntityResolver(DocumentBuilder builder) {
        Object entityResolver = null;
        try {
            entityResolver = new JBossWSEntityResolver();
        }
        catch (Throwable t) {
            boolean debugEnabled = log.isDebugEnabled();
            if (debugEnabled) {
                log.debug((Object)"Cannot load JBossWSEntityResolver");
            }
            String[] resolvers = new String[]{"org.jboss.util.xml.JBossEntityResolver"};
            ClassLoader loader = SecurityActions.getContextClassLoader();
            for (String resolver : resolvers) {
                try {
                    Class<?> resolverClass = SecurityActions.loadClass(loader, resolver);
                    entityResolver = (EntityResolver)resolverClass.newInstance();
                    break;
                }
                catch (Exception ex) {
                    if (!debugEnabled) continue;
                    log.debug((Object)("Cannot load: " + resolver));
                }
            }
        }
        if (entityResolver != null) {
            builder.setEntityResolver((EntityResolver)entityResolver);
        }
    }

    private static void initializeFactory(DocumentBuilderFactory factory) {
        factory.setValidating(false);
        factory.setNamespaceAware(true);
        factory.setExpandEntityReferences(false);
        try {
            factory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
            if (disableDeferedNodeExpansion) {
                factory.setFeature(DEFER_NODE_EXPANSION_FEATURE, false);
            }
            if (!enableDoctypeDeclaration) {
                factory.setFeature(DISALLOW_DOCTYPE_DECL_FEATURE, true);
            }
        }
        catch (ParserConfigurationException pce) {
            log.error((Object)pce);
        }
    }

    public static void clearThreadLocals() {
        documentThreadLocal.remove();
        builderThreadLocal.remove();
    }

    private DOMUtils() {
    }

    public static DocumentBuilder newDocumentBuilder(DocumentBuilderFactory factory) {
        try {
            DocumentBuilder builder = factory.newDocumentBuilder();
            DOMUtils.setEntityResolver(builder);
            return builder;
        }
        catch (Exception e) {
            throw new RuntimeException(BundleUtils.getMessage((ResourceBundle)bundle, (String)"UNABLE_TO_CREATE_DOCUMENT_BUILDER", (Object[])new Object[0]), e);
        }
    }

    public static DocumentBuilder getDocumentBuilder() {
        return builderThreadLocal.get();
    }

    public static Element parse(String xmlString) throws IOException {
        try {
            return DOMUtils.parse(new ByteArrayInputStream(xmlString.getBytes("UTF-8")));
        }
        catch (IOException e) {
            log.error((Object)BundleUtils.getMessage((ResourceBundle)bundle, (String)"CANNOT_PARSE", (Object[])new Object[]{xmlString}));
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Element parse(InputStream xmlStream, DocumentBuilder builder) throws IOException {
        try {
            Document doc;
            Object object = builder;
            synchronized (object) {
                doc = builder.parse(xmlStream);
            }
            object = doc.getDocumentElement();
            return object;
        }
        catch (SAXException se) {
            throw new IOException(se.toString());
        }
        finally {
            xmlStream.close();
        }
    }

    public static Element parse(InputStream xmlStream) throws IOException {
        DocumentBuilder builder = DOMUtils.getDocumentBuilder();
        return DOMUtils.parse(xmlStream, builder);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Element parse(InputSource source) throws IOException {
        try {
            Document doc;
            DocumentBuilder builder = DOMUtils.getDocumentBuilder();
            Object object = builder;
            synchronized (object) {
                doc = builder.parse(source);
            }
            object = doc.getDocumentElement();
            return object;
        }
        catch (SAXException se) {
            throw new IOException(se.toString());
        }
        finally {
            Reader r;
            InputStream is = source.getByteStream();
            if (is != null) {
                is.close();
            }
            if ((r = source.getCharacterStream()) != null) {
                r.close();
            }
        }
    }

    public static Element createElement(String localPart) {
        Document doc = DOMUtils.getOwnerDocument();
        if (log.isTraceEnabled()) {
            log.trace((Object)("createElement {}" + localPart));
        }
        return doc.createElement(localPart);
    }

    public static Element createElement(String localPart, String prefix) {
        Document doc = DOMUtils.getOwnerDocument();
        if (log.isTraceEnabled()) {
            log.trace((Object)("createElement {}" + prefix + ":" + localPart));
        }
        return doc.createElement(prefix + ":" + localPart);
    }

    public static Element createElement(String localPart, String prefix, String uri) {
        Document doc = DOMUtils.getOwnerDocument();
        if (prefix == null || prefix.length() == 0) {
            if (log.isTraceEnabled()) {
                log.trace((Object)("createElement {" + uri + "}" + localPart));
            }
            return doc.createElementNS(uri, localPart);
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)("createElement {" + uri + "}" + prefix + ":" + localPart));
        }
        return doc.createElementNS(uri, prefix + ":" + localPart);
    }

    public static Element createElement(QName qname) {
        return DOMUtils.createElement(qname.getLocalPart(), qname.getPrefix(), qname.getNamespaceURI());
    }

    public static Text createTextNode(String value) {
        Document doc = DOMUtils.getOwnerDocument();
        return doc.createTextNode(value);
    }

    public static Document peekOwnerDocument() {
        return documentThreadLocal.get();
    }

    public static void setOwnerDocument(Document doc) {
        documentThreadLocal.set(doc);
    }

    public static Document getOwnerDocument() {
        Document doc = documentThreadLocal.get();
        if (doc == null) {
            doc = DOMUtils.getDocumentBuilder().newDocument();
            documentThreadLocal.set(doc);
        }
        return doc;
    }

    public static Element sourceToElement(Source source) throws IOException {
        Element retElement = null;
        if (source instanceof StreamSource) {
            Reader reader;
            StreamSource streamSource = (StreamSource)source;
            InputStream ins = streamSource.getInputStream();
            if (ins != null) {
                retElement = DOMUtils.parse(ins);
            }
            if ((reader = streamSource.getReader()) != null) {
                retElement = DOMUtils.parse(new InputSource(reader));
            }
        } else if (source instanceof DOMSource) {
            DOMSource domSource = (DOMSource)source;
            Node node = domSource.getNode();
            if (node instanceof Element) {
                retElement = (Element)node;
            } else if (node instanceof Document) {
                retElement = ((Document)node).getDocumentElement();
            }
        } else if (source instanceof SAXSource) {
            boolean hasXMLReader;
            boolean hasInputSource = ((SAXSource)source).getInputSource() != null;
            boolean bl = hasXMLReader = ((SAXSource)source).getXMLReader() != null;
            if (hasInputSource || hasXMLReader) {
                try {
                    TransformerFactory tf = TransformerFactory.newInstance();
                    ByteArrayOutputStream baos = new ByteArrayOutputStream(1024);
                    Transformer transformer = tf.newTransformer();
                    transformer.setOutputProperty("omit-xml-declaration", "yes");
                    transformer.setOutputProperty("method", "xml");
                    transformer.transform(source, new StreamResult(baos));
                    retElement = DOMUtils.parse(new ByteArrayInputStream(baos.toByteArray()));
                }
                catch (TransformerException ex) {
                    throw new IOException(ex);
                }
            }
        } else {
            throw new RuntimeException(BundleUtils.getMessage((ResourceBundle)bundle, (String)"SOURCE_TYPE_NOT_IMPLEMENTED", (Object[])new Object[]{source.getClass()}));
        }
        return retElement;
    }

    public static String node2String(Node node) throws UnsupportedEncodingException {
        return DOMUtils.node2String(node, true, "UTF-8");
    }

    public static String node2String(Node node, boolean prettyPrint) throws UnsupportedEncodingException {
        return DOMUtils.node2String(node, prettyPrint, "UTF-8");
    }

    public static String node2String(Node node, boolean prettyPrint, String encoding) throws UnsupportedEncodingException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        new DOMWriter(new PrintWriter(baos), encoding).setPrettyprint(prettyPrint).print(node);
        return baos.toString(encoding);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        alwaysResolveFactoryName = Boolean.getBoolean("org.jboss.ws.alwaysResolveDocumentBuilderFactory");
        disableDeferedNodeExpansion = Boolean.getBoolean(DISABLE_DEFERRED_NODE_EXPANSION);
        enableDoctypeDeclaration = Boolean.getBoolean(ENABLE_DOCTYPE_DECL);
        ClassLoader classLoader = SecurityActions.getContextClassLoader();
        SecurityActions.setContextClassLoader(DOMUtils.class.getClassLoader());
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DOMUtils.initializeFactory(factory);
            documentBuilderFactoryName = factory.getClass().getCanonicalName();
            documentBuilderFactory = factory;
        }
        finally {
            SecurityActions.setContextClassLoader(classLoader);
        }
        documentThreadLocal = new ThreadLocal();
        builderThreadLocal = new ThreadLocal<DocumentBuilder>(){

            @Override
            protected DocumentBuilder initialValue() {
                try {
                    DocumentBuilderFactory threadFactory;
                    DocumentBuilderFactory factory = null;
                    factory = alwaysResolveFactoryName ? DocumentBuilderFactory.newInstance() : DocumentBuilderFactory.newInstance(documentBuilderFactoryName, SecurityActions.getContextClassLoader());
                    if (factory.getClass().getClassLoader() == documentBuilderFactory.getClass().getClassLoader() && (!alwaysResolveFactoryName || documentBuilderFactoryName.equals(factory.getClass().getCanonicalName()))) {
                        threadFactory = documentBuilderFactory;
                    } else {
                        threadFactory = factory;
                        DOMUtils.initializeFactory(threadFactory);
                    }
                    DocumentBuilder builder = threadFactory.newDocumentBuilder();
                    DOMUtils.setEntityResolver(builder);
                    return builder;
                }
                catch (Exception e) {
                    throw new RuntimeException(BundleUtils.getMessage((ResourceBundle)bundle, (String)"UNABLE_TO_CREATE_DOCUMENT_BUILDER", (Object[])new Object[0]), e);
                }
            }
        };
    }
}

