/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.domain.controller.operations.coordination;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.ProxyController;
import org.jboss.as.controller.descriptions.common.InterfaceDescription;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.domain.controller.DomainControllerLogger;
import org.jboss.as.domain.controller.DomainControllerMessages;
import org.jboss.as.domain.controller.ServerIdentity;
import org.jboss.as.domain.controller.operations.coordination.DomainServerUtils;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.Property;

public class ServerOperationResolver {
    public static OperationContext.AttachmentKey<Set<ModelNode>> DONT_PROPAGATE_TO_SERVERS_ATTACHMENT = OperationContext.AttachmentKey.create(Set.class);
    private final String localHostName;
    private final Map<String, ProxyController> serverProxies;

    public ServerOperationResolver(String localHostName, Map<String, ProxyController> serverProxies) {
        this.localHostName = localHostName;
        this.serverProxies = serverProxies;
    }

    public static synchronized void addToDontPropagateToServersAttachment(OperationContext context, ModelNode op) {
        HashSet<ModelNode> ops = (HashSet<ModelNode>)context.getAttachment(DONT_PROPAGATE_TO_SERVERS_ATTACHMENT);
        if (ops == null) {
            ops = new HashSet<ModelNode>();
            context.attach(DONT_PROPAGATE_TO_SERVERS_ATTACHMENT, ops);
        }
        ops.add(op);
    }

    public Map<Set<ServerIdentity>, ModelNode> getServerOperations(OperationContext context, ModelNode operation, PathAddress address) {
        Set dontPropagate;
        if (DomainControllerLogger.HOST_CONTROLLER_LOGGER.isTraceEnabled()) {
            DomainControllerLogger.HOST_CONTROLLER_LOGGER.tracef("Resolving %s", operation);
        }
        if ((dontPropagate = (Set)context.getAttachment(DONT_PROPAGATE_TO_SERVERS_ATTACHMENT)) != null && dontPropagate.contains(operation)) {
            return Collections.emptyMap();
        }
        ModelNode domain = Resource.Tools.readModel((Resource)context.getRootResource());
        ModelNode host = domain.get(new String[]{"host", this.localHostName});
        if (address.size() == 0) {
            return this.resolveDomainRootOperation(operation, domain, host);
        }
        DomainKey domainKey = DomainKey.forName(address.getElement(0).getKey());
        switch (domainKey) {
            case EXTENSION: {
                Set<ServerIdentity> allServers = DomainServerUtils.getAllRunningServers(host, this.localHostName, this.serverProxies);
                return Collections.singletonMap(allServers, operation);
            }
            case DEPLOYMENT: {
                return Collections.emptyMap();
            }
            case PATH: {
                return this.getServerPathOperations(operation, address, host, true);
            }
            case SYSTEM_PROPERTY: {
                return this.getServerSystemPropertyOperations(operation, address, Level.DOMAIN, domain, null, host);
            }
            case PROFILE: {
                return this.getServerProfileOperations(operation, address, domain, host);
            }
            case INTERFACE: {
                return this.getServerInterfaceOperations(operation, address, host, true);
            }
            case SOCKET_BINDING_GROUP: {
                return this.getServerSocketBindingGroupOperations(operation, address, domain, host);
            }
            case SERVER_GROUP: {
                return this.getServerGroupOperations(operation, address, domain, host);
            }
            case MANAGMENT_CLIENT_CONTENT: {
                return Collections.emptyMap();
            }
            case HOST: {
                return this.getServerHostOperations(operation, address, domain, host);
            }
        }
        throw DomainControllerMessages.MESSAGES.unexpectedInitialPathKey(address.getElement(0).getKey());
    }

    private Map<Set<ServerIdentity>, ModelNode> getServerProfileOperations(ModelNode operation, PathAddress address, ModelNode domain, ModelNode host) {
        if (address.size() == 1) {
            return Collections.emptyMap();
        }
        String profileName = address.getElement(0).getValue();
        Set<String> relatedProfiles = DomainServerUtils.getRelatedElements("profile", profileName, domain);
        HashSet<ServerIdentity> allServers = new HashSet<ServerIdentity>();
        for (String profile : relatedProfiles) {
            allServers.addAll(DomainServerUtils.getServersForType("profile", profile, domain, host, this.localHostName, this.serverProxies));
        }
        ModelNode serverOp = operation.clone();
        PathAddress serverAddress = address.subAddress(1);
        serverOp.get("address").set(serverAddress.toModelNode());
        return Collections.singletonMap(allServers, serverOp);
    }

    private Map<Set<ServerIdentity>, ModelNode> getServerInterfaceOperations(ModelNode operation, PathAddress address, ModelNode hostModel, boolean forDomain) {
        Map<Set<ServerIdentity>, Object> result;
        String pathName = address.getElement(0).getValue();
        if (forDomain && hostModel.hasDefined("interface") && hostModel.get("interface").keys().contains(pathName)) {
            result = Collections.emptyMap();
        } else if (forDomain && "add".equals(operation.get("operation").asString()) && InterfaceDescription.isOperationDefined((ModelNode)operation)) {
            result = Collections.emptyMap();
        } else if (hostModel.hasDefined("server-config")) {
            HashSet<ServerIdentity> servers = new HashSet<ServerIdentity>();
            for (Property prop : hostModel.get("server-config").asPropertyList()) {
                String serverName = prop.getName();
                if (this.serverProxies.get(serverName) == null) continue;
                ModelNode server = prop.getValue();
                String serverGroupName = server.require("group").asString();
                if (server.hasDefined("interface") && server.get("interface").keys().contains(pathName)) continue;
                ServerIdentity groupedServer = new ServerIdentity(this.localHostName, serverGroupName, serverName);
                servers.add(groupedServer);
            }
            ModelNode serverOp = operation.clone();
            serverOp.get("address").setEmptyList().add("interface", pathName);
            result = Collections.singletonMap(servers, serverOp);
        } else {
            result = Collections.emptyMap();
        }
        return result;
    }

    private Map<Set<ServerIdentity>, ModelNode> getServerPathOperations(ModelNode operation, PathAddress address, ModelNode hostModel, boolean forDomain) {
        Map<Set<ServerIdentity>, ModelNode> result;
        String pathName = address.getElement(0).getValue();
        if (forDomain && hostModel.hasDefined("path") && hostModel.get("path").keys().contains(pathName)) {
            result = Collections.emptyMap();
        } else if ("add".equals(operation.get("operation").asString()) && !operation.hasDefined("path")) {
            result = Collections.emptyMap();
        } else if (hostModel.hasDefined("server-config")) {
            HashSet<ServerIdentity> servers = new HashSet<ServerIdentity>();
            for (Property prop : hostModel.get("server-config").asPropertyList()) {
                String serverName = prop.getName();
                if (this.serverProxies.get(serverName) == null) continue;
                ModelNode server = prop.getValue();
                String serverGroupName = server.require("group").asString();
                if (server.hasDefined("path") && server.get("path").keys().contains(pathName)) continue;
                ServerIdentity groupedServer = new ServerIdentity(this.localHostName, serverGroupName, serverName);
                servers.add(groupedServer);
            }
            ModelNode serverOp = operation.clone();
            serverOp.get("address").setEmptyList().add("path", pathName);
            result = Collections.singletonMap(servers, serverOp);
        } else {
            result = Collections.emptyMap();
        }
        return result;
    }

    private Map<Set<ServerIdentity>, ModelNode> getServerSocketBindingGroupOperations(ModelNode operation, PathAddress address, ModelNode domain, ModelNode host) {
        String bindingGroupName = address.getElement(0).getValue();
        Set<String> relatedBindingGroups = DomainServerUtils.getRelatedElements("socket-binding-group", bindingGroupName, domain);
        HashSet<ServerIdentity> result = new HashSet<ServerIdentity>();
        for (String bindingGroup : relatedBindingGroups) {
            result.addAll(DomainServerUtils.getServersForType("socket-binding-group", bindingGroup, domain, host, this.localHostName, this.serverProxies));
        }
        Iterator iter = result.iterator();
        while (iter.hasNext()) {
            ServerIdentity gs = (ServerIdentity)iter.next();
            ModelNode server = host.get(new String[]{"server-config", gs.getServerName()});
            if (!server.hasDefined("socket-binding-group") || bindingGroupName.equals(server.get("socket-binding-group").asString())) continue;
            iter.remove();
        }
        ModelNode serverOp = operation.clone();
        return Collections.singletonMap(result, serverOp);
    }

    private Map<Set<ServerIdentity>, ModelNode> getServerGroupOperations(ModelNode operation, PathAddress address, ModelNode domain, ModelNode host) {
        Map<Set<ServerIdentity>, ModelNode> result = null;
        if (address.size() > 1) {
            String type = address.getElement(1).getKey();
            if ("jvm".equals(type)) {
                result = Collections.emptyMap();
            } else if ("deployment".equals(type)) {
                String groupName = address.getElement(0).getValue();
                Set<ServerIdentity> servers = DomainServerUtils.getServersForGroup(groupName, host, this.localHostName, this.serverProxies);
                ModelNode serverOp = operation.clone();
                if ("add".equals(serverOp.get("operation").asString())) {
                    ModelNode domainDeployment = domain.get(new String[]{"deployment", address.getElement(1).getValue()});
                    if (!serverOp.hasDefined("runtime-name")) {
                        serverOp.get("runtime-name").set(domainDeployment.get("runtime-name"));
                    }
                    serverOp.get("content").set(domainDeployment.require("content"));
                }
                PathAddress serverAddress = address.subAddress(1);
                serverOp.get("address").set(serverAddress.toModelNode());
                result = Collections.singletonMap(servers, serverOp);
            } else if ("system-property".equals(type)) {
                String affectedGroup = address.getElement(0).getValue();
                result = this.getServerSystemPropertyOperations(operation, address, Level.SERVER_GROUP, domain, affectedGroup, host);
            }
        } else if ("replace-deployment".equals(operation.require("operation").asString())) {
            String groupName = address.getElement(0).getValue();
            Set<ServerIdentity> servers = DomainServerUtils.getServersForGroup(groupName, host, this.localHostName, this.serverProxies);
            ModelNode serverOp = operation.clone();
            serverOp.get("address").setEmptyList();
            ModelNode domainDeployment = domain.get(new String[]{"deployment", operation.require("name").asString()});
            serverOp.get("runtime-name").set(domainDeployment.get("runtime-name"));
            serverOp.get("content").set(domainDeployment.require("content"));
            result = Collections.singletonMap(servers, serverOp);
        } else if ("write-attribute".equals(operation.require("operation").asString()) && "profile".equals(operation.get("name").asString())) {
            String groupName = address.getElement(0).getValue();
            Set<ServerIdentity> servers = DomainServerUtils.getServersForGroup(groupName, host, this.localHostName, this.serverProxies);
            return this.getServerRestartRequiredOperations(servers);
        }
        if (result == null) {
            result = Collections.emptyMap();
        }
        return result;
    }

    private Map<Set<ServerIdentity>, ModelNode> resolveDomainRootOperation(ModelNode operation, ModelNode domain, ModelNode host) {
        Map<Set<ServerIdentity>, ModelNode> result = null;
        String opName = operation.require("operation").asString();
        if ("full-replace-deployment".equals(opName)) {
            String propName = operation.require("name").asString();
            Set<String> groups = this.getServerGroupsForDeployment(propName, domain);
            HashSet<ServerIdentity> allServers = new HashSet<ServerIdentity>();
            for (String group : groups) {
                allServers.addAll(DomainServerUtils.getServersForGroup(group, host, this.localHostName, this.serverProxies));
            }
            result = Collections.singletonMap(allServers, operation);
        } else if ("resolve-expression-on-domain".equals(opName)) {
            ModelNode serverOp = operation.clone();
            serverOp.get("operation").set("resolve-expression");
            serverOp.get("address").setEmptyList();
            Set<ServerIdentity> allServers = DomainServerUtils.getAllRunningServers(host, this.localHostName, this.serverProxies);
            result = Collections.singletonMap(allServers, serverOp);
        }
        if (result == null) {
            result = Collections.emptyMap();
        }
        return result;
    }

    private Set<String> getServerGroupsForDeployment(String deploymentName, ModelNode domainModel) {
        Set<String> groups;
        if (domainModel.hasDefined("server-group")) {
            groups = new HashSet();
            for (Property prop : domainModel.get("server-group").asPropertyList()) {
                ModelNode serverGroup = prop.getValue();
                if (!serverGroup.hasDefined("deployment") || !serverGroup.get("deployment").hasDefined(deploymentName)) continue;
                groups.add(prop.getName());
            }
        } else {
            groups = Collections.emptySet();
        }
        return groups;
    }

    private boolean hasSystemProperty(ModelNode resource, String propName) {
        return resource.hasDefined("system-property") && resource.get("system-property").hasDefined(propName);
    }

    private Map<Set<ServerIdentity>, ModelNode> getServerHostOperations(ModelNode operation, PathAddress address, ModelNode domain, ModelNode host) {
        if (address.size() == 1) {
            return this.resolveHostRootOperation(operation, domain, host);
        }
        HostKey hostKey = HostKey.forName(address.getElement(1).getKey());
        address = address.subAddress(1);
        switch (hostKey) {
            case PATH: {
                return this.getServerPathOperations(operation, address, host, false);
            }
            case SYSTEM_PROPERTY: {
                return this.getServerSystemPropertyOperations(operation, address, Level.HOST, domain, null, host);
            }
            case CORE_SERVICE: {
                return Collections.emptyMap();
            }
            case INTERFACE: {
                return this.getServerInterfaceOperations(operation, address, host, false);
            }
            case JVM: {
                return Collections.emptyMap();
            }
            case SERVER_CONFIG: {
                return this.resolveServerConfigOperation(operation, address, domain, host);
            }
        }
        throw DomainControllerMessages.MESSAGES.unexpectedInitialPathKey(address.getElement(0).getKey());
    }

    private Map<Set<ServerIdentity>, ModelNode> resolveHostRootOperation(ModelNode operation, ModelNode domain, ModelNode host) {
        Map<Set<ServerIdentity>, ModelNode> result = null;
        String opName = operation.require("operation").asString();
        if ("resolve-expression-on-domain".equals(opName)) {
            ModelNode serverOp = operation.clone();
            serverOp.get("operation").set("resolve-expression");
            serverOp.get("address").setEmptyList();
            Set<ServerIdentity> allServers = DomainServerUtils.getAllRunningServers(host, this.localHostName, this.serverProxies);
            result = Collections.singletonMap(allServers, serverOp);
        }
        if (result == null) {
            result = Collections.emptyMap();
        }
        return result;
    }

    private Map<Set<ServerIdentity>, ModelNode> getServerSystemPropertyOperations(ModelNode operation, PathAddress address, Level level, ModelNode domain, String affectedGroup, ModelNode host) {
        Map<Set<ServerIdentity>, ModelNode> result = null;
        if (this.isServerAffectingSystemPropertyOperation(operation)) {
            String propName = address.getLastElement().getValue();
            boolean overridden = false;
            Set<String> groups = null;
            if (level == Level.DOMAIN || level == Level.SERVER_GROUP) {
                if (this.hasSystemProperty(host, propName)) {
                    overridden = true;
                } else if (affectedGroup != null) {
                    groups = Collections.singleton(affectedGroup);
                } else if (domain.hasDefined("server-group")) {
                    groups = new HashSet<String>();
                    for (Property groupProp : domain.get("server-group").asPropertyList()) {
                        String groupName = groupProp.getName();
                        if (this.hasSystemProperty(groupProp.getValue(), propName)) continue;
                        groups.add(groupName);
                    }
                }
            }
            HashSet<ServerIdentity> servers = null;
            if (!overridden && host.hasDefined("server-config")) {
                servers = new HashSet<ServerIdentity>();
                for (Property serverProp : host.get("server-config").asPropertyList()) {
                    ModelNode server;
                    String string = serverProp.getName();
                    if (this.serverProxies.get(string) == null || this.hasSystemProperty(server = serverProp.getValue(), propName)) continue;
                    String groupName = server.require("group").asString();
                    if (groups != null && !groups.contains(groupName)) continue;
                    servers.add(new ServerIdentity(this.localHostName, groupName, string));
                }
            }
            if (servers != null && servers.size() > 0) {
                HashMap<ModelNode, HashSet<ServerIdentity>> ops = new HashMap<ModelNode, HashSet<ServerIdentity>>();
                for (ServerIdentity serverIdentity : servers) {
                    ModelNode serverOp = this.getServerSystemPropertyOperation(operation, propName, serverIdentity, level, domain, host);
                    HashSet<ServerIdentity> set = (HashSet<ServerIdentity>)ops.get(serverOp);
                    if (set == null) {
                        set = new HashSet<ServerIdentity>();
                        ops.put(serverOp, set);
                    }
                    set.add(serverIdentity);
                }
                result = new HashMap<Set<ServerIdentity>, ModelNode>();
                for (Map.Entry entry : ops.entrySet()) {
                    result.put((Set<ServerIdentity>)entry.getValue(), (ModelNode)entry.getKey());
                }
            }
        }
        if (result == null) {
            result = Collections.emptyMap();
        }
        return result;
    }

    private ModelNode getServerSystemPropertyOperation(ModelNode operation, String propName, ServerIdentity server, Level level, ModelNode domain, ModelNode host) {
        ModelNode result = null;
        String opName = operation.get("operation").asString();
        if ("add".equals(opName) || "remove".equals(opName)) {
            ModelNode value = null;
            switch (level) {
                case SERVER: {
                    value = this.getSystemPropertyValue(host, propName);
                    if (value == null) {
                        value = this.getSystemPropertyValue(domain.get(new String[]{"server-group", server.getServerGroupName()}), propName);
                    }
                    if (value != null) break;
                    value = this.getSystemPropertyValue(domain, propName);
                    break;
                }
                case HOST: {
                    value = this.getSystemPropertyValue(domain.get(new String[]{"server-group", server.getServerGroupName()}), propName);
                    if (value != null) break;
                    value = this.getSystemPropertyValue(domain, propName);
                    break;
                }
                case SERVER_GROUP: {
                    value = this.getSystemPropertyValue(domain, propName);
                    break;
                }
            }
            if (value != null) {
                if ("add".equals(opName)) {
                    value = operation.has("value") ? operation.get("value") : new ModelNode();
                }
                ModelNode addr = new ModelNode();
                addr.add("system-property", propName);
                result = Util.getEmptyOperation((String)"write-attribute", (ModelNode)addr);
                result.get("name").set("value");
                if (value.isDefined()) {
                    result.get("value").set(value);
                }
            }
        }
        if (result == null) {
            result = operation.clone();
            ModelNode addr = new ModelNode();
            addr.add("system-property", propName);
            result.get("address").set(addr);
        }
        return result;
    }

    private ModelNode getSystemPropertyValue(ModelNode root, String propName) {
        ModelNode result = null;
        if (root.hasDefined("system-property") && root.get("system-property").hasDefined(propName)) {
            ModelNode resource = root.get(new String[]{"system-property", propName});
            result = resource.hasDefined("value") ? resource.get("value") : new ModelNode();
        }
        return result;
    }

    private Map<Set<ServerIdentity>, ModelNode> resolveServerConfigOperation(ModelNode operation, PathAddress address, ModelNode domain, ModelNode host) {
        Map<Set<ServerIdentity>, ModelNode> result;
        String attr;
        ModelNode serverOp = null;
        if (address.size() > 1) {
            String type = address.getElement(1).getKey();
            if ("path".equals(type) || "interface".equals(type)) {
                serverOp = operation.clone();
                PathAddress serverAddress = address.subAddress(1);
                serverOp.get("address").set(serverAddress.toModelNode());
            } else if ("system-property".equals(type) && this.isServerAffectingSystemPropertyOperation(operation)) {
                String propName = address.getLastElement().getValue();
                String serverName = address.getElement(0).getValue();
                ServerIdentity serverId = this.getServerIdentity(serverName, host);
                serverOp = this.getServerSystemPropertyOperation(operation, propName, serverId, Level.SERVER, domain, host);
            }
        } else if (address.size() == 1 && "write-attribute".equals(operation.require("operation").asString()) && ("group".equals(attr = operation.get("name").asString()) || "socket-binding-group".equals(attr) || "socket-binding-port-offset".equals(attr))) {
            String serverName = address.getElement(0).getValue();
            String group = host.get(new String[]{address.getLastElement().getKey(), address.getLastElement().getValue(), "group"}).asString();
            ServerIdentity id = new ServerIdentity(this.localHostName, group, serverName);
            Map<Set<ServerIdentity>, ModelNode> result2 = this.getServerRestartRequiredOperations(Collections.singleton(id));
            return result2;
        }
        if (serverOp == null) {
            result = Collections.emptyMap();
        } else {
            String serverName = address.getElement(0).getValue();
            ServerIdentity gs = this.getServerIdentity(serverName, host);
            Set<ServerIdentity> set = Collections.singleton(gs);
            result = Collections.singletonMap(set, serverOp);
        }
        return result;
    }

    private Map<Set<ServerIdentity>, ModelNode> getServerRestartRequiredOperations(Set<ServerIdentity> servers) {
        ModelNode op = new ModelNode();
        op.get("operation").set("server-set-restart-required");
        op.get("address").setEmptyList();
        return Collections.singletonMap(servers, op);
    }

    private ServerIdentity getServerIdentity(String serverName, ModelNode host) {
        ModelNode serverNode = host.get(new String[]{"server-config", serverName});
        return new ServerIdentity(this.localHostName, serverNode.require("group").asString(), serverName);
    }

    private boolean isServerAffectingSystemPropertyOperation(ModelNode operation) {
        String opName = operation.require("operation").asString();
        return "add".equals(opName) || "remove".equals(opName) || "write-attribute".equals(opName) && "value".equals(operation.require("name").asString());
    }

    private static enum Level {
        DOMAIN,
        SERVER_GROUP,
        HOST,
        SERVER;

    }

    private static enum HostKey {
        UNKNOWN(null),
        PATH("path"),
        SYSTEM_PROPERTY("system-property"),
        CORE_SERVICE("core-service"),
        INTERFACE("interface"),
        JVM("jvm"),
        SERVER("server"),
        SERVER_CONFIG("server-config");

        private final String name;
        private static final Map<String, HostKey> MAP;

        private HostKey(String name) {
            this.name = name;
        }

        public static HostKey forName(String localName) {
            HostKey element = MAP.get(localName);
            return element == null ? UNKNOWN : element;
        }

        static {
            HashMap<String, HostKey> map = new HashMap<String, HostKey>();
            for (HostKey element : HostKey.values()) {
                String name = element.name;
                if (name == null) continue;
                map.put(name, element);
            }
            MAP = map;
        }
    }

    private static enum DomainKey {
        UNKNOWN(null),
        EXTENSION("extension"),
        PATH("path"),
        SYSTEM_PROPERTY("system-property"),
        PROFILE("profile"),
        INTERFACE("interface"),
        SOCKET_BINDING_GROUP("socket-binding-group"),
        DEPLOYMENT("deployment"),
        SERVER_GROUP("server-group"),
        MANAGMENT_CLIENT_CONTENT("management-client-content"),
        HOST("host");

        private final String name;
        private static final Map<String, DomainKey> MAP;

        private DomainKey(String name) {
            this.name = name;
        }

        public static DomainKey forName(String localName) {
            DomainKey element = MAP.get(localName);
            return element == null ? UNKNOWN : element;
        }

        static {
            HashMap<String, DomainKey> map = new HashMap<String, DomainKey>();
            for (DomainKey element : DomainKey.values()) {
                String name = element.name;
                if (name == null) continue;
                map.put(name, element);
            }
            MAP = map;
        }
    }
}

