/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.host.controller;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.extension.ExtensionAddHandler;
import org.jboss.as.controller.operations.common.InterfaceAddHandler;
import org.jboss.as.controller.operations.common.NamespaceAddHandler;
import org.jboss.as.controller.operations.common.PathAddHandler;
import org.jboss.as.controller.operations.common.SchemaLocationAddHandler;
import org.jboss.as.controller.operations.common.SocketBindingAddHandler;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.as.controller.parsing.Attribute;
import org.jboss.as.domain.controller.DomainController;
import org.jboss.as.host.controller.HostControllerEnvironment;
import org.jboss.as.host.controller.HostControllerMessages;
import org.jboss.as.host.controller.JvmElement;
import org.jboss.as.host.controller.JvmOptionsBuilderFactory;
import org.jboss.as.host.controller.ManagedServer;
import org.jboss.as.host.controller.SecurityActions;
import org.jboss.as.process.DefaultJvmUtils;
import org.jboss.as.repository.HostFileRepository;
import org.jboss.as.server.services.net.BindingGroupAddHandler;
import org.jboss.as.server.services.net.LocalDestinationOutboundSocketBindingAddHandler;
import org.jboss.as.server.services.net.RemoteDestinationOutboundSocketBindingAddHandler;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.Property;

class ModelCombiner
implements ManagedServer.ManagedServerBootConfiguration {
    private static final String RMI_CLIENT_INTERVAL = "sun.rmi.dgc.client.gcInterval";
    private static final String RMI_SERVER_INTERVAL = "sun.rmi.dgc.server.gcInterval";
    private static final String DEFAULT_RMI_INTERVAL = "3600000";
    private static final ModelNode EMPTY = new ModelNode();
    private final String serverName;
    private final ModelNode domainModel;
    private final ModelNode hostModel;
    private final ModelNode serverModel;
    private final ModelNode serverGroup;
    private final String profileName;
    private final JvmElement jvmElement;
    private final HostControllerEnvironment environment;
    private final DomainController domainController;
    private final boolean managementSubsystemEndpoint;

    ModelCombiner(String serverName, ModelNode domainModel, ModelNode hostModel, DomainController domainController, HostControllerEnvironment environment) {
        Iterator i$;
        Iterator i$2;
        this.serverName = serverName;
        this.domainModel = domainModel;
        this.hostModel = hostModel;
        this.serverModel = hostModel.require("server-config").require(serverName);
        this.domainController = domainController;
        this.environment = environment;
        String serverGroupName = this.serverModel.require("group").asString();
        this.serverGroup = domainModel.require("server-group").require(serverGroupName);
        this.profileName = this.serverGroup.require("profile").asString();
        String serverVMName = null;
        ModelNode serverVM = null;
        if (this.serverModel.hasDefined("jvm") && (i$2 = this.serverModel.get("jvm").keys().iterator()).hasNext()) {
            String jvm;
            serverVMName = jvm = (String)i$2.next();
            serverVM = this.serverModel.get(new String[]{"jvm", jvm});
        }
        String groupVMName = null;
        ModelNode groupVM = null;
        if (this.serverGroup.hasDefined("jvm") && (i$ = this.serverGroup.get("jvm").keys().iterator()).hasNext()) {
            String jvm;
            groupVMName = jvm = (String)i$.next();
            groupVM = this.serverGroup.get(new String[]{"jvm", jvm});
        }
        boolean managementSubsystemEndpoint = false;
        if (this.serverGroup.hasDefined("management-subsystem-endpoint")) {
            managementSubsystemEndpoint = this.serverGroup.get("management-subsystem-endpoint").asBoolean();
        }
        this.managementSubsystemEndpoint = managementSubsystemEndpoint;
        String jvmName = serverVMName != null ? serverVMName : groupVMName;
        ModelNode hostVM = jvmName != null ? hostModel.get(new String[]{"jvm", jvmName}) : null;
        this.jvmElement = new JvmElement(jvmName, hostVM, groupVM, serverVM);
    }

    public ManagedServer.ManagedServerBootConfiguration createConfiguration() {
        return new ProcessedBootConfiguration(this.getServerLaunchCommand(), this.getBootUpdates(), this.getServerLaunchEnvironment(), this.isManagementSubsystemEndpoint(), this.environment);
    }

    @Override
    public List<ModelNode> getBootUpdates() {
        int portOffSet = 0;
        String socketBindingRef = null;
        if (this.serverGroup.hasDefined("socket-binding-group")) {
            socketBindingRef = this.serverGroup.get("socket-binding-group").asString();
        }
        if (this.serverModel.hasDefined("socket-binding-group")) {
            socketBindingRef = this.serverModel.get("socket-binding-group").asString();
        }
        if (this.serverGroup.hasDefined("socket-binding-port-offset")) {
            portOffSet = this.serverGroup.get("socket-binding-port-offset").asInt();
        }
        if (this.serverModel.hasDefined("socket-binding-port-offset")) {
            portOffSet = this.serverModel.get("socket-binding-port-offset").asInt();
        }
        if (socketBindingRef == null) {
            throw HostControllerMessages.MESSAGES.undefinedSocketBinding(this.serverName);
        }
        ArrayList<ModelNode> updates = new ArrayList<ModelNode>();
        this.addNamespaces(updates);
        this.addProfileName(updates);
        this.addSchemaLocations(updates);
        this.addExtensions(updates);
        this.addPaths(updates);
        this.addSystemProperties(updates);
        this.addVault(updates);
        this.addManagementSecurityRealms(updates);
        this.addManagementConnections(updates);
        this.addInterfaces(updates);
        this.addSocketBindings(updates, portOffSet, socketBindingRef);
        this.addSubsystems(updates);
        this.addDeployments(updates);
        return updates;
    }

    @Override
    public HostControllerEnvironment getHostControllerEnvironment() {
        return this.environment;
    }

    @Override
    public List<String> getServerLaunchCommand() {
        ArrayList<String> command = new ArrayList<String>();
        command.add(this.getJavaCommand());
        command.add("-D[" + ManagedServer.getServerProcessName(this.serverName) + "]");
        JvmOptionsBuilderFactory.getInstance().addOptions(this.jvmElement, command);
        command.add("-Dsun.rmi.dgc.client.gcInterval=" + SecurityActions.getSystemProperty(RMI_CLIENT_INTERVAL, DEFAULT_RMI_INTERVAL));
        command.add("-Dsun.rmi.dgc.server.gcInterval=" + SecurityActions.getSystemProperty(RMI_SERVER_INTERVAL, DEFAULT_RMI_INTERVAL));
        Map<String, String> bootTimeProperties = this.getAllSystemProperties(true);
        for (Map.Entry<String, String> hostProp : this.environment.getHostSystemProperties().entrySet()) {
            if (bootTimeProperties.containsKey(hostProp.getKey())) continue;
            bootTimeProperties.put(hostProp.getKey(), hostProp.getValue());
        }
        for (Map.Entry<String, String> entry : bootTimeProperties.entrySet()) {
            String property = entry.getKey();
            if ("org.jboss.boot.log.file".equals(property) || "logging.configuration".equals(property)) continue;
            StringBuilder sb = new StringBuilder("-D");
            sb.append(property);
            sb.append('=');
            sb.append(entry.getValue() == null ? "true" : entry.getValue());
            command.add(sb.toString());
        }
        command.add("-Dorg.jboss.boot.log.file=" + ModelCombiner.getAbsolutePath(this.environment.getDomainServersDir(), this.serverName, "log", "boot.log"));
        String loggingConfiguration = System.getProperty("logging.configuration");
        if (loggingConfiguration == null) {
            loggingConfiguration = "file:" + ModelCombiner.getAbsolutePath(this.environment.getDomainConfigurationDir(), "logging.properties");
        }
        command.add("-Dlogging.configuration=" + loggingConfiguration);
        command.add("-jar");
        command.add("jboss-modules.jar");
        command.add("-mp");
        command.add("modules");
        command.add("-jaxpmodule");
        command.add("javax.xml.jaxp-provider");
        command.add("org.jboss.as.server");
        return command;
    }

    @Override
    public boolean isManagementSubsystemEndpoint() {
        return this.managementSubsystemEndpoint;
    }

    private String getJavaCommand() {
        String javaHome = this.jvmElement.getJavaHome();
        if (javaHome == null) {
            String defaultJvm;
            if (this.environment.getDefaultJVM() != null && (!(defaultJvm = this.environment.getDefaultJVM().getAbsolutePath()).equals("java") || defaultJvm.equals("java") && System.getenv("JAVA_HOME") != null)) {
                return defaultJvm;
            }
            javaHome = DefaultJvmUtils.getCurrentJvmHome();
        }
        return DefaultJvmUtils.findJavaExecutable((String)javaHome);
    }

    @Override
    public Map<String, String> getServerLaunchEnvironment() {
        HashMap<String, String> env = new HashMap<String, String>();
        for (Map.Entry<String, String> property : this.jvmElement.getEnvironmentVariables().entrySet()) {
            env.put(property.getKey(), property.getValue());
        }
        return env;
    }

    private void addNamespaces(List<ModelNode> updates) {
        LinkedHashMap<String, ModelNode> map = new LinkedHashMap<String, ModelNode>();
        this.addNamespaces(map, this.domainModel.get("namespaces"));
        this.addNamespaces(map, this.hostModel.get("namespaces"));
        updates.addAll(map.values());
    }

    private void addNamespaces(Map<String, ModelNode> map, ModelNode namespaces) {
        if (namespaces.isDefined()) {
            for (Property prop : namespaces.asPropertyList()) {
                map.put(prop.getName(), NamespaceAddHandler.getAddNamespaceOperation((ModelNode)EMPTY, (String)prop.getName(), (String)prop.getValue().asString()));
            }
        }
    }

    private void addProfileName(List<ModelNode> updates) {
        updates.add(Util.getWriteAttributeOperation((ModelNode)EMPTY, (String)"profile-name", (String)this.profileName));
    }

    private void addSchemaLocations(List<ModelNode> updates) {
        LinkedHashMap<String, ModelNode> map = new LinkedHashMap<String, ModelNode>();
        this.addSchemaLocations(map, this.domainModel.get("schema-locations"));
        this.addSchemaLocations(map, this.hostModel.get("schema-locations"));
        updates.addAll(map.values());
    }

    private void addSchemaLocations(Map<String, ModelNode> map, ModelNode namespaces) {
        if (namespaces.isDefined()) {
            for (Property prop : namespaces.asPropertyList()) {
                map.put(prop.getName(), SchemaLocationAddHandler.getAddSchemaLocationOperation((ModelNode)EMPTY, (String)prop.getName(), (String)prop.getValue().asString()));
            }
        }
    }

    private void addExtensions(List<ModelNode> updates) {
        LinkedHashSet<String> extensionNames = new LinkedHashSet<String>();
        this.addExtensions(extensionNames, this.domainModel.get("extension"));
        this.addExtensions(extensionNames, this.hostModel.get("extension"));
        for (String name : extensionNames) {
            updates.add(ExtensionAddHandler.getAddExtensionOperation((ModelNode)this.pathAddress(PathElement.pathElement((String)"extension", (String)name))));
        }
    }

    private void addExtensions(Set<String> extensionNames, ModelNode extensions) {
        if (extensions.isDefined()) {
            extensionNames.addAll(extensions.keys());
        }
    }

    private void addPaths(List<ModelNode> updates) {
        LinkedHashMap<String, ModelNode> paths = new LinkedHashMap<String, ModelNode>();
        this.addPaths(paths, this.domainModel.get("path"));
        this.addPaths(paths, this.hostModel.get("path"));
        this.addPaths(paths, this.serverModel.get("path"));
        for (Map.Entry entry : paths.entrySet()) {
            updates.add(PathAddHandler.getAddPathOperation((ModelNode)this.pathAddress(PathElement.pathElement((String)"path", (String)((String)entry.getKey()))), (ModelNode)((ModelNode)entry.getValue()).get("path"), (ModelNode)((ModelNode)entry.getValue()).get("relative-to")));
        }
    }

    private void addPaths(Map<String, ModelNode> map, ModelNode path) {
        if (path.isDefined()) {
            for (Property prop : path.asPropertyList()) {
                map.put(prop.getName(), prop.getValue());
            }
        }
    }

    private void addSystemProperties(List<ModelNode> updates) {
        Map<String, String> props = this.getAllSystemProperties(false);
        for (Map.Entry<String, String> entry : props.entrySet()) {
            ModelNode address = new ModelNode();
            address.add("system-property", entry.getKey());
            ModelNode op = Util.getEmptyOperation((String)"add", (ModelNode)address);
            if (entry.getValue() != null) {
                op.get("value").set(entry.getValue());
            }
            updates.add(op);
        }
    }

    private Map<String, String> getAllSystemProperties(boolean boottimeOnly) {
        HashMap<String, String> props = new HashMap<String, String>();
        this.addSystemProperties(this.domainModel, props, boottimeOnly);
        this.addSystemProperties(this.serverGroup, props, boottimeOnly);
        this.addSystemProperties(this.hostModel, props, boottimeOnly);
        this.addSystemProperties(this.serverModel, props, boottimeOnly);
        return props;
    }

    private void addSystemProperties(ModelNode source, Map<String, String> props, boolean boottimeOnly) {
        if (source.hasDefined("system-property")) {
            for (Property prop : source.get("system-property").asPropertyList()) {
                ModelNode propResource = prop.getValue();
                if (boottimeOnly && !propResource.get("boot-time").asBoolean()) continue;
                String val = propResource.hasDefined("value") ? propResource.get("value").asString() : null;
                props.put(prop.getName(), val);
            }
        }
    }

    private void addVault(List<ModelNode> updates) {
        if (this.hostModel.get("core-service").isDefined()) {
            this.addVault(updates, this.hostModel.get("core-service").get("vault"));
        }
    }

    private void addVault(List<ModelNode> updates, ModelNode vaultNode) {
        if (vaultNode.isDefined()) {
            ModelNode vault = new ModelNode();
            ModelNode codeNode = vaultNode.get(Attribute.CODE.getLocalName());
            if (codeNode.isDefined()) {
                vault.get(Attribute.CODE.getLocalName()).set(codeNode.asString());
            }
            vault.get("operation").set("add");
            ModelNode vaultAddress = new ModelNode();
            vaultAddress.add("core-service", "vault");
            vault.get("address").set(vaultAddress);
            ModelNode optionsNode = vaultNode.get("vault-options");
            if (optionsNode.isDefined()) {
                vault.get("vault-options").set(optionsNode);
            }
            updates.add(vault);
        }
    }

    private void addManagementSecurityRealms(List<ModelNode> updates) {
        if (this.hostModel.get(new String[]{"core-service", "management", "security-realm"}).isDefined()) {
            ModelNode securityRealms = this.hostModel.get(new String[]{"core-service", "management", "security-realm"});
            Set keys = securityRealms.keys();
            for (String current : keys) {
                ModelNode addOp = new ModelNode();
                ModelNode realmAddress = new ModelNode();
                realmAddress.add("core-service", "management").add("security-realm", current);
                addOp.get("operation").set("add");
                addOp.get("address").set(realmAddress);
                updates.add(addOp);
                ModelNode currentRealm = securityRealms.get(current);
                if (currentRealm.hasDefined("server-identity")) {
                    this.addManagementComponentComponent(currentRealm, realmAddress, "server-identity", updates);
                }
                if (currentRealm.hasDefined("authentication")) {
                    this.addManagementComponentComponent(currentRealm, realmAddress, "authentication", updates);
                }
                if (!currentRealm.hasDefined("authorization")) continue;
                this.addManagementComponentComponent(currentRealm, realmAddress, "authorization", updates);
            }
        }
    }

    private void addManagementComponentComponent(ModelNode realm, ModelNode parentAddress, String key, List<ModelNode> updates) {
        for (String currentComponent : realm.get(key).keys()) {
            ModelNode addComponent = new ModelNode();
            addComponent.set(realm.get(new String[]{key, currentComponent}));
            ModelNode identityAddress = parentAddress.clone().add(key, currentComponent);
            addComponent.get("operation").set("add");
            addComponent.get("address").set(identityAddress);
            updates.add(addComponent);
        }
    }

    private void addManagementConnections(List<ModelNode> updates) {
        if (this.hostModel.get(new String[]{"core-service", "management", "ldap-connection"}).isDefined()) {
            ModelNode baseAddress = new ModelNode();
            baseAddress.add("core-service", "management");
            ModelNode connections = this.hostModel.get(new String[]{"core-service", "management", "ldap-connection"});
            for (String connectionName : connections.keys()) {
                ModelNode addConnection = new ModelNode();
                addConnection.set(connections.get(connectionName));
                ModelNode identityAddress = baseAddress.clone().add("ldap-connection", connectionName);
                addConnection.get("operation").set("add");
                addConnection.get("address").set(identityAddress);
                updates.add(addConnection);
            }
        }
    }

    private void addInterfaces(List<ModelNode> updates) {
        LinkedHashMap<String, ModelNode> interfaces = new LinkedHashMap<String, ModelNode>();
        this.addInterfaces(interfaces, this.domainModel.get("interface"));
        this.addInterfaces(interfaces, this.hostModel.get("interface"));
        this.addInterfaces(interfaces, this.hostModel.get(new String[]{"server-config", this.serverName, "interface"}));
        for (Map.Entry entry : interfaces.entrySet()) {
            updates.add(InterfaceAddHandler.getAddInterfaceOperation((ModelNode)this.pathAddress(PathElement.pathElement((String)"interface", (String)((String)entry.getKey()))), (ModelNode)((ModelNode)entry.getValue())));
        }
    }

    private void addInterfaces(Map<String, ModelNode> map, ModelNode iface) {
        if (iface.isDefined()) {
            for (Property prop : iface.asPropertyList()) {
                map.put(prop.getName(), prop.getValue());
            }
        }
    }

    private void addSocketBindings(List<ModelNode> updates, int portOffSet, String bindingRef) {
        ModelNode group;
        HashSet<String> processed = new HashSet<String>();
        LinkedHashMap<String, ModelNode> groups = new LinkedHashMap<String, ModelNode>();
        if (this.domainModel.hasDefined("socket-binding-group")) {
            for (Property prop : this.domainModel.get("socket-binding-group").asPropertyList()) {
                ModelNode node = prop.getValue().clone();
                if (portOffSet > 0) {
                    node.get("port-offset").set(portOffSet);
                }
                groups.put(prop.getName(), node);
            }
        }
        if ((group = (ModelNode)groups.get(bindingRef)) == null) {
            throw HostControllerMessages.MESSAGES.undefinedSocketBindingGroup(bindingRef);
        }
        ModelNode groupAddress = this.pathAddress(PathElement.pathElement((String)"socket-binding-group", (String)bindingRef));
        ModelNode groupAdd = BindingGroupAddHandler.getOperation((ModelNode)groupAddress, (ModelNode)group);
        groupAdd.get("port-offset").set(portOffSet);
        updates.add(groupAdd);
        this.mergeBindingGroups(updates, groups, bindingRef, group, processed);
    }

    private void mergeBindingGroups(List<ModelNode> updates, Map<String, ModelNode> groups, String groupName, ModelNode group, Set<String> processed) {
        this.addSocketBindings(updates, group, groupName, group.get("default-interface"));
        if (group.has("includes") && group.get("includes").isDefined()) {
            for (ModelNode include : group.get("includes").asList()) {
                String ref = include.asString();
                if (!processed.add(ref)) continue;
                ModelNode includedGroup = groups.get(ref);
                if (group == null) {
                    throw HostControllerMessages.MESSAGES.undefinedSocketBindingGroup(ref);
                }
                this.mergeBindingGroups(updates, groups, groupName, includedGroup, processed);
            }
        }
    }

    private void addSocketBindings(List<ModelNode> updates, ModelNode group, String groupName, ModelNode defaultInterface) {
        String outboundSocketBindingName;
        ModelNode binding;
        for (Property socketBinding : group.get("socket-binding").asPropertyList()) {
            String name = socketBinding.getName();
            binding = socketBinding.getValue();
            if (!binding.isDefined()) continue;
            if (!binding.get("default-interface").isDefined()) {
                binding.get("default-interface").set(defaultInterface);
            }
            updates.add(SocketBindingAddHandler.getOperation((ModelNode)this.pathAddress(PathElement.pathElement((String)"socket-binding-group", (String)groupName), PathElement.pathElement((String)"socket-binding", (String)name)), (ModelNode)binding));
        }
        if (group.hasDefined("local-destination-outbound-socket-binding")) {
            for (Property localDestinationOutboundSocketBindings : group.get("local-destination-outbound-socket-binding").asPropertyList()) {
                outboundSocketBindingName = localDestinationOutboundSocketBindings.getName();
                binding = localDestinationOutboundSocketBindings.getValue();
                if (!binding.isDefined()) continue;
                updates.add(LocalDestinationOutboundSocketBindingAddHandler.getOperation((ModelNode)this.pathAddress(PathElement.pathElement((String)"socket-binding-group", (String)groupName), PathElement.pathElement((String)"local-destination-outbound-socket-binding", (String)outboundSocketBindingName)), (ModelNode)binding));
            }
        }
        if (group.hasDefined("remote-destination-outbound-socket-binding")) {
            for (Property remoteDestinationOutboundSocketBindings : group.get("remote-destination-outbound-socket-binding").asPropertyList()) {
                outboundSocketBindingName = remoteDestinationOutboundSocketBindings.getName();
                binding = remoteDestinationOutboundSocketBindings.getValue();
                if (!binding.isDefined()) continue;
                updates.add(RemoteDestinationOutboundSocketBindingAddHandler.getOperation((ModelNode)this.pathAddress(PathElement.pathElement((String)"socket-binding-group", (String)groupName), PathElement.pathElement((String)"remote-destination-outbound-socket-binding", (String)outboundSocketBindingName)), (ModelNode)binding));
            }
        }
    }

    private void addSubsystems(List<ModelNode> updates) {
        ModelNode node = this.domainController.getProfileOperations(this.profileName);
        updates.addAll(node.asList());
    }

    private void addDeployments(List<ModelNode> updates) {
        if (this.serverGroup.hasDefined("deployment")) {
            HostFileRepository remoteRepository = null;
            if (!this.domainController.getLocalHostInfo().isMasterDomainController()) {
                remoteRepository = this.domainController.getRemoteFileRepository();
            }
            for (Property deployment : this.serverGroup.get("deployment").asPropertyList()) {
                String name = deployment.getName();
                ModelNode details = deployment.getValue();
                ModelNode domainDeployment = this.domainModel.require("deployment").require(name);
                ModelNode deploymentContent = domainDeployment.require("content").clone();
                if (remoteRepository != null) {
                    for (ModelNode content : deploymentContent.asList()) {
                        if (!content.hasDefined("hash")) continue;
                        byte[] hash = content.require("hash").asBytes();
                        File[] files = this.domainController.getLocalFileRepository().getDeploymentFiles(hash);
                        if (files != null && files.length != 0) continue;
                        remoteRepository.getDeploymentFiles(hash);
                    }
                }
                PathAddress addr = PathAddress.pathAddress((PathElement[])new PathElement[]{PathElement.pathElement((String)"deployment", (String)name)});
                ModelNode addOp = Util.getEmptyOperation((String)"add", (ModelNode)addr.toModelNode());
                addOp.get("runtime-name").set(details.get("runtime-name"));
                addOp.get("content").set(deploymentContent);
                addOp.get("enabled").set(!details.hasDefined("enabled") || details.get("enabled").asBoolean());
                updates.add(addOp);
            }
        }
    }

    private ModelNode pathAddress(PathElement ... elements) {
        return PathAddress.pathAddress((PathElement[])elements).toModelNode();
    }

    static String getAbsolutePath(File root, String ... paths) {
        File path = root;
        for (String segment : paths) {
            path = new File(path, segment);
        }
        return path.getAbsolutePath();
    }

    static {
        EMPTY.setEmptyList();
        EMPTY.protect();
    }

    static class ProcessedBootConfiguration
    implements ManagedServer.ManagedServerBootConfiguration {
        List<String> command;
        List<ModelNode> bootUpdates;
        Map<String, String> environment;
        boolean managementSubsystemEndpoint;
        HostControllerEnvironment hostControllerEnvironment;

        ProcessedBootConfiguration(List<String> command, List<ModelNode> bootUpdates, Map<String, String> environment, boolean managementSubsystemEndpoint, HostControllerEnvironment hostControllerEnvironment) {
            this.command = command;
            this.bootUpdates = bootUpdates;
            this.environment = environment;
            this.managementSubsystemEndpoint = managementSubsystemEndpoint;
            this.hostControllerEnvironment = hostControllerEnvironment;
        }

        @Override
        public List<ModelNode> getBootUpdates() {
            return this.bootUpdates;
        }

        @Override
        public Map<String, String> getServerLaunchEnvironment() {
            return this.environment;
        }

        @Override
        public List<String> getServerLaunchCommand() {
            return this.command;
        }

        @Override
        public HostControllerEnvironment getHostControllerEnvironment() {
            return this.hostControllerEnvironment;
        }

        @Override
        public boolean isManagementSubsystemEndpoint() {
            return this.managementSubsystemEndpoint;
        }
    }
}

