/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.osgi.resolver.v2.spi;

import java.util.Hashtable;
import java.util.Map;
import org.jboss.osgi.resolver.v2.XCapability;
import org.jboss.osgi.resolver.v2.spi.AbstractRequirement;
import org.osgi.framework.Filter;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.wiring.BundleCapability;
import org.osgi.framework.wiring.BundleRequirement;
import org.osgi.framework.wiring.BundleRevision;

public abstract class AbstractBundleRequirement
extends AbstractRequirement
implements BundleRequirement {
    private Filter filter;

    protected AbstractBundleRequirement(BundleRevision brev, String namespace, Map<String, Object> atts, Map<String, String> dirs) {
        super(brev, namespace, atts, dirs);
        String filterdir = this.getDirective("filter");
        if (filterdir != null) {
            try {
                this.filter = FrameworkUtil.createFilter((String)filterdir);
            }
            catch (InvalidSyntaxException e) {
                throw new IllegalArgumentException("Invalid filter directive: " + filterdir);
            }
        }
    }

    @Override
    public BundleRevision getRevision() {
        return (BundleRevision)super.getResource();
    }

    @Override
    public BundleRevision getResource() {
        return (BundleRevision)super.getResource();
    }

    @Override
    public boolean matches(BundleCapability cap) {
        String namespace = this.getNamespace();
        boolean matches = namespace.equals(cap.getNamespace());
        if (matches) {
            XCapability xcap = (XCapability)((Object)cap);
            Object thisatt = this.getAttribute(namespace);
            Object otheratt = xcap.getAttribute(namespace);
            matches = thisatt.equals(otheratt);
        }
        if (matches && this.filter != null) {
            Hashtable<String, Object> dict = new Hashtable<String, Object>(cap.getAttributes());
            matches = this.filter.match(dict);
        }
        return matches;
    }
}

