/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.osgi.resolver.v2.spi;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jboss.osgi.metadata.OSGiMetaData;
import org.jboss.osgi.metadata.PackageAttribute;
import org.jboss.osgi.metadata.Parameter;
import org.jboss.osgi.metadata.ParameterizedAttribute;
import org.jboss.osgi.resolver.v2.XCapability;
import org.jboss.osgi.resolver.v2.XRequirement;
import org.jboss.osgi.resolver.v2.XResource;
import org.jboss.osgi.resolver.v2.XResourceBuilder;
import org.jboss.osgi.resolver.v2.spi.AbstractCapability;
import org.jboss.osgi.resolver.v2.spi.AbstractFragmentHostCapability;
import org.jboss.osgi.resolver.v2.spi.AbstractFragmentHostRequirement;
import org.jboss.osgi.resolver.v2.spi.AbstractIdentityCapability;
import org.jboss.osgi.resolver.v2.spi.AbstractIdentityRequirement;
import org.jboss.osgi.resolver.v2.spi.AbstractPackageCapability;
import org.jboss.osgi.resolver.v2.spi.AbstractPackageRequirement;
import org.jboss.osgi.resolver.v2.spi.AbstractRequirement;
import org.osgi.framework.BundleException;
import org.osgi.framework.Version;

public class AbstractResourceBuilder
extends XResourceBuilder {
    public AbstractResourceBuilder(XResource resource) {
        super(resource);
    }

    public AbstractResourceBuilder() {
    }

    @Override
    public XCapability addIdentityCapability(String symbolicName, Version version, String type, Map<String, Object> atts, Map<String, String> dirs) {
        this.assertResourceCreated();
        atts.put("osgi.identity", symbolicName);
        atts.put("version", version);
        atts.put("type", type != null ? type : "unknown");
        AbstractIdentityCapability cap = new AbstractIdentityCapability(this.resource, atts, dirs);
        this.resource.addCapability(cap);
        return cap;
    }

    @Override
    public XRequirement addIdentityRequirement(String symbolicName, Map<String, Object> atts, Map<String, String> dirs) {
        this.assertResourceCreated();
        atts.put("osgi.identity", symbolicName);
        AbstractIdentityRequirement req = new AbstractIdentityRequirement(this.resource, atts, dirs);
        this.resource.addRequirement(req);
        return req;
    }

    @Override
    public XCapability addFragmentHostCapability(String symbolicName, Version version, Map<String, Object> atts, Map<String, String> dirs) {
        this.assertResourceCreated();
        atts.put("osgi.wiring.host", symbolicName);
        atts.put("bundle-version", version);
        AbstractFragmentHostCapability cap = new AbstractFragmentHostCapability(this.resource, atts, dirs);
        this.resource.addCapability(cap);
        return cap;
    }

    @Override
    public XRequirement addFragmentHostRequirement(String symbolicName, Map<String, Object> atts, Map<String, String> dirs) {
        this.assertResourceCreated();
        atts.put("osgi.wiring.host", symbolicName);
        AbstractFragmentHostRequirement req = new AbstractFragmentHostRequirement(this.resource, atts, dirs);
        this.resource.addRequirement(req);
        return req;
    }

    @Override
    public XCapability addPackageCapability(String packageName, Map<String, Object> atts, Map<String, String> dirs) {
        this.assertResourceCreated();
        atts.put("osgi.wiring.package", packageName);
        AbstractPackageCapability cap = new AbstractPackageCapability(this.resource, atts, dirs);
        this.resource.addCapability(cap);
        return cap;
    }

    @Override
    public XRequirement addPackageRequirement(String packageName, Map<String, Object> atts, Map<String, String> dirs) {
        this.assertResourceCreated();
        atts.put("osgi.wiring.package", packageName);
        AbstractPackageRequirement req = new AbstractPackageRequirement(this.resource, atts, dirs);
        this.resource.addRequirement(req);
        return req;
    }

    @Override
    public XCapability addGenericCapability(String namespace, Map<String, Object> atts, Map<String, String> dirs) {
        this.assertResourceCreated();
        AbstractCapability cap = "osgi.identity".equals(namespace) ? new AbstractIdentityCapability(this.resource, atts, dirs) : ("osgi.wiring.package".equals(namespace) ? new AbstractPackageCapability(this.resource, atts, dirs) : ("osgi.wiring.host".equals(namespace) ? new AbstractFragmentHostCapability(this.resource, atts, dirs) : new AbstractCapability(this.resource, namespace, atts, dirs){

            @Override
            protected List<String> getMandatoryAttributes() {
                return Arrays.asList(new Object[0]);
            }
        }));
        this.resource.addCapability(cap);
        return cap;
    }

    @Override
    public XRequirement addGenericRequirement(String namespace, Map<String, Object> atts, Map<String, String> dirs) {
        this.assertResourceCreated();
        AbstractRequirement req = "osgi.identity".equals(namespace) ? new AbstractIdentityRequirement(this.resource, atts, dirs) : ("osgi.wiring.package".equals(namespace) ? new AbstractPackageRequirement(this.resource, atts, dirs) : ("osgi.wiring.host".equals(namespace) ? new AbstractFragmentHostRequirement(this.resource, atts, dirs) : new AbstractRequirement(this.resource, namespace, atts, dirs){

            @Override
            protected List<String> getMandatoryAttributes() {
                return Arrays.asList(new Object[0]);
            }
        }));
        this.resource.addRequirement(req);
        return req;
    }

    @Override
    public XResourceBuilder load(OSGiMetaData metadata) throws BundleException {
        this.assertResourceCreated();
        try {
            List<PackageAttribute> dynamicImports;
            List<PackageAttribute> imports;
            List<PackageAttribute> exports;
            String symbolicName = metadata.getBundleSymbolicName();
            Version bundleVersion = metadata.getBundleVersion();
            ParameterizedAttribute idparams = metadata.getBundleParameters();
            Map<String, Object> idatts = this.getAttributes(idparams);
            Map<String, String> iddirs = this.getDirectives(idparams);
            ParameterizedAttribute fragmentHost = metadata.getFragmentHost();
            if (fragmentHost == null) {
                this.addIdentityCapability(symbolicName, bundleVersion, "osgi.bundle", idatts, iddirs);
                Map<String, Object> atts = this.getAttributes(idparams);
                Map<String, String> dirs = this.getDirectives(idparams);
                this.addFragmentHostCapability(symbolicName, bundleVersion, atts, dirs);
            } else {
                String hostName = fragmentHost.getAttribute();
                this.addIdentityCapability(symbolicName, bundleVersion, "osgi.fragment", idatts, iddirs);
                Map<String, Object> atts = this.getAttributes(fragmentHost);
                Map<String, String> dirs = this.getDirectives(fragmentHost);
                this.addFragmentHostRequirement(hostName, atts, dirs);
            }
            List<ParameterizedAttribute> requireBundles = metadata.getRequireBundles();
            if (requireBundles != null && !requireBundles.isEmpty()) {
                for (ParameterizedAttribute attr : requireBundles) {
                    String name = attr.getAttribute();
                    Map<String, Object> atts = this.getAttributes(attr);
                    Map<String, String> dirs = this.getDirectives(attr);
                    this.addIdentityRequirement(name, atts, dirs);
                }
            }
            if ((exports = metadata.getExportPackages()) != null && !exports.isEmpty()) {
                for (PackageAttribute attr : exports) {
                    String name = attr.getAttribute();
                    Map<String, Object> atts = this.getAttributes(attr);
                    Map<String, String> dirs = this.getDirectives(attr);
                    this.addPackageCapability(name, atts, dirs);
                }
            }
            if ((imports = metadata.getImportPackages()) != null && !imports.isEmpty()) {
                for (PackageAttribute attr : imports) {
                    String name = attr.getAttribute();
                    Map<String, Object> atts = this.getAttributes(attr);
                    Map<String, String> dirs = this.getDirectives(attr);
                    this.addPackageRequirement(name, atts, dirs);
                }
            }
            if ((dynamicImports = metadata.getDynamicImports()) != null && !dynamicImports.isEmpty()) {
                for (PackageAttribute attr : dynamicImports) {
                    String name = attr.getAttribute();
                }
            }
        }
        catch (RuntimeException ex) {
            throw new BundleException("Cannot initialize XResource from: " + metadata, (Throwable)ex);
        }
        return this;
    }

    private Map<String, String> getDirectives(ParameterizedAttribute attribs) {
        HashMap<String, String> dirs = new HashMap<String, String>();
        for (String key : attribs.getDirectives().keySet()) {
            String value = attribs.getDirectiveValue(key, String.class);
            dirs.put(key.trim(), value.trim());
        }
        return dirs;
    }

    private Map<String, Object> getAttributes(ParameterizedAttribute attribs) {
        HashMap<String, Object> atts = new HashMap<String, Object>();
        for (String key : attribs.getAttributes().keySet()) {
            Parameter param = attribs.getAttribute(key);
            atts.put(key.trim(), param.getValue().toString().trim());
        }
        return atts;
    }

    private void assertResourceCreated() {
        if (this.resource == null) {
            throw new IllegalStateException("Resource not created");
        }
    }
}

