/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.envers.configuration;

import java.sql.Date;
import java.util.Iterator;
import java.util.Set;
import javax.persistence.Column;
import org.dom4j.Document;
import org.dom4j.Element;
import org.hibernate.MappingException;
import org.hibernate.annotations.common.reflection.ReflectionManager;
import org.hibernate.annotations.common.reflection.XClass;
import org.hibernate.annotations.common.reflection.XProperty;
import org.hibernate.cfg.Configuration;
import org.hibernate.envers.Audited;
import org.hibernate.envers.DefaultRevisionEntity;
import org.hibernate.envers.DefaultTrackingModifiedEntitiesRevisionEntity;
import org.hibernate.envers.ModifiedEntityNames;
import org.hibernate.envers.RevisionEntity;
import org.hibernate.envers.RevisionListener;
import org.hibernate.envers.RevisionNumber;
import org.hibernate.envers.RevisionTimestamp;
import org.hibernate.envers.configuration.GlobalConfiguration;
import org.hibernate.envers.configuration.RevisionInfoConfigurationResult;
import org.hibernate.envers.configuration.metadata.AuditTableData;
import org.hibernate.envers.configuration.metadata.MetadataTools;
import org.hibernate.envers.entities.PropertyData;
import org.hibernate.envers.revisioninfo.DefaultRevisionInfoGenerator;
import org.hibernate.envers.revisioninfo.DefaultTrackingModifiedEntitiesRevisionInfoGenerator;
import org.hibernate.envers.revisioninfo.ModifiedEntityNamesReader;
import org.hibernate.envers.revisioninfo.RevisionInfoNumberReader;
import org.hibernate.envers.revisioninfo.RevisionInfoQueryCreator;
import org.hibernate.envers.tools.MutableBoolean;
import org.hibernate.internal.util.xml.XMLHelper;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.type.LongType;
import org.hibernate.type.Type;

public class RevisionInfoConfiguration {
    private String revisionInfoEntityName;
    private PropertyData revisionInfoIdData;
    private PropertyData revisionInfoTimestampData;
    private PropertyData modifiedEntityNamesData;
    private Type revisionInfoTimestampType;
    private GlobalConfiguration globalCfg;
    private String revisionPropType;
    private String revisionPropSqlType;

    public RevisionInfoConfiguration(GlobalConfiguration globalCfg) {
        this.globalCfg = globalCfg;
        this.revisionInfoEntityName = "org.hibernate.envers.DefaultRevisionEntity";
        this.revisionInfoIdData = new PropertyData("id", "id", "field", null);
        this.revisionInfoTimestampData = new PropertyData("timestamp", "timestamp", "field", null);
        this.modifiedEntityNamesData = new PropertyData("modifiedEntityNames", "modifiedEntityNames", "field", null);
        this.revisionInfoTimestampType = new LongType();
        this.revisionPropType = "integer";
    }

    private Document generateDefaultRevisionInfoXmlMapping() {
        Document document = XMLHelper.getDocumentFactory().createDocument();
        Element class_mapping = MetadataTools.createEntity(document, new AuditTableData(null, null, this.globalCfg.getDefaultSchemaName(), this.globalCfg.getDefaultCatalogName()), null);
        class_mapping.addAttribute("name", this.revisionInfoEntityName);
        class_mapping.addAttribute("table", "REVINFO");
        Element idProperty = MetadataTools.addNativelyGeneratedId(class_mapping, this.revisionInfoIdData.getName(), this.revisionPropType);
        MetadataTools.addColumn(idProperty, "REV", null, 0, 0, null, null, null, false);
        Element timestampProperty = MetadataTools.addProperty(class_mapping, this.revisionInfoTimestampData.getName(), this.revisionInfoTimestampType.getName(), true, false);
        MetadataTools.addColumn(timestampProperty, "REVTSTMP", null, 0, 0, null, null, null, false);
        if (this.globalCfg.isTrackEntitiesChangedInRevisionEnabled()) {
            this.generateEntityNamesTrackingTableMapping(class_mapping, "modifiedEntityNames", this.globalCfg.getDefaultSchemaName(), this.globalCfg.getDefaultCatalogName(), "REVCHANGES", "REV", "ENTITYNAME", "string");
        }
        return document;
    }

    private void generateEntityNamesTrackingTableMapping(Element class_mapping, String propertyName, String joinTableSchema, String joinTableCatalog, String joinTableName, String joinTablePrimaryKeyColumnName, String joinTableValueColumnName, String joinTableValueColumnType) {
        Element set = class_mapping.addElement("set");
        set.addAttribute("name", propertyName);
        set.addAttribute("table", joinTableName);
        set.addAttribute("schema", joinTableSchema);
        set.addAttribute("catalog", joinTableCatalog);
        set.addAttribute("cascade", "persist, delete");
        set.addAttribute("fetch", "join");
        set.addAttribute("lazy", "false");
        Element key = set.addElement("key");
        key.addAttribute("column", joinTablePrimaryKeyColumnName);
        Element element = set.addElement("element");
        element.addAttribute("type", joinTableValueColumnType);
        Element column = element.addElement("column");
        column.addAttribute("name", joinTableValueColumnName);
    }

    private Element generateRevisionInfoRelationMapping() {
        Document document = XMLHelper.getDocumentFactory().createDocument();
        Element rev_rel_mapping = document.addElement("key-many-to-one");
        rev_rel_mapping.addAttribute("type", this.revisionPropType);
        rev_rel_mapping.addAttribute("class", this.revisionInfoEntityName);
        if (this.revisionPropSqlType != null) {
            MetadataTools.addColumn(rev_rel_mapping, "*", null, 0, 0, this.revisionPropSqlType, null, null, false);
        }
        return rev_rel_mapping;
    }

    private void searchForRevisionInfoCfgInProperties(XClass clazz, ReflectionManager reflectionManager, MutableBoolean revisionNumberFound, MutableBoolean revisionTimestampFound, MutableBoolean modifiedEntityNamesFound, String accessType) {
        for (XProperty property : clazz.getDeclaredProperties(accessType)) {
            RevisionNumber revisionNumber = (RevisionNumber)property.getAnnotation(RevisionNumber.class);
            RevisionTimestamp revisionTimestamp = (RevisionTimestamp)property.getAnnotation(RevisionTimestamp.class);
            ModifiedEntityNames modifiedEntityNames = (ModifiedEntityNames)property.getAnnotation(ModifiedEntityNames.class);
            if (revisionNumber != null) {
                if (revisionNumberFound.isSet()) {
                    throw new MappingException("Only one property may be annotated with @RevisionNumber!");
                }
                XClass revisionNumberClass = property.getType();
                if (reflectionManager.equals(revisionNumberClass, Integer.class) || reflectionManager.equals(revisionNumberClass, Integer.TYPE)) {
                    this.revisionInfoIdData = new PropertyData(property.getName(), property.getName(), accessType, null);
                    revisionNumberFound.set();
                } else if (reflectionManager.equals(revisionNumberClass, Long.class) || reflectionManager.equals(revisionNumberClass, Long.TYPE)) {
                    this.revisionInfoIdData = new PropertyData(property.getName(), property.getName(), accessType, null);
                    revisionNumberFound.set();
                    this.revisionPropType = "long";
                } else {
                    throw new MappingException("The field annotated with @RevisionNumber must be of type int, Integer, long or Long");
                }
                Column revisionPropColumn = (Column)property.getAnnotation(Column.class);
                if (revisionPropColumn != null) {
                    this.revisionPropSqlType = revisionPropColumn.columnDefinition();
                }
            }
            if (revisionTimestamp != null) {
                if (revisionTimestampFound.isSet()) {
                    throw new MappingException("Only one property may be annotated with @RevisionTimestamp!");
                }
                XClass revisionTimestampClass = property.getType();
                if (reflectionManager.equals(revisionTimestampClass, Long.class) || reflectionManager.equals(revisionTimestampClass, Long.TYPE) || reflectionManager.equals(revisionTimestampClass, java.util.Date.class) || reflectionManager.equals(revisionTimestampClass, Date.class)) {
                    this.revisionInfoTimestampData = new PropertyData(property.getName(), property.getName(), accessType, null);
                    revisionTimestampFound.set();
                } else {
                    throw new MappingException("The field annotated with @RevisionTimestamp must be of type long, Long, java.util.Date or java.sql.Date");
                }
            }
            if (modifiedEntityNames == null) continue;
            if (modifiedEntityNamesFound.isSet()) {
                throw new MappingException("Only one property may be annotated with @ModifiedEntityNames!");
            }
            XClass modifiedEntityNamesClass = property.getType();
            if (reflectionManager.equals(modifiedEntityNamesClass, Set.class) && reflectionManager.equals(property.getElementClass(), String.class)) {
                this.modifiedEntityNamesData = new PropertyData(property.getName(), property.getName(), accessType, null);
                modifiedEntityNamesFound.set();
                continue;
            }
            throw new MappingException("The field annotated with @ModifiedEntityNames must be of Set<String> type.");
        }
    }

    private void searchForRevisionInfoCfg(XClass clazz, ReflectionManager reflectionManager, MutableBoolean revisionNumberFound, MutableBoolean revisionTimestampFound, MutableBoolean modifiedEntityNamesFound) {
        XClass superclazz = clazz.getSuperclass();
        if (!"java.lang.Object".equals(superclazz.getName())) {
            this.searchForRevisionInfoCfg(superclazz, reflectionManager, revisionNumberFound, revisionTimestampFound, modifiedEntityNamesFound);
        }
        this.searchForRevisionInfoCfgInProperties(clazz, reflectionManager, revisionNumberFound, revisionTimestampFound, modifiedEntityNamesFound, "field");
        this.searchForRevisionInfoCfgInProperties(clazz, reflectionManager, revisionNumberFound, revisionTimestampFound, modifiedEntityNamesFound, "property");
    }

    public RevisionInfoConfigurationResult configure(Configuration cfg, ReflectionManager reflectionManager) {
        Iterator classes = cfg.getClassMappings();
        boolean revisionEntityFound = false;
        DefaultRevisionInfoGenerator revisionInfoGenerator = null;
        Class revisionInfoClass = null;
        while (classes.hasNext()) {
            XClass clazz;
            PersistentClass pc = (PersistentClass)classes.next();
            try {
                clazz = reflectionManager.classForName(pc.getClassName(), this.getClass());
            }
            catch (ClassNotFoundException e) {
                throw new MappingException((Throwable)e);
            }
            RevisionEntity revisionEntity = (RevisionEntity)clazz.getAnnotation(RevisionEntity.class);
            if (revisionEntity == null) continue;
            if (revisionEntityFound) {
                throw new MappingException("Only one entity may be annotated with @RevisionEntity!");
            }
            if (clazz.getAnnotation(Audited.class) != null) {
                throw new MappingException("An entity annotated with @RevisionEntity cannot be audited!");
            }
            revisionEntityFound = true;
            MutableBoolean revisionNumberFound = new MutableBoolean();
            MutableBoolean revisionTimestampFound = new MutableBoolean();
            MutableBoolean modifiedEntityNamesFound = new MutableBoolean();
            this.searchForRevisionInfoCfg(clazz, reflectionManager, revisionNumberFound, revisionTimestampFound, modifiedEntityNamesFound);
            if (!revisionNumberFound.isSet()) {
                throw new MappingException("An entity annotated with @RevisionEntity must have a field annotated with @RevisionNumber!");
            }
            if (!revisionTimestampFound.isSet()) {
                throw new MappingException("An entity annotated with @RevisionEntity must have a field annotated with @RevisionTimestamp!");
            }
            this.revisionInfoEntityName = pc.getEntityName();
            revisionInfoClass = pc.getMappedClass();
            Class<? extends RevisionListener> revisionListenerClass = this.getRevisionListenerClass(revisionEntity.value());
            this.revisionInfoTimestampType = pc.getProperty(this.revisionInfoTimestampData.getName()).getType();
            if (this.globalCfg.isTrackEntitiesChangedInRevisionEnabled() || DefaultTrackingModifiedEntitiesRevisionEntity.class.isAssignableFrom(revisionInfoClass) || modifiedEntityNamesFound.isSet()) {
                revisionInfoGenerator = new DefaultTrackingModifiedEntitiesRevisionInfoGenerator(this.revisionInfoEntityName, revisionInfoClass, revisionListenerClass, this.revisionInfoTimestampData, this.isTimestampAsDate(), this.modifiedEntityNamesData);
                this.globalCfg.setTrackEntitiesChangedInRevisionEnabled(true);
                continue;
            }
            revisionInfoGenerator = new DefaultRevisionInfoGenerator(this.revisionInfoEntityName, revisionInfoClass, revisionListenerClass, this.revisionInfoTimestampData, this.isTimestampAsDate());
        }
        Document revisionInfoXmlMapping = null;
        Class<? extends RevisionListener> revisionListenerClass = this.getRevisionListenerClass(RevisionListener.class);
        if (revisionInfoGenerator == null) {
            if (this.globalCfg.isTrackEntitiesChangedInRevisionEnabled()) {
                revisionInfoClass = DefaultTrackingModifiedEntitiesRevisionEntity.class;
                this.revisionInfoEntityName = DefaultTrackingModifiedEntitiesRevisionEntity.class.getName();
                revisionInfoGenerator = new DefaultTrackingModifiedEntitiesRevisionInfoGenerator(this.revisionInfoEntityName, revisionInfoClass, revisionListenerClass, this.revisionInfoTimestampData, this.isTimestampAsDate(), this.modifiedEntityNamesData);
            } else {
                revisionInfoClass = DefaultRevisionEntity.class;
                revisionInfoGenerator = new DefaultRevisionInfoGenerator(this.revisionInfoEntityName, revisionInfoClass, revisionListenerClass, this.revisionInfoTimestampData, this.isTimestampAsDate());
            }
            revisionInfoXmlMapping = this.generateDefaultRevisionInfoXmlMapping();
        }
        return new RevisionInfoConfigurationResult(revisionInfoGenerator, revisionInfoXmlMapping, new RevisionInfoQueryCreator(this.revisionInfoEntityName, this.revisionInfoIdData.getName(), this.revisionInfoTimestampData.getName(), this.isTimestampAsDate()), this.generateRevisionInfoRelationMapping(), new RevisionInfoNumberReader(revisionInfoClass, this.revisionInfoIdData), this.globalCfg.isTrackEntitiesChangedInRevisionEnabled() ? new ModifiedEntityNamesReader(revisionInfoClass, this.modifiedEntityNamesData) : null, this.revisionInfoEntityName, revisionInfoClass, this.revisionInfoTimestampData);
    }

    private boolean isTimestampAsDate() {
        String typename = this.revisionInfoTimestampType.getName();
        return "date".equals(typename) || "time".equals(typename) || "timestamp".equals(typename);
    }

    private Class<? extends RevisionListener> getRevisionListenerClass(Class<? extends RevisionListener> defaultListener) {
        if (this.globalCfg.getRevisionListenerClass() != null) {
            return this.globalCfg.getRevisionListenerClass();
        }
        return defaultListener;
    }
}

