/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.protocols;

import java.io.InterruptedIOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.jgroups.Address;
import org.jgroups.Event;
import org.jgroups.Message;
import org.jgroups.PhysicalAddress;
import org.jgroups.View;
import org.jgroups.ViewId;
import org.jgroups.annotations.MBean;
import org.jgroups.annotations.ManagedAttribute;
import org.jgroups.annotations.ManagedOperation;
import org.jgroups.annotations.Property;
import org.jgroups.protocols.PingData;
import org.jgroups.protocols.PingHeader;
import org.jgroups.protocols.pbcast.JoinRsp;
import org.jgroups.stack.Protocol;
import org.jgroups.util.Promise;
import org.jgroups.util.TimeScheduler;
import org.jgroups.util.Tuple;
import org.jgroups.util.UUID;
import org.jgroups.util.Util;

@MBean
public abstract class Discovery
extends Protocol {
    @Property(description="Timeout to wait for the initial members. Default is 3000 msec")
    protected long timeout = 3000L;
    @Property(description="Minimum number of initial members to get a response from. Default is 2")
    protected int num_initial_members = 4;
    @Property(description="Minimum number of server responses (PingData.isServer()=true). If this value is greater than 0, we'll ignore num_initial_members")
    protected int num_initial_srv_members = 0;
    @Property(description="Return from the discovery phase as soon as we have 1 coordinator response")
    protected boolean break_on_coord_rsp = true;
    @Property(description="If greater than 0, we'll wait a random number of milliseconds in range [0..stagger_timeout] before sending a discovery response. This prevents traffic spikes in large clusters when everyone sends their discovery response at the same time")
    protected long stagger_timeout = 0L;
    @ManagedAttribute(description="Always sends a discovery response, no matter what", writable=true)
    protected boolean force_sending_discovery_rsps = true;
    @ManagedAttribute(description="Total number of discovery requests sent ")
    protected int num_discovery_requests = 0;
    @ManagedAttribute
    private volatile int max_found_members = 0;
    protected volatile boolean is_server = false;
    protected volatile boolean is_leaving = false;
    protected TimeScheduler timer = null;
    protected View view;
    protected final List<Address> members = new ArrayList<Address>(11);
    @ManagedAttribute(description="Whether this member is the current coordinator")
    protected boolean is_coord;
    protected Address local_addr = null;
    protected Address current_coord;
    protected String group_addr = null;
    protected final Set<Responses> ping_responses = new HashSet<Responses>();

    @ManagedOperation(description="Sets force_sending_discovery_rsps")
    public void setForceSendingDiscoveryRsps(boolean flag) {
        this.force_sending_discovery_rsps = flag;
    }

    @Override
    public void init() throws Exception {
        this.timer = this.getTransport().getTimer();
        if (this.timer == null) {
            throw new Exception("timer cannot be retrieved from protocol stack");
        }
        if (this.stagger_timeout < 0L) {
            throw new IllegalArgumentException("stagger_timeout cannot be negative");
        }
        if (this.stagger_timeout > this.timeout) {
            this.log.debug("stagger_timeout (" + this.stagger_timeout + ") was greater than timeout (" + this.timeout + "); setting it to " + this.timeout + " ms");
            this.stagger_timeout = this.timeout;
        }
    }

    public abstract Collection<PhysicalAddress> fetchClusterMembers(String var1);

    public abstract boolean sendDiscoveryRequestsInParallel();

    public abstract boolean isDynamic();

    public void handleDisconnect() {
    }

    public void handleConnect() {
    }

    public void discoveryRequestReceived(Address sender, String logical_name, Collection<PhysicalAddress> physical_addrs) {
    }

    public long getTimeout() {
        return this.timeout;
    }

    public void setTimeout(long timeout) {
        this.timeout = timeout;
    }

    public int getNumInitialMembers() {
        return this.num_initial_members;
    }

    public void setNumInitialMembers(int num_initial_members) {
        this.num_initial_members = num_initial_members;
    }

    public int getNumberOfDiscoveryRequestsSent() {
        return this.num_discovery_requests;
    }

    @ManagedAttribute
    public String getView() {
        return this.view != null ? this.view.getViewId().toString() : "null";
    }

    public ViewId getViewId() {
        return this.view != null ? this.view.getViewId() : null;
    }

    @ManagedAttribute(description="The address of the current coordinator")
    public String getCurrentCoord() {
        return this.current_coord != null ? this.current_coord.toString() : "n/a";
    }

    protected boolean isMergeRunning() {
        Object retval = this.up_prot.up(new Event(100));
        return retval instanceof Boolean && (Boolean)retval != false;
    }

    @Override
    public List<Integer> providedUpServices() {
        ArrayList<Integer> ret = new ArrayList<Integer>(3);
        ret.add(12);
        ret.add(13);
        ret.add(87);
        return ret;
    }

    @Override
    public void resetStats() {
        super.resetStats();
        this.num_discovery_requests = 0;
    }

    @Override
    public void start() throws Exception {
        super.start();
    }

    @Override
    public void stop() {
        this.is_server = false;
        this.max_found_members = 0;
    }

    public List<PingData> findInitialMembers(Promise<JoinRsp> promise) {
        return this.findMembers(promise, this.num_initial_members, this.break_on_coord_rsp, null);
    }

    public List<PingData> findAllViews(Promise<JoinRsp> promise) {
        int num_expected_mbrs = Math.max(this.max_found_members, Math.max(this.num_initial_members, this.view != null ? this.view.size() : this.num_initial_members));
        this.max_found_members = Math.max(this.max_found_members, num_expected_mbrs);
        return this.findMembers(promise, num_expected_mbrs, false, this.getViewId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<PingData> findMembers(Promise<JoinRsp> promise, int num_expected_rsps, boolean break_on_coord, ViewId view_id) {
        Responses rsps;
        block21: {
            ++this.num_discovery_requests;
            rsps = new Responses(num_expected_rsps, this.num_initial_srv_members, break_on_coord, promise);
            Set<Responses> set = this.ping_responses;
            synchronized (set) {
                this.ping_responses.add(rsps);
            }
            try {
                this.sendDiscoveryRequest(this.group_addr, promise, view_id);
            }
            catch (InterruptedIOException ie) {
            }
            catch (InterruptedException ex) {
            }
            catch (Throwable ex) {
                if (!this.log.isErrorEnabled()) break block21;
                this.log.error("failed sending discovery request", ex);
            }
        }
        try {
            List<PingData> ex = rsps.get(this.timeout);
            return ex;
        }
        catch (Exception e) {
            LinkedList<PingData> linkedList = new LinkedList<PingData>();
            return linkedList;
        }
        finally {
            Set<Responses> set = this.ping_responses;
            synchronized (set) {
                this.ping_responses.remove(rsps);
            }
        }
    }

    public void sendDiscoveryRequest(String cluster_name, Promise promise, ViewId view_id) throws Exception {
        PingData data = null;
        PhysicalAddress physical_addr = (PhysicalAddress)this.down(new Event(87, this.local_addr));
        if (view_id == null) {
            List<PhysicalAddress> physical_addrs = Arrays.asList(physical_addr);
            data = new PingData(this.local_addr, null, false, UUID.get(this.local_addr), physical_addrs);
        }
        PingHeader hdr = new PingHeader(1, data, cluster_name);
        hdr.view_id = view_id;
        Collection<PhysicalAddress> cluster_members = this.fetchClusterMembers(cluster_name);
        if (cluster_members == null) {
            Message msg = new Message(null);
            msg.setFlag(Message.OOB);
            msg.putHeader(this.getId(), hdr);
            this.sendMcastDiscoveryRequest(msg);
        } else if (cluster_members.isEmpty()) {
            if (promise != null) {
                promise.setResult(null);
            }
        } else {
            for (final PhysicalAddress addr : cluster_members) {
                if (addr.equals(physical_addr)) continue;
                final Message msg = new Message((Address)addr, null, null);
                msg.setFlag(Message.OOB);
                msg.putHeader(this.id, hdr);
                if (this.log.isTraceEnabled()) {
                    this.log.trace("[FIND_INITIAL_MBRS] sending discovery request to " + msg.getDest());
                }
                if (!this.sendDiscoveryRequestsInParallel()) {
                    this.down_prot.down(new Event(1, msg));
                    continue;
                }
                this.timer.execute(new Runnable(){

                    @Override
                    public void run() {
                        block2: {
                            try {
                                Discovery.this.down_prot.down(new Event(1, msg));
                            }
                            catch (Exception ex) {
                                if (!Discovery.this.log.isErrorEnabled()) break block2;
                                Discovery.this.log.error("failed sending discovery request to " + addr + ": " + ex);
                            }
                        }
                    }
                });
            }
        }
    }

    protected void sendMcastDiscoveryRequest(Message discovery_request) {
        this.down_prot.down(new Event(1, discovery_request));
    }

    @ManagedOperation(description="Runs the discovery protocol to find initial members")
    public String findInitialMembersAsString() {
        List<PingData> results = this.findInitialMembers(null);
        if (results == null || results.isEmpty()) {
            return "<empty>";
        }
        StringBuilder sb = new StringBuilder();
        for (PingData rsp : results) {
            sb.append(rsp).append("\n");
        }
        return sb.toString();
    }

    @ManagedOperation(description="Runs the discovery protocol to find all views")
    public String findAllViewsAsString() {
        List<PingData> rsps = this.findAllViews(null);
        if (rsps == null || rsps.isEmpty()) {
            return "<empty>";
        }
        StringBuilder sb = new StringBuilder();
        for (PingData data : rsps) {
            View v = data.getView();
            if (v == null) continue;
            sb.append(v).append("\n");
        }
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Object up(Event evt) {
        switch (evt.getType()) {
            case 1: {
                Address logical_addr;
                Message msg = (Message)evt.getArg();
                PingHeader hdr = (PingHeader)msg.getHeader(this.id);
                if (hdr == null) {
                    return this.up_prot.up(evt);
                }
                PingData data = hdr.data;
                Address address = logical_addr = data != null ? data.getAddress() : null;
                if (this.is_leaving) {
                    return null;
                }
                switch (hdr.type) {
                    case 1: {
                        Collection<PhysicalAddress> physical_addrs;
                        if (this.group_addr == null || hdr.cluster_name == null) {
                            if (this.log.isWarnEnabled()) {
                                this.log.warn("group_addr (" + this.group_addr + ") or cluster_name of header (" + hdr.cluster_name + ") is null; passing up discovery request from " + msg.getSrc() + ", but this should not" + " be the case");
                            }
                        } else if (!this.group_addr.equals(hdr.cluster_name)) {
                            if (!this.log.isWarnEnabled()) return null;
                            this.log.warn("discarding discovery request for cluster '" + hdr.cluster_name + "' from " + msg.getSrc() + "; our cluster name is '" + this.group_addr + "'. " + "Please separate your clusters cleanly.");
                            return null;
                        }
                        if (data != null) {
                            PhysicalAddress physical_addr;
                            if (logical_addr == null) {
                                logical_addr = msg.getSrc();
                            }
                            PhysicalAddress physicalAddress = physical_addr = (physical_addrs = data.getPhysicalAddrs()) != null && !physical_addrs.isEmpty() ? physical_addrs.iterator().next() : null;
                            if (logical_addr != null && physical_addr != null) {
                                this.down(new Event(89, new Tuple<Address, PhysicalAddress>(logical_addr, physical_addr)));
                            }
                            if (logical_addr != null && data.getLogicalName() != null) {
                                UUID.add(logical_addr, data.getLogicalName());
                            }
                            this.discoveryRequestReceived(msg.getSrc(), data.getLogicalName(), physical_addrs);
                            Set<Responses> set = this.ping_responses;
                            synchronized (set) {
                                for (Responses response : this.ping_responses) {
                                    response.addResponse(data, false);
                                }
                            }
                        }
                        if (hdr.view_id != null) {
                            boolean send_discovery_rsp;
                            ViewId my_view_id;
                            ViewId viewId = my_view_id = this.view != null ? this.view.getViewId() : null;
                            if (my_view_id != null && my_view_id.equals(hdr.view_id)) {
                                return null;
                            }
                            boolean bl = send_discovery_rsp = this.force_sending_discovery_rsps || this.is_coord || this.current_coord == null || this.current_coord.equals(msg.getSrc());
                            if (!send_discovery_rsp) {
                                if (!this.log.isTraceEnabled()) return null;
                                this.log.trace(this.local_addr + ": suppressing merge response as I'm not a coordinator and the " + "discovery request was not sent by a coordinator");
                                return null;
                            }
                        }
                        if (this.isMergeRunning()) {
                            if (!this.log.isTraceEnabled()) return null;
                            this.log.trace(this.local_addr + ": suppressing merge response as a merge is already in progress");
                            return null;
                        }
                        physical_addrs = hdr.view_id != null ? null : Arrays.asList((PhysicalAddress)this.down(new Event(87, this.local_addr)));
                        this.sendDiscoveryResponse(this.local_addr, (List<PhysicalAddress>)physical_addrs, this.is_server, hdr.view_id != null, UUID.get(this.local_addr), msg.getSrc());
                        return null;
                    }
                    case 2: {
                        Collection<PhysicalAddress> addrs;
                        PhysicalAddress physical_addr;
                        if (data == null) return null;
                        Address response_sender = msg.getSrc();
                        if (logical_addr == null) {
                            logical_addr = msg.getSrc();
                        }
                        PhysicalAddress physicalAddress = physical_addr = (addrs = data.getPhysicalAddrs()) != null && !addrs.isEmpty() ? addrs.iterator().next() : null;
                        if (logical_addr != null && physical_addr != null) {
                            this.down(new Event(89, new Tuple<Address, PhysicalAddress>(logical_addr, physical_addr)));
                        }
                        if (logical_addr != null && data.getLogicalName() != null) {
                            UUID.add(logical_addr, data.getLogicalName());
                        }
                        if (this.log.isTraceEnabled()) {
                            this.log.trace(this.local_addr + ": received GET_MBRS_RSP from " + response_sender + ": " + data);
                        }
                        boolean overwrite = logical_addr != null && logical_addr.equals(response_sender);
                        Set<Responses> set = this.ping_responses;
                        synchronized (set) {
                            for (Responses response : this.ping_responses) {
                                response.addResponse(data, overwrite);
                            }
                            return null;
                        }
                    }
                }
                if (!this.log.isWarnEnabled()) return null;
                this.log.warn("got PING header with unknown type (" + hdr.type + ')');
                return null;
            }
            case 87: {
                try {
                    this.sendDiscoveryRequest(this.group_addr, null, null);
                    return null;
                }
                catch (InterruptedIOException ie) {
                    if (this.log.isWarnEnabled()) {
                        this.log.warn("Discovery request for cluster " + this.group_addr + " interrupted");
                    }
                    Thread.currentThread().interrupt();
                    return null;
                }
                catch (Exception ex) {
                    if (!this.log.isErrorEnabled()) return null;
                    this.log.error("failed sending discovery request", ex);
                }
                return null;
            }
            case 12: {
                return this.findInitialMembers(null);
            }
        }
        return this.up_prot.up(evt);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object down(Event evt) {
        switch (evt.getType()) {
            case 12: 
            case 13: {
                long start = System.currentTimeMillis();
                boolean find_all_views = evt.getType() == 13;
                Promise promise = (Promise)evt.getArg();
                List<PingData> rsps = find_all_views ? this.findAllViews(promise) : this.findInitialMembers(promise);
                long diff = System.currentTimeMillis() - start;
                if (this.log.isTraceEnabled()) {
                    this.log.trace("discovery took " + diff + " ms: responses: " + Util.printPingData(rsps));
                }
                return rsps;
            }
            case 6: 
            case 15: {
                this.view = (View)evt.getArg();
                List<Address> tmp = this.view.getMembers();
                if (tmp != null) {
                    List<Address> list = this.members;
                    synchronized (list) {
                        this.members.clear();
                        this.members.addAll(tmp);
                    }
                }
                this.current_coord = !this.members.isEmpty() ? this.members.get(0) : null;
                this.is_coord = this.current_coord != null && this.local_addr != null && this.current_coord.equals(this.local_addr);
                return this.down_prot.down(evt);
            }
            case 16: {
                this.down_prot.down(evt);
                this.is_server = true;
                return null;
            }
            case 8: {
                this.local_addr = (Address)evt.getArg();
                return this.down_prot.down(evt);
            }
            case 2: 
            case 80: 
            case 92: 
            case 93: {
                this.is_leaving = false;
                this.group_addr = (String)evt.getArg();
                Object ret = this.down_prot.down(evt);
                this.handleConnect();
                return ret;
            }
            case 4: {
                this.is_leaving = true;
                this.handleDisconnect();
                return this.down_prot.down(evt);
            }
        }
        return this.down_prot.down(evt);
    }

    protected byte[] serializeWithoutView(PingData data) {
        PingData clone = new PingData(data.getAddress(), null, data.isServer(), data.getLogicalName(), data.getPhysicalAddrs());
        try {
            return Util.streamableToByteBuffer(clone);
        }
        catch (Exception e) {
            this.log.error("Error", e);
            return null;
        }
    }

    protected PingData deserialize(byte[] data) {
        try {
            return (PingData)Util.streamableFromByteBuffer(PingData.class, data);
        }
        catch (Exception e) {
            this.log.error("Error", e);
            return null;
        }
    }

    protected void sendDiscoveryResponse(Address logical_addr, List<PhysicalAddress> physical_addrs, boolean is_server, boolean return_view_only, String logical_name, final Address sender) {
        PingData data;
        if (return_view_only) {
            data = new PingData(logical_addr, this.view, is_server, null, null);
        } else {
            ViewId view_id = this.view != null ? this.view.getViewId() : null;
            data = new PingData(logical_addr, null, view_id, is_server, logical_name, physical_addrs);
        }
        final Message rsp_msg = new Message(sender, null, null);
        rsp_msg.setFlag(Message.OOB);
        final PingHeader rsp_hdr = new PingHeader(2, data);
        rsp_msg.putHeader(this.id, rsp_hdr);
        if (this.stagger_timeout > 0L) {
            int view_size = this.view != null ? this.view.size() : 10;
            int rank = Util.getRank(this.view, this.local_addr);
            long sleep_time = rank == 0 ? Util.random(this.stagger_timeout) : this.stagger_timeout * (long)rank / (long)view_size - this.stagger_timeout / (long)view_size;
            this.timer.schedule(new Runnable(){

                @Override
                public void run() {
                    if (Discovery.this.log.isTraceEnabled()) {
                        Discovery.this.log.trace(Discovery.this.local_addr + ": received GET_MBRS_REQ from " + sender + ", sending staggered response " + rsp_hdr);
                    }
                    Discovery.this.down_prot.down(new Event(1, rsp_msg));
                }
            }, sleep_time, TimeUnit.MILLISECONDS);
            return;
        }
        if (this.log.isTraceEnabled()) {
            this.log.trace("received GET_MBRS_REQ from " + sender + ", sending response " + rsp_hdr);
        }
        this.down_prot.down(new Event(1, rsp_msg));
    }

    protected static class Responses {
        final Promise<JoinRsp> promise;
        final List<PingData> ping_rsps = new ArrayList<PingData>();
        final int num_expected_rsps;
        final int num_expected_srv_rsps;
        final boolean break_on_coord_rsp;

        protected Responses(int num_expected_rsps, int num_expected_srv_rsps, boolean break_on_coord_rsp, Promise<JoinRsp> promise) {
            this.num_expected_rsps = num_expected_rsps;
            this.num_expected_srv_rsps = num_expected_srv_rsps;
            this.break_on_coord_rsp = break_on_coord_rsp;
            this.promise = promise != null ? promise : new Promise();
        }

        public void addResponse(PingData rsp) {
            this.addResponse(rsp, false);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addResponse(PingData rsp, boolean overwrite) {
            if (rsp == null) {
                return;
            }
            this.promise.getLock().lock();
            try {
                PingData pr;
                int index;
                if (overwrite) {
                    this.ping_rsps.remove(rsp);
                }
                if ((index = this.ping_rsps.indexOf(rsp)) == -1) {
                    this.ping_rsps.add(rsp);
                    this.promise.getCond().signalAll();
                } else if (rsp.isCoord() && !(pr = this.ping_rsps.get(index)).isCoord()) {
                    this.ping_rsps.set(index, rsp);
                    this.promise.getCond().signalAll();
                }
            }
            finally {
                this.promise.getLock().unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public List<PingData> get(long timeout) throws InterruptedException {
            long start_time = System.currentTimeMillis();
            long time_to_wait = timeout;
            this.promise.getLock().lock();
            try {
                while (time_to_wait > 0L && !this.promise.hasResult()) {
                    if (this.num_expected_srv_rsps > 0) {
                        int received_srv_rsps = Responses.getNumServerResponses(this.ping_rsps);
                        if (received_srv_rsps >= this.num_expected_srv_rsps) {
                            LinkedList<PingData> linkedList = new LinkedList<PingData>(this.ping_rsps);
                            return linkedList;
                        }
                    } else if (this.ping_rsps.size() >= this.num_expected_rsps) {
                        LinkedList<PingData> linkedList = new LinkedList<PingData>(this.ping_rsps);
                        return linkedList;
                    }
                    if (this.break_on_coord_rsp && Responses.containsCoordinatorResponse(this.ping_rsps)) {
                        LinkedList<PingData> linkedList = new LinkedList<PingData>(this.ping_rsps);
                        return linkedList;
                    }
                    this.promise.getCond().await(time_to_wait, TimeUnit.MILLISECONDS);
                    time_to_wait = timeout - (System.currentTimeMillis() - start_time);
                }
                LinkedList<PingData> linkedList = new LinkedList<PingData>(this.ping_rsps);
                return linkedList;
            }
            finally {
                this.promise.getLock().unlock();
            }
        }

        private static int getNumServerResponses(Collection<PingData> rsps) {
            int cnt = 0;
            for (PingData rsp : rsps) {
                if (!rsp.isServer()) continue;
                ++cnt;
            }
            return cnt;
        }

        private static boolean containsCoordinatorResponse(Collection<PingData> rsps) {
            if (rsps == null || rsps.isEmpty()) {
                return false;
            }
            for (PingData rsp : rsps) {
                if (!rsp.isCoord()) continue;
                return true;
            }
            return false;
        }
    }
}

