/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.cli.gui;

import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.text.BadLocationException;
import javax.swing.text.Utilities;
import org.jboss.as.cli.gui.DoOperationActionListener;

public class SelectPreviousOpMouseAdapter
extends MouseAdapter
implements ClipboardOwner {
    private JTextPane output;
    private JTextField cmdText;
    private DoOperationActionListener opListener;
    private Clipboard systemClipboard = Toolkit.getDefaultToolkit().getSystemClipboard();

    public SelectPreviousOpMouseAdapter(JTextPane output, JTextField cmdText, DoOperationActionListener opListener) {
        this.output = output;
        this.cmdText = cmdText;
        this.opListener = opListener;
    }

    @Override
    public void mouseClicked(MouseEvent me) {
        if (me.getClickCount() < 2) {
            return;
        }
        int pos = this.output.viewToModel(me.getPoint());
        try {
            int rowStart = Utilities.getRowStart(this.output, pos);
            int rowEnd = Utilities.getRowEnd(this.output, pos);
            String line = this.output.getDocument().getText(rowStart, rowEnd - rowStart);
            if (this.opListener.getCmdHistory().contains(line)) {
                this.output.select(rowStart, rowEnd);
                this.cmdText.setText(line);
                this.systemClipboard.setContents(new StringSelection(line), this);
            }
        }
        catch (BadLocationException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void lostOwnership(Clipboard clpbrd, Transferable t) {
    }
}

