/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.identity.federation.bindings.tomcat.sp;

import java.io.IOException;
import java.security.KeyPair;
import java.util.List;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.connector.Response;
import org.apache.log4j.Logger;
import org.picketlink.identity.federation.api.saml.v2.sig.SAML2Signature;
import org.picketlink.identity.federation.bindings.tomcat.sp.SPPostFormAuthenticator;
import org.picketlink.identity.federation.bindings.tomcat.sp.SecurityActions;
import org.picketlink.identity.federation.core.config.KeyProviderType;
import org.picketlink.identity.federation.core.exceptions.ConfigurationException;
import org.picketlink.identity.federation.core.exceptions.ProcessingException;
import org.picketlink.identity.federation.core.interfaces.TrustKeyManager;
import org.picketlink.identity.federation.core.saml.v2.util.DocumentUtil;
import org.picketlink.identity.federation.core.util.CoreConfigUtil;
import org.picketlink.identity.federation.core.util.StringUtil;
import org.w3c.dom.Document;

public class SPPostSignatureFormAuthenticator
extends SPPostFormAuthenticator {
    private static Logger log = Logger.getLogger(SPPostSignatureFormAuthenticator.class);
    private final boolean trace = log.isTraceEnabled();
    protected String idpAddress = null;

    public void setIdpAddress(String idpAddress) {
        this.idpAddress = idpAddress;
    }

    public void start() throws LifecycleException {
        super.start();
        this.supportSignatures = true;
        KeyProviderType keyProvider = this.spConfiguration.getKeyProvider();
        if (keyProvider == null) {
            throw new LifecycleException("PL00092: Null Value:KeyProvider");
        }
        try {
            String keyManagerClassName = keyProvider.getClassName();
            if (keyManagerClassName == null) {
                throw new RuntimeException("PL00092: Null Value:KeyManager class name");
            }
            Class<?> clazz = SecurityActions.loadClass(((Object)((Object)this)).getClass(), keyManagerClassName);
            if (clazz == null) {
                throw new RuntimeException("PL00085: Class Not Loaded:" + keyManagerClassName);
            }
            this.keyManager = (TrustKeyManager)clazz.newInstance();
            List authProperties = CoreConfigUtil.getKeyProviderProperties((KeyProviderType)keyProvider);
            this.keyManager.setAuthProperties(authProperties);
            this.keyManager.setValidatingAlias(keyProvider.getValidatingAlias());
            if (StringUtil.isNotNull((String)this.idpAddress)) {
                this.keyManager.addAdditionalOption("idp.key", (Object)this.idpAddress);
            }
        }
        catch (Exception e) {
            log.error((Object)"Exception reading configuration:", (Throwable)e);
            throw new LifecycleException(e.getLocalizedMessage());
        }
        if (this.trace) {
            log.trace((Object)("Key Provider=" + keyProvider.getClassName()));
        }
    }

    protected void sendRequestToIDP(String destination, Document samlDocument, String relayState, Response response, boolean willSendRequest) throws ProcessingException, ConfigurationException, IOException {
        if (this.keyManager == null) {
            throw new IllegalStateException("PL00092: Null Value:Key Manager");
        }
        SAML2Signature samlSignature = new SAML2Signature();
        KeyPair keypair = this.keyManager.getSigningKeyPair();
        samlSignature.signSAMLDocument(samlDocument, keypair);
        if (this.trace) {
            log.trace((Object)("Sending to IDP:" + DocumentUtil.asString((Document)samlDocument)));
        }
        super.sendRequestToIDP(destination, samlDocument, relayState, response, willSendRequest);
    }
}

